/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.archive.ArchiveRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ApproverListField;
import kd.bos.entity.datamodel.DynamicTextListField;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.datamodel.QueryType;
import kd.bos.entity.datamodel.VoucherNoListField;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.FormatFieldData;
import kd.bos.entity.list.FormatRowData;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.AmountColumnDesc;
import kd.bos.entity.list.column.ApproverColumnDesc;
import kd.bos.entity.list.column.BaseDataColumnDesc;
import kd.bos.entity.list.column.BigIntColumnDesc;
import kd.bos.entity.list.column.BooleanColumnDesc;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.ComboColumnDesc;
import kd.bos.entity.list.column.DateTimeColumnDesc;
import kd.bos.entity.list.column.DecimalColumnDesc;
import kd.bos.entity.list.column.FlexColumnDesc;
import kd.bos.entity.list.column.IconColumnDesc;
import kd.bos.entity.list.column.IntegerColumnDesc;
import kd.bos.entity.list.column.MulBaseDataColumnDesc;
import kd.bos.entity.list.column.NumberColumnDesc;
import kd.bos.entity.list.column.TextColumnDesc;
import kd.bos.entity.list.column.TimeColumnDesc;
import kd.bos.entity.list.column.VoucherNoColumnDesc;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.plugin.args.SensitiveArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IconProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.KDBizException;
import kd.bos.export.po.ExportFileInfo;
import kd.bos.export.po.ExportSplitFileContext;
import kd.bos.export.util.ExportListUtil;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.bos.lang.Lang;
import kd.bos.limiter.impl.ConcurrencyLimiter;
import kd.bos.list.ApproverListColumn;
import kd.bos.list.AvatarListColumn;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.DynamicTextListColumn;
import kd.bos.list.FlexListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.ListColumnType;
import kd.bos.list.ListFieldMeta;
import kd.bos.list.ListOperationColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MergeListColumn;
import kd.bos.list.SeqColumnType;
import kd.bos.list.TemplateTextListColumn;
import kd.bos.list.ViewCommonUtil;
import kd.bos.list.VoucherNoListColumn;
import kd.bos.list.plugin.AbstractListViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.mservice.svc.expt.IExportService;
import kd.bos.mvc.export.ExportCsvWriter;
import kd.bos.mvc.export.ExportDataTask;
import kd.bos.mvc.export.ExportListContext;
import kd.bos.mvc.export.ListExporter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.QueryBuilderFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.svc.util.FileHandlerUtil;
import kd.bos.svc.util.PermissionParam;
import kd.bos.url.UrlService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ExportListTask
extends ExportDataTask {
    private static final String BOS_EXPORT = "bos-export";
    private static final String CHILDREN = "children";
    private static final String COMPLETE = "complete";
    private static Log log = LogFactory.getLog(ExportListTask.class);
    private static Pattern IgnoreStringPattern = Pattern.compile("[\\p{C}&&[^\\s]&&[^\n]&&[^\r][^\t]]");
    private static Pattern DotPattern = Pattern.compile("\\.");
    private static int DecimalValueIndex = 1;
    private static int DateTimeValueIndex = 0;
    private static int ExtendColTypeIndex = 0;
    private static final IExportService exportService = (IExportService)ServiceFactory.getService(IExportService.class);
    private final String SEQ = "seq";
    private final String FSEQ = "fseq";
    private ExportListContext context;
    private ListExporter exporter;
    private Boolean isFillParent;
    private static final int batchSize = 10000;
    private Boolean hasEntryField;

    @Override
    public String getExptType() {
        return "1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export() {
        try (EntityTraceSpan entityTraceSpan = EntityTracer.create((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"ExportByList");){
            String attachId;
            String url;
            this.context = this.buildContext();
            String appId = ShowFormHelper.getBizAppId((FormShowParameter)this.getParentView().getFormShowParameter());
            FieldControlRules fieldControlRules = this.getFieldControlRules(appId, this.context.getBillList().getEntityType().getName());
            this.context.setFieldControlRules(fieldControlRules);
            this.getExportProgress().feedbackProgress(this.context.getBillDataCount(), 0);
            this.getExportLogObj().set("total", (Object)this.context.getBillDataCount());
            this.exporter = new ListExporter(ResManager.loadKDString((String)"\u5217\u8868\u6570\u636e", (String)"ExportListTask_0", (String)BOS_EXPORT, (Object[])new Object[0]), this.context.getFieldCaptions(), true, this.getMainType().getName());
            if (!this.isExportCsv().booleanValue()) {
                List<ExportFileInfo> fileList = this.exportExcelRows();
                if (CollectionUtils.isEmpty(fileList)) {
                    return;
                }
                url = super.getFinalUrl(this.exporter, this.getMainType(), fileList, this.exportEventArgs.getFileName());
            } else {
                ExportFileInfo exportFile = this.exportCsvRows();
                url = super.getFinalUrl(this.exporter, this.getMainType(), Collections.singletonList(exportFile), this.exportEventArgs.getFileName());
            }
            url = UrlService.getAttachmentFullUrl((String)url);
            boolean checkFilePermission = ((IAttachmentService)ServiceFactory.getService(IAttachmentService.class)).checkFilePermission();
            if (checkFilePermission) {
                String entityNum = this.context.getBillList().getEntityType().getName();
                String entityAppId = EntityMetadataCache.getDataEntityType((String)entityNum).getAppId();
                String logEntityNum = "bos_exportlog";
                Object logPkId = this.context.getLogId();
                String fileType = "";
                String permissionItemId = this.getParams().get("PermissionItemId") == null ? null : this.getParams().get("PermissionItemId").toString();
                attachId = PermissionParam.genAttacId((String)entityAppId, (String)entityNum, (String)logEntityNum, (Object)logPkId, (String)fileType, (String)permissionItemId);
            } else {
                attachId = this.context.getLogId() + "@bos_exportlog";
                attachId = Base64.getEncoder().encodeToString(attachId.getBytes(StandardCharsets.UTF_8));
            }
            String downloadUrl = UrlService.getDomainContextUrl() + "/attachment/download.do?attachId=" + attachId + "&fId=" + this.getEntityNumber() + "&appId=" + appId;
            Object encryptPassword = this.getParams().get("password");
            if (StringUtils.isNotBlank((Object)encryptPassword)) {
                downloadUrl = downloadUrl + "&password=" + encryptPassword;
            }
            this.getExportProgress().feedbackFileUrl(downloadUrl);
            this.getExportLogObj().set("downloadurl", (Object)url);
            this.getExportLogObj().set(COMPLETE, this.getExportLogObj().get("total"));
        }
        finally {
            if (null != this.exporter && null != this.exporter.wb) {
                this.exporter.wb.dispose();
            }
            if (this.getParams().get("concurrentID") != null && StringUtils.isNotEmpty((CharSequence)this.getParams().get("concurrentID").toString())) {
                ConcurrencyLimiter.release((String)this.getParams().get("concurrentID").toString());
            }
        }
    }

    private String[] parseToCsvHeader(List<KeyValue> fieldCaptions) {
        ArrayList<String> headNamesList = new ArrayList<String>();
        for (KeyValue fieldCaption : fieldCaptions) {
            this.setHeadName(fieldCaption, headNamesList);
        }
        return headNamesList.toArray(new String[0]);
    }

    private void setHeadName(KeyValue fieldCaption, List<String> headNamesList) {
        if (fieldCaption.value instanceof String) {
            headNamesList.add(fieldCaption.value.toString());
        }
        if (fieldCaption.value instanceof KeyValue) {
            this.setHeadName((KeyValue)fieldCaption.value, headNamesList);
        }
        if (fieldCaption.value instanceof List) {
            if (ExportListTask.isMergeColumnOrDynamicListText(fieldCaption)) {
                headNamesList.add(fieldCaption.key);
            } else {
                List values = (List)fieldCaption.value;
                for (Object value : values) {
                    if (!(value instanceof KeyValue)) continue;
                    this.setHeadName((KeyValue)value, headNamesList);
                }
            }
        }
    }

    private static boolean isMergeColumnOrDynamicListText(KeyValue fieldCaption) {
        return fieldCaption.extend != null && fieldCaption.extend.length > 0 && (ListColumnType.DynamicTextList.getValue() == ((Integer)fieldCaption.extend[ExtendColTypeIndex]).intValue() || ListColumnType.MergeColumn.getValue() == ((Integer)fieldCaption.extend[ExtendColTypeIndex]).intValue());
    }

    private List<ExportFileInfo> exportExcelRows() {
        BillList billList = this.getBillList();
        BillEntityType listEntityType = this.getMainType();
        List<ListField> listFields = this.context.getListFields();
        List<KeyValue> fieldCaptions = this.context.getFieldCaptions();
        int complete = 0;
        ArrayList<List<SummaryResult>> summaryResultsList = new ArrayList<List<SummaryResult>>(10);
        ExportSplitFileContext splitFileContext = new ExportSplitFileContext(complete, summaryResultsList);
        List<ExportFileInfo> fileList = new ArrayList<ExportFileInfo>();
        if (listFields != null) {
            fileList.add(this.createExportFileInfo((List<ListSelectedRow>)this.context.getSelectedRows()));
            fileList = this.toExcel4Selected(fileList, splitFileContext, billList, (MainEntityType)listEntityType, listFields);
            this.getExportLogObj().set(COMPLETE, (Object)splitFileContext.getComplete());
            return fileList;
        }
        String isForceSplitFileStr = this.getParentView().getPageCache().get("isForceSplitFile");
        boolean isForceSplitFile = Boolean.parseBoolean(isForceSplitFileStr);
        IListDataProvider provider = billList.getListModel().getProvider();
        if (provider != null && !provider.getClass().toString().equals(ListDataProvider.class.toString()) && !isForceSplitFile) {
            int maxRowSize = 0x100000;
            int realCount = billList.getListModel().getRealCount();
            if (realCount > maxRowSize) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570\u8d85\u51faExcel\u6587\u4ef6\u6700\u5927\u884c\u65701048576\u884c\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\uff1b\u6216\u79fb\u9664\u5217\u8868\u63d2\u4ef6beforeCreateListDataProvider\u65b9\u6cd5\u3002", (String)"ListDataExporter_0", (String)BOS_EXPORT, (Object[])new Object[0]));
            }
            fileList = new ArrayList(1);
            fileList.add(this.createExportFileInfo(realCount));
            this.toExcelWithoutSelect(fileList, splitFileContext, billList, (MainEntityType)listEntityType, this.context.getZeroShow(), fieldCaptions);
            this.getExportLogObj().set(COMPLETE, (Object)splitFileContext.getComplete());
            return fileList;
        }
        List<Object> pkIdList = this.getAllPkIds();
        fileList = this.splitFile4NotSelected(this.checkHasEntryField(), pkIdList);
        if (this.getCurrentBatchTotalRow(fileList) > 10000000) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570\u8d85\u51fa\u7cfb\u7edf\u6700\u5927\u884c\u6570\u9650\u5236\uff1a%s\u884c\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\u3002", (String)"ExportDataTask_8", (String)BOS_EXPORT, (Object[])new Object[0]), 10000000));
        }
        this.toExcelWithoutSelect(fileList, splitFileContext, billList, (MainEntityType)listEntityType, this.context.getZeroShow(), fieldCaptions);
        this.getExportLogObj().set(COMPLETE, (Object)splitFileContext.getComplete());
        return fileList;
    }

    private ExportFileInfo exportCsvRows() {
        List<KeyValue> fieldCaptions = this.context.getFieldCaptions();
        String[] headerNames = this.parseToCsvHeader(fieldCaptions);
        int totalRowCount = this.context.getSelectedRows().size();
        List<ListField> listFields = this.context.getListFields();
        if (totalRowCount >= 10000000) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570\u8d85\u51faCSV\u6587\u4ef6\u6700\u5927\u884c\u6570\u9650\u523610000000\u884c\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\u3002", (String)"ListDataExporter_10", (String)BOS_EXPORT, (Object[])new Object[0]), 0x100000));
        }
        ExportCsvWriter csvWriter = new ExportCsvWriter(headerNames, null, (MainEntityType)this.getMainType(), this.exportEventArgs.getFileName(), this.context.getSaveDir());
        if (listFields != null) {
            return this.exportCsvForHasSelected(csvWriter);
        }
        return this.exportCsvForNotSelected(csvWriter);
    }

    private ExportFileInfo exportCsvForNotSelected(ExportCsvWriter csvWriter) {
        int complete;
        int rowCount;
        List<KeyValue> fieldCaptions = this.context.getFieldCaptions();
        BillList billList = this.getBillList();
        BillEntityType listEntityType = this.getMainType();
        Set<String> zeroShow = this.context.getZeroShow();
        HashSet<Object> idSet = new HashSet<Object>(16);
        int start = 0;
        int batchSize = 10000;
        int startSeq = 0;
        ArrayList<List<SummaryResult>> summaryResultsList = new ArrayList<List<SummaryResult>>(10);
        do {
            QueryResult rows;
            try (ArchiveRoute mr = ArchiveRoute.mapRoute((String)billList.getContext().getRouteKey(), (String)billList.getContext().getArchiveKey());){
                rows = billList.queryBatchData(start, batchSize);
            }
            int n = rowCount = rows == null ? 0 : rows.getCollection().size();
            if ((start += rowCount) >= 10000000) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570\u8d85\u51faCSV\u6587\u4ef6\u6700\u5927\u884c\u6570\u9650\u523610000000\u884c\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\u3002", (String)"ListDataExporter_10", (String)BOS_EXPORT, (Object[])new Object[0]), 0x100000));
            }
            if (rows != null && rows.getCollection().size() != 0) {
                try {
                    csvWriter.lists2csv(this.formatRows((MainEntityType)listEntityType, billList, zeroShow, rows, fieldCaptions, idSet, startSeq));
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"ExportDataProgressFormPlugin_4", (String)BOS_EXPORT, (Object[])new Object[0]));
                }
                summaryResultsList.add(rows.getSummaryResults());
            }
            complete = idSet.size();
            startSeq += rowCount;
            this.getExportProgress().feedbackProgress(this.context.getBillDataCount(), complete);
        } while (rowCount != 0);
        return this.getExportCsvResult(billList, fieldCaptions, complete, csvWriter, summaryResultsList);
    }

    private ExportFileInfo exportCsvForHasSelected(ExportCsvWriter csvWriter) {
        List<KeyValue> fieldCaptions = this.context.getFieldCaptions();
        BillList billList = this.getBillList();
        BillEntityType listEntityType = this.getMainType();
        Set<String> zeroShow = this.context.getZeroShow();
        HashSet<Object> idSet = new HashSet<Object>(16);
        int complete = 0;
        int batchSize = 10000;
        int startSeq = 0;
        ArrayList<List<SummaryResult>> summaryResultsList = new ArrayList<List<SummaryResult>>(10);
        List<ListField> listFields = this.context.getListFields();
        int totalRowCount = this.context.getSelectedRows().size();
        ListSelectedRowCollection subRowSelection = new ListSelectedRowCollection();
        for (int start = 0; start < this.context.getSelectedRows().size(); start += batchSize) {
            int rowCount;
            QueryResult rows;
            if (this.getExportSuspendAppCache().get(this.getExportSuspendCacheKey(), String.class) != null) {
                this.getExportSuspendAppCache().remove(this.getExportSuspendCacheKey());
                return null;
            }
            List subList = this.context.getSelectedRows().subList(start, Math.min(start + batchSize, totalRowCount));
            subRowSelection.addAll((Collection)subList);
            try (ArchiveRoute mr = ArchiveRoute.mapRoute((String)billList.getContext().getRouteKey(), (String)billList.getContext().getArchiveKey());){
                rows = billList.getSelectedRowDatas(listFields, subRowSelection);
            }
            int n = rowCount = rows == null ? 0 : rows.getCollection().size();
            if (rows != null) {
                this.sortRows(rows, subRowSelection);
                try {
                    csvWriter.lists2csv(this.formatRows((MainEntityType)listEntityType, billList, zeroShow, rows, fieldCaptions, idSet, startSeq));
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"ExportDataProgressFormPlugin_4", (String)BOS_EXPORT, (Object[])new Object[0]));
                }
                summaryResultsList.add(rows.getSummaryResults());
            }
            complete = idSet.size();
            startSeq += rowCount;
            this.getExportProgress().feedbackProgress(this.context.getBillDataCount(), complete);
            subRowSelection.clear();
        }
        return this.getExportCsvResult(billList, fieldCaptions, complete, csvWriter, summaryResultsList);
    }

    private ExportFileInfo getExportCsvResult(BillList billList, List<KeyValue> fieldCaptions, int complete, ExportCsvWriter csvWriter, List<List<SummaryResult>> summaryResultsList) {
        this.getExportLogObj().set(COMPLETE, (Object)complete);
        try {
            List<List<Object>> summaryLineForCsv = this.exportSummaryLineForCsv(billList, fieldCaptions, summaryResultsList, csvWriter);
            csvWriter.lists2csv(summaryLineForCsv);
            csvWriter.flush();
            csvWriter.close();
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"ExportDataProgressFormPlugin_4", (String)BOS_EXPORT, (Object[])new Object[0]));
        }
        ExportFileInfo exportFileInfo = new ExportFileInfo();
        exportFileInfo.setUrl(csvWriter.getCsvFile().getAbsolutePath());
        return exportFileInfo;
    }

    private void exportSummaryLine(BillList billList, List<KeyValue> fieldCaptions, ExportSplitFileContext splitFileContext) {
        if (exportService.getSettingOfExportSummaryLine(billList.getBillFormId())) {
            this.exportSummaryResult(fieldCaptions, splitFileContext.getSummaryResultsList());
        }
    }

    private List<List<Object>> exportSummaryLineForCsv(BillList billList, List<KeyValue> fieldCaptions, List<List<SummaryResult>> summaryResultsList, ExportCsvWriter csvWriter) {
        if (exportService.getSettingOfExportSummaryLine(billList.getBillFormId())) {
            if (summaryResultsList.isEmpty()) {
                return null;
            }
            Map<String, NumberPrecision> summaryMap = this.getSummaryMap(summaryResultsList);
            return this.getExportSummaryData(fieldCaptions, summaryMap);
        }
        return null;
    }

    private int getCurrentBatchTotalRow(List<ExportFileInfo> fileList) {
        int batchTotalRow = 0;
        for (ExportFileInfo fileInfo : fileList) {
            batchTotalRow += fileInfo.getBatchSize();
        }
        return batchTotalRow;
    }

    private List<ExportFileInfo> toExcelWithoutSelect(List<ExportFileInfo> fileList, ExportSplitFileContext splitFileContext, BillList billList, MainEntityType listEntityType, Set<String> zeroShow, List<KeyValue> fieldCaptions) {
        int sysParamListMaxLimit;
        int startIndex = 0;
        int startSeq = 0;
        HashSet<Object> idSet = new HashSet<Object>(16);
        int totalRow = this.getCurrentBatchTotalRow(fileList);
        boolean isRowsLessThanListCount = totalRow <= (sysParamListMaxLimit = ExportListUtil.getSysParamListMaxLimit(this.getEntityNumber()));
        String orderByExpr = billList.getListModel().getProvider().getOrderByExpr();
        boolean useDefaultOrder = false;
        if (this.checkHasEntryField() && this.sqlWithOutOrderByEntryField(orderByExpr) && this.isDuplicationExportByList()) {
            useDefaultOrder = true;
        }
        for (int i = 0; i < fileList.size(); ++i) {
            this.context.setFileFirstRow(true);
            ExportFileInfo exportFileInfo = fileList.get(i);
            int fileBatchSize = exportFileInfo.getBatchSize();
            int curBatchSize = Math.min(fileBatchSize, 100000);
            do {
                QueryResult rows;
                try (ArchiveRoute mr = ArchiveRoute.mapRoute((String)billList.getContext().getRouteKey(), (String)billList.getContext().getArchiveKey());){
                    rows = isRowsLessThanListCount ? billList.queryBatchDataForExport(startIndex, curBatchSize, QueryType.IdQuery) : (useDefaultOrder ? billList.queryBatchDataForExportByDefaultOrder(startIndex, curBatchSize, QueryType.SqlQuery) : billList.queryBatchData(true, startIndex, curBatchSize));
                }
                if (rows != null && rows.getCollection().size() != 0) {
                    this.exporter.write(this.formatRows(listEntityType, billList, zeroShow, rows, fieldCaptions, idSet, startSeq));
                    List<List<SummaryResult>> summaryResultsList = splitFileContext.getSummaryResultsList();
                    summaryResultsList.add(rows.getSummaryResults());
                    splitFileContext.setSummaryResultsList(summaryResultsList);
                }
                startSeq += curBatchSize;
                startIndex += curBatchSize;
                curBatchSize = Math.min(fileBatchSize -= curBatchSize, 10000);
                splitFileContext.setComplete(idSet.size());
                this.getExportProgress().feedbackProgress(this.context.getBillDataCount(), splitFileContext.getComplete());
            } while (fileBatchSize > 0);
            if (i == fileList.size() - 1) {
                this.exportSummaryLine(billList, fieldCaptions, splitFileContext);
            }
            this.createFile(exportFileInfo);
        }
        return fileList;
    }

    private boolean sqlWithOutOrderByEntryField(String orderByExpr) {
        return StringUtils.isNotEmpty((CharSequence)orderByExpr) && (!orderByExpr.contains(".id") || !orderByExpr.contains(".seq"));
    }

    private boolean isDuplicationExportByList() {
        Object isDuplicationExportByList = SystemParamServiceHelper.loadPublicParameterFromCache((String)"isduplicationexportbylist");
        if (isDuplicationExportByList instanceof Boolean) {
            return (Boolean)isDuplicationExportByList;
        }
        return false;
    }

    private List<ExportFileInfo> toExcel4Selected(List<ExportFileInfo> fileList, ExportSplitFileContext splitFileContext, BillList billList, MainEntityType listEntityType, List<ListField> listFields) {
        int startSeq = 0;
        QueryResult rows = null;
        HashSet<Object> idSet = new HashSet<Object>(16);
        for (int i = 0; i < fileList.size(); ++i) {
            this.context.setFileFirstRow(true);
            ExportFileInfo exportFileInfo = fileList.get(i);
            int start = 0;
            List<ListSelectedRow> selectedRowList = exportFileInfo.getSelectedRowList();
            while (start < selectedRowList.size()) {
                ListSelectedRowCollection subRowSelection = new ListSelectedRowCollection();
                if (this.getExportSuspendAppCache().get(this.getExportSuspendCacheKey(), String.class) != null) {
                    this.getExportSuspendAppCache().remove(this.getExportSuspendCacheKey());
                    return new ArrayList<ExportFileInfo>();
                }
                List<ListSelectedRow> subList = selectedRowList.subList(start, Math.min(start + 10000, selectedRowList.size()));
                subRowSelection.addAll(subList);
                try (ArchiveRoute mr = ArchiveRoute.mapRoute((String)billList.getContext().getRouteKey(), (String)billList.getContext().getArchiveKey());){
                    rows = billList.getSelectedRowDatas(listFields, subRowSelection);
                }
                if (rows != null) {
                    this.sortRows(rows, subRowSelection);
                    this.exporter.write(this.formatRows(listEntityType, billList, this.context.getZeroShow(), rows, this.context.getFieldCaptions(), idSet, startSeq));
                    List<List<SummaryResult>> summaryResultsList = splitFileContext.getSummaryResultsList();
                    summaryResultsList.add(rows.getSummaryResults());
                    splitFileContext.setSummaryResultsList(summaryResultsList);
                }
                start += 10000;
                startSeq += subList.size();
                subRowSelection.clear();
                splitFileContext.setComplete(idSet.size());
                this.getExportProgress().feedbackProgress(this.context.getBillDataCount(), splitFileContext.getComplete());
            }
            if (i == fileList.size() - 1) {
                this.exportSummaryLine(billList, this.context.getFieldCaptions(), splitFileContext);
            }
            this.createFile(exportFileInfo);
        }
        return fileList;
    }

    private List<ExportFileInfo> splitFile4NotSelected(boolean hasEntryField, List<Object> pkIdList) {
        ArrayList<ExportFileInfo> fileList = new ArrayList<ExportFileInfo>(10);
        int maxFileRowSize = ExportFileInfo.maxFileRowSize;
        if (!(this.getBillList().getEntityType() instanceof QueryEntityType) && hasEntryField) {
            String entryEntity = this.getBillList().getEntryEntity();
            EntityType entityType = (EntityType)this.getMainType().getAllEntities().get(entryEntity);
            IDataEntityType parent = entityType.getParent();
            Map<Object, Integer> entryRowCount = this.getEntryRowCountMap(pkIdList, entityType, parent);
            int curFileRowCount = 0;
            for (Object pkId : pkIdList) {
                int curBillRowCount = entryRowCount.getOrDefault(pkId, 1);
                if (curBillRowCount >= maxFileRowSize) {
                    if (curFileRowCount != 0) {
                        fileList.add(this.createExportFileInfo(curFileRowCount));
                        curFileRowCount = 0;
                    }
                    int fileCount = ExportFileInfo.getFileCount(curBillRowCount);
                    for (int i = 0; i < fileCount; ++i) {
                        int batSize = i == fileCount - 1 ? curBillRowCount - i * maxFileRowSize : maxFileRowSize;
                        fileList.add(this.createExportFileInfo(batSize));
                    }
                    continue;
                }
                if (curFileRowCount + curBillRowCount > maxFileRowSize) {
                    fileList.add(this.createExportFileInfo(curFileRowCount));
                    curFileRowCount = 0;
                }
                curFileRowCount += curBillRowCount;
            }
            if (curFileRowCount != 0) {
                fileList.add(this.createExportFileInfo(curFileRowCount));
            }
        } else {
            int fileCount = ExportFileInfo.getFileCount(pkIdList.size());
            for (int i = 0; i < fileCount; ++i) {
                int size = i == fileCount - 1 ? pkIdList.size() - i * maxFileRowSize : maxFileRowSize;
                fileList.add(this.createExportFileInfo(size));
            }
        }
        log.info("exportAll splitFile fileList is " + SerializationUtils.toJsonString(fileList));
        return fileList;
    }

    private Map<Object, Integer> getEntryRowCountMap(List<Object> pkIdList, EntityType entityType, IDataEntityType parent) {
        Map<Object, Integer> entryRowCount = new LinkedHashMap<Object, Integer>(16);
        if (parent instanceof MainEntityType) {
            entryRowCount = super.getEntryRowCount(pkIdList, this.getMainType(), entityType, null);
        } else if (parent instanceof EntryType) {
            entryRowCount = super.getEntryRowCount(pkIdList, this.getMainType(), (EntityType)parent, entityType);
        }
        return entryRowCount;
    }

    private boolean checkHasEntryField() {
        if (this.hasEntryField != null) {
            return this.hasEntryField;
        }
        List<KeyValue> visibleCol = this.context.getFieldCaptions();
        HashSet<String> allEntryFieldSet = new HashSet<String>();
        Map allEntities = this.getMainType().getAllEntities();
        Set entries = allEntities.entrySet();
        for (Map.Entry entry : entries) {
            if (!(entry.getValue() instanceof EntryType)) continue;
            allEntryFieldSet.add(((EntityType)entry.getValue()).getName());
            allEntryFieldSet.addAll(((EntityType)entry.getValue()).getFields().keySet());
        }
        log.info("checkHasEntryField result start , visibleCol is " + SerializationUtils.toJsonString(visibleCol));
        log.info("checkHasEntryField result start , allEntryFieldSet is " + SerializationUtils.toJsonString(allEntryFieldSet));
        for (KeyValue keyValue : visibleCol) {
            this.hasEntryField = ExportListTask.isHasEntryField(allEntryFieldSet, keyValue);
            if (!this.hasEntryField.booleanValue()) continue;
            break;
        }
        log.info("checkHasEntryField result is " + this.hasEntryField);
        return this.hasEntryField;
    }

    private static boolean isHasEntryField(Set<String> allEntryFieldSet, KeyValue keyValue) {
        String fieldKey = keyValue.key;
        if (fieldKey.contains(".")) {
            fieldKey = fieldKey.split("\\.")[0];
        }
        if (allEntryFieldSet.contains(fieldKey)) {
            log.info("checkHasEntryField result is true , fieldKey is " + fieldKey);
            return true;
        }
        if (keyValue.value instanceof List) {
            for (Object tmpListValue : (List)keyValue.value) {
                if (!(tmpListValue instanceof KeyValue)) continue;
                return ExportListTask.isHasEntryField(allEntryFieldSet, (KeyValue)tmpListValue);
            }
        }
        if (keyValue.value instanceof KeyValue) {
            return ExportListTask.isHasEntryField(allEntryFieldSet, (KeyValue)keyValue.value);
        }
        return false;
    }

    private EntityType getFirstEntryType() {
        EntityType firstEntryType = null;
        BillEntityType mainType = this.getMainType();
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            if (!(((EntityType)entry.getValue()).getParent() instanceof MainEntityType)) continue;
            firstEntryType = (EntityType)entry.getValue();
            break;
        }
        return firstEntryType;
    }

    private String createFile(ExportFileInfo exportFileInfo) {
        String url = this.exporter.flushToLocal(this.getListPluginProxy(), this.exportEventArgs, this.context.getSaveDir());
        log.info("kd.bos.mvc.export.ExportListTask exporter.flush end url --------- " + url);
        exportFileInfo.setUrl(url);
        this.exporter = new ListExporter(ResManager.loadKDString((String)"\u5217\u8868\u6570\u636e", (String)"ExportListTask_0", (String)BOS_EXPORT, (Object[])new Object[0]), this.context.getFieldCaptions(), true, this.getMainType().getName());
        return url;
    }

    private ExportFileInfo createExportFileInfo(List<ListSelectedRow> selectedRowsOfFile) {
        ExportFileInfo fileInfo = new ExportFileInfo();
        fileInfo.setSelectedRowList(selectedRowsOfFile);
        return fileInfo;
    }

    private ExportFileInfo createExportFileInfo(int batchSize) {
        ExportFileInfo fileInfo = new ExportFileInfo();
        fileInfo.setBatchSize(batchSize);
        return fileInfo;
    }

    @Override
    protected List<String> getListFields() {
        return this.getBillList().getCachedListFields();
    }

    private void exportSummaryResult(List<KeyValue> fieldCaptions, List<List<SummaryResult>> summaryResultsList) {
        if (summaryResultsList.isEmpty()) {
            return;
        }
        Map<String, NumberPrecision> summaryMap = this.getSummaryMap(summaryResultsList);
        List<List<Object>> exportSummaryData = this.getExportSummaryData(fieldCaptions, summaryMap);
        this.exporter.write(exportSummaryData);
    }

    private List<List<Object>> getExportSummaryData(List<KeyValue> fieldCaptions, Map<String, NumberPrecision> summaryMap) {
        ArrayList<Object> sumRes = new ArrayList<Object>(10);
        for (int i = 0; i < fieldCaptions.size(); ++i) {
            if (i == 0) {
                sumRes.add(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ExportListTask_3", (String)BOS_EXPORT, (Object[])new Object[0]));
                continue;
            }
            KeyValue keyValue = fieldCaptions.get(i);
            this.fillExportData(summaryMap, sumRes, keyValue);
        }
        ArrayList<List<Object>> exportSummaryData = new ArrayList<List<Object>>(1);
        exportSummaryData.add(sumRes);
        return exportSummaryData;
    }

    private void fillExportData(Map<String, NumberPrecision> summaryMap, List<Object> sumRes, KeyValue keyValue) {
        String fieldName = keyValue.key;
        if (!summaryMap.containsKey(fieldName)) {
            if (!this.checkKeyValueType(keyValue, ListColumnType.ListColumnGroup)) {
                sumRes.add(null);
                return;
            }
            if (!(keyValue.value instanceof KeyValue)) {
                sumRes.add(null);
                return;
            }
            Object listGroupValue = ((KeyValue)keyValue.value).value;
            if (!(listGroupValue instanceof List)) {
                sumRes.add(null);
                return;
            }
            List listGroup = (List)listGroupValue;
            for (Object obj : listGroup) {
                if (!(obj instanceof KeyValue)) continue;
                KeyValue item = (KeyValue)obj;
                this.fillExportData(summaryMap, sumRes, item);
            }
            return;
        }
        if (this.isSensitive(fieldName)) {
            sumRes.add("******");
            return;
        }
        sumRes.add(summaryMap.get(fieldName).toString());
    }

    private boolean checkKeyValueType(KeyValue keyValue, ListColumnType listColumnType) {
        return keyValue.extend != null && keyValue.extend.length >= 1 && listColumnType.getValue() == ((Integer)keyValue.extend[0]).intValue();
    }

    private Map<String, NumberPrecision> getSummaryMap(List<List<SummaryResult>> summaryResultsList) {
        HashMap<String, NumberPrecision> summaryMap = new HashMap<String, NumberPrecision>(16);
        for (List<SummaryResult> summaryResults : summaryResultsList) {
            summaryResults.forEach(summaryResult -> {
                if (summaryResult != null && summaryResult.getNumberPrecision() != null) {
                    FilterField field = FilterField.create((MainEntityType)((MainEntityType)this.getBillList().getEntityType()), (String)summaryResult.getFieldName());
                    if (field.getFieldProp() instanceof QtyProp) {
                        summaryResult.getNumberPrecision().setStripTrailingZeros(true);
                    }
                    this.fillSummaryMap((Map<String, NumberPrecision>)summaryMap, (SummaryResult)summaryResult);
                }
            });
        }
        return summaryMap;
    }

    private void fillSummaryMap(Map<String, NumberPrecision> summaryMap, SummaryResult summaryResult) {
        String fieldName = summaryResult.getFieldName();
        NumberPrecision summaryResultNumberPrecision = summaryResult.getNumberPrecision();
        if (summaryResultNumberPrecision == null) {
            return;
        }
        if (!summaryMap.containsKey(fieldName)) {
            summaryMap.put(fieldName, summaryResultNumberPrecision);
            return;
        }
        NumberPrecision numberPrecision = summaryMap.get(fieldName);
        numberPrecision.addResult(summaryResultNumberPrecision.getResult());
    }

    private void sortRows(QueryResult rows, ListSelectedRowCollection subRowSelection) {
        int i;
        List formatRowDatas = rows.getFormatRowDatas();
        DynamicObjectCollection collection = rows.getCollection();
        HashMap sortFormatRowDataMap = new HashMap(16);
        HashMap<Object, Integer> sortRowMap = new HashMap<Object, Integer>(16);
        if (collection.size() != subRowSelection.size()) {
            List pkIds = collection.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            log.warn("\u5217\u8868\u67e5\u8be2\u51fa\u6765\u7684\u6570\u636e\u6709\u8bef");
            log.warn("\u539fpkIds:" + Arrays.toString(subRowSelection.getPrimaryKeyValues()) + "-----\u67e5\u8be2\u51fa\u6765\u7684pkIds:" + Arrays.toString(pkIds.toArray()));
        }
        for (i = 0; i < subRowSelection.size(); ++i) {
            ListSelectedRow selectedRow = subRowSelection.get(i);
            sortRowMap.put(selectedRow.getPrimaryKeyValue(), i);
        }
        for (i = 0; i < collection.size(); ++i) {
            sortFormatRowDataMap.put(formatRowDatas.get(i), ((DynamicObject)collection.get(i)).getPkValue());
        }
        collection.sort((row1, row2) -> {
            Integer seq2;
            Integer seq1 = (Integer)sortRowMap.get(row1.getPkValue());
            if (this.checkNull(seq1, seq2 = (Integer)sortRowMap.get(row2.getPkValue()))) {
                log.warn(row1.getPkValue() + ":" + seq1 + "-------" + row2.getPkValue() + ":" + seq2);
                return 0;
            }
            return seq1 - seq2;
        });
        formatRowDatas.sort((formatRowData1, formatRowData2) -> {
            Integer seq2;
            Object pkId2;
            Object pkId1 = sortFormatRowDataMap.get(formatRowData1);
            if (this.checkNull(pkId1, pkId2 = sortFormatRowDataMap.get(formatRowData2))) {
                return 0;
            }
            Integer seq1 = (Integer)sortRowMap.get(pkId1);
            if (this.checkNull(seq1, seq2 = (Integer)sortRowMap.get(pkId2))) {
                return 0;
            }
            return seq1 - seq2;
        });
        List collect = collection.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
    }

    private boolean checkNull(Object o1, Object o2) {
        return o1 == null || o2 == null;
    }

    private ExportListContext buildContext() {
        BillList billList = this.getBillList();
        HashSet<String> zeroShow = new HashSet<String>();
        FilterContainer filterContainer = this.getFilterContainer();
        if (filterContainer != null) {
            filterContainer.bindData(null);
        }
        Set<String> columns = this.prepareListColumns(billList);
        billList.queryBatchData(0, 1);
        List listFields = billList.getListFields();
        EntityType dataEntityType = billList.getListModel().getDataEntityType();
        List<KeyValue> fieldCaptions = this.prepareListHeader(billList, dataEntityType, columns, zeroShow);
        BillEntityType listEntityType = this.getMainType();
        String fileName = this.getExportFileName();
        this.exportEventArgs = new ExportFileEvent(this.getParentView(), this.getMainType(), fileName);
        SensitiveArgs sensitiveArgs = new SensitiveArgs((Object)this);
        AbstractListViewPluginProxy proxy = this.getListPluginProxy();
        if (proxy != null) {
            proxy.fireBeforeExportFile((BeforeExportFileEvent)this.exportEventArgs);
            proxy.fireBeforeDesensitive(sensitiveArgs);
        }
        int billDataCount = 0;
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] selectIds = selectedRows.getPrimaryKeyValues();
        boolean isNoSelect = selectIds == null || selectIds.length == 0;
        boolean defaultExportAll = this.isDefaultExportListAll();
        if (!isNoSelect) {
            billDataCount = new HashSet<Object>(Arrays.asList(selectIds)).size();
        } else if (defaultExportAll) {
            IListModel listModel = billList.getListModel();
            listModel.setFilterParameter(billList.generalFilterParameter());
            listModel.setNeedKeyFields(true);
            listModel.setListFields(listFields);
            IListDataProvider provider = listModel.getProvider();
            boolean isRegisterProperty = this.isRegisterProperty(provider);
            QueryBuilder qb = QueryBuilderFactory.createQueryBuilder((IListDataProvider)provider, (int)0, (int)1, (provider.isCustomListDataProvider() && !isRegisterProperty ? 1 : 0) != 0);
            qb.setFilters(billList.generalFilterParameter().getQFilters().toArray(new QFilter[0]));
            try {
                log.info("----\u5f00\u59cb\u6267\u884c\u5217\u8868\u5bfc\u51fa----\u51c6\u5907\u6761\u4ef6----" + JSON.toJSONString((Object)qb.getFilters()));
            }
            catch (Exception e) {
                log.warn((Throwable)e);
            }
            billDataCount = ExportListUtil.getBillDataCount(billList, this.getParentView().getPageCache(), this.getEntityNumber());
        }
        String mainEntityDisplayName = this.getParentView().getFormShowParameter().getCaption();
        File saveDir = FileHandlerUtil.createSaveDir((String)"data_excel_writer");
        ExportListContext expCtx = new ExportListContext().setLogId(this.getExportLogObj().getPkValue()).setFileName(fileName).setBillDataCount(billDataCount).setMainEntityDisplayName(mainEntityDisplayName).setBillList(billList).setListEntityType((MainEntityType)listEntityType).setZeroShow(zeroShow).setFieldCaptions(fieldCaptions).setListFields((List<ListField>)(isNoSelect && defaultExportAll ? null : listFields)).setSelectedRows(selectedRows).setExptType(this.getExptType()).setListPageId(this.getParentView().getPageId()).setSensitiveArgs(sensitiveArgs).setFillParent(this.isFillParent()).setSensitiveArgs(sensitiveArgs);
        expCtx.setSaveDir(saveDir);
        return expCtx;
    }

    private String getExportFileName() {
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("MMddHHmmss");
        String nowDateFormat = format.format(now);
        String entityName = "";
        LocaleString localeString = this.getParentView().getFormShowParameter().getFormConfig().getCaption();
        if (localeString != null) {
            entityName = localeString.getLocaleValue();
        } else if (this.getParams().get("entityname") != null) {
            entityName = this.getParams().get("entityname") + "";
        }
        String fileName = String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5217\u8868_%1$s_%2$s", (String)"ExportListTask_1", (String)BOS_EXPORT, (Object[])new Object[0]), entityName, nowDateFormat);
        fileName = RequestContext.get().getLang() == Lang.zh_CN || RequestContext.get().getLang() == Lang.zh_TW ? BlankPattern.matcher(FileNamePattern.matcher(fileName).replaceAll("")).replaceAll("_") : FileNamePattern.matcher(fileName).replaceAll("");
        int length = fileName.getBytes().length;
        if (length >= 250) {
            Object entityNumber = this.getParams().get("entitynumber");
            if (entityNumber == null) {
                entityNumber = "";
            }
            fileName = String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5217\u8868_%1$s_%2$s", (String)"ExportListTask_1", (String)BOS_EXPORT, (Object[])new Object[0]), entityNumber, nowDateFormat);
            fileName = BlankPattern.matcher(FileNamePattern.matcher(fileName).replaceAll("")).replaceAll("_");
        }
        return fileName;
    }

    private Set<String> prepareListColumns(BillList billList) {
        HashSet<String> listColumns = new HashSet<String>();
        for (IListColumn col : billList.getShowListColumns()) {
            if (col instanceof ListOperationColumn) continue;
            if (col instanceof DynamicTextListColumn) {
                listColumns.add(((DynamicTextListColumn)col).getKey());
                continue;
            }
            listColumns.add(col.getListFieldKey());
        }
        return listColumns;
    }

    private List<KeyValue> prepareListHeader(BillList billList, EntityType entityType, Set<String> columns, Set<String> zeroShow) {
        String json = UserConfigServiceHelper.getSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getParentView().getFormShowParameter().getSettingKey());
        JSONObject settings = JSON.parseObject((String)json);
        Map<String, Boolean> userConfigColumnSettings = this.parseUserConfigColumnSettings();
        boolean hideSeq = billList.getListUserOption().isHideSeq();
        List containers = billList.getItems();
        Container gridView = null;
        String listGridViewKey = billList.getListGridViewKey();
        for (Control c : containers) {
            if (!c.getKey().equals(listGridViewKey)) continue;
            gridView = (Container)c;
        }
        ArrayList<KeyValue> fieldCaptions = new ArrayList<KeyValue>();
        if (null == gridView) {
            return fieldCaptions;
        }
        List items = gridView.getItems();
        LinkedHashMap<String, Control> pluginItems = new LinkedHashMap<String, Control>();
        BeforeCreateListColumnsArgs createColumns = billList.getBeforeCreateListColumnsArgs();
        if (createColumns != null) {
            for (IListColumn col : createColumns.getListColumns()) {
                if (col == null || col.getParent() != null && !col.getParent().getKey().equalsIgnoreCase(listGridViewKey)) continue;
                Control c = (Control)col;
                pluginItems.put(c.getKey(), c);
            }
            for (Control c : items) {
                pluginItems.remove(c.getKey());
            }
            items.addAll(pluginItems.values());
        }
        for (IListColumn col : gridView.getItems()) {
            KeyValue caption;
            List<KeyValue> captions;
            if (col instanceof ListOperationColumn || col instanceof ListColumn && billList.isDetailEntry() && !((ListColumn)col).isHeaderField()) continue;
            if (col instanceof ListColumnGroup) {
                ListColumnGroup groupColumn = (ListColumnGroup)col;
                if (!this.isListColumnVisible(entityType, userConfigColumnSettings, (Control)groupColumn) || (captions = this.getContainerCaption(entityType, settings, userConfigColumnSettings, groupColumn.getItems(), columns, zeroShow, hideSeq)).isEmpty()) continue;
                int seq = this.getListColumnGroupSeq(groupColumn);
                fieldCaptions.add(new KeyValue(groupColumn.getKey(), new KeyValue("" + groupColumn.getName(), captions, new Object[]{ListColumnType.ListColumnGroup.getValue()}, seq), new Object[]{ListColumnType.ListColumnGroup.getValue()}, seq));
                continue;
            }
            if (col instanceof FlexListColumn && ((FlexListColumn)col).isExpand() && ((FlexListColumn)col).getUserConfigColumnSettings() != null && ((FlexListColumn)col).getUserConfigColumnSettings().get("visible") instanceof Integer && (Integer)((FlexListColumn)col).getUserConfigColumnSettings().get("visible") != 10) {
                FlexListColumn flexListColumn = (FlexListColumn)col;
                List showListColumns = billList.getShowListColumns();
                Optional<IListColumn> any = showListColumns.stream().filter(arg_0 -> ExportListTask.lambda$prepareListHeader$3((Control)col, arg_0)).findAny();
                if (!any.isPresent() || !this.isListColumnVisible(entityType, userConfigColumnSettings, (Control)col)) continue;
                Map column = flexListColumn.createColumn((MainEntityType)this.getMainType());
                List<KeyValue> captions2 = this.getFlexColumnCaptions(column);
                if (captions2.size() > 0) {
                    fieldCaptions.add(new KeyValue(flexListColumn.getListFieldKey(), new KeyValue("" + flexListColumn.getCaption(), captions2, new Object[]{105, flexListColumn.getSeq()}), new Object[]{105, "default"}, flexListColumn.getSeq()));
                    continue;
                }
            }
            if (col instanceof MergeListColumn) {
                int mLen;
                JSONObject widthObj;
                MergeListColumn mergeColumn = (MergeListColumn)col;
                if (!this.isListColumnVisible(entityType, userConfigColumnSettings, (Control)mergeColumn) || (captions = this.getContainerCaption(entityType, settings, userConfigColumnSettings, mergeColumn.getItems(), null, zeroShow, hideSeq)).isEmpty()) continue;
                JSONObject jSONObject = widthObj = settings == null || mergeColumn.getParent() == null ? null : settings.getJSONObject(mergeColumn.getParent().getKey());
                if (widthObj != null) {
                    widthObj = widthObj.getJSONObject("cw");
                }
                int n = mLen = widthObj == null ? 0 : widthObj.getIntValue(DotPattern.matcher(mergeColumn.getListFieldKey()).replaceAll("_"));
                if (mLen == 0) {
                    for (KeyValue m : captions) {
                        if (!(m.value instanceof String)) continue;
                        mLen += ((String)m.value).length() * 16;
                    }
                }
                fieldCaptions.add(new KeyValue(mergeColumn.getListFieldKey(), new KeyValue("" + mergeColumn.getCaption(), captions, new Object[]{ListColumnType.MergeColumn.getValue(), mLen, "default"}, mergeColumn.getSeq()), new Object[]{ListColumnType.MergeColumn.getValue(), mLen, "default"}, mergeColumn.getSeq()));
                continue;
            }
            if (!(col instanceof IListColumn)) continue;
            String fieldKey = col.getListFieldKey();
            if (col instanceof DynamicTextListColumn) {
                fieldKey = col.getKey();
            }
            if (columns != null && !columns.contains(fieldKey) || (caption = this.buildFieldCaption(entityType, col, settings, userConfigColumnSettings, zeroShow, hideSeq)) == null) continue;
            fieldCaptions.add(caption);
        }
        this.sort(fieldCaptions);
        return fieldCaptions;
    }

    private Map<String, Boolean> parseUserConfigColumnSettings() {
        LinkedHashMap<String, Boolean> userConfigColumnSettings = new LinkedHashMap<String, Boolean>();
        for (Map<String, Object> listFieldsControlColumn : this.getListFieldsControlColumns()) {
            this.parseUserConfigColumnSetting(userConfigColumnSettings, listFieldsControlColumn);
        }
        return userConfigColumnSettings;
    }

    private void parseUserConfigColumnSetting(Map<String, Boolean> userConfigColumnSettings, Map<String, Object> listFieldsControlColumn) {
        int visibleValue = Integer.parseInt(listFieldsControlColumn.get("visible").toString());
        String listFieldKey = listFieldsControlColumn.get("listFieldKey").toString();
        if (null != userConfigColumnSettings.get(listFieldKey)) {
            return;
        }
        userConfigColumnSettings.put(listFieldKey, ViewCommonUtil.getListColumnVisible((boolean)true, (boolean)this.isLookup(), (int)visibleValue));
        if (listFieldsControlColumn.containsKey("items") && listFieldsControlColumn.get("items") instanceof List) {
            List items = (List)listFieldsControlColumn.get("items");
            for (Map item : items) {
                this.parseUserConfigColumnSetting(userConfigColumnSettings, item);
            }
        }
    }

    private int getListColumnGroupSeq(ListColumnGroup groupColumn) {
        List groupColumnItems = groupColumn.getItems();
        if (CollectionUtils.isEmpty((Collection)groupColumnItems)) {
            return Integer.MAX_VALUE;
        }
        Control control = (Control)groupColumnItems.get(0);
        if (control instanceof IListColumn) {
            IListColumn cItem = (IListColumn)control;
            return cItem.getSeq();
        }
        if (control instanceof ListColumnGroup) {
            ListColumnGroup listItem = (ListColumnGroup)control;
            return this.getListColumnGroupSeq(listItem);
        }
        return Integer.MAX_VALUE;
    }

    private void sort(List<KeyValue> fieldCaptions) {
        fieldCaptions.sort((c1, c2) -> {
            if (c1.seq == null && c2.seq == null) {
                return 0;
            }
            if (c1.seq == null) {
                return 1;
            }
            if (c2.seq == null) {
                return -1;
            }
            return c1.seq.compareTo(c2.seq);
        });
        for (KeyValue sub : fieldCaptions) {
            Object subValue = sub.value;
            if (!(subValue instanceof KeyValue)) continue;
            KeyValue castKeyValue = (KeyValue)subValue;
            if (!(castKeyValue.value instanceof List) || sub.extend != null && ListColumnType.DynamicTextList.getValue() == ((Integer)sub.extend[ExtendColTypeIndex]).intValue()) continue;
            this.sort((List)castKeyValue.value);
        }
    }

    private KeyValue buildFieldCaption(EntityType entityType, IListColumn listColumn, JSONObject settings, Map<String, Boolean> userConfigColumnSettings, Set<String> zeroShow, boolean hideSeq) {
        JSONObject widthObj;
        if (listColumn.getSeqColType() == SeqColumnType.EntitySeq && hideSeq || listColumn instanceof AvatarListColumn || !this.isListColumnVisible(entityType, userConfigColumnSettings, (Control)listColumn)) {
            return null;
        }
        JSONObject jSONObject = widthObj = settings == null || listColumn.getParent() == null ? null : settings.getJSONObject(listColumn.getParent().getKey());
        if (widthObj != null) {
            widthObj = widthObj.getJSONObject("cw");
        }
        if (listColumn instanceof DynamicTextListColumn) {
            DynamicTextListColumn txtListColumn = (DynamicTextListColumn)listColumn;
            ArrayList<KeyValue> items = new ArrayList<KeyValue>(10);
            for (ListFieldMeta listFld : txtListColumn.getListFieldMetas()) {
                KeyValue keyValue = new KeyValue(listFld.getKey(), "");
                items.add(keyValue);
            }
            return new KeyValue(txtListColumn.getKey(), new KeyValue("" + txtListColumn.getCaption(), items, new Object[]{ListColumnType.DynamicTextList.getValue()}, txtListColumn.getSeq()), new Object[]{ListColumnType.DynamicTextList.getValue()}, txtListColumn.getSeq());
        }
        if (listColumn instanceof TemplateTextListColumn) {
            TemplateTextListColumn templateTextColumn = (TemplateTextListColumn)listColumn;
            if (templateTextColumn.getListFieldKey() == null) {
                templateTextColumn.setListFieldKey("templatetext");
            }
            if (templateTextColumn.getCaption() == null) {
                templateTextColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6a21\u5f0f\u6587\u672c\u5217", (String)"ExportListTask_2", (String)BOS_EXPORT, (Object[])new Object[0])));
            }
            Object[] extend = new Object[]{templateTextColumn.getColType(), widthObj == null ? 0 : widthObj.getIntValue(DotPattern.matcher(templateTextColumn.getListFieldKey()).replaceAll("_")), templateTextColumn.getTextAlign()};
            return new KeyValue(templateTextColumn.getListFieldKey(), "" + templateTextColumn.getCaption(), extend, templateTextColumn.getSeq());
        }
        if (listColumn instanceof VoucherNoListColumn) {
            VoucherNoListColumn voucherNo = (VoucherNoListColumn)listColumn;
            return new KeyValue(voucherNo.getKey(), "" + voucherNo.getCaption(), new Object[]{ListColumnType.VoucherNo.getValue(), widthObj == null ? 0 : widthObj.getIntValue(DotPattern.matcher(voucherNo.getKey()).replaceAll("_")), voucherNo.getTextAlign()}, voucherNo.getSeq());
        }
        if (listColumn instanceof ApproverListColumn) {
            ApproverListColumn approverListColumn = (ApproverListColumn)listColumn;
            return new KeyValue(approverListColumn.getKey(), "" + approverListColumn.getCaption(), new Object[]{104, widthObj == null ? 0 : widthObj.getIntValue(DotPattern.matcher(approverListColumn.getKey()).replaceAll("_")), approverListColumn.getTextAlign()}, approverListColumn.getSeq());
        }
        if (listColumn instanceof DecimalListColumn && ((DecimalListColumn)listColumn).isZeroShow()) {
            zeroShow.add(listColumn.getListFieldKey());
        }
        int colType = listColumn.getColType();
        if (listColumn instanceof ListColumn) {
            IDataEntityProperty prop = ((ListColumn)listColumn).getSrcFieldProp();
            if (prop != null && (prop instanceof FieldProp && "number".equals(((FieldProp)prop).getClientType()) || prop instanceof BasedataProp && "number".equals(((BasedataProp)prop).getClientType(listColumn.getListFieldKey())))) {
                colType = 2;
            }
            if (prop instanceof DateTimeProp && ((DateTimeProp)prop).getRegionType() == 2) {
                colType = 4;
            }
        }
        return new KeyValue(listColumn.getListFieldKey(), "" + listColumn.getCaption(), new Object[]{colType, widthObj == null ? 0 : widthObj.getIntValue(DotPattern.matcher(listColumn.getListFieldKey()).replaceAll("_")), this.getAlign(listColumn)}, listColumn.getSeq());
    }

    private List<KeyValue> getFlexColumnCaptions(Map<String, Object> column) {
        if (column == null || !column.containsKey(CHILDREN)) {
            return new ArrayList<KeyValue>(1);
        }
        List children = (List)column.get(CHILDREN);
        ArrayList<KeyValue> captions = new ArrayList<KeyValue>(children.size());
        for (Map child : children) {
            Object vi = child.get("vi");
            if (!(vi instanceof Integer) || (Integer)vi != 11 && (Integer)vi != 9) continue;
            String dataIndex = (String)child.get("dataIndex");
            LocaleString header = (LocaleString)child.get("header");
            captions.add(new KeyValue(dataIndex, header.getLocaleValue()));
        }
        return captions;
    }

    private String getAlign(IListColumn listColumn) {
        String align = listColumn.getTextAlign();
        if ((StringUtils.isBlank((CharSequence)align) || "default".equalsIgnoreCase(align)) && listColumn instanceof ListColumn) {
            if (((ListColumn)listColumn).getSrcFieldProp() instanceof ComboProp) {
                align = "center";
            } else if (((ListColumn)listColumn).getSrcFieldProp() instanceof DateTimeProp) {
                align = "left";
            } else if (((ListColumn)listColumn).getSrcFieldProp() instanceof DecimalProp) {
                align = "right";
            }
        }
        return align;
    }

    private List<KeyValue> getContainerCaption(EntityType entityType, JSONObject settings, Map<String, Boolean> userConfigColumnSettings, List<Control> items, Set<String> columns, Set<String> zeroShow, boolean hideSeq) {
        ArrayList<KeyValue> itemCaptions = new ArrayList<KeyValue>();
        for (Control c : items) {
            KeyValue caption;
            FlexListColumn flexListColumn;
            Map column;
            List<KeyValue> captions;
            List<KeyValue> captions2;
            if (c instanceof ListOperationColumn) continue;
            if (c instanceof ListColumnGroup) {
                ListColumnGroup groupColumn = (ListColumnGroup)c;
                if (!this.isListColumnVisible(entityType, userConfigColumnSettings, (Control)groupColumn) || (captions2 = this.getContainerCaption(entityType, settings, userConfigColumnSettings, groupColumn.getItems(), columns, zeroShow, hideSeq)).isEmpty()) continue;
                int seq = this.getListColumnGroupSeq(groupColumn);
                KeyValue groupCaption = new KeyValue(groupColumn.getKey(), new KeyValue("" + groupColumn.getName(), captions2, seq), new Object[]{ListColumnType.ListColumnGroup.getValue()}, seq);
                itemCaptions.add(groupCaption);
                continue;
            }
            if (c instanceof MergeListColumn) {
                int mLen;
                JSONObject widthObj;
                MergeListColumn mergeColumn = (MergeListColumn)c;
                if (!this.isListColumnVisible(entityType, userConfigColumnSettings, (Control)mergeColumn) || !columns.contains(((IListColumn)c).getListFieldKey()) || (captions2 = this.getContainerCaption(entityType, settings, userConfigColumnSettings, mergeColumn.getItems(), null, zeroShow, hideSeq)).isEmpty()) continue;
                JSONObject jSONObject = widthObj = settings == null || mergeColumn.getParent() == null ? null : settings.getJSONObject(mergeColumn.getParent().getKey());
                if (widthObj != null) {
                    widthObj = widthObj.getJSONObject("cw");
                }
                int n = mLen = widthObj == null ? 0 : widthObj.getIntValue(DotPattern.matcher(mergeColumn.getListFieldKey()).replaceAll("_"));
                if (mLen == 0) {
                    for (KeyValue m : captions2) {
                        if (!(m.value instanceof String)) continue;
                        mLen += ((String)m.value).length() * 16;
                    }
                }
                KeyValue mergeCaption = new KeyValue(mergeColumn.getListFieldKey(), new KeyValue("" + mergeColumn.getCaption(), captions2, new Object[]{ListColumnType.MergeColumn.getValue(), mLen, "default"}, mergeColumn.getSeq()), new Object[]{ListColumnType.MergeColumn.getValue(), mLen, "default"}, mergeColumn.getSeq());
                itemCaptions.add(mergeCaption);
                continue;
            }
            if (c instanceof FlexListColumn && ((FlexListColumn)c).isExpand() && (captions = this.getFlexColumnCaptions(column = (flexListColumn = (FlexListColumn)c).createColumn((MainEntityType)this.getMainType()))).size() > 0) {
                itemCaptions.add(new KeyValue(flexListColumn.getListFieldKey(), new KeyValue("" + flexListColumn.getCaption(), captions, new Object[]{105, flexListColumn.getSeq()}), new Object[]{105, "default"}, flexListColumn.getSeq()));
                continue;
            }
            if (!(c instanceof IListColumn)) continue;
            IListColumn listColumn = (IListColumn)c;
            String fieldKey = listColumn.getListFieldKey();
            if (c instanceof DynamicTextListColumn) {
                fieldKey = c.getKey();
            }
            if (columns != null && !columns.contains(fieldKey) || (caption = this.buildFieldCaption(entityType, (IListColumn)c, settings, userConfigColumnSettings, zeroShow, hideSeq)) == null) continue;
            itemCaptions.add(caption);
        }
        return itemCaptions;
    }

    private boolean isListColumnVisible(EntityType entityType, Map<String, Boolean> userConfigColumnSettings, Control listColumn) {
        Boolean configColumnVisible;
        String listFieldKey = null;
        int visibleValue = 0;
        if (listColumn instanceof IListColumn) {
            listFieldKey = ((IListColumn)listColumn).getListFieldKey();
            if (listFieldKey == null) {
                listFieldKey = listColumn.getKey();
            }
            visibleValue = ((IListColumn)listColumn).getVisible();
        } else if (listColumn instanceof MergeListColumn) {
            listFieldKey = ((MergeListColumn)listColumn).getListFieldKey();
            visibleValue = ((MergeListColumn)listColumn).getVisible();
        } else if (listColumn instanceof ListColumnGroup) {
            listFieldKey = ((ListColumnGroup)listColumn).getKey();
            visibleValue = ((ListColumnGroup)listColumn).getVisible();
        }
        Boolean bl = configColumnVisible = userConfigColumnSettings != null ? userConfigColumnSettings.get(listFieldKey) : null;
        if (configColumnVisible != null) {
            return configColumnVisible;
        }
        boolean listColumnVisible = ViewCommonUtil.getListColumnVisible((boolean)true, (boolean)false, (int)visibleValue);
        if (!listColumnVisible) {
            return false;
        }
        boolean lisColumnHidden = false;
        if (listColumn instanceof IListColumn) {
            lisColumnHidden = ((IListColumn)listColumn).isListColumnHidden(entityType, true, false);
        } else if (listColumn instanceof MergeListColumn) {
            lisColumnHidden = ((MergeListColumn)listColumn).isListColumnHidden(entityType, true, false);
        } else if (listColumn instanceof ListColumnGroup) {
            // empty if block
        }
        return listColumnVisible && !lisColumnHidden;
    }

    private List<Map<String, Object>> getListFieldsControlColumns() {
        String setting = UserConfigServiceHelper.getSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)((IListView)this.getParentView()).getBillFormId());
        if (StringUtils.isNotBlank((CharSequence)setting)) {
            return SerializationUtils.fromJsonStringToList((String)setting, Map.class);
        }
        return new ArrayList<Map<String, Object>>();
    }

    private boolean isLookup() {
        IListView listView = (IListView)this.getParentView();
        ListShowParameter listShowParameter = (ListShowParameter)listView.getFormShowParameter();
        return listShowParameter.isLookUp();
    }

    private List<List<Object>> formatRows(MainEntityType listEntityType, BillList billList, Set<String> zeroShow, QueryResult rows, List<KeyValue> fieldCaptions, Set<Object> idSet, int startSeq) {
        ArrayList<List<Object>> dataRows = new ArrayList<List<Object>>();
        List formatRowDatas = rows.getFormatRowDatas();
        Map<String, ListField> fieldMapping = ExportListTask.buildFieldMapping(billList.getListModel().getProvider().getVisibleSelectFieldList());
        ListUserOption providerListUserOption = billList.getListModel().getProvider().getListUserOption();
        if (providerListUserOption == null) {
            providerListUserOption = new ListUserOption();
        }
        boolean showSeq = !providerListUserOption.isHideSeq();
        boolean existSeq = rows.getCollection().getDynamicObjectType().getProperty("seq") != null;
        boolean existFSeq = rows.getCollection().getDynamicObjectType().getProperty("fseq") != null;
        ListUserOption listUserOption = billList.getListUserOption();
        if (listUserOption == null) {
            listUserOption = new ListUserOption();
        }
        boolean stripTrailingZeros = !listUserOption.isShowZero();
        int i = 0;
        FormatObject format = InteServiceHelper.getUserFormat((Long)Long.parseLong(RequestContext.get().getUserId()));
        String mainOrg = listEntityType.getMainOrg();
        long mainOrgId = 0L;
        for (DynamicObject row : rows.getCollection()) {
            startSeq = this.setRowSeq(listEntityType, startSeq, showSeq, existSeq, existFSeq, row);
            idSet.add(row.get("id"));
            NumberFormatProvider numFormat = rows.getNumberFormatProvider();
            if (StringUtils.isNotBlank((CharSequence)mainOrg) && this.containsMainOrg(mainOrg, row)) {
                mainOrgId = (Long)row.getDynamicObject(mainOrg).getPkValue();
            }
            FieldControlRule fieldControlRule = this.getFieldControlRule(mainOrgId);
            ArrayList<Object> rowData = new ArrayList<Object>(10);
            for (KeyValue kv : fieldCaptions) {
                ListField listField = fieldMapping.get(kv.key);
                if (listField == null && kv.extend != null && kv.extend.length > 0 && ((Integer)kv.extend[ExtendColTypeIndex]).intValue() == ListColumnType.VoucherNo.getValue()) {
                    listField = fieldMapping.get("$vouchernolistcolumn$");
                }
                if (listField == null && kv.extend != null && kv.extend.length > 0 && (Integer)kv.extend[ExtendColTypeIndex] == 104) {
                    listField = fieldMapping.get("$approverlistcolumn$");
                }
                Object value = null;
                if (listField == null && kv.extend != null && kv.extend.length > 0 && ((Integer)kv.extend[ExtendColTypeIndex]).intValue() == ListColumnType.DynamicTextList.getValue()) {
                    value = "";
                } else if (listField instanceof DynamicTextListField) {
                    String formatExp = ((DynamicTextListField)listField).getFormatExpression();
                    value = ExportListTask.formatDynamicTextListColumn(listEntityType, formatRowDatas, format, numFormat, zeroShow, kv, fieldMapping, row, i, formatExp, stripTrailingZeros);
                } else if (listField != null && kv.extend != null && kv.extend.length > 0 && (Integer)kv.extend[ExtendColTypeIndex] == 105) {
                    value = this.formatFlexExpandColumn(i, kv, formatRowDatas);
                } else if (listField != null) {
                    value = ExportListTask.formatNormalColumn(listEntityType, formatRowDatas, format, numFormat, zeroShow, kv, listField, row, i, stripTrailingZeros);
                } else {
                    if (!(kv.value instanceof KeyValue)) continue;
                    value = this.formatComplexColumn(listEntityType, formatRowDatas, format, numFormat, zeroShow, kv, fieldMapping, row, i, stripTrailingZeros);
                }
                if (value instanceof String) {
                    value = IgnoreStringPattern.matcher((CharSequence)value).replaceAll("");
                }
                boolean canExport = this.isCanExport(fieldControlRule, this.getFieldNumber(kv.key, listField, billList));
                value = this.tryDeSensitiveValue(row, kv, listField, value, canExport);
                value = this.canFillParent(listEntityType, kv, listField, row, value, fieldMapping);
                this.fillRowData(rowData, value);
            }
            dataRows.add(rowData);
            ++i;
            this.addIdSets(listEntityType, row);
            if (!this.context.isFileFirstRow()) continue;
            this.context.setFileFirstRow(false);
        }
        return dataRows;
    }

    private String getFieldNumber(String key, ListField listField, BillList billList) {
        EntityType entityType = billList.getEntityType();
        if (entityType instanceof QueryEntityType && listField != null) {
            String[] splitField;
            IDataEntityProperty srcFieldProp;
            int fieldIndex = 0;
            QueryEntityType queryEntity = (QueryEntityType)entityType;
            List joinEntity = queryEntity.getJoinEntitys();
            ArrayList joinFields = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)joinEntity)) {
                joinEntity.forEach(entity -> joinFields.addAll(Arrays.asList(StringUtils.split((String)entity.getIncludeFieldNames(), (String)","))));
            }
            if (joinFields.contains(key)) {
                ++fieldIndex;
            }
            if ((srcFieldProp = listField.getSrcFieldProp()) != null && srcFieldProp.getParent() instanceof EntryType) {
                ++fieldIndex;
            }
            if ((splitField = key.split("\\.")).length > fieldIndex) {
                StringBuilder field = new StringBuilder(splitField[0]);
                for (int i = 1; i <= fieldIndex; ++i) {
                    field.append(".").append(splitField[i]);
                }
                return field.toString();
            }
        }
        return key.split("\\.")[0];
    }

    private List<String> formatFlexExpandColumn(int i, KeyValue kv, List<FormatRowData> formatRowDatas) {
        KeyValue value = (KeyValue)kv.value;
        List children = (List)value.value;
        ArrayList<String> flexValues = new ArrayList<String>(children.size());
        FormatFieldData formatFieldData = formatRowDatas.get(i).get(kv.key);
        Object fieldValue = formatFieldData.getFieldValue();
        Map<String, String> fieldValueFormatMap = null;
        if (fieldValue instanceof List) {
            List fieldValueList = (List)fieldValue;
            fieldValueFormatMap = this.formatFieldValueMapFormat(fieldValueList, children);
        }
        boolean hasFlexValue = MapUtils.isNotEmpty(fieldValueFormatMap);
        for (KeyValue child : children) {
            String fieldValueFormat = null;
            if (hasFlexValue) {
                fieldValueFormat = fieldValueFormatMap.get(child.key);
            }
            flexValues.add(null != fieldValueFormat ? fieldValueFormat : "");
        }
        return flexValues;
    }

    private Map<String, String> formatFieldValueMapFormat(List fieldValueList, List<KeyValue> children) {
        HashMap<String, String> flexValueMapFormat = new HashMap<String, String>(fieldValueList.size());
        for (Object fieldValue : fieldValueList) {
            if (!(fieldValue instanceof Map)) continue;
            Map fieldValueTmp = (Map)fieldValue;
            String flexValueKey = (String)fieldValueTmp.get("k");
            Object flexValueVObject = fieldValueTmp.get("v");
            String flexValueV = "";
            if (flexValueVObject instanceof Object[] && ((Object[])flexValueVObject).length > 1) {
                Optional<KeyValue> any = children.stream().filter(keyValue -> StringUtils.equals((CharSequence)keyValue.key, (CharSequence)flexValueKey)).findAny();
                ArrayList<String> tmpList = new ArrayList<String>();
                if (any.isPresent()) {
                    KeyValue keyValue2 = any.get();
                    if (keyValue2.value instanceof String) {
                        String display = (String)keyValue2.value;
                        String numberOrName = display.substring(display.lastIndexOf(46));
                        String num = ResManager.loadKDString((String)"\u7f16\u7801", (String)"ExportWriterBuilder_1", (String)BOS_EXPORT, (Object[])new Object[0]);
                        String name = ResManager.loadKDString((String)"\u540d\u79f0", (String)"ExportWriterBuilder_2", (String)BOS_EXPORT, (Object[])new Object[0]);
                        if (StringUtils.contains((CharSequence)numberOrName, (CharSequence)num)) {
                            tmpList.add(String.valueOf(((Object[])flexValueVObject)[0]));
                        }
                        if (StringUtils.contains((CharSequence)numberOrName, (CharSequence)name)) {
                            tmpList.add(String.valueOf(((Object[])flexValueVObject)[1]));
                        }
                    }
                }
                flexValueV = String.join((CharSequence)",", tmpList);
            } else if (flexValueVObject instanceof String) {
                flexValueV = flexValueVObject.toString();
            }
            flexValueMapFormat.put(flexValueKey, flexValueV);
        }
        return flexValueMapFormat;
    }

    private Object tryDeSensitiveValue(DynamicObject row, KeyValue kv, ListField listField, Object value, boolean canExport) {
        if (!canExport) {
            return this.setDefalutDeSensitiveValue(value);
        }
        return this.tryDeSensitive(row, kv, listField, value);
    }

    private void fillRowData(List<Object> rowData, Object value) {
        if (this.isInstanceofList(value)) {
            rowData.addAll((List)value);
            return;
        }
        rowData.add(value);
    }

    private Object tryDeSensitive(DynamicObject row, KeyValue kv, ListField listField, Object value) {
        if (!this.isInstanceofList(value)) {
            value = this.deSensitive(kv.key, listField, row, value);
            return value;
        }
        List listValue = (List)value;
        ArrayList<Object> res = new ArrayList<Object>(10);
        for (Object obj : listValue) {
            res.add(this.deSensitive(kv.key, listField, row, obj));
        }
        return res;
    }

    private boolean isInstanceofList(Object value) {
        return value instanceof List;
    }

    private Object setDefalutDeSensitiveValue(Object value) {
        if (!this.isInstanceofList(value)) {
            value = "******";
            return value;
        }
        List listValue = (List)value;
        ArrayList<String> res = new ArrayList<String>(10);
        for (Object ignored : listValue) {
            res.add("******");
        }
        return res;
    }

    private int setRowSeq(MainEntityType listEntityType, int startSeq, boolean showSeq, boolean existSeq, boolean existFSeq, DynamicObject row) {
        if (showSeq) {
            if (existSeq) {
                row.set("seq", (Object)(++startSeq));
                return startSeq;
            }
            if (existFSeq) {
                row.set("fseq", (Object)(++startSeq));
            }
        }
        return startSeq;
    }

    private Object canFillParent(MainEntityType mainEntityType, KeyValue kv, ListField listField, DynamicObject row, Object value, Map<String, ListField> fieldMapping) {
        try {
            boolean existParentRow;
            if (this.context.isFillParent() || "seq".equals(kv.key) || "fseq".equals(kv.key) || listField instanceof VoucherNoListField || listField instanceof ApproverListField) {
                return value;
            }
            if (kv.value instanceof KeyValue) {
                for (int i = 0; i < ((List)((KeyValue)kv.value).value).size(); ++i) {
                    Object tmpVal = "";
                    boolean isList = value instanceof List;
                    if (isList) {
                        if (kv.extend != null && ListColumnType.MergeColumn.getValue() == ((Integer)kv.extend[ExtendColTypeIndex]).intValue()) {
                            tmpVal = ((List)value).get(0);
                        } else if (((List)value).size() > i) {
                            tmpVal = ((List)value).get(i);
                        }
                    } else {
                        tmpVal = value;
                    }
                    Object obj = this.canFillParent(mainEntityType, (KeyValue)((List)((KeyValue)kv.value).value).get(i), fieldMapping.get(((KeyValue)((List)((KeyValue)kv.value).value).get((int)i)).key), row, tmpVal, fieldMapping);
                    if (isList) {
                        if (kv.extend != null && ListColumnType.MergeColumn.getValue() == ((Integer)kv.extend[ExtendColTypeIndex]).intValue()) {
                            value = Collections.singletonList(obj);
                            continue;
                        }
                        if (((List)value).size() <= i) continue;
                        ((List)value).set(i, obj);
                        continue;
                    }
                    value = obj;
                }
            }
            if (null != listField && !(listField instanceof DynamicTextListField) && (existParentRow = this.existParentRow(mainEntityType, listField, row))) {
                if (value instanceof List && 105 == (Integer)kv.extend[ExtendColTypeIndex]) {
                    int size = ((List)value).size();
                    ArrayList<String> tmpList = new ArrayList<String>(size);
                    for (int i = 0; i < size; ++i) {
                        tmpList.add("");
                    }
                    value = tmpList;
                } else {
                    value = "";
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"ExportDataProgressFormPlugin_4", (String)BOS_EXPORT, (Object[])new Object[0]), new Object[0]));
        }
        return value;
    }

    private boolean existParentRow(MainEntityType mainEntityType, ListField listField, DynamicObject row) {
        if (this.context.isFileFirstRow()) {
            return false;
        }
        if (!(!listField.isSeq() && !(listField.getSrcFieldProp().getParent() instanceof BillEntityType) || this.context.getIdSetMap().get(mainEntityType.getName()) != null && this.context.getIdSetMap().get(mainEntityType.getName()).contains(row.getPkValue()))) {
            return false;
        }
        if (listField.getSrcFieldProp().getParent() instanceof SubEntryType) {
            return false;
        }
        if (listField.getSrcFieldProp().getParent() instanceof EntryType) {
            String name = listField.getSrcFieldProp().getParent().getName();
            Object id = row.get(listField.getSrcFieldProp().getParent().getName() + "." + listField.getSrcFieldProp().getParent().getPrimaryKey().getName());
            if (this.context.getIdSetMap().get(name) == null || !this.context.getIdSetMap().get(name).contains(id)) {
                return false;
            }
        }
        return true;
    }

    private void addIdSets(MainEntityType listEntityType, DynamicObject row) {
        if (this.context.isFillParent()) {
            return;
        }
        Map allEntities = listEntityType.getAllEntities();
        for (Map.Entry entityTypeEntry : allEntities.entrySet()) {
            if (entityTypeEntry.getValue() instanceof SubEntryType) continue;
            if (entityTypeEntry.getValue() instanceof EntryType) {
                String pkName = ((EntityType)entityTypeEntry.getValue()).getName() + "." + ((EntityType)entityTypeEntry.getValue()).getPrimaryKey().getName();
                if (null == row.getDataEntityType().getProperties().get((Object)pkName)) continue;
                this.context.addIdSet(((EntityType)entityTypeEntry.getValue()).getName(), row.get(pkName));
                continue;
            }
            if (row.getPkValue() == null) continue;
            this.context.addIdSet(((EntityType)entityTypeEntry.getValue()).getName(), row.getPkValue());
        }
    }

    private boolean containsMainOrg(String mainOrg, DynamicObject row) {
        IDataEntityType dataEntityType = row.getDataEntityType();
        return dataEntityType.getProperties().containsKey((Object)mainOrg) && row.getDynamicObject(mainOrg) != null;
    }

    private static Object formatNormalColumn(MainEntityType listEntityType, List<FormatRowData> formatRowDatas, FormatObject format, NumberFormatProvider numFormat, Set<String> zeroShow, KeyValue kv, ListField f, DynamicObject row, int i, boolean stripTrailingZeros) {
        AbstractColumnDesc columnDesc = f.getColumnDesc(row.getDynamicObjectType(), listEntityType.getMainOrg(), ExportListTask.isSpecialFormat(f));
        columnDesc.setUserFormat(format);
        Object value = ExportListTask.formatExportValue(row, columnDesc, numFormat, zeroShow.contains(kv.key), stripTrailingZeros);
        FormatRowData formatRow = formatRowDatas.get(i);
        if (formatRow != null) {
            Object fmtval;
            FormatFieldData formatData;
            if (columnDesc instanceof BaseDataColumnDesc) {
                columnDesc = ((BaseDataColumnDesc)columnDesc).getColumnDesc();
            }
            if ((formatData = formatRow.get(kv.key)) == null && kv.extend != null && kv.extend.length > 0 && ((Integer)kv.extend[ExtendColTypeIndex]).intValue() == ListColumnType.VoucherNo.getValue()) {
                formatData = formatRow.get("$vouchernolistcolumn$");
            }
            Object object = fmtval = formatData != null ? formatData.getFieldValue() : null;
            if (!StringUtils.isBlank((Object)fmtval)) {
                if (columnDesc instanceof TimeColumnDesc) {
                    if (fmtval instanceof Object[] && ((Object[])fmtval).length >= 2) {
                        Object valTmp = ((Object[])fmtval)[0];
                        value = valTmp instanceof String && StringUtils.isNotEmpty((CharSequence)valTmp.toString()) ? valTmp.toString() : ExportListTask.formatTimeStr((Integer)((Object[])fmtval)[1]);
                    }
                } else if (columnDesc instanceof DecimalColumnDesc || columnDesc instanceof AmountColumnDesc || columnDesc instanceof BigIntColumnDesc || columnDesc instanceof IntegerColumnDesc) {
                    if (value == null && fmtval instanceof Object[] && ((Object[])fmtval).length >= 2) {
                        value = ((Object[])fmtval)[DecimalValueIndex];
                    }
                } else if (columnDesc instanceof DateTimeColumnDesc && fmtval != null && fmtval.getClass().isArray()) {
                    if (fmtval instanceof Object[] && ((Object[])fmtval).length >= 2) {
                        fmtval = ((Object[])fmtval)[DateTimeValueIndex];
                    }
                    value = fmtval;
                } else if (columnDesc instanceof VoucherNoColumnDesc || columnDesc instanceof TextColumnDesc || columnDesc instanceof ApproverColumnDesc || value == null) {
                    value = fmtval;
                }
            }
        }
        return ExportListTask.checkAndToGetDesensitizeValue(f, value, row, listEntityType.getMainOrg());
    }

    private static Object checkAndToGetDesensitizeValue(ListField listField, Object value, DynamicObject row, String mainOrg) {
        Object ret;
        if (listField == null) {
            return value;
        }
        IDataEntityProperty fieldProp = listField.getSrcFieldProp();
        value = ExportListTask.getRealValue(value);
        if (fieldProp instanceof BasedataProp) {
            AbstractColumnDesc columnDesc = listField.getColumnDesc(row.getDynamicObjectType(), mainOrg, ExportListTask.isSpecialFormat(listField));
            columnDesc.setFormaType(2);
            ret = columnDesc.getDesensitizeValue(ResManager.getLanguage(), row, value);
        } else {
            ret = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)fieldProp, (String)ResManager.getLanguage(), (String)"EXPORT", (DynamicObject)row, (Object)value);
        }
        return ret;
    }

    private static Object getRealValue(Object value) {
        if (!(value instanceof Map)) {
            return value;
        }
        Map valueMap = (Map)value;
        if (valueMap.containsKey("result")) {
            Object result = valueMap.get("result");
            return result;
        }
        return value;
    }

    private static String formatTimeStr(int time) {
        if (time < 0) {
            return "";
        }
        int second = time % 60;
        int minute = (time /= 60) % 60;
        int hour = (time /= 60) % 24;
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    private List<Object> formatComplexColumn(MainEntityType listEntityType, List<FormatRowData> formatRowDatas, FormatObject format, NumberFormatProvider numFormat, Set<String> zeroShow, KeyValue kv, Map<String, ListField> fieldMapping, DynamicObject row, int i, boolean stripTrailingZeros) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (KeyValue k : (List)((KeyValue)kv.value).value) {
            Object object = ExportListTask.getDynamicText(listEntityType, formatRowDatas, format, numFormat, zeroShow, k, fieldMapping, row, i, stripTrailingZeros);
            if (object != null) {
                values.add(object);
                continue;
            }
            if (k.extend != null && (Integer)k.extend[0] == 105) {
                values.addAll(this.formatFlexExpandColumn(i, k, formatRowDatas));
                continue;
            }
            if (k.value instanceof KeyValue) {
                List<Object> subValues = this.formatComplexColumn(listEntityType, formatRowDatas, format, numFormat, zeroShow, k, fieldMapping, row, i, stripTrailingZeros);
                values.addAll(subValues);
                continue;
            }
            ExportListTask.convertValue(listEntityType, formatRowDatas, format, numFormat, k, row, fieldMapping, values, zeroShow, i, stripTrailingZeros);
        }
        if (kv.extend != null && ListColumnType.MergeColumn.getValue() == ((Integer)kv.extend[ExtendColTypeIndex]).intValue()) {
            StringBuilder sb = new StringBuilder();
            for (Object e : values) {
                if (!StringUtils.isNotBlank(e)) continue;
                if (sb.length() != 0) {
                    sb.append(' ');
                }
                sb.append(e);
            }
            return Collections.singletonList(sb.toString());
        }
        return values;
    }

    private static Object getDynamicText(MainEntityType listEntityType, List<FormatRowData> formatRowDatas, FormatObject format, NumberFormatProvider numFormat, Set<String> zeroShow, KeyValue keyValue, Map<String, ListField> fieldMapping, DynamicObject row, int i, boolean stripTrailingZeros) {
        if (fieldMapping.containsKey(keyValue.key) && fieldMapping.get(keyValue.key) instanceof DynamicTextListField) {
            String formatExp = ((DynamicTextListField)fieldMapping.get(keyValue.key)).getFormatExpression();
            Object dynamicText = ExportListTask.formatDynamicTextListColumn(listEntityType, formatRowDatas, format, numFormat, zeroShow, keyValue, fieldMapping, row, i, formatExp, stripTrailingZeros);
            return dynamicText;
        }
        return null;
    }

    private static void convertValue(MainEntityType listEntityType, List<FormatRowData> formatRowDatas, FormatObject format, NumberFormatProvider numFormat, KeyValue k, DynamicObject row, Map<String, ListField> fieldMapping, List<Object> values, Set<String> zeroShow, int i, boolean stripTrailingZeros) {
        ListField listField = fieldMapping.get(k.key);
        if (listField == null) {
            return;
        }
        AbstractColumnDesc columnDesc = listField.getColumnDesc(row.getDynamicObjectType(), listEntityType.getMainOrg(), ExportListTask.isSpecialFormat(listField));
        columnDesc.setUserFormat(format);
        Object value = ExportListTask.formatExportValue(row, columnDesc, numFormat, zeroShow.contains(k.key), stripTrailingZeros);
        if (value != null) {
            value = ExportListTask.checkAndToGetDesensitizeValue(listField, value, row, listEntityType.getMainOrg());
            values.add(value);
            return;
        }
        value = formatRowDatas.get(i).get(k.key).getFieldValue();
        if (StringUtils.isBlank((Object)value)) {
            value = ExportListTask.checkAndToGetDesensitizeValue(listField, value, row, listEntityType.getMainOrg());
            values.add(value);
            return;
        }
        if (columnDesc instanceof BaseDataColumnDesc) {
            columnDesc = ((BaseDataColumnDesc)columnDesc).getColumnDesc();
        }
        if (columnDesc instanceof DecimalColumnDesc || columnDesc instanceof AmountColumnDesc || columnDesc instanceof BigIntColumnDesc || columnDesc instanceof IntegerColumnDesc) {
            if (value.getClass().isArray() && ((Object[])value).length >= 2) {
                value = ((Object[])value)[DecimalValueIndex];
            }
            if (StringUtils.isNotBlank((Object)value) && BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0 && !zeroShow.contains(k.key)) {
                value = null;
            }
        } else if (columnDesc instanceof DateTimeColumnDesc && value.getClass().isArray() && ((Object[])value).length >= 2) {
            value = ((Object[])value)[DateTimeValueIndex];
        }
        value = ExportListTask.checkAndToGetDesensitizeValue(listField, value, row, listEntityType.getMainOrg());
        values.add(value);
    }

    private static Object formatDynamicTextListColumn(MainEntityType listEntityType, List<FormatRowData> formatRowDatas, FormatObject format, NumberFormatProvider numFormat, Set<String> zeroShow, KeyValue kv, Map<String, ListField> fieldMapping, DynamicObject row, int i, String formatExp, boolean stripTrailingZeros) {
        Object value = null;
        String v = formatExp == null ? "" : formatExp;
        for (KeyValue kValue : (List)((KeyValue)kv.value).value) {
            String key = kValue.key;
            ListField listField = fieldMapping.get(key);
            AbstractColumnDesc columnDesc = listField.getColumnDesc(row.getDynamicObjectType(), listEntityType.getMainOrg(), ExportListTask.isSpecialFormat(listField));
            columnDesc.setUserFormat(format);
            value = ExportListTask.formatExportValue(row, columnDesc, numFormat, zeroShow.contains(key), stripTrailingZeros);
            if (value != null) {
                value = ExportListTask.checkAndToGetDesensitizeValue(listField, value, row, listEntityType.getMainOrg());
                v = v.replace(String.format("{%s}", key), value.toString());
                continue;
            }
            value = formatRowDatas.get(i).get(key).getFieldValue();
            if (StringUtils.isNotBlank((Object)value)) {
                if (columnDesc instanceof BaseDataColumnDesc) {
                    columnDesc = ((BaseDataColumnDesc)columnDesc).getColumnDesc();
                }
                if (columnDesc instanceof DecimalColumnDesc || columnDesc instanceof AmountColumnDesc || columnDesc instanceof BigIntColumnDesc || columnDesc instanceof IntegerColumnDesc) {
                    if (value.getClass().isArray() && ((Object[])value).length >= 2) {
                        value = ((Object[])value)[DecimalValueIndex];
                    }
                    if (value != null && BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0 && !zeroShow.contains(kv.key)) {
                        value = null;
                    }
                } else if (columnDesc instanceof DateTimeColumnDesc && value.getClass().isArray() && ((Object[])value).length >= 2) {
                    value = ((Object[])value)[DateTimeValueIndex];
                }
            }
            value = ExportListTask.checkAndToGetDesensitizeValue(listField, value, row, listEntityType.getMainOrg());
            v = v.replace(String.format("{%s}", key), value != null ? value.toString() : "");
        }
        return v;
    }

    private static Object formatExportValue(DynamicObject dr, AbstractColumnDesc col, NumberFormatProvider numberFormatProvider, boolean zeroShow, boolean stripTrailingZeros) {
        Object value = col.getValue(dr);
        if (StringUtils.isNotBlank((Object)value)) {
            if (col instanceof FlexColumnDesc) {
                FlexColumnDesc flexColumnDesc = (FlexColumnDesc)col;
                List flexValues = (List)FlexValueFormatUtils.getListDisplayValue((DynamicObject)dr, (FlexProp)((FlexProp)flexColumnDesc.getFieldProp()), (String)flexColumnDesc.getBasePropKey());
                ArrayList<String> displayValues = new ArrayList<String>();
                for (Map item : flexValues) {
                    String alias = (String)item.get("alias");
                    if (!StringUtils.isNotBlank((CharSequence)alias)) continue;
                    displayValues.add(alias);
                }
                value = String.join((CharSequence)"; ", displayValues);
            } else if (col instanceof ComboColumnDesc) {
                value = ExportListTask.formatComboItems((ComboColumnDesc)col, value, col);
            } else if (col instanceof TimeColumnDesc) {
                if (((Object[])value).length >= 2) {
                    value = ((Object[])value)[DateTimeValueIndex];
                }
            } else if (col instanceof DecimalColumnDesc || col instanceof AmountColumnDesc || col instanceof BigIntColumnDesc || col instanceof IntegerColumnDesc) {
                if (value instanceof Object[] && ((Object[])value).length >= 2) {
                    value = ((Object[])value)[DecimalValueIndex];
                }
                if (StringUtils.isNotBlank((Object)value)) {
                    BigDecimal bigDecimal = new BigDecimal(value.toString());
                    if (!zeroShow && BigDecimal.ZERO.compareTo(bigDecimal) == 0) {
                        value = "";
                    } else if (numberFormatProvider != null) {
                        NumberPrecision numberPrecision = numberFormatProvider.getFormatPrecision(((ColumnDesc)col).getFieldProp().getName(), dr);
                        if (numberPrecision != null) {
                            boolean groupingUsed = numberPrecision.isGroupingUsed();
                            numberPrecision.setGroupingUsed(false);
                            String numberString = numberPrecision.toString();
                            if (!ExportListTask.isDecimalTooBig(numberString)) {
                                int currLen = numberString.length();
                                if (stripTrailingZeros) {
                                    if (ExportListTask.isValidBigDecimal(numberString)) {
                                        numberPrecision.setResult(new BigDecimal(numberString));
                                    }
                                    numberPrecision.setStripTrailingZeros(stripTrailingZeros);
                                    int diffPrecision = currLen - numberPrecision.toString().length();
                                    numberPrecision.setPrecision(numberPrecision.getPrecision() - diffPrecision);
                                }
                                numberPrecision.setGroupingUsed(groupingUsed);
                                if (numberPrecision.getPrecision() != 23) {
                                    value = numberPrecision;
                                }
                            } else if (numberPrecision.getResult().compareTo(new BigDecimal(value.toString())) == 0) {
                                numberPrecision.setStripTrailingZeros(stripTrailingZeros);
                                value = numberString;
                            } else if (ExportListTask.isDecimalTooBig(value.toString())) {
                                value = value.toString();
                            }
                        }
                    } else if (stripTrailingZeros) {
                        value = new BigDecimal(bigDecimal.stripTrailingZeros().toPlainString());
                    }
                }
            } else if (col instanceof DateTimeColumnDesc && value.getClass().isArray()) {
                if (((Object[])value).length >= 2) {
                    value = ((Object[])value)[DateTimeValueIndex];
                }
            } else if (col instanceof IconColumnDesc || col instanceof ColumnDesc && ((ColumnDesc)col).getSrcFieldProp() instanceof PictureProp) {
                value = "";
            } else if (col instanceof BooleanColumnDesc) {
                value = ExportListTask.formatBooleanColumn((BooleanColumnDesc)col, value);
            } else if (col instanceof BaseDataColumnDesc) {
                HashMap<String, Object> mapTemp = new HashMap<String, Object>();
                Map<String, Object> lastDynamicObjectAndColumnDesc = ExportListTask.getLastDynamicObject(col, dr, mapTemp);
                AbstractColumnDesc columnDesc = (AbstractColumnDesc)lastDynamicObjectAndColumnDesc.get("columnDesc");
                col = (AbstractColumnDesc)lastDynamicObjectAndColumnDesc.get("col");
                dr = (DynamicObject)lastDynamicObjectAndColumnDesc.get("dr");
                if (columnDesc instanceof ComboColumnDesc) {
                    value = ExportListTask.formatComboItems((ComboColumnDesc)columnDesc, value, col);
                }
                if (columnDesc instanceof BooleanColumnDesc) {
                    value = ExportListTask.formatBooleanColumn((BooleanColumnDesc)columnDesc, value);
                } else if (columnDesc instanceof ColumnDesc && ((ColumnDesc)columnDesc).getSrcFieldProp() instanceof PictureProp) {
                    value = "";
                } else if (columnDesc instanceof DateTimeColumnDesc && value.getClass().isArray()) {
                    if (((Object[])value).length >= 2) {
                        value = ((Object[])value)[DateTimeValueIndex];
                    }
                } else if (columnDesc instanceof NumberColumnDesc) {
                    if (col instanceof MulBaseDataColumnDesc) {
                        DynamicObjectCollection basedataObjCol = (DynamicObjectCollection)((MulBaseDataColumnDesc)col).getFieldProp().getValue((Object)dr);
                        value = ExportListTask.formatMulBasedataNumberColumn((NumberColumnDesc)columnDesc, basedataObjCol, zeroShow);
                    } else {
                        DynamicObject basedataObj = (DynamicObject)((BaseDataColumnDesc)col).getFieldProp().getValue((Object)dr);
                        value = ExportListTask.formatBasedataNumberColumn((NumberColumnDesc)columnDesc, basedataObj, zeroShow);
                    }
                }
            }
        }
        return value;
    }

    private static Map<String, Object> getLastDynamicObject(AbstractColumnDesc col, DynamicObject dr, Map<String, Object> map) {
        AbstractColumnDesc columnDesc = ((BaseDataColumnDesc)col).getColumnDesc();
        map.put("dr", dr);
        map.put("col", col);
        map.put("columnDesc", columnDesc);
        Object drTmp = dr.get(((BaseDataColumnDesc)col).getFieldProp());
        if (columnDesc instanceof BaseDataColumnDesc && drTmp instanceof DynamicObject) {
            dr = (DynamicObject)dr.get(((BaseDataColumnDesc)col).getFieldProp());
            col = columnDesc;
            columnDesc = ((BaseDataColumnDesc)columnDesc).getColumnDesc();
            map.put("dr", dr);
            map.put("col", col);
            map.put("columnDesc", columnDesc);
            ExportListTask.getLastDynamicObject(col, dr, map);
        }
        return map;
    }

    private static Object formatBooleanColumn(BooleanColumnDesc columnDesc, Object value) {
        if (value instanceof Boolean) {
            Object xtitle;
            if ((long)columnDesc.getCheckBoxItemShowStyle() == 0L) {
                return Boolean.TRUE.equals(value) ? "\u221a" : "";
            }
            Object otitle = columnDesc.getOTitle();
            if (otitle == null) {
                otitle = ResManager.loadKDString((String)"\u662f", (String)"ExportBooleanProp_0", (String)BOS_EXPORT, (Object[])new Object[0]);
            }
            if ((xtitle = columnDesc.getXTitle()) == null) {
                xtitle = ResManager.loadKDString((String)"\u5426", (String)"ExportBooleanProp_1", (String)BOS_EXPORT, (Object[])new Object[0]);
            }
            return Boolean.TRUE.equals(value) ? otitle : xtitle;
        }
        return value;
    }

    private static Object formatMulBasedataNumberColumn(NumberColumnDesc numberCol, DynamicObjectCollection basedataObjCol, boolean zeroShow) {
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = 0; i < basedataObjCol.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)((DynamicObject)basedataObjCol.get(i)).get("fbasedataid");
            Object result = ExportListTask.formatBasedataNumberColumn(numberCol, dynamicObject, zeroShow);
            if (result instanceof Map) {
                result = ((Map)result).get("result");
            }
            valueBuilder.append(result).append(";");
        }
        if (valueBuilder.length() > 0) {
            valueBuilder = valueBuilder.deleteCharAt(valueBuilder.lastIndexOf(";"));
        }
        return valueBuilder.toString();
    }

    private static Object formatBasedataNumberColumn(NumberColumnDesc numberCol, DynamicObject dr, boolean zeroShow) {
        IDataEntityProperty prop = numberCol.getFieldProp();
        Object value = null;
        if (prop != null && dr != null) {
            value = prop.getValueFast((Object)dr);
        }
        if (StringUtils.isBlank(value) || !zeroShow && BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0) {
            value = "";
        } else if ((value = numberCol.formatCell(dr, value, true)) instanceof Object[] && ((Object[])value).length >= 2) {
            value = ((Object[])value)[DecimalValueIndex];
        }
        return value;
    }

    private static Object formatComboItems(ComboColumnDesc innerCol, Object value, AbstractColumnDesc outerCol) {
        ArrayList<String> desc = new ArrayList<String>();
        boolean isMulCombo = innerCol.getComboProp() instanceof MulComboProp;
        boolean isMulBaseDataCol = outerCol instanceof MulBaseDataColumnDesc;
        List comboItems = innerCol.getComboProp().getComboItems();
        if (isMulBaseDataCol) {
            return ExportListTask.formatComboItems(value, comboItems);
        }
        for (ValueMapItem item : comboItems) {
            if (!(isMulCombo ? ((String)value).contains(item.getValue()) : item.getValue().equals(value))) continue;
            desc.add(item.getName().toString());
        }
        return !desc.isEmpty() ? String.join((CharSequence)" ", desc) : ExportListTask.formatDefaultValue(value);
    }

    private static String formatDefaultValue(Object value) {
        String[] split = ((String)value).split(",");
        if (split.length == 0) {
            return "";
        }
        return (String)value;
    }

    private static Object formatComboItems(Object value, List<ValueMapItem> comboItems) {
        StringBuilder sb = new StringBuilder();
        String cellStr = String.valueOf(value);
        String[] split = cellStr.split(";");
        List<String> baseDataValueList = Arrays.asList(split);
        for (String baseDataValue : baseDataValueList) {
            ArrayList<String> desc = new ArrayList<String>();
            for (ValueMapItem item : comboItems) {
                if (!baseDataValue.contains(item.getValue())) continue;
                desc.add(item.getName().toString());
            }
            sb.append(CollectionUtils.isNotEmpty(desc) ? String.join((CharSequence)" ", desc) : baseDataValue).append(" ; ");
        }
        if (sb.length() != 0) {
            sb.delete(sb.length() - 3, sb.length());
        }
        return sb.toString();
    }

    private static Map<String, ListField> buildFieldMapping(List<ListField> listFields) {
        HashMap<String, ListField> mapping = new HashMap<String, ListField>(16);
        for (ListField f : listFields) {
            mapping.put(f.getKey(), f);
        }
        return mapping;
    }

    private static boolean isSpecialFormat(ListField listField) {
        IDataEntityProperty srcProp = listField.getSrcFieldProp();
        boolean isSpecial = srcProp instanceof DecimalProp || srcProp instanceof IconProp || srcProp instanceof PictureProp || srcProp instanceof FlexProp;
        return isSpecial;
    }

    public static boolean isDecimalTooBig(String decimalStr) {
        int i = decimalStr.lastIndexOf(46);
        int j = decimalStr.length();
        if (i >= 0) {
            --j;
            while (j > i && decimalStr.charAt(j) == '0') {
                --j;
            }
        }
        if (decimalStr.startsWith("-")) {
            --j;
        }
        return j > 15;
    }

    private FieldControlRules getFieldControlRules(String appId, String formId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        FieldControlRules fieldControlRules = permissionService.getFieldControlRules(userId, appId, formId);
        if (fieldControlRules == null || fieldControlRules.getFieldControlRuleDtos() == null || fieldControlRules.getFieldControlRuleDtos().isEmpty()) {
            return null;
        }
        return fieldControlRules;
    }

    private FieldControlRule getFieldControlRule(long orgId) {
        FieldControlRules fieldControlRules = this.context.getFieldControlRules();
        if (fieldControlRules == null) {
            return null;
        }
        FieldControlRule fieldControlRule = new FieldControlRule();
        fieldControlRule.setCanNotReadRuleFields(new ArrayList());
        fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
        fieldControlRule.setCanNotReadFields(new HashSet());
        fieldControlRule.setCanNotWriteFields(new HashSet());
        if (orgId != 0L) {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp;
                if (!Objects.equals(listField.getMainOrgId(), orgId) && (!listField.getIncludeSubOrg() || !listField.getSubOrgId().contains(orgId)) || (temp = listField.getFieldControlRule()) == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
        } else {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp = listField.getFieldControlRule();
                if (temp == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
        }
        return fieldControlRule;
    }

    private boolean isCanExport(FieldControlRule fieldControlRule, String fieldKey) {
        if (fieldControlRule == null) {
            return true;
        }
        return !fieldControlRule.getCanNotReadFields().contains(fieldKey);
    }

    private boolean isSensitive(String field) {
        SensitiveArgs sensitiveArgs = this.context.getSensitiveArgs();
        if (sensitiveArgs == null) {
            return false;
        }
        return sensitiveArgs.contain(field);
    }

    private Object deSensitive(String field, ListField listField, DynamicObject row, Object value) {
        if (value == null) {
            return value;
        }
        if (!this.isSensitive(field)) {
            return ExportListTask.checkAndToGetDesensitizeValue(listField, value, row, this.getMainType().getMainOrg());
        }
        SensitiveArgs sensitiveArgs = this.context.getSensitiveArgs();
        SensitiveArgs.SensitiveRule rule = sensitiveArgs.getRule(field);
        String exportVal = value.toString();
        exportVal = rule != null && Pattern.matches(rule.regex, exportVal) ? exportVal.replaceAll(rule.regex, rule.replacement) : sensitiveArgs.getDesensitiveFun().handle(field, exportVal);
        return exportVal;
    }

    private boolean isFillParent() {
        if (this.isFillParent == null) {
            this.isFillParent = this.isFillParentFromDB();
        }
        return this.isFillParent;
    }

    private boolean isFillParentFromDB() {
        Object entityNumber = this.getParams().get("entitynumber");
        if (entityNumber == null) {
            this.isFillParent = true;
            return true;
        }
        Optional autoFullSuperInfoAtImportTemplate = exportService.getSettingOfAutoFullSuperInfoAtList(entityNumber.toString());
        return autoFullSuperInfoAtImportTemplate.orElse(true);
    }

    @Override
    protected File getSaveDir() {
        return this.context.getSaveDir();
    }

    private static boolean isValidBigDecimal(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        try {
            new BigDecimal(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static /* synthetic */ boolean lambda$prepareListHeader$3(Control col, IListColumn i) {
        return StringUtils.equals((CharSequence)i.getFieldName(), (CharSequence)((FlexListColumn)col).getFieldName());
    }
}

