/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.mvc.export.dataconvert.DesensitiveResult;
import kd.bos.mvc.export.dataconvert.ExportFileType;
import kd.bos.mvc.export.dataconvert.ExportNullProp;
import kd.bos.mvc.export.dataconvert.ExportPropConvert;
import kd.bos.mvc.export.dataconvert.IExportPropConvert;

class ExportBasedataProp
extends ExportPropConvert {
    private Map<String, IExportPropConvert> childPropConverts = new HashMap<String, IExportPropConvert>();
    private static final int BD_JSON_OBJ_MAX_SIZE = 1000;
    private Map<Object, JSONObject> bdJsonObjs = new LinkedHashMap<Object, JSONObject>(1000, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, JSONObject> pEldest) {
            return this.size() > 1000;
        }
    };

    public ExportBasedataProp(IDataEntityProperty prop) {
        super(prop);
    }

    public BasedataProp getBasedataProp() {
        return (BasedataProp)this.getProp();
    }

    private IExportPropConvert getChildPropConvert(IDataEntityProperty childProp) {
        IExportPropConvert childPropConvert = this.childPropConverts.get(childProp.getName());
        if (childPropConvert == null) {
            childPropConvert = childProp instanceof DynamicLocaleProperty ? new ExportNullProp(childProp) : (childProp instanceof ICollectionProperty ? new ExportNullProp(childProp) : IExportPropConvert.get(childProp));
            childPropConvert.initialize(this.getContext(), this.getExportDataConvert());
            this.childPropConverts.put(childProp.getName(), childPropConvert);
        }
        return childPropConvert;
    }

    @Override
    public Object formatValue(DynamicObject activeRow, Object value, ExportFileType exportFileType) {
        if (value instanceof DynamicObject) {
            if (exportFileType == ExportFileType.JSArray) {
                return this.toJSONObject((DynamicObject)value);
            }
            return this.getDisplayVal(value);
        }
        return null;
    }

    protected Object getDisplayVal(Object value) {
        return this.getBasedataProp().getDisplayValue(value);
    }

    protected JSONObject toJSONObject(DynamicObject value) {
        Object pkValue = value.getPkValue();
        JSONObject bdJsonObj = this.bdJsonObjs.get(pkValue);
        if (bdJsonObj != null) {
            return bdJsonObj;
        }
        bdJsonObj = new JSONObject(value.getDataEntityType().getProperties().size());
        for (IDataEntityProperty childProp : value.getDataEntityType().getProperties()) {
            Object propValue;
            IExportPropConvert childPropConvert = this.getChildPropConvert(childProp);
            Object formatValue = childPropConvert.formatValue(value, propValue = childProp.getValueFast((Object)value), ExportFileType.JSArray);
            if (formatValue == null) continue;
            bdJsonObj.put(childProp.getName(), formatValue);
        }
        this.bdJsonObjs.put(pkValue, bdJsonObj);
        if (!(value.getDataEntityType() instanceof BasedataEntityType)) {
            return bdJsonObj;
        }
        BasedataEntityType bdType = (BasedataEntityType)value.getDataEntityType();
        if (bdType.getMasteridType() == 2) {
            MasterBasedataProp masterIdProp = (MasterBasedataProp)bdType.findProperty(bdType.getMasteridPropName());
            if (masterIdProp == null || masterIdProp.getComplexType() == null) {
                return bdJsonObj;
            }
            BasedataEntityType refMasterType = (BasedataEntityType)masterIdProp.getComplexType();
            if (bdJsonObj == null || !bdJsonObj.containsKey((Object)masterIdProp.getName())) {
                return bdJsonObj;
            }
            Map refMasterObj = (Map)bdJsonObj.get((Object)masterIdProp.getName());
            if (refMasterObj == null) {
                return bdJsonObj;
            }
            if (refMasterObj.containsKey(refMasterType.getNameProperty())) {
                String nameKey = StringUtils.isBlank((CharSequence)bdType.getNameProperty()) ? "name" : bdType.getNameProperty();
                bdJsonObj.put(nameKey, refMasterObj.get(refMasterType.getNameProperty()));
            }
            if (refMasterObj.containsKey(refMasterType.getNumberProperty())) {
                String numberKey = StringUtils.isBlank((CharSequence)bdType.getNumberProperty()) ? "number" : bdType.getNumberProperty();
                bdJsonObj.put(numberKey, refMasterObj.get(refMasterType.getNumberProperty()));
            }
        }
        return bdJsonObj;
    }

    @Override
    protected void exportSubPropValue(DynamicObject activeRow, Object value) {
        if (!(value instanceof DynamicObject)) {
            super.exportSubPropValue(activeRow, value);
            return;
        }
        DynamicObject bdObj = (DynamicObject)value;
        for (Map.Entry<Integer, Map<String, Object>> exportCol : this.getExportCols().entrySet()) {
            this.exportSubPropValue(activeRow, bdObj, exportCol.getKey(), exportCol.getValue());
        }
    }

    protected void exportSubPropValue(DynamicObject activeRow, DynamicObject bdObj, int col, Map<String, Object> colPropertys) {
        Object dataKeyObj = colPropertys.get("DataKey");
        String dataKey = "";
        dataKey = dataKeyObj instanceof String ? (String)dataKeyObj : "name";
        Object writeValue = this.getPropValue(activeRow, bdObj, dataKey);
        String fieldName = this.getProp().getName() + "." + dataKey;
        DesensitiveResult result = this.deSensitive(fieldName, writeValue, activeRow);
        if (!result.isPluginSensitive() && !result.isSensitive()) {
            IDataEntityProperty property = this.getSubProp(dataKey);
            result = this.getSensitiveValue(property, writeValue, activeRow, null, fieldName);
        }
        this.writeValue(col, result.getValue(), colPropertys);
    }

    protected Object getPropValue(DynamicObject activeRow, Object obj, String propName) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof DynamicObject)) {
            return null;
        }
        DynamicObject dataEntity = (DynamicObject)obj;
        if (!dataEntity.getDataEntityType().getProperties().containsKey((Object)propName)) {
            return null;
        }
        IDataEntityProperty subprop = this.getSubProp(propName);
        return subprop instanceof IFieldHandle ? ((IFieldHandle)subprop).getBasePropDisplayValue(obj) : dataEntity.get(propName);
    }

    protected IDataEntityProperty getSubProp(String propName) {
        return (IDataEntityProperty)this.getBasedataProp().getComplexType().getProperties().get((Object)propName);
    }

    @Override
    protected void deSensitiveNullValue(DynamicObject activeRow, Object value) {
        for (Map.Entry<Integer, Map<String, Object>> colItem : this.getExportCols().entrySet()) {
            IDataEntityProperty subProp;
            int col = colItem.getKey();
            Map<String, Object> cellPropertys = colItem.getValue();
            String field = "name";
            Object dataKey = cellPropertys.get("DataKey");
            if (dataKey instanceof String) {
                field = (String)dataKey;
            }
            String fieldName = this.getFieldName(field);
            DesensitiveResult result = this.getSensitiveValue(this.getProp(), value, activeRow, null, fieldName);
            if (!result.isSensitive() && !(result = this.getSensitiveValue(subProp = this.getSubProp(field), value, activeRow, null, fieldName)).isSensitive()) continue;
            this.writeValue(col, result.getValue(), cellPropertys);
        }
    }

    protected String getFieldName(String field) {
        return this.getBasedataProp().getName() + "." + field;
    }
}

