/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.mvc.export.dataconvert.ExportFileType;
import kd.bos.mvc.export.dataconvert.ExportPropConvert;
import kd.bos.mvc.export.dataconvert.IExportPropConvert;

class ExportCollectionProp
extends ExportPropConvert {
    private Map<String, IExportPropConvert> childPropConverts = new HashMap<String, IExportPropConvert>();

    public ExportCollectionProp(IDataEntityProperty prop) {
        super(prop);
    }

    public ICollectionProperty getCollectionProp() {
        return (ICollectionProperty)this.getProp();
    }

    private IExportPropConvert getChildPropConvert(IDataEntityProperty childProp) {
        IExportPropConvert childPropConvert = this.childPropConverts.get(childProp.getName());
        if (childPropConvert == null) {
            childPropConvert = IExportPropConvert.get(childProp);
            childPropConvert.initialize(this.getContext(), this.getExportDataConvert());
            this.childPropConverts.put(childProp.getName(), childPropConvert);
        }
        return childPropConvert;
    }

    @Override
    public Object formatValue(DynamicObject activeRow, Object value, ExportFileType exportFileType) {
        if (this.getProp() instanceof ILocaleProperty) {
            return null;
        }
        if (!(value instanceof DynamicObjectCollection)) {
            return null;
        }
        DynamicObjectCollection rows = (DynamicObjectCollection)value;
        if (rows.isEmpty()) {
            return null;
        }
        JSONArray jsonArray = new JSONArray(rows.size());
        for (DynamicObject row : rows) {
            JSONObject rowJsonObject = new JSONObject(row.getDataEntityType().getProperties().size());
            for (IDataEntityProperty childProp : row.getDataEntityType().getProperties()) {
                Object childPropValue = childProp.getValueFast((Object)row);
                Object formatValue = this.getChildPropConvert(childProp).formatValue(row, childPropValue, exportFileType);
                if (formatValue == null) continue;
                rowJsonObject.put(childProp.getName(), formatValue);
            }
        }
        return jsonArray;
    }
}

