/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.ComboProp;
import kd.bos.mvc.export.dataconvert.DesensitiveResult;
import kd.bos.mvc.export.dataconvert.ExportPropConvert;

class ExportComboProp
extends ExportPropConvert {
    private Map<String, String> itemDescs = new HashMap<String, String>();

    public ComboProp getComboProp() {
        return (ComboProp)this.getProp();
    }

    public ExportComboProp(IDataEntityProperty prop) {
        super(prop);
    }

    @Override
    protected void exportSubPropValue(DynamicObject activeRow, Object value) {
        DesensitiveResult result = this.getSensitiveValue((IDataEntityProperty)this.getComboProp(), value, activeRow, null, this.getProp().getName());
        if (result.isSensitive()) {
            this.writeValue(result.getValue());
            return;
        }
        String formatValue = value.toString();
        String writeValue = this.itemDescs.get(formatValue);
        if (writeValue != null) {
            this.writeValue(writeValue);
            return;
        }
        List<String> names = Arrays.asList(formatValue.split(","));
        ArrayList<String> descs = new ArrayList<String>();
        for (String name : names) {
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            String desc = this.getComboProp().getItemByName(name);
            if (StringUtils.isNotBlank((CharSequence)desc)) {
                descs.add(desc);
                continue;
            }
            descs.add(name);
        }
        if (!descs.isEmpty()) {
            writeValue = String.join((CharSequence)",", descs);
        }
        this.itemDescs.put(formatValue, writeValue);
        this.writeValue(writeValue);
    }
}

