/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.export.po.ExportFileInfo;
import kd.bos.export.util.ConvertUtil;
import kd.bos.mvc.export.ExportDataContext;
import kd.bos.mvc.export.ExportProgress;
import kd.bos.mvc.export.dataconvert.ExportFileType;
import kd.bos.mvc.export.dataconvert.IExportDataConvert;
import org.apache.commons.collections4.CollectionUtils;

public class ExportDataConvert {
    private static final String BILLNO = "billno";
    private ExportDataContext context;
    private ExportFileType exportFileType;
    private IExportDataConvert exporter;
    private ExportProgress exportProgress;
    private Map<Object, List<Map<String, Object>>> attachArr;
    private Set<Object> existAttachBillIds = new HashSet<Object>();
    private int complete = 0;
    private int total = 0;
    private Date lastfeedbackProgress = new Date();
    private static final int FEED_BACK_PROGRESS_TIME_INTERVAL = 2000;

    public ExportDataConvert(ExportDataContext context, ExportFileType exportFileType) {
        this.context = context;
        this.exportFileType = exportFileType;
        this.total = context.getAllPkIds().size();
    }

    public ExportProgress getExportProgress() {
        return this.exportProgress;
    }

    public void setExportProgress(ExportProgress exportProgress) {
        this.exportProgress = exportProgress;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public Map<Object, List<Map<String, Object>>> getAttachArr() {
        return this.attachArr;
    }

    public void setAttachArr(Map<Object, List<Map<String, Object>>> attachArr) {
        this.attachArr = attachArr;
        if (attachArr != null) {
            for (Object pkId : attachArr.keySet()) {
                if (pkId == null) continue;
                this.existAttachBillIds.add(pkId);
            }
        }
    }

    public IExportDataConvert getExportDataConvert() {
        if (this.exporter == null) {
            this.exporter = IExportDataConvert.get(this.exportFileType);
            this.exporter.initialize(this.context);
        }
        return this.exporter;
    }

    public int export(DynamicObject[] billObjs, int rowIndex) {
        IExportDataConvert exporter = this.getExportDataConvert();
        int rowCount = 0;
        if (exporter.beginBatch(billObjs, rowIndex)) {
            for (DynamicObject billObj : billObjs) {
                Date currTime;
                if (exporter.beginBill(billObj)) {
                    this.setBillNo(billObj);
                    this.exportDataEntity(exporter, billObj);
                    this.collectCurrentBillAttachmentPanelAtt(billObj);
                    exporter.writeAttachPanelMessage(billObj.getPkValue());
                    exporter.endBill(billObj);
                    this.resetBillNo();
                }
                billObj = null;
                if (this.context.getBigBillComplete().booleanValue()) {
                    ++this.complete;
                }
                if (Long.compare((currTime = new Date()).getTime() - this.lastfeedbackProgress.getTime(), 2000L) <= 0) continue;
                this.getExportProgress().feedbackProgress(this.total, this.complete);
                this.lastfeedbackProgress = currTime;
            }
            rowCount = exporter.endBatch(billObjs);
        }
        return rowCount;
    }

    private void collectCurrentBillAttachmentPanelAtt(DynamicObject billObj) {
        Map<Object, List<Map<String, Object>>> attachArr = this.context.getAttachArr();
        Object pkValue = billObj.getPkValue();
        if (attachArr != null && pkValue != null && attachArr.get(pkValue.toString()) != null) {
            List<Map<String, Object>> currentBillAttList = attachArr.get(pkValue.toString());
            for (Map<String, Object> attMessageMap : currentBillAttList) {
                Object url = attMessageMap.get("url");
                Object name = attMessageMap.get("name");
                String prefix = "";
                if (this.context.getExportAttType() == 1 && StringUtils.isNotEmpty((CharSequence)this.context.getBillNo())) {
                    prefix = this.context.getBillNo();
                }
                if (!(url instanceof String) || !(name instanceof String)) continue;
                String finalName = ConvertUtil.collectSingleUrl(this.context.getExportAttMessageMap(), url.toString(), prefix);
                if (StringUtils.isNotEmpty((CharSequence)finalName)) {
                    name = finalName;
                }
                this.context.getExportAttMessageMap().put((Object)url.toString(), (Object)name.toString());
            }
        }
    }

    private void resetBillNo() {
        this.context.setBillNo(null);
    }

    private void setBillNo(DynamicObject billObj) {
        BillEntityType mainEntityType = (BillEntityType)billObj.getDataEntityType();
        String billNo = mainEntityType.getBillNo();
        if (billObj.containsProperty(billNo)) {
            this.context.setBillNo(billObj.getString(billNo));
        }
    }

    private void exportDataEntity(IExportDataConvert exporter, DynamicObject dataEntity) {
        IDataEntityType dt = dataEntity.getDataEntityType();
        List<String> selectFieldsList = this.context.getFormats().get(0).listFields(new ArrayList<String>());
        HashSet<String> selectFields = new HashSet<String>(selectFieldsList);
        for (IDataEntityProperty prop : dt.getProperties()) {
            DynamicObjectCollection entryRows;
            HashMap<String, Object> values;
            if (!(prop instanceof EntryProp) && !selectFields.contains(this.buildPropName(dt, prop)) || prop instanceof PKFieldProp && ((PKFieldProp)prop).isRefId()) continue;
            if (prop instanceof LargeTextProp) {
                values = new HashMap<String, Object>();
                values.put(prop.getName(), prop.getValueFast((Object)dataEntity));
                values.put(prop.getName() + "_tag", ((IDataEntityProperty)prop.getParent().getProperties().get((Object)(prop.getName() + "_tag"))).getValueFast((Object)dataEntity));
                exporter.convertValue(prop, values);
                continue;
            }
            if (prop instanceof GeoPointProp) {
                values = new HashMap();
                values.put(prop.getName(), prop.getValueFast((Object)dataEntity));
                values.put(prop.getName() + "_lo", ((IDataEntityProperty)prop.getParent().getProperties().get((Object)(prop.getName() + "_lo"))).getValueFast((Object)dataEntity));
                values.put(prop.getName() + "_la", ((IDataEntityProperty)prop.getParent().getProperties().get((Object)(prop.getName() + "_la"))).getValueFast((Object)dataEntity));
                values.put(prop.getName() + "_ad", ((IDataEntityProperty)prop.getParent().getProperties().get((Object)(prop.getName() + "_ad"))).getValueFast((Object)dataEntity));
                exporter.convertValue(prop, values);
                continue;
            }
            if (prop instanceof ISimpleProperty) {
                exporter.convertValue(prop, prop.getValueFast((Object)dataEntity));
                continue;
            }
            if (prop instanceof IComplexProperty) {
                exporter.convertValue(prop, prop.getValueFast((Object)dataEntity));
                continue;
            }
            if (prop instanceof DynamicLocaleProperty) continue;
            if (prop instanceof MulBasedataProp) {
                exporter.convertValue(prop, prop.getValueFast((Object)dataEntity));
                continue;
            }
            if (!(prop instanceof ICollectionProperty) || CollectionUtils.isEmpty((Collection)(entryRows = (DynamicObjectCollection)prop.getValueFast((Object)dataEntity)))) continue;
            IDataEntityType entryType = ((ICollectionProperty)prop).getItemType();
            int maxFileRowSize = this.exportFileType == ExportFileType.CsvFile ? Integer.MAX_VALUE : ExportFileInfo.maxFileRowSize;
            int endStartEntryRowIndex = entryRows.size() > maxFileRowSize ? Math.min(entryRows.size(), exporter.getStartEntryRowIndex(prop.getName()) + maxFileRowSize) : entryRows.size();
            for (int i = exporter.getStartEntryRowIndex(prop.getName()).intValue(); i < endStartEntryRowIndex; ++i) {
                DynamicObject entryRow = (DynamicObject)entryRows.get(i);
                if (!exporter.beginEntryRow(entryType, entryRow)) continue;
                this.exportDataEntity(exporter, entryRow);
                exporter.endEntryRow(entryType, entryRow);
            }
            exporter.setStartEntryRowIndex(prop.getName(), endStartEntryRowIndex);
            if (entryRows.size() != endStartEntryRowIndex) continue;
            exporter.setStartEntryRowIndex(prop.getName(), 0);
        }
    }

    private Object buildPropName(IDataEntityType dt, IDataEntityProperty prop) {
        String propName = prop.getName();
        if (("id".equals(propName) || "pid".equals(propName)) && dt instanceof EntryType) {
            return dt.getName() + "." + prop.getName();
        }
        return prop.getName();
    }

    public Object getExportResult() {
        IExportDataConvert exporter = this.getExportDataConvert();
        exporter.finished();
        return exporter.getExportResult();
    }

    @Deprecated
    public String flushAndUpload(String fileName) throws IOException {
        IExportDataConvert exporter = this.getExportDataConvert();
        return exporter.flushAndUpload(fileName);
    }

    public String flushToLocal() throws IOException {
        IExportDataConvert exporter = this.getExportDataConvert();
        return exporter.flushToLocal();
    }
}

