/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.FmtField;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.mvc.export.dataconvert.DesensitiveResult;
import kd.bos.mvc.export.dataconvert.ExportFileType;
import kd.bos.mvc.export.dataconvert.ExportPropConvert;

class ExportDecimalProp
extends ExportPropConvert {
    private String controlEntityKey;
    private NumberFormatProvider numberFormatProvider;

    public ExportDecimalProp(IDataEntityProperty prop) {
        super(prop);
    }

    public DecimalProp getDecimalProp() {
        return (DecimalProp)this.getProp();
    }

    public NumberFormatProvider getNumberFormatProvider(DynamicObject activeRow) {
        NumberFormatProvider numberFormatProvider;
        Map<DynamicObjectType, Map<IDataEntityProperty, NumberFormatProvider>> dtNumberFormatProviderMap = this.getContext().getDtNumberFormatProviderMap();
        if (dtNumberFormatProviderMap.containsKey(activeRow.getDynamicObjectType()) && (numberFormatProvider = dtNumberFormatProviderMap.get(activeRow.getDynamicObjectType()).get(this.getProp())) != null) {
            this.numberFormatProvider = numberFormatProvider;
            return this.numberFormatProvider;
        }
        DynamicObject controlRow = null;
        String controlPropName = this.getDecimalProp().getControlPropName();
        if (StringUtils.isBlank((CharSequence)controlPropName)) {
            controlRow = activeRow;
        } else if (activeRow.getDynamicObjectType().getProperties().containsKey((Object)controlPropName)) {
            controlRow = activeRow;
        } else {
            DynamicObject parentRow;
            for (parentRow = (DynamicObject)activeRow.getParent(); parentRow != null && !parentRow.getDynamicObjectType().getProperties().containsKey((Object)controlPropName); parentRow = (DynamicObject)parentRow.getParent()) {
            }
            if (parentRow == null) {
                controlRow = activeRow;
                controlPropName = "";
            } else {
                controlRow = parentRow;
            }
        }
        this.controlEntityKey = controlRow.getDataEntityType().getName();
        DynamicObjectCollection formatRows = new DynamicObjectCollection(activeRow.getDynamicObjectType(), null);
        formatRows.add((Object)activeRow);
        FmtField fmtField = new FmtField(this.getProp(), this.getProp().getName(), controlPropName);
        ArrayList<FmtField> fmtFields = new ArrayList<FmtField>();
        fmtFields.add(fmtField);
        this.numberFormatProvider = new NumberFormatProvider(fmtFields, formatRows, controlRow, this.getContext().getFormatObject(), this.getContext().isApplyMaterialPrecision());
        dtNumberFormatProviderMap.putIfAbsent(activeRow.getDynamicObjectType(), new HashMap(16));
        Map<IDataEntityProperty, NumberFormatProvider> iDataEntityPropertyNumberFormatProviderMap = dtNumberFormatProviderMap.get(activeRow.getDynamicObjectType());
        if (iDataEntityPropertyNumberFormatProviderMap != null) {
            iDataEntityPropertyNumberFormatProviderMap.putIfAbsent(this.getProp(), this.numberFormatProvider);
            return iDataEntityPropertyNumberFormatProviderMap.get(this.getProp());
        }
        return this.numberFormatProvider;
    }

    private DynamicObject getControlRow(DynamicObject activeRow) {
        DynamicObject parentRow;
        if (StringUtils.equals((CharSequence)activeRow.getDataEntityType().getName(), (CharSequence)this.controlEntityKey)) {
            return activeRow;
        }
        for (parentRow = (DynamicObject)activeRow.getParent(); parentRow != null && !StringUtils.equals((CharSequence)parentRow.getDataEntityType().getName(), (CharSequence)this.controlEntityKey); parentRow = (DynamicObject)parentRow.getParent()) {
        }
        return parentRow;
    }

    @Override
    public Object formatValue(DynamicObject activeRow, Object value, ExportFileType exportFileType) {
        BigIntProp prop;
        Boolean readOriginalNum = this.getContext().getReadOriginalNum();
        if (value == null || this.getProp().getParent() instanceof LinkEntryType || readOriginalNum.booleanValue()) {
            return super.formatValue(activeRow, value, exportFileType);
        }
        if (this.getProp() instanceof BigIntProp && (prop = (BigIntProp)this.getProp()) instanceof FieldProp && !prop.isZeroShow() && BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0) {
            return null;
        }
        return this.formatDecimal(activeRow, value);
    }

    private Object formatDecimal(DynamicObject activeRow, Object value) {
        NumberFormatProvider formatProvider = this.getNumberFormatProvider(activeRow);
        DynamicObject controlRow = this.getControlRow(activeRow);
        NumberPrecision numberPrecision = formatProvider.getFormatPrecision(this.getProp().getName(), activeRow, controlRow);
        if (numberPrecision != null) {
            numberPrecision.setGroupingUsed(false);
        }
        return numberPrecision;
    }

    @Override
    protected void exportSubPropValue(DynamicObject activeRow, Object value) {
        Object formatValue = this.formatValue(activeRow, value, ExportFileType.JSArray);
        if (formatValue instanceof BigDecimal) {
            formatValue = ((BigDecimal)formatValue).toPlainString();
        }
        DesensitiveResult result = this.getSensitiveValue((IDataEntityProperty)this.getDecimalProp(), formatValue, activeRow, null, this.getProp().getName());
        this.writeValue(result.getValue());
    }
}

