/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.nameversion.NameVersionService;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.operate.webapi.FlexEntityTypeReader;
import kd.bos.form.util.ExportNameVersionHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExportDataContext;
import kd.bos.mvc.export.dataconvert.ExportFileType;
import kd.bos.mvc.export.dataconvert.ExportPropConvert;
import kd.bos.mvc.export.dataconvert.IExportDataConvert;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

class ExportFlexProp
extends ExportPropConvert {
    private static final Log log = LogFactory.getLog(ExportFlexProp.class);
    private int flexStartCol;
    private FlexEntityTypeReader flexEntityTypeReader;
    private Map<String, BasedataEntityType> flexRefBDTypes = new HashMap<String, BasedataEntityType>();
    private Map<String, Map<Object, DynamicObject>> flexBasedataObjs = new HashMap<String, Map<Object, DynamicObject>>();
    private RowDataModel rowDataModel;
    private Map<String, Boolean> flexBaseDataNameVersionOpenStatus = new HashMap<String, Boolean>(16);
    private static final int FLEX_JSON_OBJ_MAX_SIZE = 1000;
    private Map<Object, JSONObject> flexJsonObjs = new LinkedHashMap<Object, JSONObject>(1000, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, JSONObject> pEldest) {
            return this.size() > 1000;
        }
    };

    public ExportFlexProp(IDataEntityProperty prop) {
        super(prop);
    }

    public RowDataModel getRowDataModel(DynamicObject activeRow) {
        if (this.rowDataModel == null) {
            IDataEntityType subMainType = activeRow.getDataEntityType();
            while (subMainType.getParent() != null) {
                subMainType = subMainType.getParent();
            }
            this.rowDataModel = new RowDataModel(this.getProp().getParent().getName(), (MainEntityType)subMainType);
        }
        this.rowDataModel.setRowContext(activeRow);
        return this.rowDataModel;
    }

    @Override
    public void initialize(ExportDataContext context, IExportDataConvert exportDataConvert) {
        super.initialize(context, exportDataConvert);
        this.flexEntityTypeReader = new FlexEntityTypeReader(context.getSubMainType().getName());
    }

    @Override
    protected int createColHeader(ExportWriterFormat colFormats, Map<String, Object> propertys, int col) {
        int offset = 0;
        List<String> subCols = colFormats.flexColumn.get(this.getProp().getName());
        List<String> subDisplay = colFormats.flexColumnDisplay.get(this.getProp().getName());
        List<String> subColDesc = colFormats.flexColumnDesc.get(this.getProp().getName());
        boolean mustInput = Boolean.TRUE.equals(propertys.get("MustInput"));
        if (subCols.isEmpty()) {
            return col + offset;
        }
        this.flexStartCol = col;
        for (int i = 0; i < subCols.size(); ++i) {
            int currCol = col + i;
            HashMap<String, Object> cellPropertys = new HashMap<String, Object>(propertys);
            String caption = (i == 0 && mustInput ? "*" : "") + subDisplay.get(i);
            if (subColDesc.size() > i) {
                cellPropertys.put("InputDesc", subColDesc.get(i));
            }
            this.getExportDataConvert().writeColHeader(currCol, caption, cellPropertys);
            this.getExportCols().put(currCol, cellPropertys);
        }
        offset = subCols.size();
        return col + offset;
    }

    @Override
    public Object formatValue(DynamicObject activeRow, Object value, ExportFileType exportFileType) {
        if (value instanceof DynamicObject) {
            return this.toJSONObject(activeRow, (DynamicObject)value);
        }
        return null;
    }

    @Override
    protected void exportSubPropValue(DynamicObject activeRow, Object value) {
        if (!(value instanceof DynamicObject)) {
            return;
        }
        JSONObject flexValues = this.toJSONObject(activeRow, (DynamicObject)value);
        int offset = 0;
        for (Map.Entry flexItem : flexValues.entrySet()) {
            if (offset >= this.getExportCols().size()) continue;
            this.writeValue(this.flexStartCol + offset, flexItem.getKey(), this.getExportCols().get(this.flexStartCol + offset));
            ++offset;
            Object flexValue = flexItem.getValue();
            if (flexValue instanceof Map) {
                HashMap flexMap = (HashMap)flexValue;
                this.writeValue(this.flexStartCol + offset, flexMap.get("number"), this.getExportCols().get(this.flexStartCol + offset));
                this.writeValue(this.flexStartCol + ++offset, flexMap.get("name"), this.getExportCols().get(this.flexStartCol + offset));
                ++offset;
                continue;
            }
            this.writeValue(this.flexStartCol + ++offset, flexValue, this.getExportCols().get(this.flexStartCol + offset));
            ++offset;
        }
    }

    private void exportSubPropValue(DynamicObject activeRow, JSONObject flexValues, int col, Map<String, Object> colPropertys) {
        String flexKey = (String)colPropertys.get("DataKey");
        if (StringUtils.isBlank((CharSequence)flexKey)) {
            return;
        }
        String[] keys = flexKey.split("\\.");
        Object dataVal = flexValues.get((Object)keys[0]);
        if (dataVal instanceof Map) {
            dataVal = ((Map)dataVal).get(keys[keys.length - 1]);
        }
        String writeValue = dataVal == null ? "" : "" + dataVal;
        this.writeValue(col, writeValue, colPropertys);
    }

    protected JSONObject toJSONObject(DynamicObject activeRow, DynamicObject value) {
        Object pkValue = value.getPkValue();
        boolean enableNameVersionControl = this.isEnableNameVersionControl(value.getDataEntityType().getName());
        JSONObject flexValMap = this.flexJsonObjs.get(pkValue);
        if (flexValMap != null && !enableNameVersionControl) {
            return flexValMap;
        }
        String json = SerializationUtils.toJsonString((Object)value);
        JSONObject flexJsonObj = JSONArray.parseObject((String)json);
        FlexProp flexProp = (FlexProp)this.getProp();
        BasedataProp parentBdProp = (BasedataProp)this.getContext().getSubMainType().findProperty(flexProp.getBasePropertyKey());
        DynamicObject parentBdObj = (DynamicObject)this.getRowDataModel(activeRow).getValue(flexProp.getBasePropertyKey());
        if (parentBdObj == null) {
            return flexJsonObj;
        }
        Map valueMap = (Map)SerializationUtils.fromJsonString((String)flexJsonObj.getString("value"), Map.class);
        FlexEntityType flexEntityType = this.flexEntityTypeReader.read(flexProp, parentBdProp, parentBdObj);
        flexValMap = new JSONObject();
        for (IDataEntityProperty flexObjectProp : flexEntityType.getProperties()) {
            String name = flexObjectProp.getName();
            String[] nameSplit = name.split("__");
            if (nameSplit.length <= 1) continue;
            try {
                Object baseValue = valueMap.get(nameSplit[1]);
                if (baseValue == null) continue;
                if (flexObjectProp instanceof BasedataProp) {
                    String numPropKey;
                    BasedataEntityType flexObjectBaseType;
                    boolean enableNameVersionControl1;
                    if (baseValue instanceof Integer) {
                        baseValue = ((Integer)baseValue).longValue();
                    }
                    if (enableNameVersionControl1 = this.isEnableNameVersionControl((flexObjectBaseType = (BasedataEntityType)((BasedataProp)flexObjectProp).getComplexType()).getName())) {
                        this.flexBaseDataNameVersionOpenStatus.put(value.getDataEntityType().getName(), true);
                    }
                    DynamicObject basedata = this.loadFlexBasedataObj(flexProp, flexObjectBaseType, baseValue, activeRow);
                    String flexValKey = ((BasedataProp)flexObjectProp).getDisplayName().toString();
                    HashMap<String, Object> flexPropValMap = new HashMap<String, Object>();
                    String namePropKeys = flexObjectBaseType.getNameProperty();
                    if (StringUtils.isNotBlank((CharSequence)namePropKeys)) {
                        ArrayList<String> caption = new ArrayList<String>();
                        for (String propKey : namePropKeys.split(",")) {
                            Object propV = basedata.get(propKey);
                            if (!StringUtils.isNotBlank((Object)propV)) continue;
                            caption.add(propV.toString());
                        }
                        flexPropValMap.put("name", String.join((CharSequence)",", caption));
                    }
                    if (StringUtils.isNotBlank((CharSequence)(numPropKey = flexObjectBaseType.getNumberProperty()))) {
                        flexPropValMap.put("number", basedata.get(numPropKey));
                    }
                    flexValMap.put(flexValKey, flexPropValMap);
                    continue;
                }
                if (!(flexObjectProp instanceof TextProp)) continue;
                String flexValKey = ((TextProp)flexObjectProp).getDisplayName().toString();
                flexValMap.put(flexValKey, baseValue);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        if (SystemParamServiceHelper.isShowStackTrace() && valueMap.size() != flexValMap.size()) {
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u5f39\u6027\u57df\u6570\u636e\u548c\u7ec4\u88c5\u7684\u5f39\u6027\u57df\u6570\u636e\u4e0d\u4e00\u81f4\uff1avalueMap=", (String)"ExportFlexProp_0", (String)"bos-export", (Object[])new Object[0])).append(valueMap).append(" <> flexValMap=").append(flexValMap);
            log.error(sb.toString());
        }
        flexValMap = this.reSort(flexValMap, flexEntityType.getFlexProperties());
        this.flexJsonObjs.put(pkValue, flexValMap);
        return flexValMap;
    }

    private JSONObject reSort(JSONObject flexValMap, List<FlexProperty> flexProperties) {
        JSONObject jsonObject = new JSONObject(true);
        for (FlexProperty flexProperty : flexProperties) {
            String glName = flexProperty.getName().getLocaleValue();
            if (!StringUtils.isNotEmpty((CharSequence)glName) || flexValMap.get((Object)glName) == null) continue;
            jsonObject.put(glName, flexValMap.get((Object)glName));
        }
        return jsonObject.isEmpty() ? flexValMap : jsonObject;
    }

    private boolean isEnableNameVersionControl(String dataEntityTypename) {
        Boolean isEnableNameVersionCtl = this.flexBaseDataNameVersionOpenStatus.get(dataEntityTypename);
        if (isEnableNameVersionCtl == null) {
            isEnableNameVersionCtl = NameVersionService.getInstance().enableNameVersionControl(dataEntityTypename);
            this.flexBaseDataNameVersionOpenStatus.put(dataEntityTypename, isEnableNameVersionCtl);
        }
        return isEnableNameVersionCtl;
    }

    private Date getVersionDate(DynamicObject activeRow, String dataEntityTypename) {
        boolean enableNameVersionControl = NameVersionService.getInstance().enableNameVersionControl(dataEntityTypename);
        if (enableNameVersionControl) {
            DynamicObject mainData = ExportNameVersionHandler.getMainData(activeRow);
            Date nameVersionDate = ExportNameVersionHandler.getNameVersionDate(mainData);
            return nameVersionDate;
        }
        return null;
    }

    private DynamicObject loadFlexBasedataObj(FlexProp flexProp, BasedataEntityType flexObjectBaseType, Object id, DynamicObject activeRow) {
        String subExtName;
        String typeKey = flexProp.getName() + "_" + flexObjectBaseType.getName();
        BasedataEntityType refBDType = this.flexRefBDTypes.get(typeKey);
        if (refBDType == null) {
            String namePropKeys = flexObjectBaseType.getNameProperty();
            HashSet<String> selectedFields = new HashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)flexObjectBaseType.getNumberProperty())) {
                selectedFields.add(flexObjectBaseType.getNumberProperty());
            }
            if (!StringUtils.isBlank((CharSequence)namePropKeys)) {
                String[] propKeys;
                for (String propKey : propKeys = namePropKeys.split(",")) {
                    if (!StringUtils.isNotBlank((CharSequence)propKey)) continue;
                    selectedFields.add(propKey);
                }
            }
            refBDType = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)flexObjectBaseType.getName(), selectedFields);
            this.flexRefBDTypes.put(typeKey, refBDType);
        }
        String string = subExtName = StringUtils.isBlank((CharSequence)refBDType.getExtendName()) ? refBDType.getName() : refBDType.getExtendName();
        if (!this.flexBasedataObjs.containsKey(subExtName)) {
            this.flexBasedataObjs.put(subExtName, new HashMap());
        }
        String dateStr = "";
        Date versionControlDate = null;
        if (this.isEnableNameVersionControl(refBDType.getName())) {
            versionControlDate = this.getVersionDate(activeRow, refBDType.getName());
            dateStr = dateStr + (versionControlDate == null ? "now" : versionControlDate.toString());
        }
        if (this.flexBasedataObjs.get(subExtName).containsKey(id + dateStr)) {
            return this.flexBasedataObjs.get(subExtName).get(id + dateStr);
        }
        DynamicObject flexBaseData = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (DynamicObjectType)refBDType);
        if (this.isEnableNameVersionControl(refBDType.getName())) {
            flexBaseData = NameVersionService.getInstance().getNameVersionData(flexBaseData, versionControlDate);
        }
        this.flexBasedataObjs.get(subExtName).put(id + dateStr, flexBaseData);
        return flexBaseData;
    }
}

