/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.dataconvert.DesensitiveResult;
import kd.bos.mvc.export.dataconvert.ExportPropConvert;

class ExportTimeProp
extends ExportPropConvert {
    private static final String BOS_EXPORT = "bos-export";
    private static Log log = LogFactory.getLog(ExportTimeProp.class);

    public ExportTimeProp(IDataEntityProperty prop) {
        super(prop);
    }

    @Override
    protected void exportSubPropValue(DynamicObject activeRow, Object value) {
        Integer timeValue;
        Integer n = timeValue = value instanceof Integer ? (Integer)value : null;
        if (timeValue == null || timeValue < 0) {
            this.deSensitiveNullValue(activeRow, null);
            return;
        }
        int time = timeValue;
        int second = time % 60;
        int minute = (time /= 60) % 60;
        int hour = (time /= 60) % 24;
        Object formatValue = String.format("%02d:%02d:%02d", hour, minute, second);
        formatValue = this.formatDateValue(activeRow, this.getProp(), formatValue);
        DesensitiveResult result = this.getSensitiveValue(this.getProp(), formatValue, activeRow, null, this.getProp().getName());
        this.writeValue(result.getValue());
    }

    @Override
    protected Object formatDateValue(DynamicObject activeRow, IDataEntityProperty prop, Object value) {
        Map<String, String> dateFieldFormatMapping = this.getContext().getDateFieldFormatMapping();
        if (dateFieldFormatMapping.containsKey(prop.getName())) {
            String dateFormat = dateFieldFormatMapping.get(prop.getName());
            try {
                Date dateValue = new SimpleDateFormat("HH:mm:ss").parse(value.toString());
                return new SimpleDateFormat(dateFormat).format(dateValue);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        return value;
    }
}

