/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.mvc.export.dataconvert.AbstractExportDataConvert;
import kd.bos.mvc.export.dataconvert.ExportFileType;
import kd.bos.mvc.export.dataconvert.IExportPropConvert;

class ExportToJSArray
extends AbstractExportDataConvert {
    private JSONArray exportResult = new JSONArray(1);
    private RowMapper currBill;
    private RowMapper activeRow;

    ExportToJSArray() {
    }

    @Override
    public boolean beginBill(DynamicObject billObj) {
        JSONObject fieldValues = new JSONObject(billObj.getDataEntityType().getProperties().size());
        this.activeRow = this.currBill = new RowMapper(null, billObj, fieldValues);
        return true;
    }

    @Override
    public void endBill(DynamicObject billObj) {
        if (!this.currBill.getTargetObj().isEmpty()) {
            this.exportResult.add((Object)this.currBill.getTargetObj());
        }
        this.currBill = null;
    }

    @Override
    public boolean beginEntryRow(IDataEntityType entryType, DynamicObject entryRow) {
        if (entryType instanceof LinkEntryType) {
            return false;
        }
        JSONObject fieldValues = new JSONObject(entryType.getProperties().size());
        this.activeRow = new RowMapper(this.activeRow, entryRow, fieldValues);
        return true;
    }

    @Override
    public void endEntryRow(IDataEntityType entryType, DynamicObject entryRow) {
        RowMapper parent = this.activeRow.getParent();
        JSONArray rows = (JSONArray)parent.getTargetObj().get((Object)entryType.getName());
        if (rows == null) {
            rows = new JSONArray(1);
            parent.getTargetObj().put(entryType.getName(), (Object)rows);
        }
        rows.add((Object)this.activeRow.getTargetObj());
        this.activeRow = this.activeRow.getParent();
    }

    @Override
    public void convertValue(IDataEntityProperty prop, Object value) {
        IExportPropConvert propConvert = this.getPropConvert(prop);
        Object formatValue = propConvert.formatValue(this.activeRow.getSourceObj(), value, ExportFileType.JSArray);
        if (formatValue != null) {
            this.activeRow.getTargetObj().put(prop.getName(), formatValue);
        }
    }

    @Override
    public void finished() {
        super.finished();
    }

    @Override
    public Object getExportResult() {
        return this.exportResult;
    }

    class RowMapper {
        private RowMapper parent;
        private DynamicObject sourceObj;
        private JSONObject targetObj;

        public RowMapper(RowMapper parent, DynamicObject sourceObj, JSONObject targetObj) {
            this.parent = parent;
            this.sourceObj = sourceObj;
            this.targetObj = targetObj;
        }

        public RowMapper getParent() {
            return this.parent;
        }

        public DynamicObject getSourceObj() {
            return this.sourceObj;
        }

        public JSONObject getTargetObj() {
            return this.targetObj;
        }
    }
}

