/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export.dataconvert;

import java.io.IOException;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mvc.export.ExportDataContext;
import kd.bos.mvc.export.dataconvert.ExportFileType;
import kd.bos.mvc.export.dataconvert.ExportToCsv;
import kd.bos.mvc.export.dataconvert.ExportToExcel;
import kd.bos.mvc.export.dataconvert.ExportToJSArray;
import kd.bos.mvc.export.dataconvert.ExportToString;

interface IExportDataConvert {
    public static final String FATTACHMENTPANEL = "fattachmentpanel";

    public static IExportDataConvert get(ExportFileType exportFileType) {
        switch (exportFileType) {
            case String: {
                return new ExportToString();
            }
            case JSArray: {
                return new ExportToJSArray();
            }
            case Excel: {
                return new ExportToExcel();
            }
            case TextFile: {
                throw new KDException(new ErrorCode("IExportDataConvert_01", "no impl export text file"), new Object[0]);
            }
            case CsvFile: {
                return new ExportToCsv();
            }
        }
        return new ExportToString();
    }

    default public void initialize(ExportDataContext context) {
    }

    default public boolean beginBatch(DynamicObject[] billObjs, int rowIndex) {
        return true;
    }

    default public int endBatch(DynamicObject[] billObjs) {
        return 0;
    }

    default public boolean beginBill(DynamicObject billObj) {
        return true;
    }

    default public void writeAttachLink() {
    }

    default public void endBill(DynamicObject billObj) {
    }

    default public void writeAttachPanelMessage(Object pkValue) {
    }

    default public boolean beginEntryRow(IDataEntityType entryType, DynamicObject entryRow) {
        return true;
    }

    default public void endEntryRow(IDataEntityType entryType, DynamicObject entryRow) {
    }

    default public void convertValue(IDataEntityProperty prop, Object value) {
    }

    default public void writeColHeader(int col, String caption, Map<String, Object> cellPropertys) {
    }

    default public void writeValue(int col, Object value, Map<String, Object> cellPropertys) {
    }

    default public boolean isCanExport(String field) {
        return true;
    }

    default public void finished() {
    }

    default public Object getExportResult() {
        return null;
    }

    default public Integer getStartEntryRowIndex(String entryCollectionProperty) {
        return 0;
    }

    default public void setStartEntryRowIndex(String entryCollectionProperty, Integer startEntryRowIndex) {
    }

    @Deprecated
    default public String flushAndUpload(String fileName) throws IOException {
        return null;
    }

    default public String flushToLocal() throws IOException {
        return null;
    }
}

