/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata.export;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExportWriterFormat {
    public String name;
    public String displayName;
    public int col;
    public int splitColCount;
    public boolean isAttachPanel;
    private String description;
    private Boolean enableSetNull = true;
    private Boolean splitSubEntries = false;
    private Boolean hideFieldRow = false;
    private Boolean exchangeNameAndMark = false;
    private Boolean forUpdateMultiLangFields = false;
    public Map<String, List<String>> flexColumn = new HashMap<String, List<String>>();
    public Map<String, List<String>> flexColumnDisplay = new HashMap<String, List<String>>();
    public Map<String, List<String>> flexColumnDesc = new HashMap<String, List<String>>();
    public List<String> fields = new ArrayList<String>();
    public Map<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
    public List<ExportWriterFormat> next = new ArrayList<ExportWriterFormat>();
    private static int tempParseOffset;

    public ExportWriterFormat() {
    }

    public ExportWriterFormat(String name, String displayName, int col) {
        this.name = name;
        this.displayName = displayName;
        this.col = col;
    }

    public List<String> listFields(List<String> list) {
        list.addAll(this.fields);
        for (ExportWriterFormat entry : this.next) {
            entry.listFields(list);
        }
        return list;
    }

    public synchronized ExportWriterFormat ready(Set<String> fieldset) {
        tempParseOffset = 0;
        return this.build(fieldset);
    }

    private synchronized ExportWriterFormat build(Set<String> fieldset) {
        this.col = tempParseOffset;
        tempParseOffset += this.fields.size() + this.countSplitColumn();
        if (fieldset != null && !fieldset.isEmpty()) {
            this.fields.sort((s1, s2) -> {
                if (s1 != null && s1.endsWith(".id")) {
                    return -1;
                }
                if (s2 != null && s2.endsWith(".id")) {
                    return 1;
                }
                for (String str : fieldset) {
                    if (str == null) continue;
                    if (str.equals(s1)) {
                        return -1;
                    }
                    if (!str.equals(s2)) continue;
                    return 1;
                }
                return 0;
            });
        }
        Iterator<ExportWriterFormat> iter = this.next.iterator();
        while (iter.hasNext()) {
            ExportWriterFormat w = iter.next();
            if (w.fields.size() == 0) {
                iter.remove();
                continue;
            }
            w.build(fieldset);
        }
        return this;
    }

    private int countSplitColumn() {
        int split = 0;
        int repeat = 0;
        for (Map.Entry<String, List<String>> splitCols : this.flexColumn.entrySet()) {
            if (this.fields.contains(splitCols.getKey())) {
                ++repeat;
            }
            split += splitCols.getValue().size();
        }
        return split > 0 ? split - repeat : 0;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getEnableSetNull() {
        return this.enableSetNull;
    }

    public void setEnableSetNull(Boolean enableSetNull) {
        this.enableSetNull = enableSetNull;
    }

    public Boolean getSplitSubEntries() {
        return this.splitSubEntries;
    }

    public void setSplitSubEntries(Boolean splitSubEntries) {
        this.splitSubEntries = splitSubEntries;
    }

    public Boolean getHideFieldRow() {
        return this.hideFieldRow;
    }

    public void setHideFieldRow(Boolean hideFieldRow) {
        this.hideFieldRow = hideFieldRow;
    }

    public Boolean getExchangeNameAndMark() {
        return this.exchangeNameAndMark;
    }

    public void setExchangeNameAndMark(Boolean exchangeNameAndMark) {
        this.exchangeNameAndMark = exchangeNameAndMark;
    }

    public Boolean getForUpdateMultiLangFields() {
        return this.forUpdateMultiLangFields;
    }

    public void setForUpdateMultiLangFields(Boolean forUpdateMultiLangFields) {
        this.forUpdateMultiLangFields = forUpdateMultiLangFields;
    }

    public boolean isAttachPanel() {
        return this.isAttachPanel;
    }

    public void setAttachPanel(boolean attachPanel) {
        this.isAttachPanel = attachPanel;
    }
}

