/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.form.impt.BlankDataEntityInfo;

public class ApiServiceLocalCache {
    private static final String LOCALCACHE_ID = "ImportDataLocalCache";
    private static final String TYPE_ENTITY_CACHE_TIME = "CACHE_TIME";
    private static final String TYPE_BLANK_DATAENTITY = "BLANK_DATA";
    private static final String TYPE_BASE_PKS = "BASE_PKS";
    private static final String LRU_BASE_PKS = "LRU_BASE_PKS";
    private static final String TYPE_BASE_OBJ = "BASE_OBJ";
    private static final String LRU_BASE_OBJ = "LRU_BASE_OBJ";
    private static final int CACHE_TIME_OUT = 21600;
    private static final int CACHE_MAX_ITEM_SIZE = 20;
    private static final int CACHE_MAX_MEM_SIZE = 300;
    private static final long ENTITY_CACHE_TIME_OUT = 1800000L;
    private static final long BLANK_DATA_TIME_OUT = 1800000L;
    private static final int BASE_PKS_MAX_SIZE = 10000;
    private static final int BASE_OBJ_MAX_SIZE = 1000;
    private static final CacheConfigInfo info = new CacheConfigInfo();

    private static LocalMemoryCache getLocalCache() {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), LOCALCACHE_ID, info);
    }

    protected static void clear() {
        ApiServiceLocalCache.getLocalCache().clear();
    }

    public static void clearEntityCache(String entityNumber) {
        LocalMemoryCache localMemoryCache = ApiServiceLocalCache.getLocalCache();
        if (localMemoryCache != null) {
            localMemoryCache.remove(new String[]{entityNumber});
        }
    }

    protected static Map<Object, Object> getEntityCache(String entityNumber) {
        LocalMemoryCache localMemoryCache = ApiServiceLocalCache.getLocalCache();
        ConcurrentHashMap<String, Date> entityCache = (ConcurrentHashMap<String, Date>)localMemoryCache.get(entityNumber);
        if (entityCache != null) {
            Date cacheTime = (Date)entityCache.get(TYPE_ENTITY_CACHE_TIME);
            if (cacheTime == null) {
                entityCache.put(TYPE_ENTITY_CACHE_TIME, new Date());
            } else if (ApiServiceLocalCache.isTimeOut(cacheTime, 1800000L)) {
                localMemoryCache.remove(new String[]{entityNumber});
                entityCache = null;
            }
        }
        if (entityCache == null) {
            entityCache = new ConcurrentHashMap<String, Date>(4);
            entityCache.put(TYPE_ENTITY_CACHE_TIME, new Date());
            localMemoryCache.put(entityNumber, entityCache);
        }
        return entityCache;
    }

    private static String makeBlankDataEntityCacheKey(String orgId, String userId) {
        return String.format("%s_%s_%s", TYPE_BLANK_DATAENTITY, orgId, userId);
    }

    public static DynamicObject getBlankDataEntity(String entityNumber, String orgId, String userId) {
        String cacheKey;
        Map<Object, Object> entityCache = ApiServiceLocalCache.getEntityCache(entityNumber);
        BlankDataEntityInfo blankDataEntityInfo = (BlankDataEntityInfo)entityCache.get(cacheKey = ApiServiceLocalCache.makeBlankDataEntityCacheKey(orgId, userId));
        if (blankDataEntityInfo == null) {
            return null;
        }
        if (ApiServiceLocalCache.isTimeOut(blankDataEntityInfo.getCacheTime(), 1800000L)) {
            return null;
        }
        return blankDataEntityInfo.getDataEntity();
    }

    public static void putBlankDataEntity(String entityNumber, String orgId, String userId, DynamicObject dataEntity) {
        Map<Object, Object> entityCache = ApiServiceLocalCache.getEntityCache(entityNumber);
        String cacheKey = ApiServiceLocalCache.makeBlankDataEntityCacheKey(orgId, userId);
        entityCache.put(cacheKey, new BlankDataEntityInfo(dataEntity));
    }

    public static Map<BasedataItem, Object> getBasePKs(String entityNumber) {
        Map<Object, Object> entityCache = ApiServiceLocalCache.getEntityCache(entityNumber);
        Map cacheBasePKs = (Map)entityCache.get(TYPE_BASE_PKS);
        if (cacheBasePKs == null) {
            return null;
        }
        HashMap<BasedataItem, Object> map = new HashMap<BasedataItem, Object>(cacheBasePKs);
        return map;
    }

    protected static void putBasePKs(String entityNumber, Map<BasedataItem, Object> basePKs) {
        Map<Object, Object> entityCache = ApiServiceLocalCache.getEntityCache(entityNumber);
        ConcurrentHashMap<BasedataItem, Object> cacheBasePKs = (ConcurrentHashMap<BasedataItem, Object>)entityCache.get(TYPE_BASE_PKS);
        Map lruBasePKs = (Map)entityCache.get(LRU_BASE_PKS);
        if (cacheBasePKs == null) {
            cacheBasePKs = new ConcurrentHashMap<BasedataItem, Object>();
            entityCache.put(TYPE_BASE_PKS, cacheBasePKs);
        }
        if (lruBasePKs == null) {
            lruBasePKs = new LinkedHashMap<BasedataItem, Long>(10000, 0.75f, true){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<BasedataItem, Long> pEldest) {
                    return this.size() > 10000;
                }
            };
            entityCache.put(LRU_BASE_PKS, lruBasePKs);
        }
        Long timestamp = System.currentTimeMillis();
        for (BasedataItem item : basePKs.keySet()) {
            lruBasePKs.put(item, timestamp);
        }
        Iterator it = cacheBasePKs.keySet().iterator();
        while (it.hasNext()) {
            Long itemTimestamp = (Long)lruBasePKs.get(it.next());
            if (itemTimestamp != null && timestamp - itemTimestamp <= 1800000L) continue;
            it.remove();
        }
        for (Map.Entry<BasedataItem, Object> entry : basePKs.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            cacheBasePKs.put(entry.getKey(), entry.getValue());
        }
    }

    public static Map<String, Map<Object, DynamicObject>> getBaseOBJs(String entityNumber) {
        Map<Object, Object> entityCache = ApiServiceLocalCache.getEntityCache(entityNumber);
        Map cacheBaseObjs = (Map)entityCache.get(TYPE_BASE_OBJ);
        if (cacheBaseObjs == null) {
            return null;
        }
        HashMap<String, Map<Object, DynamicObject>> baseObjs = new HashMap<String, Map<Object, DynamicObject>>(16);
        for (Map.Entry bdType : cacheBaseObjs.entrySet()) {
            baseObjs.put((String)bdType.getKey(), new HashMap((Map)bdType.getValue()));
        }
        return baseObjs;
    }

    protected static void putBaseOBJs(String entityNumber, Map<String, Map<Object, DynamicObject>> baseObjs) {
        Map<Object, Object> entityCache = ApiServiceLocalCache.getEntityCache(entityNumber);
        ConcurrentHashMap cacheBaseObjs = (ConcurrentHashMap)entityCache.get(TYPE_BASE_OBJ);
        Map lruBaseObjs = (Map)entityCache.get(LRU_BASE_OBJ);
        if (cacheBaseObjs == null) {
            cacheBaseObjs = new ConcurrentHashMap(baseObjs.size());
            entityCache.put(TYPE_BASE_OBJ, cacheBaseObjs);
        }
        if (lruBaseObjs == null) {
            lruBaseObjs = new LinkedHashMap<Object, Long>(10000, 0.75f, true){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<Object, Long> pEldest) {
                    return this.size() > 1000;
                }
            };
            entityCache.put(LRU_BASE_OBJ, lruBaseObjs);
        }
        for (Map.Entry<String, Map<Object, DynamicObject>> bdType : baseObjs.entrySet()) {
            ConcurrentHashMap<Object, DynamicObject> cacheBDType = (ConcurrentHashMap<Object, DynamicObject>)cacheBaseObjs.get(bdType.getKey());
            if (cacheBDType == null) {
                cacheBDType = new ConcurrentHashMap<Object, DynamicObject>();
                cacheBaseObjs.put(bdType.getKey(), cacheBDType);
            }
            Long timestamp = System.currentTimeMillis();
            for (Object item : bdType.getValue().keySet()) {
                lruBaseObjs.put(item, timestamp);
            }
            Iterator it = cacheBDType.keySet().iterator();
            while (it.hasNext()) {
                Long itemTimestamp = (Long)lruBaseObjs.get(it.next());
                if (itemTimestamp != null && timestamp - itemTimestamp <= 1800000L) continue;
                it.remove();
            }
            for (Map.Entry<Object, DynamicObject> entry : bdType.getValue().entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                cacheBDType.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private static boolean isTimeOut(Date cacheTime, long timeout_MS) {
        Date now = new Date();
        long offset_MS = now.getTime() - cacheTime.getTime();
        return offset_MS > timeout_MS;
    }

    static {
        info.setTimeout(21600);
        info.setMaxItemSize(20);
        info.setMaxMemSize(300);
    }
}

