/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt.background;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.impt.background.ImportProgress;
import kd.bos.schedule.executor.ExecutorService;

public class ImportProgressImpl
implements ImportProgress {
    public static final String BOS_IMPORT = "bos-import";
    private final String taskId;
    private int progress;
    private String desc;
    private final Map<String, Object> custData = new HashMap<String, Object>();

    public ImportProgressImpl(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public void feedbackProgress(JSONObject progressJson) {
        Integer currRow = progressJson.getInteger("curRowNum");
        Integer rowcount = progressJson.getInteger("totalRowNum");
        Integer handlecount = progressJson.getInteger("total");
        Integer handlerow = progressJson.getInteger("totalRow");
        Integer progress = progressJson.getInteger("progress");
        this.progress = Optional.ofNullable(progress).orElseGet(new Supplier<Integer>(){

            @Override
            public Integer get() {
                return 0;
            }
        });
        this.putNum(key -> {
            Integer value = progressJson.getInteger(key);
            if (value != null) {
                this.custData.put((String)key, String.valueOf(value));
            }
        }, "curRowNum", "totalRowNum", "total", "totalRow", "progress", "failed");
        this.putNum(key -> {
            String value = progressJson.getString(key);
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                this.custData.put((String)key, value);
            }
        }, "err");
        this.desc = String.format(ResManager.loadKDString((String)"\u5df2\u5904\u7406 %1$s \u6761/%2$s \u5f20\u5355\u636e", (String)"ImportDataProgressFormPlugin_2", (String)BOS_IMPORT, (Object[])new Object[0]), currRow, handlecount);
        ExecutorService.getInstance().getObjectFactory().getTaskDao().updateProgress(this.taskId, this.progress, this.desc, this.custData);
    }

    private void putNum(Consumer<String> consumer, String ... keys) {
        for (String key : keys) {
            consumer.accept(key);
        }
    }

    @Override
    public void feedbackCustData(Map<String, Object> data) {
        if (data != null) {
            this.custData.putAll(data);
        }
        ExecutorService.getInstance().getObjectFactory().getTaskDao().updateProgress(this.taskId, this.progress, this.desc, this.custData);
    }

    @Override
    public void fail(String err) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("err", err);
        this.feedbackCustData(data);
    }

    @Override
    public void feedbackLogId(Object logId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("logid", logId);
        this.feedbackCustData(data);
    }

    @Override
    public void complete() {
        ExecutorService.getInstance().getObjectFactory().getTaskDao().updateCustomData(this.taskId, this.custData);
    }
}

