/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt.basecache;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.form.impt.basecache.ApiPropConverterContextPlus;
import kd.bos.form.impt.basecache.ImportCacheBasedata;
import kd.bos.form.impt.basecache.ImportSourceObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.utils.ImportNameVersionHandler;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class BasedataItemUtil {
    private static final Log log = LogFactory.getLog(BasedataItemUtil.class);

    public static BasedataItem createInstanceWithCopy(BasedataItem basedataItem) {
        return new BasedataItem(basedataItem.getFieldKey(), basedataItem.getEntityNumber(), basedataItem.getRefBDType(), basedataItem.getOrgId(), basedataItem.getSearchKey(), basedataItem.getSearchValue(), basedataItem.getBizTag(), basedataItem.getVersionControl());
    }

    public static BasedataItem createInstanceWithCopy(BasedataItem basedataItem, String searchValue) {
        return new BasedataItem(basedataItem.getFieldKey(), basedataItem.getEntityNumber(), basedataItem.getRefBDType(), basedataItem.getOrgId(), basedataItem.getSearchKey(), searchValue, basedataItem.getBizTag(), basedataItem.getVersionControl());
    }

    public static BasedataItem buildBasedataItem(ApiPropConverterContextPlus apiPropConverterContext, ImportCacheBasedata importBasedata) {
        Object val = importBasedata.getBasedataObj();
        if (val == null) {
            return null;
        }
        IDataEntityProperty prop = importBasedata.getProp();
        BasedataEntityType bdType = null;
        if (prop instanceof BasedataProp) {
            bdType = (BasedataEntityType)((BasedataProp)prop).getComplexType();
        } else if (prop instanceof RefBillProp) {
            bdType = (RefEntityType)((RefBillProp)prop).getComplexType();
        }
        if (bdType == null) {
            return null;
        }
        String searchKey = null;
        String searchValue = null;
        String dataType = "number";
        if (val instanceof Map) {
            Map map = (Map)val;
            if (map.containsKey("id")) {
                return null;
            }
            String importprop = (String)map.get("importprop");
            if (StringUtils.isBlank((CharSequence)importprop)) {
                importprop = map.containsKey("number") ? "number" : "name";
                dataType = BasedataItemUtil.convertDefaultImportProp(bdType, importprop);
            } else {
                dataType = importprop;
            }
            searchValue = (String)map.get(importprop);
        }
        MasterBasedataProp masterIdProp = null;
        BasedataEntityType refMasterType = null;
        if (bdType.getMasteridType() == 2 && (masterIdProp = (MasterBasedataProp)bdType.findProperty(bdType.getMasteridPropName())) != null) {
            refMasterType = (BasedataEntityType)masterIdProp.getComplexType();
        }
        if (StringUtils.isBlank((CharSequence)(searchKey = refMasterType == null ? dataType : masterIdProp.getName() + "." + dataType))) {
            return null;
        }
        Long useOrgId = BasedataItemUtil.getUseOrgId(apiPropConverterContext, importBasedata);
        String controlVersionDate = ImportNameVersionHandler.getVersionControl(BasedataItemUtil.getDataEntityType(importBasedata), BasedataItemUtil.getImportSourceObject(importBasedata));
        return new BasedataItem(importBasedata.getProp().getName(), bdType.getName(), bdType, useOrgId, searchKey, searchValue, null, controlVersionDate);
    }

    public static IDataEntityType getDataEntityType(ImportCacheBasedata importCacheBasedata) {
        return importCacheBasedata.getDataEntity().getDataEntityType();
    }

    public static ImportSourceObject getImportSourceObject(ImportCacheBasedata importCacheBasedata) {
        return importCacheBasedata.getImportSourceObject();
    }

    private static String convertDefaultImportProp(BasedataEntityType refPropType, String importprop) {
        importprop = "name".equals(importprop) ? refPropType.getNameProperty() : refPropType.getNumberProperty();
        return importprop;
    }

    private static Long getUseOrgId(ApiPropConverterContextPlus context, ImportCacheBasedata importBasedata) {
        Map mapVal;
        String useOrgPropKey = BasedataItemUtil.getUserOrgPropName(importBasedata.getProp());
        if (StringUtils.isBlank((CharSequence)useOrgPropKey)) {
            useOrgPropKey = context.getModel().getDataEntityType().getMainOrg();
        }
        if (StringUtils.isBlank((CharSequence)useOrgPropKey)) {
            return 0L;
        }
        if (StringUtils.equals((CharSequence)useOrgPropKey, (CharSequence)context.getModel().getDataEntityType().getMainOrg())) {
            return context.getMainOrgId();
        }
        Object orgVal = BasedataItemUtil.getValueFromSourceObj(importBasedata.getImportSourceObject(), useOrgPropKey, true);
        if (orgVal == null) {
            return 0L;
        }
        if (orgVal instanceof DynamicObject) {
            return (Long)((DynamicObject)orgVal).getPkValue();
        }
        if (orgVal instanceof Map && (mapVal = (Map)orgVal).containsKey("id")) {
            Object id = mapVal.get("id");
            if (id instanceof Long) {
                return (Long)id;
            }
            if (id != null) {
                return Long.valueOf(id.toString());
            }
        }
        return 0L;
    }

    private static String getUserOrgPropName(IDataEntityProperty property) {
        if (property instanceof IBasedataField) {
            return ((IBasedataField)property).getOrgProp();
        }
        return null;
    }

    public static Object getValueFromSourceObj(ImportSourceObject importSourceObject, String propName, boolean searchTargetObj) {
        Map<String, Object> sourceObj = importSourceObject.getSourceObj();
        boolean exist = sourceObj.containsKey(propName);
        if (exist) {
            return sourceObj.get(propName);
        }
        CaseInsensitiveMap sourceKeys = new CaseInsensitiveMap(sourceObj.size());
        for (String key : sourceObj.keySet()) {
            sourceKeys.put(key, key);
        }
        exist = sourceKeys.containsKey(propName);
        if (exist) {
            String sourceKey = (String)sourceKeys.get(propName);
            return sourceObj.get(sourceKey);
        }
        if (importSourceObject.getParent() != null) {
            return BasedataItemUtil.getValueFromSourceObj(importSourceObject.getParent(), propName, searchTargetObj);
        }
        return null;
    }
}

