/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.impt.ImportBillResult;
import kd.bos.form.impt.SingleBillResult;

public class ResultContext {
    private final Set<String> pkIds;
    private final List<DynamicObject> billObjs;
    private final Map<Integer, ImportBillResult> resultsForCreateDataEntity;
    private OperationResult resultForConvertMapToDataEntity;
    private OperationResult resultForSaveBillObjs;
    private final Map<Integer, SingleBillResult> singleBillResults = new TreeMap<Integer, SingleBillResult>();
    private ApiResult apiResult;

    public ResultContext() {
        this.pkIds = new HashSet<String>();
        this.billObjs = new ArrayList<DynamicObject>();
        this.resultsForCreateDataEntity = new TreeMap<Integer, ImportBillResult>();
    }

    public void addResultsForCreateDataEntity(int index, ImportBillResult resultForCreateDataEntity) {
        this.resultsForCreateDataEntity.put(index, resultForCreateDataEntity);
    }

    public void addSingleBillResult(int index, SingleBillResult singleBillResult) {
        this.singleBillResults.put(index, singleBillResult);
    }

    public ImportBillResult getResultForCreateDataEntity(int index) {
        return this.resultsForCreateDataEntity.getOrDefault(index, ImportBillResult.createSuccess());
    }

    public OperationResult getResultForConvertMapToDataEntity() {
        return this.resultForConvertMapToDataEntity;
    }

    public void setResultForConvertMapToDataEntity(OperationResult resultForConvertMapToDataEntity) {
        this.resultForConvertMapToDataEntity = resultForConvertMapToDataEntity;
    }

    public OperationResult getResultForSaveBillObjs() {
        return this.resultForSaveBillObjs;
    }

    public void setResultForSaveBillObjs(OperationResult resultForSaveBillObjs) {
        this.resultForSaveBillObjs = resultForSaveBillObjs;
    }

    public List<SingleBillResult> getSingleBillResult() {
        return new ArrayList<SingleBillResult>(this.singleBillResults.values());
    }

    public Set<String> getPkIds() {
        return this.pkIds;
    }

    public void addPkId(String pkId) {
        this.pkIds.add(pkId);
    }

    public List<DynamicObject> getBillObjs() {
        return this.billObjs;
    }

    public void addBillObj(DynamicObject billObj) {
        this.billObjs.add(billObj);
    }

    public ApiResult getApiResult() {
        return this.apiResult;
    }

    public void setApiResult(ApiResult apiResult) {
        this.apiResult = apiResult;
    }
}

