/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt.process.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.impt.ImportBillData;
import kd.bos.form.impt.ImportBillResult;
import kd.bos.form.impt.context.MetadataContext;
import kd.bos.form.impt.context.ResultContext;
import kd.bos.form.impt.process.impl.CreateDataEntityProcess;
import kd.bos.mvc.bill.BillModel;

public class CreateDataEntityProcessFast
extends CreateDataEntityProcess {
    private Map<Object, List<ImportBillData>> loadDataCache;

    @Override
    protected void initForSingleBatch(IFormView formView, MetadataContext metadataContext, ResultContext resultContext) {
        super.initForSingleBatch(formView, metadataContext, resultContext);
        this.loadDataCache = new HashMap<Object, List<ImportBillData>>();
    }

    @Override
    protected void loadData(ImportBillData rowMapper, Object pkId) {
        this.loadDataCache.computeIfAbsent(pkId, x -> new LinkedList()).add(rowMapper);
    }

    @Override
    protected void createData() {
        super.createData();
        DynamicObject[] dataEntitys = this.batchLoadDataEntity();
        if (dataEntitys == null || dataEntitys.length == 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntitys) {
            List<ImportBillData> importRowMappers = this.loadDataCache.get(dataEntity.getPkValue());
            if (importRowMappers.size() > 1) {
                this.handleRepeatData(importRowMappers);
                continue;
            }
            DynamicObject dataEntityFromBiz = this.fireLoadData(dataEntity);
            ((BillModel)this.formView.getModel()).push((Object)(dataEntityFromBiz == null ? dataEntity : dataEntityFromBiz));
            ImportBillResult[] importResults = this.validateLoadData(dataEntity, importRowMappers.get(0));
            if (!importResults[0].isSuccess()) continue;
            this.metadataContext.addDataEntity(importRowMappers.get(0).getRowIndex(), this.formView.getModel().getDataEntity());
        }
    }

    private void handleRepeatData(List<ImportBillData> importRowMappers) {
        for (ImportBillData rowMapper : importRowMappers) {
            String keyFields = this.metadataContext.getKeyFields();
            String[] splitKeyFields = StringUtils.split((String)keyFields, (String)",");
            ArrayList<String> keyFieldValue = new ArrayList<String>(splitKeyFields.length);
            String[] stringArray = splitKeyFields;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String keyField;
                String keyFieldDisPlayName = keyField = stringArray[i];
                if (StringUtils.equals((CharSequence)keyField, (CharSequence)"id")) {
                    keyFieldDisPlayName = ResManager.loadKDString((String)"\u5185\u7801", (String)"BasedataPropCache_1", (String)"bos-import", (Object[])new Object[0]);
                } else if (this.formView.getModel().getProperty(keyField) != null) {
                    keyFieldDisPlayName = this.formView.getModel().getProperty(keyField).getDisplayName().getLocaleValue();
                }
                Object value = rowMapper.getSourceObj().get(keyField);
                if (value instanceof JSONObject) {
                    Object importprop = ((JSONObject)value).get((Object)"importprop");
                    value = ((JSONObject)value).get(importprop);
                }
                String reData = keyFieldDisPlayName + "=" + value;
                keyFieldValue.add(reData);
            }
            this.resultContext.addResultsForCreateDataEntity(rowMapper.getRowIndex(), ImportBillResult.createError(String.format(ResManager.loadKDString((String)"\u6570\u636e\u66ff\u6362\u89c4\u5219\u552f\u4e00\u503c\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u5bfc\u5165\u5931\u8d25\uff1a%s\u3002", (String)"CreateDataEntityProcessFast_1", (String)"bos-import", (Object[])new Object[0]), StringUtils.join((Object[])keyFieldValue.toArray(), (char)'\uff0c'))));
        }
    }

    private DynamicObject[] batchLoadDataEntity() {
        boolean splitPage = Boolean.parseBoolean(System.getProperty("billmodel.splitpage", "false"));
        DynamicObject[] load = splitPage ? BusinessDataReader.load((Object[])this.loadDataCache.keySet().toArray(), (DynamicObjectType)this.formView.getModel().getDataEntityType(), (Boolean)Boolean.TRUE, (int)0, (int)this.formView.getModel().getEntryPageSize()) : BusinessDataReader.load((Object[])this.loadDataCache.keySet().toArray(), (DynamicObjectType)this.formView.getModel().getDataEntityType(), (Boolean)Boolean.TRUE);
        return load;
    }

    private DynamicObject fireLoadData(DynamicObject dynamicObject) {
        LoadDataEventArgs e = new LoadDataEventArgs((Object)this.formView.getModel(), dynamicObject.getPkValue());
        this.modelEventProxy.fireLoadData(e);
        return e.getDataEntity();
    }

    private ImportBillResult[] validateLoadData(DynamicObject dynamicObject, ImportBillData rowMapper) {
        ImportBillResult[] importResults = new ImportBillResult[1];
        this.validateLoadData(this.formView.getModel(), dynamicObject.getPkValue(), importResults);
        this.resultContext.addResultsForCreateDataEntity(rowMapper.getRowIndex(), importResults[0]);
        return importResults;
    }
}

