/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.imptapi;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.operate.imptapi.ApiAttachmentPropConverter;
import kd.bos.form.operate.imptapi.RowMapper;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.servicehelper.AttachmentServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ApiAttachmentPanelConverter
extends ApiAttachmentPropConverter {
    private final String attachmentPanelKey;
    private final String attachmentPanelName;

    public ApiAttachmentPanelConverter(AttachmentPanelAp attachmentPanelAp) {
        this.attachmentPanelKey = attachmentPanelAp.getKey();
        this.attachmentPanelName = attachmentPanelAp.getName().getLocaleValue();
        this.maxAtmCount = attachmentPanelAp.getMaxAtmCount();
        this.maxAtmSize = attachmentPanelAp.getMaxAtmSize();
        this.sortField = attachmentPanelAp.getSortField();
        this.sortType = attachmentPanelAp.getSortType();
        this.extendName = attachmentPanelAp.getExtendName();
        this.checkDuplicateFileName = attachmentPanelAp.getCheckDuplicateFileName();
    }

    @Override
    public void beginParseValue(RowMapper rowMapper, Object value) {
        this.rowMapper = rowMapper;
        if (value == null) {
            return;
        }
        if (!(value instanceof JSONArray) || ((JSONArray)value).size() < 1 || StringUtils.isEmpty((CharSequence)this.attachmentPanelKey)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.extendName)) {
            List<String> extendNameList = Arrays.asList(this.extendName.split(","));
            ArrayList<String> tmpList = new ArrayList<String>(extendNameList);
            for (String extendName : extendNameList) {
                if (extendName.startsWith(".")) {
                    tmpList.add(extendName.substring(1));
                    continue;
                }
                tmpList.add(extendName);
            }
            this.whiteTypeList = new HashSet(CollectionUtils.intersection((Iterable)this.whiteTypeList, tmpList));
        }
        this.attachmentPanelForImportDtoList.clear();
        JSONArray attachmentPanelJsonArray = (JSONArray)value;
        String[] attachmentFileNameArr = new String[]{};
        for (int i = 0; i < attachmentPanelJsonArray.size(); ++i) {
            String[] tempNameArr = attachmentPanelJsonArray.getJSONObject(i).getString(this.attachmentPanelKey).split("\n");
            attachmentFileNameArr = (String[])Stream.concat(Arrays.stream(attachmentFileNameArr), Arrays.stream(tempNameArr)).toArray(String[]::new);
        }
        this.uploadAttList(rowMapper, attachmentFileNameArr, true);
    }

    @Override
    protected List<String> checkAttachmentExistDuplicateFileName(String[] attachmentFileNameArr, DynamicObject targetObj) {
        ArrayList<String> duplicateList = new ArrayList<String>(2);
        if (this.checkDuplicateFileName && this.rowMapper.getTargetObj().getPkValue() != null) {
            List oldAttachments = AttachmentServiceHelper.getAttachments((String)this.getContext().getModel().getDataEntityType().getName(), (Object)this.rowMapper.getTargetObj().getPkValue(), (String)this.getKey(), (boolean)false);
            ArrayList<String> oldAttachmentPanelAttNameList = new ArrayList<String>(oldAttachments.size());
            if (oldAttachments.size() > 0) {
                for (Map oldAttachment : oldAttachments) {
                    if (!(oldAttachment.get("name") instanceof String)) continue;
                    oldAttachmentPanelAttNameList.add(oldAttachment.get("name").toString());
                }
            }
            if (oldAttachmentPanelAttNameList.size() > 0) {
                for (String oldAttachmentFieldName : oldAttachmentPanelAttNameList) {
                    for (String attachmentFileName : attachmentFileNameArr) {
                        if (!StringUtils.equals((CharSequence)oldAttachmentFieldName, (CharSequence)attachmentFileName)) continue;
                        duplicateList.add(attachmentFileName);
                    }
                }
            }
        }
        return duplicateList;
    }

    @Override
    protected void execSetValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        this.getContext().getAttachmentPanelTempUrlList().addAll(this.attachmentPanelForImportDtoList);
        this.attachmentPanelForImportDtoList.clear();
    }

    @Override
    protected String getKey() {
        return this.attachmentPanelKey;
    }

    @Override
    protected String getName() {
        return this.attachmentPanelName;
    }

    @Override
    protected String getAttType() {
        return ResManager.loadKDString((String)"\u9644\u4ef6\u9762\u677f", (String)"ImportAttachment_8", (String)"bos-import", (Object[])new Object[0]);
    }
}

