/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.imptapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.operate.imptapi.ApiPropConverter;
import kd.bos.form.operate.imptapi.RowMapper;

class ApiComboPropConverter
extends ApiPropConverter {
    private final Set<String> validValues = new HashSet<String>();

    ApiComboPropConverter() {
    }

    @Override
    protected void execSetValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        ArrayList<String> invalidValues = new ArrayList<String>();
        if (this.checkImportValue(value, invalidValues)) {
            super.execSetValue(rowMapper, activeRow, value);
        } else if (invalidValues.isEmpty()) {
            String errMsg = ResManager.loadKDString((String)"\u201c%1$s\u201d\u8f93\u5165\u4e86\u672a\u77e5\u7684\u679a\u4e3e\u503c\uff1a%2$s\u3002", (String)"ApiComboPropConverter_0", (String)"bos-import", (Object[])new Object[0]);
            String itemName = this.exchangeValueToName(value.toString());
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(errMsg, this.getProp().getDisplayName().toString(), itemName));
        } else {
            String errMsg = ResManager.loadKDString((String)"\u201c%1$s\u201d\u8f93\u5165\u4e86\u672a\u77e5\u7684\u679a\u4e3e\u503c\uff1a%2$s\u3002", (String)"ApiComboPropConverter_0", (String)"bos-import", (Object[])new Object[0]);
            ArrayList<String> invalidNames = new ArrayList<String>(8);
            for (String invalidValue : invalidValues) {
                String invalidName = this.exchangeValueToName(invalidValue);
                invalidNames.add(invalidName);
            }
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(errMsg, this.getProp().getDisplayName().toString(), StringUtils.join((Object[])invalidNames.toArray(), (String)",")));
        }
    }

    private boolean checkImportValue(Object value, List<String> invalidValues) {
        String[] itemValues;
        if (StringUtils.isBlank((Object)value)) {
            return true;
        }
        ComboProp comboProp = (ComboProp)this.getProp();
        if (comboProp.isEditable()) {
            return true;
        }
        if (comboProp.isEmptyItems()) {
            return true;
        }
        for (String itemValue : itemValues = value.toString().split(",")) {
            if (StringUtils.isBlank((CharSequence)itemValue) || this.validValues.contains(itemValue)) continue;
            if (comboProp.isExistItem(itemValue)) {
                this.validValues.add(itemValue);
                continue;
            }
            invalidValues.add(itemValue);
        }
        return invalidValues.isEmpty();
    }

    private String exchangeValueToName(String value) {
        ComboProp comboProp = (ComboProp)this.getProp();
        List comboItems = comboProp.getComboItems();
        for (ValueMapItem comboItem : comboItems) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)comboItem.getValue())) continue;
            return comboItem.getName().getLocaleValue();
        }
        return value;
    }

    private boolean isItemVisible(String itemValue) {
        ComboProp comboProp = (ComboProp)this.getProp();
        ValueMapItem resultItem = null;
        for (ValueMapItem comboItem : comboProp.getComboItems()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)itemValue, (CharSequence)comboItem.getValue())) continue;
            resultItem = comboItem;
            break;
        }
        return null != resultItem && resultItem.isItemVisible();
    }
}

