/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.imptapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.imptapi.ApiPropConvertContext;
import kd.bos.form.operate.imptapi.ApiPropConvertSeq;
import kd.bos.form.operate.imptapi.IApiPropConverter;
import kd.bos.form.operate.imptapi.RowMapper;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRules;

public class ApiPropConverter
implements IApiPropConverter {
    private ApiPropConvertContext context;
    private IDataEntityProperty prop;
    protected RowMapper rowMapper;

    public ApiPropConvertContext getContext() {
        return this.context;
    }

    public void setContext(ApiPropConvertContext context) {
        this.context = context;
    }

    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    public void setRowMapper(RowMapper rowMapper) {
        this.rowMapper = rowMapper;
    }

    @Override
    public IDataEntityProperty getProp() {
        return this.prop;
    }

    public void setProp(IDataEntityProperty prop) {
        this.prop = prop;
    }

    public IFieldHandle getFieldHandle() {
        return (IFieldHandle)this.getProp();
    }

    @Override
    public int getConvertSeq() {
        return ApiPropConvertSeq.SimpleProp.getValue();
    }

    @Override
    public void beginParseValue(RowMapper rowMapper, Object value) {
        this.rowMapper = rowMapper;
    }

    @Override
    public void endParseValue() {
    }

    @Override
    public void setValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        Object fldValue = value;
        if (StringUtils.isBlank((Object)value)) {
            if (!this.getContext().isModify()) {
                return;
            }
            fldValue = null;
        }
        if (!this.hasFieldWriteControl()) {
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u65e0\u5b57\u6bb5\u5bfc\u5165\u6743\u9650\u3002", (String)"ApiPropConverter_0", (String)"bos-import", (Object[])new Object[0]), this.getProp().getDisplayName().toString()));
            return;
        }
        this.execSetValue(rowMapper, activeRow, fldValue);
    }

    protected void execSetValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        try {
            this.getContext().getModel().setFieldValueForWebApi(this.getProp(), activeRow, value, this.getContext().isCheckImportable());
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), e.getMessage());
            }
            throw e;
        }
    }

    private FieldControlRule getFieldControl(Long orgId) {
        FieldControlRules fieldControlRules = this.context.getFieldControlRules();
        if (fieldControlRules == null) {
            return null;
        }
        FieldControlRule fieldControlRule = new FieldControlRule();
        fieldControlRule.setCanNotReadRuleFields(new ArrayList());
        fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
        fieldControlRule.setCanNotReadFields(new HashSet());
        fieldControlRule.setCanNotWriteFields(new HashSet());
        if (orgId != null && orgId != 0L) {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp;
                if (!Objects.equals(listField.getMainOrgId(), orgId) && (!listField.getIncludeSubOrg() || !listField.getSubOrgId().contains(orgId)) || (temp = listField.getFieldControlRule()) == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
        } else {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp = listField.getFieldControlRule();
                if (temp == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
        }
        return fieldControlRule;
    }

    protected boolean hasFieldWriteControl() {
        IDataEntityProperty fieldProp = this.getProp();
        if (fieldProp == null) {
            return true;
        }
        Long mainOrgId = this.context.getMainOrgId();
        FieldControlRule fieldControlRule = this.getFieldControl(mainOrgId);
        if (fieldControlRule == null) {
            return true;
        }
        String fieldName = fieldProp.getName();
        return !fieldControlRule.getCanNotWriteFields().contains(fieldName) && !fieldControlRule.getCanNotReadFields().contains(fieldName);
    }
}

