/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.imptapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.property.IRefBillField;
import kd.bos.entity.property.RefBillProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.imptapi.ApiBasedataPropConverter;
import kd.bos.form.operate.imptapi.ApiFilter;
import kd.bos.form.operate.imptapi.ApiPropConvertSeq;
import kd.bos.form.operate.imptapi.AssignmentIdResult;
import kd.bos.form.operate.imptapi.RefBilldataItem;
import kd.bos.form.operate.imptapi.RowMapper;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.utils.ConvertResult;
import kd.bos.utils.ImportConvertUtils;

class ApiRefBilldataPropConverter
extends ApiBasedataPropConverter {
    protected Map<RefBilldataItem, Set<String>> refBillSearchItems = new ConcurrentHashMap<RefBilldataItem, Set<String>>();

    ApiRefBilldataPropConverter() {
    }

    public RefBillProp getRefBilldataProp() {
        return (RefBillProp)this.getProp();
    }

    @Override
    public BasedataEntityType getRefBDType(RowMapper row) {
        return (BasedataEntityType)((RefBillProp)this.getProp()).getComplexType();
    }

    @Override
    public String getUserOrgPropName() {
        if (this.getProp() instanceof IRefBillField) {
            return ((IRefBillField)this.getProp()).getOrgProp();
        }
        return null;
    }

    @Override
    public int getConvertSeq() {
        return ApiPropConvertSeq.RefBilldataProp.getValue();
    }

    @Override
    protected void addSearchItem(RowMapper rowMapper, Object value) {
        if (this.addSerchId(rowMapper, value)) {
            return;
        }
        RefBilldataItem item = this.buildRefBilldataItem(rowMapper, value);
        if (item == null) {
            return;
        }
        String searchValue = item.getSearchValue();
        item.setSearchValue(null);
        if (!this.getRefBillSearchItems().containsKey((Object)item)) {
            HashSet searchValues = new HashSet();
            this.getRefBillSearchItems().put(item, searchValues);
        }
        this.getRefBillSearchItems().get((Object)item).add(searchValue);
    }

    protected RefBilldataItem buildRefBilldataItem(RowMapper rowMapper, Object val) {
        if (!(val instanceof Map)) {
            return null;
        }
        BasedataEntityType bdType = this.getRefBDType(rowMapper);
        if (bdType == null) {
            return null;
        }
        String searchKey = null;
        String searchValue = null;
        String dataType = "number";
        Map map = (Map)val;
        if (map.containsKey("id")) {
            return null;
        }
        String importprop = (String)map.get("importprop");
        if (StringUtils.isBlank((CharSequence)importprop)) {
            importprop = map.containsKey("number") ? "number" : "name";
            BasedataEntityType refPropType = this.getEntityType();
            dataType = this.convertDefaultImportProp(refPropType, importprop);
        } else {
            dataType = importprop;
        }
        searchValue = (String)map.get(importprop);
        Object refMasterType = null;
        if (refMasterType == null) {
            searchKey = dataType;
        }
        if (StringUtils.isBlank((CharSequence)searchKey)) {
            return null;
        }
        Long useOrgId = this.getUseOrgId(rowMapper);
        return new RefBilldataItem(this.getProp().getName(), bdType.getName(), bdType, useOrgId, searchKey, searchValue, null);
    }

    @Override
    public void endParseValue() {
        try {
            this.loadRefBillPKsFromDB();
            this.loadRefBillObjsFromDB();
            this.refBillSearchItems.clear();
            this.searchPKs.clear();
        }
        catch (KDBizException bizException) {
            this.getContext().addErrorInfo(bizException.getMessage());
        }
    }

    private void loadRefBillObjsFromDB() {
        if (this.getSearchPKs().isEmpty()) {
            return;
        }
        HashSet ids = new HashSet(1000);
        HashMap<BasedataEntityType, Set<Object>> tempSearchPKs = new HashMap<BasedataEntityType, Set<Object>>(this.getSearchPKs());
        for (Map.Entry item : tempSearchPKs.entrySet()) {
            BasedataEntityType rbdType = (BasedataEntityType)item.getKey();
            Set pks = (Set)item.getValue();
            if (!this.getContext().getBaseObjs().containsKey(rbdType.getName())) {
                ids.addAll(pks);
            } else {
                for (Object id : (Set)item.getValue()) {
                    if (this.getContext().getBaseObjs().get(rbdType.getName()).containsKey(id)) continue;
                    ids.add(id);
                }
            }
            if (ids.isEmpty()) continue;
            ISimpleProperty primaryKey = rbdType.getPrimaryKey();
            String disPlayName = this.getBaseDataPropDisplayName();
            ConvertResult convertResult = ImportConvertUtils.convertIds(Arrays.asList(ids.toArray()), primaryKey.getPropertyType(), disPlayName);
            if (StringUtils.isNotBlank((CharSequence)convertResult.getErrMsg())) {
                throw new KDBizException(convertResult.getErrMsg());
            }
            Map objs = BusinessDataReader.loadFromCache((Object[])convertResult.getIds().toArray(), (DynamicObjectType)rbdType);
            if (!this.getContext().getBaseObjs().containsKey(rbdType.getName())) {
                this.getContext().getBaseObjs().put(rbdType.getName(), new HashMap(objs.size()));
            }
            this.getContext().getBaseObjs().get(rbdType.getName()).putAll(objs);
            ids.clear();
        }
    }

    private void loadRefBillPKsFromDB() {
        if (this.getRefBillSearchItems().isEmpty()) {
            return;
        }
        ArrayList<Object> ids = new ArrayList<Object>(200);
        HashMap<RefBilldataItem, List<Object>> map = new HashMap<RefBilldataItem, List<Object>>(200);
        ArrayList<String> searchValues2 = new ArrayList<String>(200);
        HashMap<RefBilldataItem, Set<String>> tempSearchItems = new HashMap<RefBilldataItem, Set<String>>(this.getRefBillSearchItems());
        for (Map.Entry item : tempSearchItems.entrySet()) {
            RefBilldataItem refbilldataItem = (RefBilldataItem)((Object)item.getKey());
            Set searchValues = (Set)item.getValue();
            for (String searchValue : searchValues) {
                RefBilldataItem refbilldataItem2 = new RefBilldataItem(refbilldataItem.getFieldKey(), refbilldataItem.getEntityNumber(), refbilldataItem.getRefBDType(), refbilldataItem.getOrgId(), refbilldataItem.getSearchKey(), searchValue, refbilldataItem.getBizTag());
                if (StringUtils.isBlank((CharSequence)searchValue)) {
                    this.getContext().getRefBillPKs().put(refbilldataItem2, null);
                    continue;
                }
                if (this.getContext().getRefBillPKs().containsKey((Object)refbilldataItem2)) continue;
                searchValues2.add(searchValue);
            }
            if (searchValues2.isEmpty()) continue;
            this.queryRefBillPk(refbilldataItem, map, ids, searchValues2);
            searchValues2.clear();
            ids.clear();
            map.clear();
        }
    }

    public Map<RefBilldataItem, Set<String>> getRefBillSearchItems() {
        return this.refBillSearchItems;
    }

    @Override
    protected BasedataEntityType getEntityType() {
        return (BasedataEntityType)this.getRefBilldataProp().getComplexType();
    }

    private void queryRefBillPk(RefBilldataItem refbilldataItem, Map<RefBilldataItem, List<Object>> searchResult, List<Object> ids, List<String> searchValues) {
        ApiFilter filters = this.buildBaseDataFilter(refbilldataItem, searchValues);
        Map<RefBilldataItem, Object> refBillPKs = this.getContext().getRefBillPKs();
        Map<RefBilldataItem, String> refBillPKErrors = this.getContext().getRefBillPKErrors();
        ORM orm = ORM.create();
        String fields = "id," + refbilldataItem.getSearchKey();
        try (DataSet ds = orm.queryDataSet("ApiRefBilldataPropConverter.loadRefBillPKsFromDB()", refbilldataItem.getEntityNumber(), fields, filters.toArray(), "");){
            RefBilldataItem refbilldataItem2;
            HashSet<String> notExistValues = new HashSet<String>(searchValues);
            for (Row row : ds) {
                List<Object> curSearchResult;
                Object pkValue = row.get("id");
                String searchValue = row.getString(refbilldataItem.getSearchKey());
                refbilldataItem2 = new RefBilldataItem(refbilldataItem.getFieldKey(), refbilldataItem.getEntityNumber(), refbilldataItem.getRefBDType(), refbilldataItem.getOrgId(), refbilldataItem.getSearchKey(), searchValue, refbilldataItem.getBizTag());
                if (!searchResult.containsKey((Object)refbilldataItem2)) {
                    searchResult.put(refbilldataItem2, new ArrayList(4));
                }
                if ((curSearchResult = searchResult.get((Object)refbilldataItem2)).contains(pkValue)) continue;
                curSearchResult.add(pkValue);
                notExistValues.remove(searchValue);
            }
            Iterator<Map.Entry<RefBilldataItem, List<Object>>> searchResultIterator = searchResult.entrySet().iterator();
            while (searchResultIterator.hasNext()) {
                Map.Entry<RefBilldataItem, List<Object>> entry = searchResultIterator.next();
                List<Object> pkIds = entry.getValue();
                if (pkIds.size() == 1) {
                    ids.add(pkIds.get(0));
                    refBillPKs.put(entry.getKey(), pkIds.get(0));
                    searchResultIterator.remove();
                    continue;
                }
                if (pkIds.size() > 1) {
                    refBillPKErrors.put(entry.getKey(), this.buildRepeatError(entry, filters));
                    continue;
                }
                refBillPKErrors.put(entry.getKey(), this.buildExistError(entry, filters));
            }
            for (String v : notExistValues) {
                refbilldataItem2 = new RefBilldataItem(refbilldataItem.getFieldKey(), refbilldataItem.getEntityNumber(), refbilldataItem.getRefBDType(), refbilldataItem.getOrgId(), refbilldataItem.getSearchKey(), v, refbilldataItem.getBizTag());
                searchResult.put(refbilldataItem2, new ArrayList());
            }
        }
        if (!this.getSearchPKs().containsKey(refbilldataItem.getRefBDType())) {
            this.getSearchPKs().put(refbilldataItem.getRefBDType(), new HashSet(ids.size()));
        }
        this.getSearchPKs().get(refbilldataItem.getRefBDType()).addAll(ids);
    }

    @Override
    protected BasedataItem rebulidBaseDataItem(BasedataItem basedataItem, String searchValue) {
        return new RefBilldataItem(basedataItem.getFieldKey(), basedataItem.getEntityNumber(), basedataItem.getRefBDType(), basedataItem.getOrgId(), basedataItem.getSearchKey(), searchValue, basedataItem.getBizTag());
    }

    @Override
    protected List<QFilter> getF7QFilter(IDataEntityProperty baseProp, IDataModel model, String formShowParameterAppId, BasedataItem basedataItem) {
        return FilterUtil.buildRefBillF7QFilters((IRefBillField)((IRefBillField)baseProp), (IDataModel)model, (String)formShowParameterAppId, (String)basedataItem.getEntityNumber(), new ArrayList(), (String)"47150e89000000ac", (boolean)true);
    }

    @Override
    protected Object getPKid(BasedataEntityType refBDType, Object id) {
        return this.getRefBilldataProp().convertPKValueType((DynamicObjectType)refBDType, id);
    }

    private String buildRepeatError(Map.Entry<RefBilldataItem, List<Object>> searchResult, ApiFilter filters) {
        StringBuilder sb = new StringBuilder();
        RefBilldataItem item = searchResult.getKey();
        sb.append(filters.getFilterDesc().get((Object)item));
        for (String msg : filters.getCommonfilterDesc()) {
            sb.append('\uff0c').append(msg);
        }
        sb.append('\uff0c').append(ResManager.loadKDString((String)"\u7b26\u5408\u5355\u636e\u5b57\u6bb5\u67e5\u8be2\u6761\u4ef6", (String)"ApiRefBilldataPropConverter_2", (String)"bos-import", (Object[])new Object[0]));
        String displayName = this.getDisplayName((EntityType)this.getContext().getModel().getDataEntityType(), item.getFieldKey());
        return String.format(ResManager.loadKDString((String)"\u201c%1$s\u7684\u201c%2$s\u201c\u5728\u7cfb\u7edf\u4e2d\u67e5\u8be2\u5230\u91cd\u590d\u7684\u201c%3$s\u201c\uff0c\u91cd\u590d\u7684\u5185\u7801\u4e3a\uff1a%4$s", (String)"ApiBasedataPropConverter_0", (String)"bos-import", (Object[])new Object[0]), sb, displayName, displayName, searchResult.getValue().size() > 3 ? searchResult.getValue().subList(0, 3) + "\u2026\u2026" : searchResult.getValue());
    }

    private String buildExistError(Map.Entry<RefBilldataItem, List<Object>> searchResult, ApiFilter filters) {
        RefBilldataItem item = searchResult.getKey();
        StringBuilder sb = new StringBuilder(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b\u201c%2$s\u201d", (String)"ApiBasedataPropConverter_8", (String)"bos-import", (Object[])new Object[0]), this.getDisplayName((EntityType)this.getContext().getModel().getDataEntityType(), item.getFieldKey()), filters.getFilterDesc().get((Object)item)));
        sb.append(ResManager.loadKDString((String)"\u5bfc\u5165\u4e0d\u6210\u529f\u3002\u53ef\u80fd\u7684\u539f\u56e0\u662f\uff1a1\u3001", (String)"ApiBasedataPropConverter_9", (String)"bos-import", (Object[])new Object[0])).append(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u6b63\u786e\uff1b2\u3001\u4e0d\u7b26\u5408\u5355\u636e\u5b57\u6bb5\u67e5\u8be2\u6761\u4ef6", (String)"ApiRefBilldataPropConverter_1", (String)"bos-import", (Object[])new Object[0]), filters.getSearchName().get((Object)item)));
        int i = 3;
        for (String msg : filters.getCommonfilterDesc()) {
            sb.append('\uff1b').append(i++).append('\u3001').append(msg).append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u4f7f\u7528\u6743\u9650", (String)"ApiBasedataPropConverter_11", (String)"bos-import", (Object[])new Object[0]));
        }
        return sb.append('\u3002').toString();
    }

    @Override
    protected BasedataItem bulidItem(RowMapper rowMapper, Object srcVal) {
        return this.buildRefBilldataItem(rowMapper, srcVal);
    }

    @Override
    protected boolean isContainsItem(BasedataItem refBilldataItem) {
        return this.getContext().getRefBillPKs().containsKey(refBilldataItem);
    }

    @Override
    protected Object getPKFromItem(BasedataItem refBilldataItem) {
        return this.getContext().getRefBillPKs().get(refBilldataItem);
    }

    @Override
    protected AssignmentIdResult assignmentId(RowMapper rowMapper, Object id, BasedataItem basedataItem, String oldFieldKey) {
        boolean isContainsError = false;
        String error = this.getContext().getRefBillPKErrors().get(basedataItem);
        if (error == null && oldFieldKey != null) {
            basedataItem.setFieldKey(oldFieldKey);
            error = this.getContext().getRefBillPKErrors().get(basedataItem);
        }
        if (error != null) {
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), error);
            isContainsError = true;
        }
        return new AssignmentIdResult(id, isContainsError);
    }
}

