/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.imptapi;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.imptapi.ApiPropConverter;
import kd.bos.form.operate.imptapi.RowMapper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ApiTimePropConverter
extends ApiPropConverter {
    private static final Log log = LogFactory.getLog(ApiTimePropConverter.class);
    private static final String BOS_FORM_CORE = "bos-form-core";

    @Override
    protected void execSetValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        if (this.validateTimeRange(rowMapper, activeRow)) {
            try {
                super.execSetValue(rowMapper, activeRow, value);
            }
            catch (NumberFormatException e) {
                LocaleString displayName = this.getProp().getDisplayName();
                this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"ApiTimePropConverter_3", (String)"bos-import", (Object[])new Object[0]), displayName == null ? this.getProp().getName() : displayName.getLocaleValue(), value));
            }
        }
    }

    private boolean validateTimeRange(RowMapper rowMapper, DynamicObject activeRow) {
        TimeProp timeProp;
        IDataEntityProperty prop = this.getProp();
        if (prop instanceof TimeProp && StringUtils.isNotBlank((CharSequence)(timeProp = (TimeProp)prop).getRelateTimeRange())) {
            return this.validateTimeRangeForEmpty(timeProp, rowMapper) && this.validateTimeRangeForTimeUp(timeProp, rowMapper);
        }
        return true;
    }

    private boolean validateTimeRangeForEmpty(TimeProp timeProp, RowMapper rowMapper) {
        Object relateTimeRangeObj = rowMapper.getSourceObj().get(timeProp.getRelateTimeRange());
        Object timeObj = rowMapper.getSourceObj().get(timeProp.getName());
        if (StringUtils.isBlank((Object)relateTimeRangeObj) && StringUtils.isBlank((Object)timeObj)) {
            return true;
        }
        if (relateTimeRangeObj == null || StringUtils.isBlank((CharSequence)relateTimeRangeObj.toString())) {
            String displayName = timeProp.getDisplayName() == null ? timeProp.getName() : timeProp.getDisplayName().getLocaleValue();
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(ResManager.loadKDString((String)"%s\uff1a\u6b64\u5c5e\u6027\u5bf9\u5e94\u7684\u8d77\u59cb\u6216\u7ed3\u675f\u65f6\u95f4\u4e0d\u5b58\u5728", (String)"ApiTimePropConverter_0", (String)BOS_FORM_CORE, (Object[])new Object[0]), displayName));
            return false;
        }
        return true;
    }

    private boolean validateTimeRangeForTimeUp(TimeProp timeProp, RowMapper rowMapper) {
        String startDisplayName = timeProp.getDisplayName() == null ? timeProp.getName() : timeProp.getDisplayName().getLocaleValue();
        String relateTimeRange = timeProp.getRelateTimeRange();
        Object startTimeObj = null;
        Object endTimeObj = null;
        String endDisplayName = null;
        try {
            if (timeProp.isStartTimeRange() && StringUtils.isNotBlank((CharSequence)relateTimeRange)) {
                startTimeObj = rowMapper.getSourceObj().get(timeProp.getName());
                endTimeObj = rowMapper.getSourceObj().get(relateTimeRange);
                IDataEntityProperty endTimeProp = (IDataEntityProperty)rowMapper.getTargetObj().getDataEntityType().getProperties().get((Object)relateTimeRange);
                int startTime = TimeProp.timeToSecond((Object)startTimeObj, (String)timeProp.getDisplayName().getLocaleValue());
                endDisplayName = endTimeProp.getDisplayName() == null ? timeProp.getName() : endTimeProp.getDisplayName().getLocaleValue();
                int endTime = TimeProp.timeToSecond((Object)endTimeObj, (String)endTimeProp.getDisplayName().getLocaleValue());
                if (startTime != -1 && endTime != -1 && startTime > endTime) {
                    this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(ResManager.loadKDString((String)"%s\uff1a\u8d77\u59cb\u65f6\u95f4\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4", (String)"ApiTimePropConverter_1", (String)BOS_FORM_CORE, (Object[])new Object[0]), startDisplayName));
                    return false;
                }
            }
        }
        catch (KDBizException e) {
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), e.getMessage());
            return false;
        }
        catch (NumberFormatException e) {
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"ApiTimePropConverter_3", (String)"bos-import", (Object[])new Object[0]), endDisplayName == null ? startDisplayName : endDisplayName, endDisplayName == null ? startTimeObj : endTimeObj));
            return false;
        }
        return true;
    }
}

