/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.listop;

import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.svc.util.OpExistChecker;

public class ImportDetails
extends DefaultDynamicFormOperate {
    public boolean needSelectData() {
        return false;
    }

    public OperationResult invokeOperation() {
        Boolean opExist = OpExistChecker.check((String)this.getEntityId(), (String)this.getType(), (IFormView)this.getView());
        if (!opExist.booleanValue()) {
            return null;
        }
        String mainEntityDisplayName = this.getView().getFormShowParameter().getCaption();
        if (StringUtils.isBlank((CharSequence)mainEntityDisplayName)) {
            mainEntityDisplayName = this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
        }
        String filterEntityName = this.getFilterEntityName();
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u5bfc\u5165\u7ed3\u679c", (String)"ImportDetails_1", (String)"bos-import", (Object[])new Object[0]), mainEntityDisplayName));
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("bos_importlog");
        showParameter.setListFilterParameter(this.buildListFilterParameter(filterEntityName));
        showParameter.setCustomParam("MainEntityDisplayName", (Object)mainEntityDisplayName);
        showParameter.setCustomParam("MainEntityId", (Object)this.getMainEntityId());
        this.injectParentShowParameter(showParameter);
        IFormView view = this.getView();
        IFormView mainView = view.getMainView();
        if (mainView == null || mainView.getPageId().equals(view.getPageId())) {
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            view.showForm((FormShowParameter)showParameter);
        } else {
            String importLogPageId = "bos_importlog" + this.getView().getPageId() + this.getView().getMainView().getPageId();
            showParameter.setPageId(importLogPageId);
            IFormView importLogFormView = this.getView().getViewNoPlugin(importLogPageId);
            if (importLogFormView != null) {
                importLogFormView.activate();
                this.getView().sendFormAction(importLogFormView);
            } else {
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
        return null;
    }

    private void injectParentShowParameter(ListShowParameter showParameter) {
        showParameter.setCustomParam("ParentEntityId", (Object)this.getEntityId());
    }

    private String getFilterEntityName() {
        String listName = null;
        IFormView view = this.getView();
        if (view instanceof IListView) {
            IListView listview = (IListView)view;
            FormConfig config = FormMetadataCache.getFormConfig((String)listview.getBillFormId());
            listName = config.getCaption().toString();
        } else if (view instanceof IBillView) {
            FormShowParameter formShowParameter = view.getFormShowParameter();
            String caption = formShowParameter.getCaption();
            listName = StringUtils.isNotBlank((CharSequence)caption) ? caption : (formShowParameter.getFormConfig() != null ? formShowParameter.getFormConfig().getCaption().toString() : "");
        }
        return listName;
    }

    private String getMainEntityId() {
        String mainEntityId = null;
        IFormView view = this.getView();
        if (view instanceof IListView) {
            IListView listview = (IListView)view;
            mainEntityId = listview.getBillFormId();
        } else if (view instanceof IBillView) {
            FormShowParameter formShowParameter = view.getFormShowParameter();
            mainEntityId = formShowParameter.getFormConfig() != null ? formShowParameter.getFormConfig().getEntityTypeId() : "";
        }
        return mainEntityId;
    }

    private ListFilterParameter buildListFilterParameter(String mainEntityDisplayName) {
        String userIdStr = RequestContext.get().getUserId();
        Long userId = Long.parseLong(userIdStr);
        QFilter f1 = new QFilter("name", "=", (Object)mainEntityDisplayName).or("sourceobj", "=", (Object)this.getEntityId()).and("creator", "=", (Object)userId);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setQFilter(f1.toSerializedString());
        return listFilterParameter;
    }
}

