/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.service.attachment.FileSource;
import kd.bos.svc.util.FileServerUtil;

@Deprecated
public class ImportPlugin
extends AbstractFormPlugin
implements UploadListener,
RowClickEventListener {
    private static final String BILLFORMID = "BillFormId";
    private static final String EXTENDDATA = "ExtendData";
    private static final String KEY_FILELIST = "_file_list_";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
        AbstractGrid grid = (AbstractGrid)this.getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        List preInsFiles = (List)this.getView().getFormShowParameter().getCustomParam("PreInsFiles");
        if (preInsFiles != null) {
            IDataModel model = this.getModel();
            int[] rows = model.batchCreateNewEntryRow("entryentity", preInsFiles.size());
            for (int i = 0; i < preInsFiles.size(); ++i) {
                String url = (String)((Map)preInsFiles.get(i)).get("url");
                model.setValue("preinsfile", (Object)url, rows[i]);
                model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1), rows[i]);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String preinsfile = (String)this.getModel().getValue("preinsfile", evt.getRow());
        if (StringUtils.isNotBlank((CharSequence)preinsfile)) {
            this.importData(Collections.singletonList(preinsfile));
        }
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID);
                String importPlugin = (String)this.getView().getFormShowParameter().getCustomParam("ImportPlugin");
                if (StringUtils.isBlank((CharSequence)billFormId)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"ImportPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bos_downloadtemplate");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam(BILLFORMID, (Object)billFormId);
                showParameter.setCustomParam("ImportPlugin", (Object)importPlugin);
                showParameter.setCustomParam(EXTENDDATA, showParameter.getCustomParam(EXTENDDATA));
                this.getView().showForm(showParameter);
                break;
            }
        }
    }

    private void importData() {
        String cacheUrls = this.getPageCache().get(KEY_FILELIST);
        if (StringUtils.isBlank((CharSequence)cacheUrls)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6\u6216\u8005\u7b49\u5f85\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\uff01", (String)"ImportPlugin_1", (String)"bos-form-business", (Object[])new Object[0]));
            return;
        }
        List filelist = (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        ArrayList<String> urls = new ArrayList<String>(4);
        FileService service = FileServiceFactory.getAttachmentFileService();
        TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String path = "/public/attachment/" + CacheKeyUtil.getAcctId() + "/import/" + UUID.randomUUID() + "/";
        for (Map file : filelist) {
            String url = (String)file.get("url");
            String fileName = (String)file.get("name");
            url = service.upload((FileItem)FileServerUtil.createFileItem((String)fileName, (String)(path + fileName), (InputStream)tempFile.getInputStream(url), (FileSource)FileSource.EXCEL_IMPORT));
            urls.add(url);
        }
        this.importData(urls);
    }

    private void importData(List<String> filelist) {
        IFormView parent = this.getView().getParentView();
        FormShowParameter showParam = this.getView().getFormShowParameter();
        List plugins = (List)showParam.getCustomParam("plugins");
        ArrayList<String> pluginClasses = new ArrayList<String>(8);
        if (plugins != null) {
            for (Map p : plugins) {
                if (!Boolean.TRUE.equals(p.get("Enabled"))) continue;
                pluginClasses.add((String)p.get("ClassName"));
            }
        }
        AbstractListView.importData((IFormView)parent, filelist, (String)((String)this.getModel().getValue("importtype")), pluginClasses, (String)((String)showParam.getCustomParam(BILLFORMID)), (String)((String)showParam.getCustomParam(EXTENDDATA)));
        this.getView().sendFormAction(parent);
        this.getView().close();
    }

    public void remove(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get(KEY_FILELIST);
        List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList(4) : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        for (Object url : evt.getUrls()) {
            filelist.removeIf(f -> f.get("uid").equals(((Map)url).get("uid")));
        }
        this.getPageCache().put(KEY_FILELIST, SerializationUtils.serializeToBase64(filelist));
    }

    public void upload(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get(KEY_FILELIST);
        List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList(4) : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        for (Object url : evt.getUrls()) {
            filelist.add((Map)url);
        }
        this.getPageCache().put(KEY_FILELIST, SerializationUtils.serializeToBase64(filelist));
    }
}

