/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.concurrent.Callable;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.impt.ImportConfig;
import kd.bos.form.plugin.impt.ImportDataTask;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

@Deprecated
public class ImportProgressBatchPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log log = LogFactory.getLog(ImportProgressBatchPlugin.class);
    public static final int THREAD_COUNT = 10;
    protected static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ImportThreadPool", (int)10);
    private static final String RUNNINGURL = "runningurl";
    private static final String WAITINGENTRY = "waitingentry";
    private static final String PROGRESS = "progress";
    private static final String FAILED = "failed";
    private static final String BOS_IMPORT = "bos-import";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        view.setVisible(Boolean.FALSE, new String[]{"operatepanel", "completeflex"});
        ArrayList urls = new ArrayList((Collection)view.getFormShowParameter().getCustomParam("Urls"));
        if (urls.size() <= 1) {
            return;
        }
        String url = (String)urls.remove(0);
        ((Label)this.getControl("runningname")).setText(url.substring(url.lastIndexOf(47) + 1));
        model.setValue(RUNNINGURL, (Object)url);
        model.batchCreateNewEntryRow(WAITINGENTRY, urls.size());
        for (int i = 0; i < urls.size(); ++i) {
            url = (String)urls.get(i);
            model.setValue("waitingname", (Object)url.substring(url.lastIndexOf(47) + 1), i);
            model.setValue("waitingurl", (Object)url, i);
        }
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("BillFormId");
        String billFormName = (String)this.getView().getFormShowParameter().getCustomParam("BillFormName");
        Object logId = this.createImportlog(billFormId, billFormName);
        ImportConfig conf = new ImportConfig(view, logId);
        RequestContext rc = RequestContext.get();
        threadPool.submit((Callable)new ImportDataTask(rc, conf, "resolveExcel"));
        threadPool.submit((Callable)new ImportDataTask(rc, conf, "importData"));
        this.getPageCache().put(PROGRESS, "0");
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        progress.start();
    }

    public void onProgress(ProgressEvent evt) {
        int progress = Integer.parseInt(this.getPageCache().get(PROGRESS));
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("BillFormId");
        JSONObject info = (JSONObject)AppCache.get((String)"bos").get(ImportDataTask.getCacheKey(billFormId, this.getView().getPageId()), JSONObject.class);
        if (info != null) {
            IDataModel model = this.getModel();
            String runningurl = (String)model.getValue(RUNNINGURL);
            JSONObject runninginfo = info.getJSONObject(runningurl);
            if (runninginfo != null) {
                if (runninginfo.getIntValue("lastRowIndex") > 0) {
                    int i = model.createNewEntryRow("completeentry");
                    model.setValue("completename", (Object)runningurl.substring(runningurl.lastIndexOf(47) + 1), i);
                    model.setValue("succeed", (Object)(runninginfo.getIntValue("total") - runninginfo.getIntValue(FAILED)), i);
                    model.setValue(FAILED, (Object)runninginfo.getIntValue(FAILED), i);
                    this.getView().setVisible(Boolean.TRUE, new String[]{"completeflex"});
                    int waitings = model.getEntryRowCount(WAITINGENTRY);
                    if (waitings > 0) {
                        String nextUrl = (String)model.getValue("waitingurl", 0);
                        ((Label)this.getControl("runningname")).setText(nextUrl.substring(nextUrl.lastIndexOf(47) + 1));
                        model.setValue(RUNNINGURL, (Object)nextUrl);
                        progress = 2;
                        this.getPageCache().put(PROGRESS, "2");
                        model.deleteEntryRow(WAITINGENTRY, 0);
                    } else {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"runningflex", "waitingflex"});
                        model.setValue(RUNNINGURL, (Object)"");
                        this.getView().setVisible(Boolean.TRUE, new String[]{"operatepanel"});
                        progress = 100;
                    }
                    if (waitings <= 0) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"waitingflex"});
                    }
                } else {
                    progress = progress < 90 ? progress + 1 : progress;
                }
            }
        } else {
            int n = progress = progress < 90 ? progress + 1 : progress;
        }
        if (progress <= 90) {
            this.getPageCache().put(PROGRESS, "" + progress);
        }
        evt.setProgress(progress);
    }

    public void click(EventObject evt) {
        if ("btnok".equals(((Control)evt.getSource()).getKey())) {
            String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskid");
            DynamicObject taskData = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"bos_importtask", (String)"data");
            String jsonData = taskData.getString("data");
            if (StringUtils.isBlank((CharSequence)jsonData)) {
                return;
            }
            JSONObject data = JSON.parseObject((String)jsonData);
            try {
                JSONObject info = data.getJSONObject("info");
                for (Object obj : info.values()) {
                    ImportLogger logger = (ImportLogger)JSONObject.parseObject((String)((JSONObject)obj).toJSONString(), ImportLogger.class);
                    IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    if (StringUtils.isNotBlank((CharSequence)logger.getErrFile())) {
                        proxy.addAction("download", (Object)(logger.getErrFile() + "&a=t"));
                        continue;
                    }
                    if (logger.getFailed() > 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"ImportProgressBatchPlugin_0", (String)BOS_IMPORT, (Object[])new Object[0]));
                        continue;
                    }
                    String msg = logger.toString().trim();
                    if (msg.isEmpty()) continue;
                    this.getView().showErrorNotification(msg);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.getView().showMessage(ResManager.loadKDString((String)"\u4ece\u65e5\u5fd7\u4e2d\u63d0\u53d6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff0c\u53ef\u80fd\u65e5\u5fd7\u683c\u5f0f\u5316\u592a\u65e7\uff0c\u8bf7\u5c1d\u8bd5\u4ece\u65e5\u5fd7\u4e2d\u624b\u52a8\u63d0\u53d6\u5230\u5730\u5740\u680f\u4e0b\u8f7d\u3002", (String)"ImportProgressBatchPlugin_1", (String)BOS_IMPORT, (Object[])new Object[0]));
            }
        }
    }

    private Object createImportlog(String billFormId, String name) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_importlog");
        DynamicObject dyn = (DynamicObject)objType.createInstance();
        dyn.set("name", (Object)name);
        dyn.set("billstatus", (Object)"C");
        dyn.set("importstatus", (Object)"0");
        dyn.set("createtime", (Object)new TimeService().now());
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String billno = coderule.getNumber("bos_importlog", dyn, null);
        this.getPageCache().put(ImportDataTask.getCacheKey(billFormId, this.getView().getPageId()), billno);
        dyn.set("billno", (Object)billno);
        dyn = (DynamicObject)BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn})[0];
        return dyn.getPkValue();
    }
}

