/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry.insertentryrows;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ORMUtil;
import kd.bos.entity.datamodel.events.BeforeImportEntryEventArgs;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.operate.imptapi.EntyRowMatchStyle;
import kd.bos.form.operate.imptapi.OperateDataConverter;
import kd.bos.form.plugin.importentry.insertentryrows.ImportEntryFailedSheetHandler;
import kd.bos.form.plugin.importentry.insertentryrows.ReferenceInteger;
import kd.bos.form.plugin.importentry.resolving.ImportEntryContext;
import kd.bos.form.plugin.importentry.resolving.ImportEntryData;
import kd.bos.form.plugin.importentry.resolving.ImportEntryEntityMapping;
import kd.bos.form.plugin.importentry.strategy.ImportEntryThread;
import kd.bos.form.plugin.impt.ImportHelper;
import kd.bos.impt.ExcelReader;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.extend.importdata.FileImportExtensionFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.svc.util.FileHandlerUtil;
import kd.bos.svc.util.PermissionParam;
import kd.bos.utils.ImportCreateViewUtil;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.utils.Lists;

public class ImportEntryInsertRows
extends ImportEntryThread {
    private static final Log log = LogFactory.getLog(ImportEntryInsertRows.class);
    public static final String FORM_ID = "bos_importlog";
    public static final String IS_DELETED = "isdeleted";
    private final ImportEntryContext ctx;
    public static final int DEFAULT_BATCH_IMPORT_SIZE = 10000;
    private final LinkedBlockingQueue<ImportEntryData> dataQueue;
    private final IFormView topView;
    private final Map<String, List<int[]>> entryRowStartAndEnd = new HashMap<String, List<int[]>>();
    private final Map<String, Map<Integer, List<String>>> entryLoggerMaps = new HashMap<String, Map<Integer, List<String>>>();
    private final Map<String, Object> cachedAdminDivision = new LinkedHashMap<String, Object>(100, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Object> pEldest) {
            return this.size() > 1000;
        }

        @Override
        public boolean containsKey(Object key) {
            this.get(key);
            return super.containsKey(key);
        }
    };
    private static final String ROWNUM = "rowNum";
    private DynamicObject blankDataEntity;
    private boolean isValid = true;
    private static final Set<String> TRUE = new HashSet<String>(Arrays.asList(ResManager.loadKDString((String)"\u662f", (String)"ImportHelper_0", (String)"bos-import", (Object[])new Object[0]), ResManager.loadKDString((String)"\u771f", (String)"ImportHelper_1", (String)"bos-import", (Object[])new Object[0]), ResManager.loadKDString((String)"\u52fe\u9009", (String)"ImportHelper_2", (String)"bos-import", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9", (String)"ImportHelper_3", (String)"bos-import", (Object[])new Object[0]), "true", "yes", "ok"));

    public ImportEntryInsertRows(ImportEntryContext ctx) {
        super("insertEntryRows");
        this.ctx = ctx;
        this.dataQueue = ctx.getDataQueue();
        String topPageId = ctx.getTopPageId();
        this.topView = ctx.getView().getView(topPageId);
    }

    @Override
    public Object call() {
        try {
            if (!"insertEntryRows".equals(this.getType())) {
                Object var1_1 = null;
                return var1_1;
            }
            if (this.ctx.getRequestContext() != null) {
                RequestContext.copyAndSet((RequestContext)this.ctx.getRequestContext());
            }
            this.insertRows();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (PermissionParam.isClearImpExpFiles()) {
                FileHandlerUtil.tryDelFile((String)this.ctx.getFileUrl());
                DynamicObject logObj = BusinessDataServiceHelper.loadSingle((Object)this.ctx.getImportEntryLogPk(), (String)FORM_ID);
                logObj.set(IS_DELETED, (Object)"2");
                OperateOption option = OperateOption.create();
                option.setVariableValue("updateModifyDate", "false");
                SaveServiceHelper.update((DynamicObject)logObj, (OperateOption)option);
            }
        }
        return null;
    }

    private void insertRows() {
        try {
            ArrayList importEntryDataList = Lists.newArrayList();
            IDataModel dataModelReal = this.topView.getModel();
            DynamicObject dataEntityReal = dataModelReal.getDataEntity(true);
            while (!this.dataQueue.isEmpty() || Boolean.FALSE.equals(this.ctx.getCompleted()) || !importEntryDataList.isEmpty()) {
                ImportEntryData entryData = null;
                entryData = this.dataQueue.poll(3L, TimeUnit.SECONDS);
                if (entryData != null && !entryData.isEmpty()) {
                    importEntryDataList.add(entryData);
                }
                this.dataQueue.drainTo(importEntryDataList, 10000);
                if (importEntryDataList.size() < 10000 && !Boolean.TRUE.equals(this.ctx.getCompleted())) continue;
                IFormView view = this.getView();
                view.getModel().putContextVariable("IGNORE_RELOADDATAMODEL", (Object)Boolean.TRUE);
                view.getModel().putContextVariable("IS_IMPORTENTRY", (Object)Boolean.TRUE);
                view.getModel().beginInit();
                view.getModel().putContextVariable("MODEL_INIT_BY_WEBAPI", (Object)true);
                view.getModel().putContextVariable("fireAfterCreateNewData", (Object)false);
                view.getModel().createNewData((Object)ImportCreateViewUtil.getBlankDataEntity(view.getModel(), this.blankDataEntity, true));
                IDataModel dataModel = view.getModel();
                this.insertWithEntryName(importEntryDataList.stream().collect(Collectors.groupingBy(ImportEntryData::getEntryName)), dataModel, dataEntityReal, dataModelReal);
                view.getModel().endInit();
                importEntryDataList.clear();
            }
            boolean isCn = RequestContext.get().getLang() == Lang.zh_CN || RequestContext.get().getLang() == Lang.zh_TW;
            this.entryLoggerMaps.forEach((entryName, errMap) -> {
                for (Map.Entry errMapEntry : errMap.entrySet()) {
                    String point;
                    List<String> tips = this.rebuildErrorLogWithoutSymbol((List)errMapEntry.getValue());
                    String msg = StringUtils.join((Object[])tips.toArray(), (String)(isCn ? "\uff1b" : ";"));
                    String string = point = isCn ? "\u3002" : ".";
                    if (StringUtils.isNotBlank((CharSequence)msg) && !msg.endsWith(point)) {
                        msg = msg + point;
                    }
                    this.ctx.getImportLoggerMap().get(entryName).log((Integer)errMapEntry.getKey(), msg);
                }
            });
            boolean isHasErrorMsg = false;
            for (Map.Entry<String, ImportLogger> importLog : this.ctx.getImportLoggerMap().entrySet()) {
                Map logCache = importLog.getValue().getLogCache();
                if (logCache.isEmpty()) continue;
                isHasErrorMsg = true;
                break;
            }
            if (isHasErrorMsg) {
                this.outputFailedData(this.ctx.getFileUrl(), this.ctx.getImportLoggerMap(), this.ctx.getEntryNameBindSheetNames(), this.ctx.getImportLogger());
            }
            this.ctx.feedbackProgress("", 0, true);
            IPageCache pageCache = this.topView.getPageCache();
            pageCache.put("Cached_Import_Entry_Logger_DATA", JSON.toJSONString((Object)this.ctx.getImportLogger()));
            int total = this.ctx.getImportLoggerMap().values().stream().map(ImportLogger::getTotal).collect(Collectors.toList()).stream().reduce(0, (a, b) -> a + b);
            int failed = this.ctx.getImportLoggerMap().values().stream().map(ImportLogger::getFailed).collect(Collectors.toList()).stream().reduce(0, (a, b) -> a + b);
            this.ctx.getImportLogger().setTotal(total);
            this.ctx.getImportLogger().setFailed(failed);
            HashMap<String, Object> retData = new HashMap<String, Object>();
            retData.put("complete", Boolean.TRUE);
            retData.put("info", this.ctx.getImportLoggerMap());
            for (ImportLogger value : this.ctx.getImportLoggerMap().values()) {
                value.setSrcFile(this.ctx.getFileUrl());
                value.setErrFile(this.ctx.getImportLogger().getErrFile());
            }
            ImportLogHelper.logAll((Object)this.ctx.getImportEntryLogPk(), (String)JSON.toJSONString(retData), (int)total, (int)failed);
            this.topView.getModel().clearNoDataRow();
            this.getView().sendFormAction(this.topView);
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            String importErrMsg = e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ImportProgressPlugin_2", (String)"bos-import", (Object[])new Object[0]);
            this.ctx.getImportLogger().log(Integer.valueOf(0), importErrMsg);
            this.ctx.feedbackProgress("", 0, true);
        }
    }

    private IFormView getView() {
        FormShowParameter parameter = ImportCreateViewUtil.createShowParameter(this.ctx.getBillFormId());
        IFormView formView = parameter.createViewForWebApi();
        formView.initialize(parameter);
        formView.getModel().putContextVariable("MODEL_INIT_BY_WEBAPI", (Object)Boolean.TRUE);
        return formView;
    }

    private void dealResult(Map.Entry<String, List<ImportEntryData>> entryListEntry, IDataModel dataModel, OperateDataConverter dataConverter) {
        if (entryListEntry.getValue().isEmpty()) {
            return;
        }
        String entryName = entryListEntry.getKey();
        Map<Integer, List<String>> contextErrorInfo = dataConverter.getContextErrorInfo();
        BidiMap<Integer, Integer> entryRowMappingExcelRows = dataConverter.getEntryRowMappingExcelRows();
        HashSet errEntrys = new HashSet();
        for (Integer integer : contextErrorInfo.keySet()) {
            Set collect = this.entryRowStartAndEnd.get(entryName).stream().filter(arr -> arr[0] <= integer && integer <= arr[1]).collect(Collectors.toSet());
            errEntrys.addAll(collect);
        }
        this.entryRowStartAndEnd.get(entryName).removeAll(errEntrys);
        List<int[]> rightEntrys = this.entryRowStartAndEnd.get(entryName);
        this.ctx.getImportLoggerMap().get(entryName).setDelRows(rightEntrys);
        int endIndex = entryListEntry.getValue().get(entryListEntry.getValue().size() - 1).getEndIndex();
        Set<Integer> needDelEntryRowsSet = errEntrys.stream().map(errRowStartAndEndArr -> errRowStartAndEndArr[0]).collect(Collectors.toSet()).stream().filter(arg_0 -> entryRowMappingExcelRows.containsValue(arg_0)).map(arg_0 -> entryRowMappingExcelRows.getKey(arg_0)).collect(Collectors.toSet());
        Integer[] errRows = new Integer[needDelEntryRowsSet.size()];
        needDelEntryRowsSet.toArray(errRows);
        int[] needDelEntryRows = Arrays.stream(errRows).mapToInt(Integer::intValue).toArray();
        dataModel.deleteEntryRows(entryName, needDelEntryRows);
        this.ctx.getImportLoggerMap().get(entryName).setFailed(this.ctx.getImportLoggerMap().get(entryName).getFailed() + contextErrorInfo.size());
        this.ctx.feedbackProgress(entryName, endIndex, false);
    }

    private void insertWithEntryName(Map<String, List<ImportEntryData>> importEntryDataWithEntry, IDataModel dataModel, DynamicObject dataEntityReal, IDataModel dataModelReal) {
        IFormView view = this.ctx.getView().getView(this.ctx.getTopPageId());
        ModelEventProxy eventProxy = (ModelEventProxy)view.getModel().getService(ModelEventProxy.class);
        HashMap<String, List<ImportLogger>> entryDataMap = new HashMap<String, List<ImportLogger>>();
        Map<String, ImportLogger> importLoggerMap = this.ctx.getImportLoggerMap();
        for (Map.Entry<String, ImportLogger> entryImportEntryDatas : importLoggerMap.entrySet()) {
            entryDataMap.putIfAbsent(entryImportEntryDatas.getKey(), Collections.singletonList(entryImportEntryDatas.getValue()));
        }
        eventProxy.fireBeforeImportEntry(new BeforeImportEntryEventArgs(importEntryDataWithEntry, entryDataMap));
        ArrayList<int[]> startEndArr = new ArrayList<int[]>();
        for (Map.Entry<String, List<ImportEntryData>> entryImportEntryDatas : importEntryDataWithEntry.entrySet()) {
            this.ctx.getImportLoggerMap().get(entryImportEntryDatas.getKey()).setTotal(this.ctx.getImportLoggerMap().get(entryImportEntryDatas.getKey()).getTotal() + entryImportEntryDatas.getValue().size());
            this.checkValues(entryImportEntryDatas);
            JSONObject parseJSON = this.parseEntryJson(entryImportEntryDatas.getKey(), entryImportEntryDatas.getValue());
            DataEntityPropertyCollection properties = dataEntityReal.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                if (!(property instanceof ISimpleProperty) && !(property instanceof IComplexProperty)) continue;
                dataModel.getDataEntity().set(property, dataEntityReal.get(property));
            }
            OperateDataConverter operateDataConverter = this.batchImportEntryData(entryImportEntryDatas.getKey(), parseJSON, dataModel, dataEntityReal);
            Map entryErrorMap = this.entryLoggerMaps.computeIfAbsent(entryImportEntryDatas.getKey(), s -> new HashMap(16));
            entryErrorMap.putAll(operateDataConverter.getContextErrorInfo());
            for (ImportEntryData entryData : entryImportEntryDatas.getValue()) {
                startEndArr.add(new int[]{entryData.getStartIndex(), entryData.getEndIndex()});
            }
            this.entryRowStartAndEnd.computeIfAbsent(entryImportEntryDatas.getKey(), s -> new ArrayList()).addAll(startEndArr);
            this.dealResult(entryImportEntryDatas, dataModel, operateDataConverter);
            startEndArr.clear();
            EntryGrid entryGrid = (EntryGrid)this.topView.getControl(entryImportEntryDatas.getKey());
            if (entryGrid != null) {
                entryGrid.setStopUpdateCell(true);
            }
            this.addDataToModel(entryImportEntryDatas.getKey(), dataEntityReal, dataModel);
            dataModelReal.updateEntryCache(dataModelReal.getEntryEntity(entryImportEntryDatas.getKey()));
        }
        dataModel.removeContextVariable("IGNORE_RELOADDATAMODEL");
        dataModel.removeContextVariable("IS_IMPORTENTRY");
        importEntryDataWithEntry.clear();
    }

    private void addDataToModel(String entryKey, DynamicObject dataEntityReal, IDataModel dataModel) {
        DynamicObjectCollection entityRealEntry = dataEntityReal.getDynamicObjectCollection(entryKey);
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity(entryKey);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        ArrayList<DynamicObject> insertRows = new ArrayList<DynamicObject>();
        for (DynamicObject entryRow : entryEntity) {
            if (entityRealEntry.contains((Object)entryRow)) continue;
            insertRows.add(entryRow);
        }
        entityRealEntry.addAll(insertRows);
    }

    private Set<String> getSubEntry(List<ImportEntryData> value) {
        HashSet<String> subEntries = new HashSet<String>();
        if (CollectionUtils.isEmpty(value)) {
            return subEntries;
        }
        ImportEntryData importEntryData = value.get(0);
        Map<String, ImportEntryEntityMapping> entryEntityMappingMap = importEntryData.getEntryEntityMapping().getSubEntries();
        if (MapUtils.isEmpty(entryEntityMappingMap)) {
            subEntries.addAll(entryEntityMappingMap.keySet());
        }
        return subEntries;
    }

    private void outputFailedData(String url, Map<String, ImportLogger> importLoggerMap, BidiMap<String, String> entryNameBindSheetNames, ImportLogger importLogger) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        try (InputStream in = FileImportExtensionFactory.getFileImportExtension().decode(url, fileService.getInputStream(url));){
            new ExcelReader().read(in, new ImportEntryFailedSheetHandler(this.ctx, importLoggerMap, entryNameBindSheetNames, service));
        }
        catch (Throwable e) {
            log.error(e);
            if (SystemParamServiceHelper.isShowStackTrace()) {
                importLogger.log(Integer.valueOf(0), e);
            }
            importLogger.log(Integer.valueOf(0), e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u9519\u8bef\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"BatchImportPlugin_4", (String)"bos-import", (Object[])new Object[0]));
        }
    }

    private List<String> rebuildErrorLogWithoutSymbol(List<String> tips) {
        tips = Optional.ofNullable(tips).orElseGet(this::getEmptyList).stream().map(x -> {
            if (StringUtils.isBlank((CharSequence)x)) {
                return x;
            }
            char lastChar = x.charAt(x.length() - 1);
            if (this.isChinesePunctuation(lastChar)) {
                x = x.substring(0, x.length() - 1);
            }
            return x;
        }).collect(Collectors.toList());
        return tips;
    }

    private List<String> getEmptyList() {
        return new ArrayList<String>(0);
    }

    public boolean isChinesePunctuation(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || ub == Character.UnicodeBlock.VERTICAL_FORMS;
    }

    private JSONObject parseEntryJson(String entryName, List<ImportEntryData> importEntryDataList) {
        JSONObject parseJSON = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        importEntryDataList.forEach(importEntryData -> jsonArray.add((Object)importEntryData.getData()));
        parseJSON.put(entryName, (Object)jsonArray);
        return parseJSON;
    }

    private OperateDataConverter batchImportEntryData(String entryName, JSONObject jsonObject, IDataModel dataModel, DynamicObject curEntityData) {
        OperateDataConverter convert = this.getDataConverter(dataModel, entryName);
        DynamicObjectCollection curEntryData = curEntityData.getDynamicObjectCollection(entryName);
        convert.setCurrentEntryList(curEntryData);
        convert.setImportEntryType(this.ctx.getImportType());
        convert.setCheckImportable(true);
        convert.setDataConvertOrder(Lists.newArrayList());
        convert.setModify(true);
        convert.setEntyRowMatchStyle(EntyRowMatchStyle.OnlyEntry);
        convert.filterBasedatas((Map<String, Object>)jsonObject, dataModel.getDataEntity(), 0);
        convert.cacheBasedataPKIds();
        convert.convertComplexProperty((Map<String, Object>)jsonObject, dataModel.getDataEntity(), 0);
        return convert;
    }

    private OperateDataConverter getDataConverter(IDataModel model, String entryName) {
        return new OperateDataConverter(model, null, null, null);
    }

    private void checkValues(Map.Entry<String, List<ImportEntryData>> entryImportEntryDatas) {
        SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
        boolean importPreInvalid = Boolean.TRUE.equals(systemParamService.loadPublicParameterFromCache("importpreinvalid"));
        List<ImportEntryData> importEntryDatas = entryImportEntryDatas.getValue();
        ImportLogger importLogger = this.ctx.getImportLoggerMap().get(entryImportEntryDatas.getKey());
        for (int i = 0; i < importEntryDatas.size(); ++i) {
            ImportEntryData importEntryData = importEntryDatas.get(i);
            this.isValid = true;
            this.checkValue(importEntryData.getEntryEntityMapping(), importEntryData.getData(), importLogger, this.cachedAdminDivision, new ReferenceInteger(importEntryData.getStartIndex()), importPreInvalid);
            if (this.isValid || !importPreInvalid) continue;
            importLogger.setFailed(importLogger.getFailed() + 1);
            importEntryDatas.remove(i);
            --i;
        }
    }

    private void checkValue(ImportEntryEntityMapping mapping, JSONObject data, ImportLogger importLogger, Map<String, Object> cachedAdminDivision, ReferenceInteger index, boolean importPreInvalid) {
        StringBuilder mustInputLogNames = new StringBuilder();
        Object val = null;
        for (Map.Entry<String, ImportEntryEntityMapping.ColInfo> entry : mapping.getCols().entrySet()) {
            String fieldKey = entry.getKey();
            ImportEntryEntityMapping.ColInfo colInfo = entry.getValue();
            String displayName = colInfo.getDisplayName();
            boolean isMustInput = colInfo.isMustInput();
            IDataEntityProperty prop = colInfo.getProperty();
            val = data.get((Object)fieldKey);
            if (val == null) {
                if (!importPreInvalid) continue;
                this.checkMustInput(isMustInput, mustInputLogNames, displayName);
                continue;
            }
            if (prop instanceof AdminDivisionProp) {
                if (!importPreInvalid) continue;
                this.checkAdminDivisionProp(displayName, data, importLogger, cachedAdminDivision, index, fieldKey, val);
                continue;
            }
            if (prop instanceof ComboProp) {
                this.checkComboProp(data, importLogger, index, fieldKey, prop, val, importPreInvalid);
                continue;
            }
            if (prop instanceof BooleanProp) {
                data.put(fieldKey, (Object)TRUE.contains(((String)val).toLowerCase()));
                continue;
            }
            if (!(prop instanceof FlexProp)) continue;
            this.checkFlexProp(importLogger, index, colInfo, val);
        }
        this.doMustInputLog(importLogger, index, mustInputLogNames);
        for (Map.Entry<String, Object> entry : mapping.getSubEntries().entrySet()) {
            JSONArray rows = data.getJSONArray(entry.getKey());
            if (rows == null || rows.isEmpty()) continue;
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                JSONObject dataObj = rows.getJSONObject(i);
                Integer rowNum = dataObj.getInteger(ROWNUM);
                this.checkValue((ImportEntryEntityMapping)entry.getValue(), dataObj, importLogger, cachedAdminDivision, new ReferenceInteger(rowNum), importPreInvalid);
            }
        }
    }

    private void checkMustInput(boolean isMustInput, StringBuilder mustInputLogNames, String displayName) {
        if (isMustInput) {
            mustInputLogNames.append(displayName).append(",");
        }
    }

    private void doMustInputLog(ImportLogger importLogger, ReferenceInteger index, StringBuilder mustInputLogNames) {
        if (mustInputLogNames.length() != 0) {
            mustInputLogNames = mustInputLogNames.deleteCharAt(mustInputLogNames.length() - 1);
            importLogger.log(index.getValue(), String.format(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a%s\u3002", (String)"ImportHelper_16", (String)"bos-import", (Object[])new Object[0]), mustInputLogNames));
            this.isValid = false;
        }
    }

    private void checkFlexProp(ImportLogger importLogger, ReferenceInteger index, ImportEntryEntityMapping.ColInfo colInfo, Object val) {
        if (!(val instanceof Map)) {
            return;
        }
        Map flexItem = (Map)val;
        for (Map.Entry entry : flexItem.entrySet()) {
            Object flexValueObj = entry.getValue();
            if (!(flexValueObj instanceof Map) || !((Map)flexValueObj).isEmpty()) continue;
            String msg = colInfo.getDisplayName() + ":\"" + (String)entry.getKey() + "\"";
            msg = String.format(ResManager.loadKDString((String)"%s\u7684\u7f16\u7801\u6216\u540d\u79f0\u81f3\u5c11\u586b\u4e00\u9879", (String)"ImportHelper_9", (String)"bos-import", (Object[])new Object[0]), msg);
            importLogger.log(index.getValue(), msg);
            this.isValid = false;
        }
    }

    private void checkComboProp(JSONObject data, ImportLogger importLogger, ReferenceInteger index, String fieldKey, IDataEntityProperty prop, Object val, boolean importPreInvalid) {
        List items = ((ComboProp)prop).getComboItems();
        if (items == null || items.isEmpty()) {
            return;
        }
        Set<String> values = ImportHelper.getComboValues(prop, (String)val, items);
        if (StringUtils.isNotBlank((Object)val) && values.isEmpty()) {
            importLogger.log(index.getValue(), String.format(ResManager.loadKDString((String)"%1$s\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879\uff1a%2$s\u3002", (String)"ImportHelper_8", (String)"bos-import", (Object[])new Object[0]), prop.getDisplayName(), val));
            this.isValid = false;
        }
        if (!StringUtils.isNotBlank((Object)val) || !values.isEmpty() || importPreInvalid) {
            data.put(fieldKey, (Object)String.join((CharSequence)",", values));
        }
    }

    private static void findAndInsertComboValue(List<ValueMapItem> items, List<String> values, String cellValue) {
        Optional<ValueMapItem> optionalValueMapItem = items.stream().filter(item -> StringUtils.equals((CharSequence)cellValue, (CharSequence)item.getName().toString())).findFirst();
        optionalValueMapItem.ifPresent(valueMapItem -> values.add(valueMapItem.getValue()));
    }

    private void checkAdminDivisionProp(String displayName, JSONObject data, ImportLogger importLogger, Map<String, Object> cachedAdminDivision, ReferenceInteger index, String fieldKey, Object val) {
        String fullName = ((String)val).replace('/', '_');
        Object adminId = cachedAdminDivision.get(fullName);
        if (adminId == null) {
            adminId = ORMUtil.getAdminDivisionByName((String)fullName);
            cachedAdminDivision.put(fullName, adminId);
        }
        if (StringUtils.isNotBlank((Object)adminId)) {
            data.put(fieldKey, adminId);
            return;
        }
        importLogger.log(index.getValue(), String.format(ResManager.loadKDString((String)"%1$s\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u7cfb\u7edf\u4e2d\u65e0\u6cd5\u5339\u914d\u5230%2$s\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ImportHelper_13", (String)"bos-import", (Object[])new Object[0]), displayName, val));
        this.isValid = false;
    }
}

