/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.form.plugin.importentry.model.ImportTreeRowTypeEnum;
import kd.bos.form.plugin.importentry.model.ImportTreeRowView;
import kd.bos.form.plugin.importentry.strategy.ImportTreeRowIteratorStategy;
import org.apache.commons.collections4.CollectionUtils;

public class ImportTreeRowInfo {
    private RowInfo rootRowInfo;

    public ImportTreeRowInfo(RowInfo rootRowInfo) {
        this.rootRowInfo = rootRowInfo;
    }

    @Deprecated
    public ImportTreeRowInfo() {
    }

    public void comparatorTreeRowInfo(Map<String, Map<String, Object>> storeDatas) {
        new ImportTreeRowIteratorStategy.CollectStategy().iterateLevel(this.rootRowInfo, rowInfos -> this.comparatorRowInfosFunction(storeDatas, (List<RowInfo>)rowInfos));
    }

    private void comparatorRowInfosFunction(Map<String, Map<String, Object>> storeDatas, List<RowInfo> rowInfos) {
        if (CollectionUtils.isEmpty(rowInfos)) {
            return;
        }
        rowInfos.sort((first, second) -> {
            int firstSeq = this.getRowInfoSeq(storeDatas, (RowInfo)first);
            int secondSeq = this.getRowInfoSeq(storeDatas, (RowInfo)second);
            if (first.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.SUBENTITY || ((RowInfo)second).isPKFieldProp) {
                return 1;
            }
            if (((RowInfo)first).isPKFieldProp || second.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.SUBENTITY) {
                return -1;
            }
            return Integer.compare(firstSeq, secondSeq);
        });
    }

    private int getRowInfoSeq(Map<String, Map<String, Object>> storeDatas, RowInfo rowInfo) {
        int[] originalRow = new int[1];
        rowInfo.functionToConditionTreeRowType(storeDatas, (storeData, rowInfoTmp) -> {
            originalRow[0] = Integer.MAX_VALUE;
            if (storeData != null) {
                originalRow[0] = (Integer)storeData.get("seq");
            }
        });
        return originalRow[0];
    }

    public void pruneAboutHead() {
        new ImportTreeRowIteratorStategy.CollectStategy().iterateLevel(this.rootRowInfo, rowInfos -> rowInfos.removeIf(next -> ((RowInfo)next).treeRowTypeEnum == ImportTreeRowTypeEnum.HEAD || ((RowInfo)next).treeRowTypeEnum == ImportTreeRowTypeEnum.HEAD_PROPERTY));
    }

    public RowInfo getRootRowInfo() {
        return this.rootRowInfo;
    }

    public void setRootRowInfo(RowInfo rootRowInfo) {
        this.rootRowInfo = rootRowInfo;
    }

    public static class RowInfo {
        private String mainEntityNumber;
        private String entryEntityNumber;
        private ImportTreeRowTypeEnum treeRowTypeEnum;
        private String entityNumber;
        private String propertyNumber;
        private boolean isPKFieldProp;
        private boolean isBaseDataProp;
        private String RefPropNumber;
        private List<RowInfo> childTreeRows;

        public RowInfo(String mainEntityNumber, ImportTreeRowTypeEnum treeRowTypeEnum, String entityNumber) {
            this(mainEntityNumber, treeRowTypeEnum, entityNumber, null, false, false);
        }

        public RowInfo(String mainEntityNumber, ImportTreeRowTypeEnum treeRowTypeEnum, String entityNumber, String propertyNumber, boolean isPKFieldProp, boolean isBaseDataProp) {
            this.mainEntityNumber = mainEntityNumber;
            this.treeRowTypeEnum = treeRowTypeEnum;
            this.entityNumber = entityNumber;
            this.propertyNumber = propertyNumber;
            this.isPKFieldProp = isPKFieldProp;
            this.isBaseDataProp = isBaseDataProp;
        }

        public RowInfo() {
        }

        public ImportTreeRowView.RowView convertToView() {
            ImportTreeRowView.RowView rowView = new ImportTreeRowView.RowView();
            rowView.setMainEntityNumber(this.mainEntityNumber);
            rowView.setTreeRowTypeEnum(this.treeRowTypeEnum);
            rowView.setEntityNumber(this.entityNumber);
            rowView.setPropertyNumber(this.propertyNumber);
            rowView.setPKFieldProp(this.isPKFieldProp);
            rowView.setRefPropertyNumber(this.getRefPropNumber());
            rowView.setEntryEntityNumber(this.getEntryEntityNumber());
            rowView.setBaseDataProp(this.isBaseDataProp());
            return rowView;
        }

        public void addChildRowInfo(RowInfo childRowInfo) {
            if (CollectionUtils.isEmpty(this.childTreeRows)) {
                this.childTreeRows = new ArrayList<RowInfo>();
            }
            this.childTreeRows.add(childRowInfo);
        }

        public void functionToConditionTreeRowType(Map<String, Map<String, Object>> storeDatas, BiConsumer<Map<String, Object>, RowInfo> function) {
            if (this.treeRowTypeEnum == ImportTreeRowTypeEnum.MAINENTITY) {
                Map<String, Object> storeData = storeDatas.get(this.mainEntityNumber);
                function.accept(storeData, this);
                return;
            }
            if (this.treeRowTypeEnum == ImportTreeRowTypeEnum.HEAD || this.treeRowTypeEnum == ImportTreeRowTypeEnum.ENTITY || this.treeRowTypeEnum == ImportTreeRowTypeEnum.SUBENTITY) {
                Map<String, Object> storeData = storeDatas.get(this.mainEntityNumber + "." + this.entityNumber);
                function.accept(storeData, this);
                return;
            }
            if (this.treeRowTypeEnum == ImportTreeRowTypeEnum.HEAD_PROPERTY || this.treeRowTypeEnum == ImportTreeRowTypeEnum.ENTITY_PROPERTY || this.treeRowTypeEnum == ImportTreeRowTypeEnum.SUBENTITY_PROPERTY) {
                Map<String, Object> storeData = storeDatas.get(this.mainEntityNumber + "." + this.propertyNumber);
                function.accept(storeData, this);
            }
        }

        public List<RowInfo> getChildTreeRows() {
            return this.childTreeRows;
        }

        public String getMainEntityNumber() {
            return this.mainEntityNumber;
        }

        public ImportTreeRowTypeEnum getTreeRowTypeEnum() {
            return this.treeRowTypeEnum;
        }

        public String getEntityNumber() {
            return this.entityNumber;
        }

        public String getPropertyNumber() {
            return this.propertyNumber;
        }

        public boolean isPKFieldProp() {
            return this.isPKFieldProp;
        }

        public void setMainEntityNumber(String mainEntityNumber) {
            this.mainEntityNumber = mainEntityNumber;
        }

        public void setTreeRowTypeEnum(ImportTreeRowTypeEnum treeRowTypeEnum) {
            this.treeRowTypeEnum = treeRowTypeEnum;
        }

        public void setEntityNumber(String entityNumber) {
            this.entityNumber = entityNumber;
        }

        public void setPropertyNumber(String propertyNumber) {
            this.propertyNumber = propertyNumber;
        }

        public void setPKFieldProp(boolean PKFieldProp2) {
            this.isPKFieldProp = PKFieldProp2;
        }

        public void setChildTreeRows(List<RowInfo> childTreeRows) {
            this.childTreeRows = childTreeRows;
        }

        public String getRefPropNumber() {
            return this.RefPropNumber;
        }

        public void setRefPropNumber(String refPropNumber) {
            this.RefPropNumber = refPropNumber;
        }

        public String getEntryEntityNumber() {
            return this.entryEntityNumber;
        }

        public void setEntryEntityNumber(String entryEntityNumber) {
            this.entryEntityNumber = entryEntityNumber;
        }

        public boolean isBaseDataProp() {
            return this.isBaseDataProp;
        }

        public void setBaseDataProp(boolean baseDataProp) {
            this.isBaseDataProp = baseDataProp;
        }
    }
}

