/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.plugin.importentry.model.ImportTreeRowTypeEnum;

public class ImportTreeRowView {
    protected static final String FIELD_ID = "id";
    protected static final String FIELD_PID = "pid";
    protected static final String FIELD_ISIMPORT = "isimport";
    protected static final String FIELD_ISNEW = "isnew";
    private final Map<Integer, RowView> treeRowInfosAtRow;

    public ImportTreeRowView(Map<Integer, RowView> treeRowInfosAtRow) {
        this.treeRowInfosAtRow = treeRowInfosAtRow;
    }

    public Map<Integer, RowView> getTreeRowInfosAtRow() {
        return this.treeRowInfosAtRow;
    }

    public static class RowView {
        private int parentRow;
        private int row;
        private String mainEntityNumber;
        private String entryEntityNumber;
        private ImportTreeRowTypeEnum treeRowTypeEnum;
        private String entityNumber;
        private String propertyNumber;
        private boolean isPKFieldProp;
        private boolean isBaseDataProp;
        private String refPropertyNumber;
        private int refRow;
        private List<Integer> ref4Rows = new ArrayList<Integer>();

        public RowView(int parentRow, int row, String mainEntityNumber, ImportTreeRowTypeEnum treeRowTypeEnum, String entityNumber) {
            this.parentRow = parentRow;
            this.row = row;
            this.mainEntityNumber = mainEntityNumber;
            this.treeRowTypeEnum = treeRowTypeEnum;
            this.entityNumber = entityNumber;
        }

        public RowView(int parentRow, int row, String mainEntityNumber, ImportTreeRowTypeEnum treeRowTypeEnum, String entityNumber, String propertyNumber, boolean isPKFieldProp) {
            this(parentRow, row, mainEntityNumber, treeRowTypeEnum, entityNumber);
            this.propertyNumber = propertyNumber;
            this.isPKFieldProp = isPKFieldProp;
        }

        public RowView() {
        }

        public EntityType getEntityType(MainEntityType mainEntityType) {
            if (this.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.HEAD) {
                return mainEntityType;
            }
            Map allEntities = mainEntityType.getAllEntities();
            return (EntityType)allEntities.get(this.getEntityNumber());
        }

        public IDataEntityProperty getProperty(MainEntityType mainEntityType) {
            EntityType entityType = this.getEntityType(mainEntityType);
            String propertyNumberLocal = this.getPropertyNumber();
            if (this.isPKFieldProp && this.getTreeRowTypeEnum() != ImportTreeRowTypeEnum.HEAD_PROPERTY) {
                propertyNumberLocal = propertyNumberLocal.substring(propertyNumberLocal.indexOf(".") + 1);
            }
            return entityType.getProperty(propertyNumberLocal);
        }

        public void functionToConditionTreeRowType(Map<String, Map<String, Object>> storeDatas, BiConsumer<Map<String, Object>, Integer> function) {
            if (this.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.MAINENTITY) {
                Map<String, Object> storeData = storeDatas.get(this.getMainEntityNumber());
                function.accept(storeData, this.getRow());
                return;
            }
            if (this.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.HEAD || this.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.ENTITY || this.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.SUBENTITY) {
                Map<String, Object> parentStoreData;
                Map<String, Object> storeData = storeDatas.get(this.getMainEntityNumber() + "." + this.getEntityNumber());
                Map<String, Object> map = parentStoreData = this.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.SUBENTITY ? storeDatas.get(this.getMainEntityNumber() + "." + this.getEntryEntityNumber()) : storeDatas.get(this.getMainEntityNumber());
                if (null == storeData || parentStoreData.get(ImportTreeRowView.FIELD_ISNEW) != null) {
                    storeData = this.createEntityStore(storeDatas, parentStoreData);
                }
                function.accept(storeData, this.getRow());
                return;
            }
            if (this.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.HEAD_PROPERTY || this.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.ENTITY_PROPERTY || this.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.SUBENTITY_PROPERTY) {
                Map<String, Object> storeData = storeDatas.get(this.getMainEntityNumber() + "." + this.getPropertyNumber());
                Map<String, Object> parentStoreData = storeDatas.get(this.getMainEntityNumber() + "." + this.getEntityNumber());
                if (storeData == null && StringUtils.isNotEmpty((CharSequence)this.getPropertyNumber()) && this.getPropertyNumber().endsWith(".id")) {
                    storeData = storeDatas.get(this.getMainEntityNumber() + "." + this.getPropertyNumber().replace(".id", ".$matchid$"));
                }
                if (null == storeData || parentStoreData.get(ImportTreeRowView.FIELD_ISNEW) != null) {
                    storeData = this.createPropStore(storeDatas, parentStoreData);
                }
                function.accept(storeData, this.getRow());
            }
        }

        private Map<String, Object> createEntityStore(Map<String, Map<String, Object>> storeDatas, Map<String, Object> parentStoreData) {
            HashMap<String, Object> storeData = null;
            if (parentStoreData != null) {
                storeData = new HashMap<String, Object>();
                storeData.put(ImportTreeRowView.FIELD_PID, parentStoreData.get(ImportTreeRowView.FIELD_ID));
                storeData.put(ImportTreeRowView.FIELD_ISIMPORT, false);
                storeData.put(ImportTreeRowView.FIELD_ISNEW, true);
                storeDatas.put(this.getMainEntityNumber() + "." + this.getEntityNumber(), storeData);
            }
            return storeData;
        }

        private Map<String, Object> createPropStore(Map<String, Map<String, Object>> storeDatas, Map<String, Object> parentStoreData) {
            HashMap<String, Object> storeData = null;
            if (parentStoreData != null) {
                storeData = new HashMap<String, Object>();
                storeData.put(ImportTreeRowView.FIELD_PID, parentStoreData.get(ImportTreeRowView.FIELD_ID));
                storeData.put(ImportTreeRowView.FIELD_ISIMPORT, false);
                storeData.put(ImportTreeRowView.FIELD_ISNEW, true);
            }
            return storeData;
        }

        public int getRow() {
            return this.row;
        }

        public ImportTreeRowTypeEnum getTreeRowTypeEnum() {
            return this.treeRowTypeEnum;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public void setTreeRowTypeEnum(ImportTreeRowTypeEnum treeRowTypeEnum) {
            this.treeRowTypeEnum = treeRowTypeEnum;
        }

        public String getEntityNumber() {
            return this.entityNumber;
        }

        public void setEntityNumber(String entityNumber) {
            this.entityNumber = entityNumber;
        }

        public String getPropertyNumber() {
            return this.propertyNumber;
        }

        public void setPropertyNumber(String propertyNumber) {
            this.propertyNumber = propertyNumber;
        }

        public int getParentRow() {
            return this.parentRow;
        }

        public void setParentRow(int parentRow) {
            this.parentRow = parentRow;
        }

        public boolean isPKFieldProp() {
            return this.isPKFieldProp;
        }

        public void setPKFieldProp(boolean PKFieldProp2) {
            this.isPKFieldProp = PKFieldProp2;
        }

        public String getMainEntityNumber() {
            return this.mainEntityNumber;
        }

        public void setMainEntityNumber(String mainEntityNumber) {
            this.mainEntityNumber = mainEntityNumber;
        }

        public String getRefPropertyNumber() {
            return this.refPropertyNumber;
        }

        public void setRefPropertyNumber(String refPropertyNumber) {
            this.refPropertyNumber = refPropertyNumber;
        }

        public int getRefRow() {
            return this.refRow;
        }

        public void setRefRow(int refRow) {
            this.refRow = refRow;
        }

        public List getRef4Rows() {
            return this.ref4Rows;
        }

        public void setRef4Rows(List ref4Rows) {
            this.ref4Rows = ref4Rows;
        }

        public String getEntryEntityNumber() {
            return this.entryEntityNumber;
        }

        public void setEntryEntityNumber(String entryEntityNumber) {
            this.entryEntityNumber = entryEntityNumber;
        }

        public boolean isBaseDataProp() {
            return this.isBaseDataProp;
        }

        public void setBaseDataProp(boolean baseDataProp) {
            this.isBaseDataProp = baseDataProp;
        }
    }
}

