/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.impt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.attachment.FileTypeEnum;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.IImportDataPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.report.ReportCotent;
import kd.bos.entity.report.ReportData;
import kd.bos.entity.report.ReportItems;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.export.util.ImpExpAttachmentUtil;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.field.ComboItem;
import kd.bos.form.impt.monitor.ImportConfigHelper;
import kd.bos.form.operate.imptapi.AttachmentFieldForImportDto;
import kd.bos.form.operate.imptapi.AttachmentPanelForImportDto;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.form.plugin.impt.BatchImportFailedSheetHandler;
import kd.bos.form.plugin.impt.BatchImportSheetHandler;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.form.plugin.impt.ImportHelper;
import kd.bos.impt.ExcelReader;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.service.attachment.extend.importdata.FileImportExtensionFactory;
import kd.bos.service.report.local.QueueProducer;
import kd.bos.servicehelper.AttDto;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.svc.util.SystemParamUtil;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.utils.ImportPluginUtils;
import kd.bos.web.actions.utils.FilePathUtil;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPlugin;
import kd.sdk.plugin.Plugin;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.lucene.util.RamUsageEstimator;

@SdkPlugin(name="\u5bfc\u5165\u6d41\u7a0b\u6269\u5c55\u63d2\u4ef6")
public class BatchImportPlugin
implements Callable<Object>,
IImportDataPlugin,
Plugin {
    private static final String BOS_IMPORT = "bos-import";
    private static final String IMPORTPROP = "importprop";
    private static final String SAVE_NEW = "kd.bos.form.impt.ImportDataSaveNew";
    private static final String SAVE = "kd.bos.form.impt.ImportDataSave";
    private static final Log log = LogFactory.getLog(BatchImportPlugin.class);
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"SVC_BatchImportPlugin", (int)5);
    private final Map<String, Object> cachedAdminDivision = new LinkedHashMap<String, Object>(100, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Object> pEldest) {
            return this.size() > 1000;
        }

        @Override
        public boolean containsKey(Object key) {
            this.get(key);
            return super.containsKey(key);
        }
    };
    private List<String> startArgs;
    private RequestContext rc;
    @SdkInternal
    protected ImportContext ctx;
    @SdkInternal
    protected MainEntityType mainEntityType;
    private AbstractOperateWebApi saveWebApi = null;
    private final HeartBeat heartbeat = new HeartBeat();
    private final Map<String, Set<String>> importRowMapping = new HashMap<String, Set<String>>(this.getBatchImportSize());
    private Set<Object> propKeysMapping;
    private Set<String> refBasePropKeys;

    public String getBillFormId() {
        return this.ctx.getBillFormId();
    }

    private String getSuspendKey() {
        String logId = (String)this.ctx.getLogId();
        return "IMPT_SUSPEND_" + this.getBillFormId() + "_" + logId;
    }

    private String getTaskIdKey() {
        String logId = (String)this.ctx.getLogId();
        return "IMPT_TASKID_" + this.getBillFormId() + "_" + logId;
    }

    private IAppCache getAppCache() {
        return AppCache.get((String)EntityMetadataCache.getDataEntityType((String)this.getBillFormId()).getAppId());
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String billFormId = this.getBillFormId();
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)billFormId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems();
        Set<String> itemSet = ImportPluginUtils.getOverrideFields(entityItems);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        for (IDataEntityProperty p : entityType.getProperties()) {
            if (!itemSet.contains(p.getName())) continue;
            items.add(new ComboItem(p.getDisplayName(), p.getName()));
        }
        if (entityType.getPrimaryKey() != null) {
            items.add(0, new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)"BatchImportPlugin_0", (String)BOS_IMPORT, (Object[])new Object[0])), entityType.getPrimaryKey().getName()));
        }
        return items;
    }

    public String getDefaultKeyFields() {
        return null;
    }

    public String getDefaultImportType() {
        return "new";
    }

    public List<String> getDefaultLockUIs() {
        return new ArrayList<String>(0);
    }

    public Map<String, List<String>> getTemplatePreInsData(Long templateId) {
        return new HashMap<String, List<String>>(0);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ArrayList<JSONObject> bills = new ArrayList<JSONObject>(rowdatas.size());
        for (ImportBillData temp : rowdatas) {
            bills.add(temp.getData());
        }
        Set<String> colIds = this.getColIds(rowdatas);
        if (rowdatas.isEmpty()) {
            return null;
        }
        JSONObject dataPack = new JSONObject();
        dataPack.put("datas", bills);
        dataPack.put("appid", (Object)this.ctx.getCheckRightAppId());
        dataPack.put("option", this.ctx.getOption());
        dataPack.put("formShowParameterAppId", (Object)this.ctx.getFormShowParameterAppId());
        dataPack.put("colIds", colIds);
        dataPack.put("importMonitor", (Object)this.ctx.getImportMonitor());
        try (EntityTraceSpan entityTraceSpan = EntityTracer.create((String)this.getClass().getSimpleName(), (String)"save");){
            AbstractOperateWebApi webApi = this.getSaveWebApi();
            webApi.initialize(this.getBillFormId(), (Map)dataPack);
            ApiResult apiResult = webApi.execute();
            return apiResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipZipFile(String zipFileUrl, FileTypeEnum fileTypeEnum) {
        File tempZipFile;
        block7: {
            if (StringUtils.isEmpty((CharSequence)zipFileUrl)) {
                return;
            }
            tempZipFile = null;
            try {
                tempZipFile = File.createTempFile(UUID.randomUUID().toString(), "zip");
                FileService service = FileServiceFactory.getAttachmentFileService();
                InputStream inputStream = FileImportExtensionFactory.getFileImportExtension().decode(zipFileUrl, service.getInputStream(zipFileUrl));
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempZipFile);
                String dirType = "attTemp_";
                if (fileTypeEnum == FileTypeEnum.IMAGE) {
                    dirType = "imgTemp_";
                }
                String dirPath = "export" + File.separator + dirType + System.currentTimeMillis();
                ImpExpAttachmentUtil.unzip((File)tempZipFile, (String)dirPath, (boolean)false, (Charset)Charset.forName("GBK"));
                if (fileTypeEnum == FileTypeEnum.ATTACHMENT) {
                    this.ctx.addOption("attDirPath", dirPath);
                    break block7;
                }
                this.ctx.addOption("imgDirPath", dirPath);
            }
            catch (IOException e) {
                try {
                    log.error("[\u5bfc\u5165\u9644\u4ef6/\u56fe\u7247\u5f02\u5e38\uff1a\u4ece\u9644\u4ef6\u670d\u52a1\u5668\u4e0b\u8f7d\u9644\u4ef6\u538b\u7f29\u5305\u89e3\u538b\u65f6\u62a5\u9519]" + e);
                }
                catch (Throwable throwable) {
                    FileSecurityUtil.safeDeleteFile(tempZipFile);
                    throw throwable;
                }
                FileSecurityUtil.safeDeleteFile((File)tempZipFile);
            }
        }
        FileSecurityUtil.safeDeleteFile((File)tempZipFile);
    }

    @SdkInternal
    private Set<String> getColIds(List<ImportBillData> rowdatas) {
        return CollectionUtils.isNotEmpty(rowdatas) ? rowdatas.get(0).getEntityMapping().getCols().keySet() : new HashSet<String>(0);
    }

    protected boolean isForceBatch() {
        return false;
    }

    public AbstractOperateWebApi getSaveWebApi() {
        this.ctx.getImportMonitor().addImportLog(ResManager.loadKDString((String)"\u6807\u51c6\u63d2\u4ef6getSaveWebApi", (String)"BatchImportPlugin_8", (String)BOS_IMPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"\u6807\u51c6\u63d2\u4ef6getSaveWebApi\u65b9\u6cd5\u8fdb\u5165", (String)"BatchImportPlugin_9", (String)BOS_IMPORT, (Object[])new Object[0]));
        if (this.saveWebApi == null) {
            String className = SAVE_NEW;
            boolean importFast = SystemParamUtil.getMcParam((String)"IMPORT_FAST");
            if (!importFast) {
                className = SAVE;
            }
            this.saveWebApi = (AbstractOperateWebApi)TypesContainer.createInstance((String)className);
            this.saveWebApi.setOperationNumber(this.ctx.getOpSaveKey());
            this.ctx.getImportMonitor().addImportLog(ResManager.loadKDString((String)"\u6807\u51c6\u63d2\u4ef6getSaveWebApi className ", (String)"BatchImportPlugin_10", (String)BOS_IMPORT, (Object[])new Object[0]), className);
        }
        return this.saveWebApi;
    }

    protected int getBatchImportSize() {
        return 1000;
    }

    @SdkInternal
    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        ctx.getOption().put("appid", ctx.getAppId());
        this.startArgs = startArgs == null ? new CopyOnWriteArrayList<String>() : new CopyOnWriteArrayList<String>(startArgs);
        this.rc = rc;
        this.ctx = ctx;
        return this;
    }

    protected MainEntityType buildMainEntityType(JSONObject billdata) {
        if (this.mainEntityType != null) {
            return this.mainEntityType;
        }
        this.mainEntityType = MetadataServiceHelper.getDataEntityType((String)this.getBillFormId());
        return this.mainEntityType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveExcel() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader reader = new ExcelReader();
        for (String url : this.ctx.getAllUrls()) {
            this.ctx.getImportMonitor().addImportLog(ResManager.loadKDString((String)"\u5f00\u59cb\u89e3\u6790excel\u6570\u636e", (String)"BatchImportPlugin_11", (String)BOS_IMPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"\u6587\u4ef6url\u4e3a\uff1a%s", (String)"BatchImportPlugin_12", (String)BOS_IMPORT, (Object[])new Object[]{url}));
            try {
                InputStream in = FileImportExtensionFactory.getFileImportExtension().decode(url, service.getInputStream(url));
                Throwable throwable = null;
                try {
                    Map<String, Object> option = this.ctx.getOption();
                    MainEntityType mainEntityType = this.buildMainEntityType(null);
                    if (mainEntityType instanceof QueryEntityType) {
                        mainEntityType = ((QueryEntityType)mainEntityType).getMainEntityType();
                    }
                    reader.read(in, new BatchImportSheetHandler(this.ctx, mainEntityType, url, option, this.heartbeat));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Throwable e) {
                log.error(e);
                String importErrMsg = this.getErrorMessage(e);
                this.ctx.getLogger(url).log(Integer.valueOf(0), importErrMsg);
                this.ctx.addBillData(url, new ImportBillData(new JSONObject(), 0, 0));
            }
            finally {
                this.ctx.setResolveComplete(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void importData() throws Throwable {
        try {
            boolean loggerMsgIsExistMsgAlthoughFailedIsZero;
            ImportBillData billdata = null;
            boolean isShowStackTrace = SystemParamServiceHelper.isShowStackTrace();
            for (String url : this.ctx.getAllUrls()) {
                LinkedBlockingQueue<ImportBillData> dataQ = this.ctx.getDataQueue(url);
                ArrayList delRows = new ArrayList(this.getBatchImportSize());
                ImportLogger logger2 = this.ctx.getLogger(url);
                logger2.setDelRows((List)delRows);
                ArrayList<ImportBillData> leftRowdatas = new ArrayList<ImportBillData>(this.getBatchImportSize());
                ArrayList<ImportBillData> billdatas = new ArrayList<ImportBillData>(this.getBatchImportSize());
                ArrayList tempBilldatas = new ArrayList(this.getBatchImportSize());
                this.unzipZipFile(this.ctx.getAttZipUrl(), FileTypeEnum.ATTACHMENT);
                this.unzipZipFile(this.ctx.getImgZipUrl(), FileTypeEnum.IMAGE);
                boolean suspend = false;
                while (this.checkHasDataLeft(url, dataQ, leftRowdatas)) {
                    if (this.getAppCache().get(this.getSuspendKey(), String.class) != null) {
                        this.getAppCache().remove(this.getSuspendKey());
                        suspend = true;
                        break;
                    }
                    int leftRowDatasCount = this.countBatchRows(leftRowdatas);
                    int needCount = this.getBatchImportSize() - leftRowDatasCount;
                    if (needCount > 0 && this.checkHasDataLeft(url, dataQ, null) || leftRowDatasCount <= 0) {
                        billdata = dataQ.poll(3L, TimeUnit.SECONDS);
                        if (billdata == null || billdata.isEmpty()) continue;
                        leftRowdatas.add(billdata);
                        if ((needCount -= Math.max(1, billdata.getEndIndex() - billdata.getStartIndex() + 1)) > 0) {
                            dataQ.drainTo(tempBilldatas, needCount);
                            for (ImportBillData tempBill : tempBilldatas) {
                                if (tempBill == null || tempBill.isEmpty()) continue;
                                leftRowdatas.add(tempBill);
                                needCount -= Math.max(1, tempBill.getEndIndex() - tempBill.getStartIndex() + 1);
                            }
                            tempBilldatas.clear();
                        }
                        if (this.isForceBatch() && needCount > 0 && this.checkHasDataLeft(url, dataQ, null)) continue;
                    }
                    this.filterFromLeftRowDatas(leftRowdatas, billdatas);
                    log.info(String.format("----BatchImportPlugin--\u5f53\u524d\u5206\u6279\uff1a\u5171%d\u884c%d\u5355", this.countBatchRows(billdatas), billdatas.size()));
                    int firstRow = ((ImportBillData)billdatas.get(0)).getStartIndex();
                    ApiResult apiResult = null;
                    try {
                        this.beforeSave(billdatas, logger2);
                        if (!billdatas.isEmpty()) {
                            firstRow = ((ImportBillData)billdatas.get(0)).getStartIndex();
                            apiResult = this.save(billdatas, logger2);
                        }
                        this.buildResult(apiResult, delRows, billdatas, url);
                    }
                    catch (KDBizException kdexp) {
                        logger2.log(Integer.valueOf(firstRow), kdexp.getMessage()).setFailed(logger2.getFailed() + billdatas.size());
                        logger2.signTotalRow(this.getBillDataRowsCount(billdatas));
                        this.buildResult(apiResult, delRows, billdatas, url);
                    }
                    catch (Throwable exp) {
                        log.error(exp);
                        if (isShowStackTrace) {
                            logger2.log(Integer.valueOf(firstRow), exp).setFailed(logger2.getFailed() + billdatas.size());
                        } else {
                            String importErrMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5f02\u5e38\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"BatchImportPlugin_2", (String)BOS_IMPORT, (Object[])new Object[0]);
                            logger2.log(Integer.valueOf(firstRow), exp instanceof KDBizException ? exp.getMessage() : importErrMsg).setFailed(logger2.getFailed() + billdatas.size());
                        }
                        logger2.signTotalRow(this.getBillDataRowsCount(billdatas));
                        this.buildResult(apiResult, delRows, billdatas, url);
                        {
                            catch (Throwable throwable) {
                                this.buildResult(apiResult, delRows, billdatas, url);
                                throw throwable;
                            }
                        }
                    }
                    logger2.setTotal(logger2.getFailed() + logger2.getDelRows().size());
                    if (billdatas.isEmpty()) continue;
                    int lastEndIndex = ((ImportBillData)billdatas.get(billdatas.size() - 1)).getEndIndex();
                    billdatas.clear();
                    this.ctx.feedbackProgress(Math.min(99, lastEndIndex * 100 / logger2.getLastRowIndex()), logger2, null);
                }
                if (!suspend && !this.ctx.isResolveComplete(url) && this.heartbeat.isTimeOut()) {
                    this.ctx.feedbackProgress(99, logger2, ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u8d85\u65f6\uff0c\u672a\u5b8c\u6210\u3002", (String)"BatchImportPlugin_3", (String)BOS_IMPORT, (Object[])new Object[0]));
                    continue;
                }
                this.ctx.feedbackProgress(99, logger2, null);
            }
            int total = 0;
            int failed = 0;
            ImportLogger logger = null;
            for (String url : this.ctx.getAllUrls()) {
                logger = this.ctx.getLogger(url);
                total += logger.getTotal();
                failed += logger.getRowIndex() < logger.getLastRowIndex() - 1 ? logger.getTotal() - logger.getDelRows().size() : logger.getFailed();
                if (logger.getFailed() <= 0 && logger.getRowIndex() >= logger.getLastRowIndex() - 1) continue;
                this.outputFailedData(url, logger);
            }
            HashMap<String, Object> retdata = new HashMap<String, Object>();
            retdata.put("complete", Boolean.TRUE);
            retdata.put("info", this.ctx.getUrlLoggers());
            ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retdata), (int)total, (int)failed);
            boolean bl = loggerMsgIsExistMsgAlthoughFailedIsZero = failed == 0 && logger != null && !MapUtils.isEmpty((Map)logger.getLogCache());
            if (loggerMsgIsExistMsgAlthoughFailedIsZero) {
                Integer firstMsgKey = (Integer)logger.getLogCache().keySet().stream().findFirst().get();
                List importLogs = (List)logger.getLogCache().get(firstMsgKey);
                if (CollectionUtils.isNotEmpty((Collection)importLogs)) {
                    String msg = ((ImportLogger.ImportLog)importLogs.get((int)0)).msg;
                    this.ctx.feedbackProgress(100, null, msg);
                    return;
                }
            }
            this.ctx.feedbackProgress(100, null, null);
        }
        catch (Throwable e) {
            log.error(e);
            this.ctx.feedbackProgress(99, null, ResManager.loadKDString((String)"\u5bfc\u5165\u5f02\u5e38\u3002", (String)"BatchImportPlugin_14", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        finally {
            this.getSaveWebApi().clear();
            this.cachedAdminDivision.clear();
            this.getAppCache().remove(this.getTaskIdKey());
            this.createMonitorReport(this.ctx.getBillFormId());
        }
    }

    private void createMonitorReport(final String billFormId) {
        if (this.ctx.getImportMonitor() != null && this.ctx.getImportMonitor().isMonitorEnable() && this.ctx.getImportMonitor().getReportCotentMap() != null) {
            threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    List allReportContent = BatchImportPlugin.this.divideReport(BatchImportPlugin.this.ctx.getImportMonitor().getReportCotentMap().values());
                    for (ReportCotent reportCotent : allReportContent) {
                        QueueProducer.produce((ReportCotent)reportCotent);
                    }
                    ImportConfigHelper.resetSettingOfMonitorEnable(billFormId);
                }
            });
        }
    }

    private List<ReportCotent> divideReport(Collection<ReportCotent> toSendReport) {
        int order = 1;
        ArrayList<ReportCotent> allReportContents = new ArrayList<ReportCotent>();
        for (ReportCotent reportCotent : toSendReport) {
            this.divideHalfReport(allReportContents, reportCotent, order);
            ++order;
        }
        allReportContents.forEach(item -> item.setMoudleCount(Integer.valueOf(allReportContents.size())));
        return allReportContents;
    }

    private void divideHalfReport(List<ReportCotent> allReportContents, ReportCotent reportCotent, int order) {
        try {
            long maxSize = 209715L;
            long size = RamUsageEstimator.sizeOf((byte[])JSON.toJSONString((Object)reportCotent).getBytes());
            if (size > maxSize) {
                if (reportCotent.getData().getReportItems().getCells().size() <= 1) {
                    reportCotent.getData().getReportItems().setOrder(Integer.valueOf(order));
                    if (reportCotent.getData().getReportItems().getCells().size() == 1) {
                        this.divideCells(reportCotent, new ArrayList<List<String>>(), maxSize);
                    }
                    allReportContents.add(reportCotent);
                    return;
                }
                ReportCotent newReportContent = new ReportCotent();
                newReportContent.setUniqueKey(reportCotent.getUniqueKey());
                newReportContent.setMoudleKey(reportCotent.getMoudleKey());
                ReportData oldReportData = reportCotent.getData();
                ReportData newReportData = new ReportData();
                newReportData.setReportTitle(oldReportData.getReportTitle());
                ReportItems oldReportItems = oldReportData.getReportItems();
                ReportItems newReportItems = new ReportItems();
                newReportItems.setOrder(Integer.valueOf(order));
                ++order;
                newReportItems.setPartTitle(oldReportItems.getPartTitle());
                newReportItems.setCells(oldReportItems.getCells().subList(0, oldReportItems.getCells().size() / 2));
                newReportData.setReportItems(newReportItems);
                newReportContent.setData(newReportData);
                ReportCotent newReportContent2 = new ReportCotent();
                BeanUtils.copyProperties((Object)newReportContent2, (Object)reportCotent);
                newReportContent2.getData().getReportItems().setOrder(Integer.valueOf(order));
                newReportContent2.getData().getReportItems().setCells(oldReportItems.getCells().subList(oldReportItems.getCells().size() / 2, oldReportItems.getCells().size()));
                this.divideHalfReport(allReportContents, newReportContent, ++order);
                this.divideHalfReport(allReportContents, newReportContent2, order);
            } else {
                reportCotent.getData().getReportItems().setOrder(Integer.valueOf(order));
                allReportContents.add(reportCotent);
            }
        }
        catch (Exception e) {
            log.error("divideHalfReport failed:", (Throwable)e);
            allReportContents.add(reportCotent);
        }
    }

    private void divideCells(ReportCotent reportCotent, List<List<String>> finalCellList, long maxSize) {
        try {
            long size = RamUsageEstimator.sizeOf((byte[])JSON.toJSONString((Object)reportCotent).getBytes());
            if (size > maxSize) {
                List cellsList = reportCotent.getData().getReportItems().getCells();
                List cells = (List)cellsList.get(0);
                finalCellList.clear();
                if (cells.size() <= 1) {
                    finalCellList.add(cells);
                    reportCotent.getData().getReportItems().setCells(finalCellList);
                    return;
                }
                finalCellList.add(cells.subList(0, cells.size() / 2));
                reportCotent.getData().getReportItems().setCells(finalCellList);
                this.divideCells(reportCotent, finalCellList, maxSize);
            } else {
                reportCotent.getData().getReportItems().setCells(finalCellList);
            }
        }
        catch (Exception e) {
            log.error("divideCells error:", (Throwable)e);
        }
    }

    @SdkInternal
    private int getBillDataRowsCount(List<ImportBillData> billDatas) {
        int rows = 0;
        for (ImportBillData billData : billDatas) {
            int startIndex = billData.getStartIndex();
            int endIndex = billData.getEndIndex();
            rows += endIndex - startIndex + 1;
        }
        return rows;
    }

    private void buildResult(ApiResult apiResult, List<int[]> delRows, List<ImportBillData> billdatas, String url) {
        boolean isCn;
        boolean bl = isCn = RequestContext.get().getLang() == Lang.zh_CN || RequestContext.get().getLang() == Lang.zh_TW;
        if (apiResult != null) {
            List billResults = (List)apiResult.getData();
            if (billResults == null) {
                log.error("\u8fd4\u56de\u7ed3\u679c\u7684data\u4e3anull\uff0c\u5f02\u5e38\uff1a" + ApiResult.toMap((ApiResult)apiResult));
                if (!billdatas.isEmpty()) {
                    this.ctx.getLogger(url).log(Integer.valueOf(billdatas.get(0).getStartIndex()), apiResult.getMessage()).fail(billdatas.size());
                }
                return;
            }
            for (Map billResult : billResults) {
                Integer dindex = (Integer)billResult.get("dindex");
                ImportBillData billData = billdatas.get(dindex);
                int startIndex = billData.getStartIndex();
                int endIndex = billData.getEndIndex();
                if (((Boolean)billResult.get("success")).booleanValue()) {
                    ArrayList successIds = new ArrayList();
                    successIds.add(billResult.get("id"));
                    delRows.add(new int[]{startIndex, endIndex});
                    this.bindAttachmentPanelAttList(billResult);
                } else if (billResult.containsKey("convertResult")) {
                    Map convertResult = (Map)billResult.get("convertResult");
                    for (Map.Entry entry : convertResult.entrySet()) {
                        List<String> tips = this.rebuildErrorLogWithoutSymbol((List)entry.getValue(), isCn);
                        this.ctx.getLogger(url).log((Integer)entry.getKey(), StringUtils.join((Object[])tips.toArray(), (String)(isCn ? "\uff1b" : ";")) + (isCn ? "\u3002" : "."));
                    }
                    this.clearPicture(billData);
                    this.clearAtt(billResult);
                    this.ctx.getLogger(url).fail();
                } else {
                    String msg = (String)billResult.get("message");
                    if (StringUtils.isBlank((CharSequence)msg)) {
                        Object errData;
                        Object objData = billResult.get("data");
                        if (objData instanceof Map) {
                            List errList;
                            errData = (Map)objData;
                            if (errData != null && ((Boolean)errData.get("success")).booleanValue() && (errList = (List)errData.get("AllErrorOrValidateInfo")) != null && !errList.isEmpty()) {
                                StringBuilder stb = new StringBuilder();
                                for (Map errinfo : errList) {
                                    stb.append(errinfo.get("message"));
                                }
                                msg = stb.toString();
                            }
                            if (StringUtils.isBlank((CharSequence)msg) || "null".equalsIgnoreCase(msg)) {
                                log.error("\u672a\u77e5\u5f02\u5e38\uff0c\u64cd\u4f5c\u9519\u8bef\u7ed3\u679cmsg is blank ");
                                msg = ResManager.loadKDString((String)"\u672a\u77e5\u4e1a\u52a1\u5f02\u5e38\u3002", (String)"BatchImportPlugin_13", (String)BOS_IMPORT, (Object[])new Object[0]);
                            }
                            this.clearPicture(billData);
                            this.clearAtt(billResult);
                            this.ctx.getLogger(url).log(Integer.valueOf(startIndex), msg).fail();
                        } else if (objData instanceof List) {
                            errData = (List)objData;
                            this.buildOperateError((List<OperateErrorInfo>)errData, billData, url);
                        }
                    } else {
                        this.clearPicture(billData);
                        this.clearAtt(billResult);
                        this.ctx.getLogger(url).log(Integer.valueOf(startIndex), msg).fail();
                    }
                }
                this.ctx.getLogger(url).signTotalRow(endIndex - startIndex + 1);
            }
        }
    }

    private void bindAttachmentPanelAttList(Map<String, Object> billResult) {
        Object attachmentPanelTempUrlList = billResult.get("attachmentPanelTempUrlList");
        if (!(attachmentPanelTempUrlList instanceof List) || ((List)attachmentPanelTempUrlList).size() == 0) {
            return;
        }
        List panelTempUrlList = (List)attachmentPanelTempUrlList;
        ArrayList<AttDto> attDtoList = new ArrayList<AttDto>(panelTempUrlList.size());
        for (AttachmentPanelForImportDto attachmentDtoForImport : panelTempUrlList) {
            AttDto attDto = new AttDto();
            attDto.setAttKey(attachmentDtoForImport.getAttachmentPanelKey());
            attDto.setPath(attachmentDtoForImport.getFilePath());
            attDto.setSize(attachmentDtoForImport.getFileSize());
            attDtoList.add(attDto);
        }
        try {
            Map bindingParam = AttachmentServiceHelper.genBindingParam((String)this.mainEntityType.getName(), (String)billResult.get("id").toString(), attDtoList);
            AttachmentServiceHelper.bindingAttachment((Map)bindingParam);
        }
        catch (Exception e) {
            log.error("[\u9644\u4ef6\u9762\u677f\u9644\u4ef6\u7ed1\u5b9a\u5931\u8d25\uff1a]" + e);
        }
    }

    private void clearPicture(ImportBillData billData) {
        if (StringUtils.isEmpty((CharSequence)this.ctx.getImgZipUrl())) {
            return;
        }
        FileService imageFileService = FileServiceFactory.getImageFileService();
        try {
            this.deletePictureInServer(billData.getData(), billData.getEntityMapping(), imageFileService);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void clearAtt(Map<String, Object> billResult) {
        if (billResult == null) {
            return;
        }
        BatchImportPlugin.clearAttachmentPanelAtt(billResult);
        this.clearAttachmentFieldAtt(billResult);
    }

    private void clearAttachmentFieldAtt(Map<String, Object> billResult) {
        Object attachmentFieldPkSet = billResult.get("attachmentFieldPkSet");
        if (!(attachmentFieldPkSet instanceof Set) || ((Set)attachmentFieldPkSet).size() == 0) {
            return;
        }
        Set fieldPkSet = (Set)attachmentFieldPkSet;
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        ArrayList<Object> attachmentFieldPkList = new ArrayList<Object>(fieldPkSet.size());
        for (AttachmentFieldForImportDto attachmentFieldForImportDto : fieldPkSet) {
            Object attachmentFieldPk = attachmentFieldForImportDto.getAttachmentFieldPk();
            String filePath = attachmentFieldForImportDto.getFilePath();
            if (attachmentFieldPk != null) {
                attachmentFieldPkList.add(attachmentFieldPk);
            }
            if (!StringUtils.isNotEmpty((CharSequence)filePath)) continue;
            attachmentFileService.delete(filePath);
        }
        if (attachmentFieldPkList.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", attachmentFieldPkList);
            DeleteServiceHelper.delete((String)"bd_attachment", (QFilter[])new QFilter[]{qFilter});
        }
    }

    private static void clearAttachmentPanelAtt(Map<String, Object> billResult) {
        Object attachmentPanelTempUrlList = billResult.get("attachmentPanelTempUrlList");
        if (!(attachmentPanelTempUrlList instanceof List) || ((List)attachmentPanelTempUrlList).size() == 0) {
            return;
        }
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        List panelTempUrlList = (List)attachmentPanelTempUrlList;
        List pathList = panelTempUrlList.stream().map(AttachmentPanelForImportDto::getFilePath).collect(Collectors.toList());
        try {
            for (String path : pathList) {
                attachmentFileService.delete(path);
            }
        }
        catch (Exception e) {
            log.error("[\u9644\u4ef6\u9762\u677f\u6e05\u7406\u5931\u8d25\uff1a]" + e);
        }
    }

    private void deletePictureInServer(JSONObject sourceJson, ImportEntityMapping entityMapping, FileService imageFileService) {
        for (Map.Entry<String, ImportEntityMapping.ColInfo> entry : entityMapping.getCols().entrySet()) {
            String value;
            String fieldKey = entry.getKey();
            ImportEntityMapping.ColInfo colInfo = entry.getValue();
            IDataEntityProperty prop = colInfo.getProperty();
            if (!(prop instanceof PictureProp) || !StringUtils.isNotEmpty((CharSequence)(value = sourceJson.getString(fieldKey)))) continue;
            imageFileService.delete(FilePathUtil.dealPath((String)value, (String)"image"));
        }
        for (Map.Entry<String, Object> entry : entityMapping.getEntries().entrySet()) {
            JSONArray entryJsonArray = sourceJson.getJSONArray(entry.getKey());
            for (int i = 0; i < entryJsonArray.size(); ++i) {
                JSONObject entryJsonObject = entryJsonArray.getJSONObject(i);
                this.deletePictureInServer(entryJsonObject, (ImportEntityMapping)entry.getValue(), imageFileService);
            }
        }
    }

    private void buildOperateError(List<OperateErrorInfo> billResult, ImportBillData billData, String url) {
        int startIndex = billData.getStartIndex();
        if (CollectionUtils.isEmpty(billResult)) {
            log.error("\u672a\u77e5\u5f02\u5e38\uff0c\u64cd\u4f5c\u9519\u8bef\u7ed3\u679cmsg is blank ");
            this.ctx.getLogger(url).log(Integer.valueOf(startIndex), ResManager.loadKDString((String)"\u672a\u77e5\u4e1a\u52a1\u5f02\u5e38\u3002", (String)"BatchImportPlugin_13", (String)BOS_IMPORT, (Object[])new Object[0])).fail();
            return;
        }
        JSONObject data = billData.getData();
        LinkedHashMap errorMsg = new LinkedHashMap();
        boolean isNewType = this.isNewType();
        for (OperateErrorInfo operateErrorInfo : billResult) {
            List errorList;
            int index = startIndex;
            if (isNewType) {
                index = this.getErrorInfoIndex(operateErrorInfo, data, startIndex);
            }
            if (!errorMsg.containsKey(index)) {
                errorMsg.put(index, new ArrayList());
            }
            if ((errorList = (List)errorMsg.get(index)).contains(operateErrorInfo.getMessage())) continue;
            errorList.add(operateErrorInfo.getMessage());
        }
        for (Map.Entry entry : errorMsg.entrySet()) {
            Integer index = (Integer)entry.getKey();
            String message = String.join((CharSequence)"", (Iterable)entry.getValue());
            this.ctx.getLogger(url).log(index, message);
        }
        this.ctx.getLogger(url).fail();
    }

    private int getErrorInfoIndex(OperateErrorInfo errorInfo, JSONObject data, int startIndex) {
        JSONArray entryDataArray;
        String entityKey = errorInfo.getEntityKey();
        if (StringUtils.equals((CharSequence)this.mainEntityType.getName(), (CharSequence)entityKey)) {
            return startIndex;
        }
        EntityType entityType = (EntityType)this.mainEntityType.getAllEntities().get(entityKey);
        String entryKey = "";
        if (entityType instanceof SubEntryType) {
            entryKey = entityType.getParent().getName();
        } else if (entityType instanceof EntryType) {
            entryKey = entityKey;
        }
        Object entryData = data.get((Object)entryKey);
        if (!(entryData instanceof JSONArray)) {
            return startIndex;
        }
        int rowIndex = errorInfo.getRowIndex();
        if (rowIndex >= (entryDataArray = (JSONArray)entryData).size()) {
            return startIndex;
        }
        JSONObject entryRow = entryDataArray.getJSONObject(rowIndex);
        if (entryRow == null) {
            return startIndex;
        }
        int rowNum = entryRow.getIntValue("rowNum");
        return rowNum == 0 ? startIndex : rowNum + errorInfo.getSubRowIndex();
    }

    private boolean isNewType() {
        Map<String, Object> option = this.ctx.getOption();
        if (MapUtils.isEmpty(option)) {
            return false;
        }
        Object importtype = option.get("importtype");
        if (StringUtils.isBlank((Object)importtype)) {
            return false;
        }
        return StringUtils.equals((CharSequence)"new", (CharSequence)importtype.toString());
    }

    private List<String> rebuildErrorLogWithoutSymbol(List<String> tips, boolean isCn) {
        tips = ((List)Optional.ofNullable(tips).orElse(new ArrayList(0))).stream().map(x -> {
            if (StringUtils.isBlank((CharSequence)x)) {
                return x;
            }
            char lastChar = x.charAt(x.length() - 1);
            if (this.isChinesePunctuation(lastChar) || !isCn && this.isDotMark(lastChar)) {
                x = x.substring(0, x.length() - 1);
            }
            return x;
        }).collect(Collectors.toList());
        return tips;
    }

    private boolean isDotMark(char lastChar) {
        return lastChar == '.';
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        ImportHelper.invalidBill(billdatas, logger, this.cachedAdminDivision);
        ImportHelper.invalidImg(billdatas, logger, this.ctx);
    }

    private boolean checkHasDataLeft(String url, LinkedBlockingQueue<ImportBillData> dataQ, List<ImportBillData> leftRowdatas) {
        return !this.ctx.isResolveComplete(url) && !this.heartbeat.isTimeOut() || !dataQ.isEmpty() || leftRowdatas != null && !leftRowdatas.isEmpty();
    }

    private int countBatchRows(List<ImportBillData> billdatas) {
        int countRows = 0;
        for (ImportBillData billdata : billdatas) {
            if (billdata.getEndIndex() < billdata.getStartIndex()) continue;
            countRows += billdata.getEndIndex() - billdata.getStartIndex() + 1;
        }
        return countRows;
    }

    protected void refreshHeartbeat() {
        this.heartbeat.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SdkInternal
    public final Object call() {
        try {
            RequestContext.copyAndSet((RequestContext)this.rc);
            OperationContext oc = new OperationContext();
            oc.setAppId(this.ctx.getAppId());
            oc.setFormId(this.ctx.getBillFormId());
            oc.setFormName(this.ctx.getListName());
            oc.setOpKey("importdata");
            OperationContext.set((OperationContext)oc);
            String tag = this.getTag();
            if (tag == null) {
                tag = "";
            }
            switch (tag) {
                case "resolveExcel": {
                    this.resolveExcel();
                    return null;
                }
                case "importData": {
                    try {
                        this.importData();
                        return null;
                    }
                    finally {
                        Map<String, Object> option;
                        if (this.ctx.isFromTask().booleanValue()) {
                            this.ctx.getCountDownLatch().countDown();
                        }
                        if ((option = this.ctx.getOption()).containsKey("attDirPath") && option.get("attDirPath") != null && StringUtils.isNotEmpty((CharSequence)option.get("attDirPath").toString())) {
                            this.tryDeleteAttOrImgDir(option.get("attDirPath").toString());
                        }
                        if (option.containsKey("imgDirPath") && option.get("imgDirPath") != null && StringUtils.isNotEmpty((CharSequence)option.get("imgDirPath").toString())) {
                            this.tryDeleteAttOrImgDir(option.get("imgDirPath").toString());
                        }
                    }
                }
            }
            return null;
        }
        catch (Throwable e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        finally {
            RequestContext.set(null);
        }
    }

    private void tryDeleteAttOrImgDir(String dirPath) {
        Path path = Paths.get(FilenameUtils.getFullPath((String)dirPath), FilenameUtils.getName((String)dirPath));
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    log.debug("\u6587\u4ef6\u88ab\u5220\u9664 :" + file.getFileName());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    log.debug("\u6587\u4ef6\u5939\u88ab\u5220\u9664:" + dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            log.error("[\u5bfc\u5165\u9644\u4ef6/\u56fe\u7247]\u5bfc\u5165\u7ed3\u675f\u540e\u5220\u9664\u78c1\u76d8\u4e34\u65f6\u6587\u4ef6\u5939\u9519\u8bef\uff1a" + e);
        }
    }

    private synchronized String getTag() {
        return this.startArgs.isEmpty() ? null : this.startArgs.remove(0);
    }

    private void outputFailedData(String url, ImportLogger logger) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream in = FileImportExtensionFactory.getFileImportExtension().decode(url, service.getInputStream(url));){
            new ExcelReader().read(in, new BatchImportFailedSheetHandler(this.ctx, logger, service));
        }
        catch (Throwable e) {
            log.error(e);
            if (SystemParamServiceHelper.isShowStackTrace()) {
                logger.log(Integer.valueOf(0), e);
            }
            logger.log(Integer.valueOf(0), e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u9519\u8bef\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"BatchImportPlugin_4", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
    }

    private void filterFromLeftRowDatas(List<ImportBillData> leftRowdatas, List<ImportBillData> rowdatas) {
        ImportBillData billdata;
        int billRowSpan;
        this.importRowMapping.clear();
        int batchSize = this.getBatchImportSize();
        int i = 0;
        for (int needRowsCount = batchSize - this.countBatchRows(rowdatas); i < leftRowdatas.size() && needRowsCount > 0 && !this.checkIfRefPrevData(billdata, (billRowSpan = (billdata = leftRowdatas.get(i)).getEndIndex() - billdata.getStartIndex() + 1) > batchSize); needRowsCount -= Math.max(1, billRowSpan)) {
            billdata = leftRowdatas.remove(i);
            rowdatas.add(billdata);
        }
        if (rowdatas.isEmpty() && !leftRowdatas.isEmpty()) {
            rowdatas.add(leftRowdatas.remove(0));
        }
    }

    private Set<Object> buildBaseRefPropKeys(MainEntityType billType) {
        if (this.mainEntityType != null && this.propKeysMapping != null) {
            this.fillImportRowMapping();
            return this.propKeysMapping;
        }
        this.propKeysMapping = new HashSet<Object>(128);
        this.refBasePropKeys = new HashSet<String>(128);
        DataEntityPropertyCollection coll = billType.getProperties();
        for (IDataEntityProperty prop : coll) {
            if (this.checkIfPropRef(billType, prop)) {
                this.mappingBasedataPropProp(prop, this.refBasePropKeys);
                this.propKeysMapping.add(prop.getName());
                continue;
            }
            if (!(prop instanceof EntryProp)) continue;
            HashMap entryPropMap = new HashMap(128);
            ArrayList<Object> entryPropKeys = new ArrayList<Object>(128);
            entryPropMap.put(prop.getName(), entryPropKeys);
            int entryCount = 0;
            for (IDataEntityProperty entryProp : ((EntryProp)prop).getDynamicCollectionItemPropertyType().getProperties()) {
                if (this.checkIfPropRef(billType, entryProp)) {
                    this.mappingBasedataPropProp(entryProp, this.refBasePropKeys);
                    entryPropKeys.add(entryProp.getName());
                    ++entryCount;
                    continue;
                }
                if (!(entryProp instanceof EntryProp)) continue;
                HashMap subEntryPropMap = new HashMap(64);
                ArrayList<String> subEntryPropKeys = new ArrayList<String>(64);
                subEntryPropMap.put(entryProp.getName(), subEntryPropKeys);
                int subEntryCount = 0;
                for (IDataEntityProperty subEntryProp : ((EntryProp)entryProp).getDynamicCollectionItemPropertyType().getProperties()) {
                    if (!this.checkIfPropRef(billType, subEntryProp)) continue;
                    this.mappingBasedataPropProp(subEntryProp, this.refBasePropKeys);
                    subEntryPropKeys.add(subEntryProp.getName());
                    ++subEntryCount;
                }
                if (subEntryCount <= 0) continue;
                entryPropKeys.add(subEntryPropMap);
                ++entryCount;
            }
            if (entryCount <= 0) continue;
            this.propKeysMapping.add(entryPropMap);
        }
        this.fillImportRowMapping();
        return this.propKeysMapping;
    }

    private boolean checkIfPropRef(MainEntityType billType, IDataEntityProperty prop) {
        boolean isRef;
        boolean bl = isRef = prop instanceof IBasedataField && !(prop instanceof AttachmentProp);
        if (isRef) {
            BasedataEntityType baseType = (BasedataEntityType)((IBasedataField)prop).getComplexType();
            String billInheritPath = billType.getInheritPath();
            String baseInheritPath = baseType.getInheritPath();
            isRef = billInheritPath != null && baseInheritPath != null && (billInheritPath.contains(baseInheritPath) || baseInheritPath.contains(billInheritPath));
        }
        return isRef;
    }

    private void fillImportRowMapping() {
        for (String key : this.refBasePropKeys) {
            Set<String> propKeys = this.importRowMapping.get(key);
            if (propKeys != null) continue;
            this.importRowMapping.put(key, new HashSet());
        }
    }

    private void mappingBasedataPropProp(IDataEntityProperty prop, Set<String> refBasePropKeys) {
        String propProp = ((IBasedataField)prop).getNumberProp();
        if (StringUtils.isNotBlank((CharSequence)propProp)) {
            refBasePropKeys.add(propProp);
        }
        if (StringUtils.isNotBlank((CharSequence)(propProp = ((IBasedataField)prop).getDisplayProp()))) {
            refBasePropKeys.add(propProp);
        }
    }

    private boolean checkIfRefPrevData(ImportBillData importBillData, boolean isBigData) {
        JSONObject billData = importBillData.getData();
        MainEntityType mainEntityType = this.buildMainEntityType(billData);
        for (Object obj : this.buildBaseRefPropKeys(mainEntityType)) {
            if (obj instanceof String) {
                String string;
                Set<String> importedRows;
                JSONObject data = billData.getJSONObject((String)obj);
                if (data == null || !data.containsKey((Object)IMPORTPROP) || (importedRows = this.importRowMapping.get(string = data.getString(IMPORTPROP))) == null || !importedRows.contains(data.get((Object)string))) continue;
                return true;
            }
            if (!(obj instanceof Map) || isBigData) continue;
            for (Map.Entry<String, Set<String>> entry : ((Map)obj).entrySet()) {
                JSONArray entryRows = billData.getJSONArray(entry.getKey());
                for (int j = 0; entryRows != null && j < entryRows.size(); ++j) {
                    JSONObject entryRow = entryRows.getJSONObject(j);
                    for (Object entryObj : (List)((Object)entry.getValue())) {
                        if (entryObj instanceof String) {
                            String dataType;
                            Set<String> importedRows;
                            JSONObject data = entryRow.getJSONObject((String)entryObj);
                            if (data == null || !data.containsKey((Object)IMPORTPROP) || (importedRows = this.importRowMapping.get(dataType = data.getString(IMPORTPROP))) == null || !importedRows.contains(data.get((Object)dataType))) continue;
                            return true;
                        }
                        if (!(entryObj instanceof Map)) continue;
                        for (Map.Entry subEntryKeyObj : ((Map)entryObj).entrySet()) {
                            JSONArray subEntryRows = entryRow.getJSONArray((String)subEntryKeyObj.getKey());
                            for (int k = 0; subEntryRows != null && k < subEntryRows.size(); ++k) {
                                for (Object subEntryObj : (List)subEntryKeyObj.getValue()) {
                                    String dataType;
                                    Set<String> importedRows;
                                    JSONObject data = subEntryRows.getJSONObject(k).getJSONObject((String)subEntryObj);
                                    if (data == null || !data.containsKey((Object)IMPORTPROP) || (importedRows = this.importRowMapping.get(dataType = data.getString(IMPORTPROP))) == null || !importedRows.contains(data.get((Object)dataType))) continue;
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (mainEntityType instanceof BillEntityType) {
            String propVal = null;
            String currLang = RequestContext.getOrCreate().getLang().name();
            for (Map.Entry<String, Set<String>> entry : this.importRowMapping.entrySet()) {
                if (mainEntityType.getProperty(entry.getKey()) instanceof MuliLangTextProp) {
                    Map mulLangVal = (Map)billData.get((Object)entry.getKey());
                    if (mulLangVal != null) {
                        propVal = (String)mulLangVal.get(currLang);
                    }
                } else {
                    propVal = billData.getString(entry.getKey());
                }
                if (!StringUtils.isNotBlank((CharSequence)propVal)) continue;
                entry.getValue().add(propVal);
            }
        }
        return false;
    }

    @SdkInternal
    protected ApiResult convertApiResult(OperationResult saveResult) {
        ApiResult apiResult = new ApiResult();
        ArrayList billResults = new ArrayList();
        if (saveResult == null) {
            apiResult.setSuccess(false);
            apiResult.setData(billResults);
        } else {
            HashSet<Object> successIds = new HashSet<Object>();
            if (saveResult.getSuccessPkIds() != null) {
                successIds.addAll(saveResult.getSuccessPkIds());
            }
            ArrayList<IOperateInfo> opFailInfos = new ArrayList<IOperateInfo>();
            HashMap<Object, List<IOperateInfo>> billErrors = new HashMap<Object, List<IOperateInfo>>();
            this.splitErrorInfoByBill(successIds, saveResult, opFailInfos, billErrors);
            apiResult.setSuccess(successIds.size() == billResults.size());
            apiResult.setData(billResults);
        }
        return apiResult;
    }

    private void splitErrorInfoByBill(Set<Object> pkIds, OperationResult saveResult, List<IOperateInfo> opFailInfos, Map<Object, List<IOperateInfo>> billErrors) {
        OperateErrorInfo errInfo;
        if (saveResult.getSuccessPkIds() != null && saveResult.getSuccessPkIds().isEmpty() && StringUtils.isNotBlank((CharSequence)saveResult.getMessage())) {
            errInfo = new OperateErrorInfo("", ErrorLevel.Error, null);
            errInfo.setMessage(saveResult.getMessage());
            opFailInfos.add((IOperateInfo)errInfo);
        }
        for (IOperateInfo info : saveResult.getAllErrorOrValidateInfo()) {
            Object pkValue = info.getPkValue();
            if (!this.isIdExist(pkValue, pkIds)) {
                opFailInfos.add(info);
                continue;
            }
            if (!this.isIdExist(pkValue, billErrors.keySet())) {
                billErrors.put(pkValue, new ArrayList());
            }
            billErrors.get(pkValue).add(info);
        }
        if (!saveResult.isSuccess() && opFailInfos.isEmpty()) {
            errInfo = new OperateErrorInfo("", ErrorLevel.Error, null);
            errInfo.setMessage(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0\u5bfc\u81f4\u7684\u4fdd\u5b58\u5931\u8d25\u3002", (String)"BatchImportPlugin_5", (String)BOS_IMPORT, (Object[])new Object[0]));
            opFailInfos.add((IOperateInfo)errInfo);
        }
    }

    private boolean isIdExist(Object id, Set<Object> successIds) {
        block6: {
            if (StringUtils.isBlank((Object)id)) {
                return false;
            }
            if (successIds.isEmpty()) {
                return false;
            }
            Object obj2 = successIds.iterator().next();
            if (obj2.getClass() != id.getClass()) {
                for (Object obj2 : successIds) {
                    if (Long.parseLong(id.toString()) != Long.parseLong(obj2.toString())) continue;
                    return true;
                }
                break block6;
            }
            return successIds.contains(id);
        }
        return false;
    }

    @SdkInternal
    public MainEntityType getExportMainEntityType(String billFormId, DynamicObject templateData) {
        return null;
    }

    @SdkInternal
    public boolean isChinesePunctuation(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || ub == Character.UnicodeBlock.VERTICAL_FORMS;
    }

    private String getErrorMessage(Throwable e) {
        String importErrMsg;
        if (e instanceof KDBizException) {
            String pluginName;
            String pluginTips = ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u4e2d\u6570\u636e\u957f\u65f6\u95f4\u65e0\u6cd5\u4fdd\u5b58\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u6216\u68c0\u67e5%1$s\u63d2\u4ef6\u3002", (String)"BatchImportSheetHandler_6", (String)BOS_IMPORT, (Object[])new Object[0]);
            importErrMsg = StringUtils.equals((CharSequence)e.getMessage(), (CharSequence)pluginTips) ? (StringUtils.equals((CharSequence)(pluginName = this.getClass().getName()), (CharSequence)"kd.bos.form.plugin.impt.BatchImportPlugin") ? ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u4e2d\u6570\u636e\u957f\u65f6\u95f4\u65e0\u6cd5\u4fdd\u5b58\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u6216\u68c0\u67e5\u4fdd\u5b58\u64cd\u4f5c\u76f8\u5173\u7684\u63d2\u4ef6\u3002", (String)"BatchImportSheetHandler_7", (String)BOS_IMPORT, (Object[])new Object[0]) : String.format(pluginTips, pluginName)) : e.getMessage();
        } else {
            importErrMsg = ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"BatchImportPlugin_1", (String)BOS_IMPORT, (Object[])new Object[0]);
        }
        return importErrMsg;
    }
}

