/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.impt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.impt.SheetHandler;
import org.xml.sax.SAXException;

public class BatchImportSheetHandler
extends SheetHandler {
    private static final String BOS_IMPORT = "bos-import";
    private final String url;
    private final ImportContext ctx;
    private final MainEntityType mainEntityType;
    private final LinkedBlockingQueue<ImportBillData> dataQueue;
    private final ImportLogger logger;
    private Map<Integer, String> nameRow;
    private ImportEntityMapping entityMapping;
    private int dataIndex = 0;
    private int startRowNum = 0;
    private int startEntryRowNum = 0;
    private boolean errorData = false;
    private boolean isNewFormat = true;
    private boolean hasErrorCol;
    private JSONObject data;
    private SheetHandler.ParsedRow currentRow;
    private Map<String, Object> option = new HashMap<String, Object>();
    private HeartBeat heartbeat;
    private int handledProgressIndex;
    private boolean isValidRow = true;
    private final Map<Integer, Integer> emptyRowsInBillData = new HashMap<Integer, Integer>(8);

    @Override
    public Map<String, Object> getOption() {
        return this.option;
    }

    public SheetHandler.ParsedRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(SheetHandler.ParsedRow currentRow) {
        this.currentRow = currentRow;
    }

    public int getHandledProgressIndex() {
        return this.handledProgressIndex;
    }

    public void setHandledProgressIndex(int handledProgressIndex) {
        this.handledProgressIndex = handledProgressIndex;
    }

    @Deprecated
    public BatchImportSheetHandler(ImportContext ctx, MainEntityType mainEntityType, String url) {
        this.ctx = ctx;
        this.url = url;
        this.mainEntityType = mainEntityType;
        this.dataQueue = ctx.getDataQueue(url);
        this.logger = ctx.getLogger(url);
    }

    public BatchImportSheetHandler(ImportContext ctx2, MainEntityType mainEntityType2, String url2, HeartBeat heartbeat) {
        this(ctx2, mainEntityType2, url2);
        this.heartbeat = heartbeat;
    }

    public BatchImportSheetHandler(ImportContext ctx2, MainEntityType mainEntityType2, String url2, Map<String, Object> option, HeartBeat heartbeat) {
        this(ctx2, mainEntityType2, url2);
        this.option = option;
        this.heartbeat = heartbeat;
        this.setReadOriginalNum(ctx2.getReadOriginalNum());
    }

    @Override
    public void handleRow(SheetHandler.ParsedRow row) {
        if (this.heartbeat != null) {
            this.heartbeat.refresh();
        }
        int currRowNum = row.getRowNum();
        this.logger.setRowIndex(currRowNum);
        if (currRowNum == 0) {
            this.ctx.getImportMonitor().checkImportMonitorRowLimit(this.getRowCount());
        }
        this.ctx.getImportMonitor().addImportLog(ResManager.loadKDString((String)"\u9010\u884c\u89e3\u6790excel\u6570\u636e", (String)"BatchImportSheetHandler_3", (String)BOS_IMPORT, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u53f7\u4e3a \uff1a %1$s\uff0c\u5185\u5bb9\u4e3a \uff1a %2$s", (String)"BatchImportSheetHandler_4", (String)BOS_IMPORT, (Object[])new Object[0]), currRowNum + 1, this.ctx.getImportMonitor().safeToJsonStrng(row.getData())));
        if (currRowNum == 0) {
            this.logger.setLastRowIndex(this.getRowCount());
            if (row.isEmpty()) {
                return;
            }
            String entityName = row.get(0);
            if (StringUtils.isEmpty((CharSequence)entityName)) {
                entityName = row.get(1);
                this.hasErrorCol = true;
            }
            if (entityName == null || !entityName.contains(" # ") || !this.mainEntityType.getName().equalsIgnoreCase(entityName.split(" # ", -1)[1])) {
                this.addBillData(new ImportBillData(this.data, this.startRowNum, currRowNum));
                this.ctx.setResolveComplete(this.url);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u4e0e\u5355\u636e\u4e0d\u5339\u914d\uff0c\u5bfc\u81f4\u5bfc\u5165\u5931\u8d25\u3002\u6570\u636e\uff1a%s", (String)"BatchImportSheetHandler_0", (String)BOS_IMPORT, (Object[])new Object[0]), entityName));
            }
        }
        if (currRowNum == 2) {
            this.nameRow = row.getData();
            this.isNewFormat = !this.nameRow.get(this.hasErrorCol ? 1 : 0).contains(" # ");
            this.ctx.setNewFormat(this.isNewFormat);
        }
        if (currRowNum >= 2) {
            if (this.isNewFormat) {
                this.buildBill(row);
            } else {
                this.buildBillOld(row);
            }
        }
        if (currRowNum - this.handledProgressIndex >= 1000) {
            this.ctx.feedbackProgress(0, this.logger, null);
            this.handledProgressIndex = currRowNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildBill(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (currRowNum == 3) {
            this.entityMapping = ImportEntityMapping.create((DynamicObjectType)this.mainEntityType, this.nameRow, row.getData(), this.option);
        } else if (currRowNum > 3) {
            try {
                if (!this.entityMapping.isEntryRow(this.currentRow, row)) {
                    if (!this.addNewBillData(row)) {
                        this.isValidRow = false;
                        return;
                    }
                    this.isValidRow = true;
                } else if (this.ctx.isBatchByEntry() && currRowNum - this.startEntryRowNum >= this.ctx.getBatchEntryRowSize() && !this.addNewEntryBatch(row)) {
                    return;
                }
                if (row.isEmpty()) {
                    Integer emptyRowNum = this.emptyRowsInBillData.getOrDefault(this.dataIndex, 0);
                    this.emptyRowsInBillData.put(this.dataIndex, emptyRowNum + 1);
                }
                if (!this.isValidRow) {
                    return;
                }
                List<String> errMsg = this.entityMapping.push(this.currentRow, row, this.data != null ? this.data : new JSONObject());
                if (!errMsg.isEmpty()) {
                    this.errorData = true;
                    this.logger.log(Integer.valueOf(currRowNum), String.join((CharSequence)"\uff1b", errMsg) + "\uff1b");
                }
            }
            finally {
                this.currentRow = row;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildBillOld(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (currRowNum == 2) {
            this.nameRow = row.getData();
            this.entityMapping = ImportEntityMapping.create((DynamicObjectType)this.mainEntityType, this.nameRow);
        } else if (currRowNum > 2) {
            try {
                if (!this.entityMapping.isEntryRow(this.currentRow, row) ? !this.addNewBillData(row) : this.ctx.isBatchByEntry() && currRowNum - this.startEntryRowNum >= this.ctx.getBatchEntryRowSize() && !this.addNewEntryBatch(row)) {
                    return;
                }
                List<String> errMsg = this.entityMapping.push(this.currentRow, row, this.data != null ? this.data : new JSONObject());
                if (!errMsg.isEmpty()) {
                    this.errorData = true;
                    this.logger.log(Integer.valueOf(currRowNum), String.join((CharSequence)"\uff1b", errMsg) + "\uff1b");
                }
            }
            finally {
                this.currentRow = row;
            }
        }
    }

    private boolean addNewBillData(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (this.entityMapping.isEntityEmpty(row.getData())) {
            return false;
        }
        if (this.data != null) {
            if (this.errorData) {
                this.logger.fail().tick();
            } else {
                ImportBillData billData = new ImportBillData(this.data, this.startEntryRowNum, currRowNum - 1, this.entityMapping);
                billData.setDataIndex(this.dataIndex);
                billData.setStartRowIndex(this.startEntryRowNum - this.startRowNum);
                billData.setEmptyRowNum(this.emptyRowsInBillData.getOrDefault(this.dataIndex, 0));
                this.addBillData(billData);
            }
            this.errorData = false;
            ++this.dataIndex;
        }
        this.data = new JSONObject();
        this.startRowNum = currRowNum;
        this.startEntryRowNum = currRowNum;
        return true;
    }

    private boolean addNewEntryBatch(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        JSONObject lastData = this.data;
        if (lastData != null) {
            if (this.errorData) {
                this.logger.fail().tick();
            } else {
                ImportBillData billData = new ImportBillData(this.data, this.startEntryRowNum, currRowNum - 1, this.entityMapping);
                billData.setDataIndex(this.dataIndex);
                billData.setStartRowIndex(this.startEntryRowNum - this.startRowNum);
                this.addBillData(billData);
            }
            this.errorData = false;
        }
        this.data = new JSONObject();
        if (lastData != null) {
            for (Map.Entry fieldItem : lastData.entrySet()) {
                if (fieldItem.getValue() instanceof JSONArray) continue;
                this.data.put((String)fieldItem.getKey(), fieldItem.getValue());
            }
        }
        this.startEntryRowNum = currRowNum;
        return true;
    }

    private void addBillData(ImportBillData billData) {
        try {
            if (!this.dataQueue.offer(billData, 10L, TimeUnit.MINUTES)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u4e2d\u6570\u636e\u957f\u65f6\u95f4\u65e0\u6cd5\u4fdd\u5b58\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u6216\u68c0\u67e5%1$s\u63d2\u4ef6\u3002", (String)"BatchImportSheetHandler_6", (String)BOS_IMPORT, (Object[])new Object[0]));
            }
        }
        catch (Throwable e) {
            throw new KDBizException(e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", (String)"BatchImportSheetHandler_2", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.setInterrupt(this.currentRow != null);
        if (this.currentRow != null) {
            ImportBillData lastBillData;
            int currRowNum = this.currentRow.getRowNum();
            if (this.errorData) {
                this.logger.fail().tick();
                lastBillData = new ImportBillData(new JSONObject(), this.startRowNum, currRowNum);
            } else {
                lastBillData = new ImportBillData(this.data, this.startRowNum, currRowNum, this.entityMapping);
            }
            lastBillData.setDataIndex(this.dataIndex);
            lastBillData.setStartRowIndex(this.startEntryRowNum - this.startRowNum);
            lastBillData.setEmptyRowNum(this.emptyRowsInBillData.getOrDefault(this.dataIndex, 0));
            this.addBillData(lastBillData);
        }
        this.ctx.setResolveComplete(this.url);
        this.ctx.feedbackProgress(0, this.logger, null);
    }
}

