/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.impt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.beanutils.ConvertUtils;

public class ImportBigBillTask
extends BatchImportPlugin {
    private static final Log log = LogFactory.getLog(ImportBigBillTask.class);
    public static final String BOS_ENTITY_BUSINESS = "bos-entity-business";
    private MainEntityType mainType;
    private final Map<Integer, Object> successPKIds = new HashMap<Integer, Object>(1);
    private final Map<Integer, Boolean> billImportResult = new HashMap<Integer, Boolean>(1);
    private AbstractOperateWebApi appendRowWebApi = null;
    private List<String> keyFields = null;

    private MainEntityType getMainType() {
        if (this.mainType == null) {
            this.mainType = EntityMetadataCache.getDataEntityType((String)this.ctx.getBillFormId());
        }
        return this.mainType;
    }

    private AbstractOperateWebApi getAppendRowWebApi() {
        if (this.appendRowWebApi == null) {
            this.appendRowWebApi = (AbstractOperateWebApi)TypesContainer.createInstance((String)"kd.bos.entity.operate.webapi.AppendEntryRows");
        }
        return this.appendRowWebApi;
    }

    private boolean isAddNew() {
        return "new".equals(this.ctx.getOption().get("importtype"));
    }

    private List<String> getKeyFields() {
        if (this.keyFields != null) {
            return this.keyFields;
        }
        if (this.ctx == null || this.ctx.getOption() == null) {
            return new ArrayList<String>(0);
        }
        this.keyFields = new ArrayList<String>(1);
        List<Object> fieldkeys = new ArrayList();
        String keyfields = (String)this.ctx.getOption().get("KeyFields");
        if (StringUtils.isBlank((CharSequence)keyfields)) {
            return this.keyFields;
        }
        fieldkeys = Arrays.asList(keyfields.split(","));
        if (fieldkeys == null) {
            return this.keyFields;
        }
        for (int i = 0; i < fieldkeys.size(); ++i) {
            String field = (String)fieldkeys.get(i);
            if (!StringUtils.isNotBlank((CharSequence)field)) continue;
            this.keyFields.add(field);
        }
        return this.keyFields;
    }

    @Override
    protected int getBatchImportSize() {
        return 1;
    }

    @Override
    protected void resolveExcel() {
        this.ctx.setBatchByEntry(true);
        this.ctx.setBatchEntryRowSize(20000);
        super.resolveExcel();
    }

    @Override
    protected void importData() throws Throwable {
        super.importData();
        int total = this.billImportResult.size();
        int fail = 0;
        for (Map.Entry<Integer, Boolean> billResult : this.billImportResult.entrySet()) {
            if (billResult.getValue().booleanValue()) continue;
            ++fail;
        }
        this.ctx.feedbackProgress(100, total, fail);
    }

    @Override
    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        if (rowdatas.isEmpty()) {
            return null;
        }
        ApiResult apiResult = null;
        for (ImportBillData billData : rowdatas) {
            ApiResult apiResult2 = null;
            apiResult2 = billData.getStartRowIndex() == 0 ? (this.isAddNew() ? this.doSaveBillHead(billData) : this.doModify(billData)) : this.doAppendEntryRows(billData);
            apiResult = this.joinResult(apiResult, apiResult2);
        }
        return apiResult;
    }

    private ApiResult doSaveBillHead(ImportBillData billData) {
        ArrayList<JSONObject> bills = new ArrayList<JSONObject>(1);
        bills.add(billData.getData());
        JSONObject dataPack = new JSONObject();
        dataPack.put("datas", bills);
        dataPack.put("appid", (Object)this.ctx.getCheckRightAppId());
        dataPack.put("option", this.ctx.getOption());
        AbstractOperateWebApi webApi = this.getSaveWebApi();
        webApi.initialize(this.getBillFormId(), (Map)dataPack);
        ApiResult apiResult = webApi.execute();
        if (apiResult != null && apiResult.getSuccess()) {
            List billResults = (List)apiResult.getData();
            Map billResult = (Map)billResults.get(0);
            this.successPKIds.put(billData.getDataIndex(), billResult.get("id"));
            this.billImportResult.put(billData.getDataIndex(), true);
        } else {
            this.billImportResult.put(billData.getDataIndex(), false);
        }
        return apiResult;
    }

    private ApiResult doModify(ImportBillData billData) {
        String entryName = this.getAppendEntryName(billData);
        if (StringUtils.isBlank((CharSequence)entryName)) {
            return this.doSaveBillHead(billData);
        }
        JSONObject headData = billData.getData();
        JSONObject entryData = new JSONObject();
        for (Map.Entry fieldItem : headData.entrySet()) {
            if (fieldItem.getValue() instanceof JSONArray) continue;
            entryData.put((String)fieldItem.getKey(), fieldItem.getValue());
        }
        entryData.put(entryName, headData.get((Object)entryName));
        headData.remove((Object)entryName);
        try {
            Object pkValue = this.loadPKValue(billData);
            this.successPKIds.put(billData.getDataIndex(), pkValue);
            this.billImportResult.put(billData.getDataIndex(), true);
        }
        catch (ParseException exp) {
            return ApiResult.ex((Throwable)exp);
        }
        billData.setData(entryData);
        return this.doAppendEntryRows(billData);
    }

    private ApiResult doAppendEntryRows(ImportBillData billData) {
        Boolean lastSuccess = this.billImportResult.get(billData.getDataIndex());
        if (lastSuccess == null || !lastSuccess.booleanValue()) {
            return this.buildFailResult(billData);
        }
        String entryName = this.getAppendEntryName(billData);
        Object pkId = this.successPKIds.get(billData.getDataIndex());
        JSONObject dataPack = new JSONObject();
        dataPack.put("data", (Object)billData.getData());
        dataPack.put("appid", (Object)this.ctx.getCheckRightAppId());
        dataPack.put("option", this.ctx.getOption());
        dataPack.put("entryName", (Object)entryName);
        billData.getData().put("id", pkId);
        AbstractOperateWebApi webApi = this.getAppendRowWebApi();
        webApi.initialize(this.getBillFormId(), (Map)dataPack);
        ApiResult apiResult = webApi.execute();
        if (apiResult == null) {
            this.billImportResult.put(billData.getDataIndex(), false);
        } else {
            if (!apiResult.getSuccess()) {
                this.billImportResult.put(billData.getDataIndex(), false);
            }
            if (apiResult.getData() instanceof OperationResult) {
                OperationResult opResult = (OperationResult)apiResult.getData();
                ArrayList billResults = new ArrayList();
                HashMap<String, Object> billResult = new HashMap<String, Object>(1);
                billResult.put("success", !opResult.getSuccessPkIds().isEmpty());
                billResult.put("id", pkId);
                billResult.put("dindex", 0);
                billResult.put("message", opResult.getMessage());
                billResult.put("data", opResult.getAllErrorOrValidateInfo());
                billResults.add(billResult);
                apiResult.setData(billResults);
            } else if (apiResult.getData() instanceof Map) {
                ArrayList<Object> dataList = new ArrayList<Object>(1);
                dataList.add(apiResult.getData());
                apiResult.setData(dataList);
            }
        }
        return apiResult;
    }

    private String getAppendEntryName(ImportBillData billData) {
        int rowCount = 0;
        String entryName = null;
        for (Map.Entry entityItem : this.getMainType().getAllEntities().entrySet()) {
            Object entryRows;
            if (!billData.getData().containsKey(entityItem.getKey()) || !((entryRows = billData.getData().get(entityItem.getKey())) instanceof JSONArray) || rowCount >= ((JSONArray)entryRows).size()) continue;
            rowCount = ((JSONArray)entryRows).size();
            entryName = (String)entityItem.getKey();
        }
        return entryName;
    }

    private Object loadPKValue(ImportBillData billData) throws ParseException {
        List<QFilter> filters;
        MainEntityType dt = this.getMainType();
        Object pkValue = billData.getData().get((Object)"id");
        if (pkValue != null && pkValue.getClass() != dt.getPrimaryKey().getPropertyType()) {
            pkValue = ConvertUtils.convert((Object)pkValue, (Class)dt.getPrimaryKey().getPropertyType());
            billData.getData().put("id", pkValue);
        }
        if ((filters = this.buildFilter(billData)) == null || filters.isEmpty()) {
            return pkValue;
        }
        String selectFields = dt.getPrimaryKey().getName();
        HashSet<Object> pkValues = new HashSet<Object>(1);
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)("ImportBigBillTask.loadPKValue(" + dt.getName() + ")"), (String)dt.getName(), (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);){
            if (dataset.hasNext()) {
                Row row = dataset.next();
                pkValues.add(row.get(dt.getPrimaryKey().getName()));
            }
        }
        if (pkValues.isEmpty()) {
            log.debug("filters: " + this.qFilterToString(filters));
            throw new KDBizException(new ErrorCode("ImportBigBillTask_01", ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6ee1\u8db3\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"ImportBigBillTask_5", (String)"bos-import", (Object[])new Object[0])), new Object[]{""});
        }
        pkValue = pkValues.iterator().next();
        billData.getData().put("id", pkValue);
        return pkValue;
    }

    private List<QFilter> buildFilter(ImportBillData billData) throws ParseException {
        MainEntityType dt = this.getMainType();
        List<String> filterKeys = this.getKeyFields();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(filterKeys.size());
        int size = filterKeys.size();
        for (int i = 0; i < size; ++i) {
            String fieldKey = filterKeys.get(i);
            if (StringUtils.isBlank((CharSequence)fieldKey)) continue;
            DynamicProperty fieldProperty = dt.getProperty(fieldKey);
            boolean isBaseData = fieldProperty instanceof BasedataProp;
            Object tempVal = billData.getData().get((Object)fieldKey);
            if (isBaseData) {
                if (tempVal != null) {
                    Map tempMap = (Map)tempVal;
                    String dataType = tempMap.containsKey("id") ? "id" : (tempMap.containsKey("importprop") ? (String)tempMap.get("importprop") : (tempMap.containsKey("number") ? "number" : "name"));
                    tempVal = tempMap.get(dataType);
                    fieldKey = fieldKey + "." + dataType;
                } else {
                    BasedataProp basedataProp = (BasedataProp)fieldProperty;
                    PKFieldProp baseatePK = (PKFieldProp)basedataProp.getDynamicComplexPropertyType().getPrimaryKey();
                    tempVal = baseatePK.getDefValue();
                }
            } else if (tempVal == null) {
                tempVal = fieldProperty.getDefaultValue();
            } else if (fieldProperty instanceof MuliLangTextProp) {
                tempVal = LocaleString.fromMap((Map)((Map)tempVal)).toString();
            } else if (fieldProperty instanceof DateTimeProp && !(tempVal instanceof Date)) {
                tempVal = ((DateTimeProp)fieldProperty).getDateFormat().parse(tempVal.toString());
            }
            QFilter filter = new QFilter(fieldKey, "=", tempVal);
            filters.add(filter);
        }
        return filters;
    }

    private String qFilterToString(List<QFilter> qFilters) {
        StringBuilder sBuilder = new StringBuilder();
        for (int i = 0; i < qFilters.size(); ++i) {
            QFilter qFilter = qFilters.get(i);
            if (i == 0) {
                sBuilder.append(qFilter);
                continue;
            }
            sBuilder.append(" and ").append(qFilter);
        }
        return sBuilder.toString();
    }

    private ApiResult buildFailResult(ImportBillData billData) {
        ApiResult apiResult = new ApiResult();
        apiResult.setSuccess(false);
        ArrayList billResults = new ArrayList();
        HashMap<String, Object> billResult = new HashMap<String, Object>(1);
        billResult.put("success", Boolean.FALSE);
        billResult.put("dindex", 0);
        billResult.put("message", ResManager.loadKDString((String)"\u672c\u5355\u4e0a\u4e00\u6279\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u672c\u6279\u6570\u636e\u88ab\u5ffd\u7565", (String)"ImportBigBillTask_2", (String)BOS_ENTITY_BUSINESS, (Object[])new Object[0]));
        billResults.add(billResult);
        apiResult.setData(billResults);
        return apiResult;
    }

    private ApiResult joinResult(ApiResult result1, ApiResult result2) {
        if (result1 == null) {
            return result2;
        }
        if (result2 == null) {
            return result1;
        }
        List billResults1 = (List)result1.getData();
        List billResults2 = (List)result2.getData();
        billResults1.addAll(billResults2);
        return result1;
    }
}

