/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.impt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.MetadataServiceHelper;

public class ImportConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ImportConfig.class);
    private int LIMIT_FOR_ERROR_MESSAGE = 5000;
    public static final int BATCH_IMPORT_SIZE = 500;
    private boolean isNewFormatType = true;
    private IFormView view;
    private Object logId;
    private Map<String, LinkedBlockingQueue<ImportBillData>> dataQueues = new HashMap<String, LinkedBlockingQueue<ImportBillData>>();
    private CountDownLatch countDownLatch;
    private Boolean isFromTask = Boolean.FALSE;
    private String pageId;
    private String opSave;
    private JSONObject option = new JSONObject();
    private String appId;
    private String checkRightAppId;
    private Map<String, ImportLogger> urlLoggers = new HashMap<String, ImportLogger>();
    private MainEntityType entityType;
    private List<IImportPlugin> importPlugins = new ArrayList<IImportPlugin>();
    private final Set<String> completeUrls = new HashSet<String>();
    public static final String ImportCacheKey = "Cached_Import_Logger";

    public ImportConfig(IFormView view, ImportContext ctx) {
        this(view, ctx.getLogId());
    }

    public ImportConfig(IFormView view, ImportContext ctx, Boolean isFromTask, CountDownLatch countDownLatch) {
        this(view, ctx.getLogId());
        this.countDownLatch = countDownLatch;
        this.isFromTask = isFromTask;
    }

    public ImportConfig(IFormView view, Object logId) {
        this.view = view;
        this.logId = logId;
        Map params = view.getFormShowParameter().getCustomParams();
        this.appId = (String)params.get("ServiceAppId");
        this.checkRightAppId = (String)params.get("CheckRightAppId");
        String billFormId = (String)params.get("BillFormId");
        this.opSave = (String)params.get("OpSave");
        this.option.put("importtype", params.get("Type"));
        String keyfds = (String)params.get("KeyFields");
        if (StringUtils.isNotBlank((CharSequence)keyfds)) {
            this.option.put("KeyFields", (Object)keyfds);
        }
        this.option.put("ExtendData", params.get("ExtendData"));
        String url = (String)params.get("Url");
        ImportLogger importLogger = new ImportLogger(url);
        SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
        Object importMaxErrCount = systemParamService.loadPublicParameterFromCache("import_max_errcount");
        if (importMaxErrCount != null && StringUtils.isNumeric((CharSequence)importMaxErrCount.toString()) && Integer.parseInt(importMaxErrCount.toString()) > 0) {
            this.LIMIT_FOR_ERROR_MESSAGE = Integer.parseInt(importMaxErrCount.toString());
        }
        importLogger.setLimitForErrorMessage(this.LIMIT_FOR_ERROR_MESSAGE);
        this.urlLoggers.put(url, importLogger);
        this.dataQueues.put(url, new LinkedBlockingQueue(1500));
        String pluginName = (String)params.get("ImportPlugin");
        if (StringUtils.isNotBlank((CharSequence)pluginName)) {
            try {
                IImportPlugin p = (IImportPlugin)TypesContainer.createInstance((String)pluginName);
                HashMap<String, ImportConfig> importParams = new HashMap<String, ImportConfig>(params);
                importParams.put("ImportConf", this);
                p.init(importParams);
                if (this.entityType == null) {
                    this.entityType = p.getImportMainEntityType(billFormId);
                }
                this.importPlugins.add(p);
            }
            catch (KDBizException e) {
                log.error((Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u63d2\u4ef6%1$s\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff1a%2$s", (String)"ImportConfig_0", (String)"bos-import", (Object[])new Object[0]), pluginName, e.getMessage())), new Object[0]);
            }
            catch (Throwable e) {
                log.error(e);
                throw new KDBizException(e, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u63d2\u4ef6%1$s\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff1a%2$s", (String)"ImportConfig_0", (String)"bos-import", (Object[])new Object[0]), pluginName, ResManager.loadKDString((String)"\u8be6\u60c5\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"ImportConfig_1", (String)"bos-import", (Object[])new Object[0]))), new Object[0]);
            }
        }
        if (this.entityType == null) {
            this.entityType = MetadataServiceHelper.getDataEntityType((String)billFormId);
        }
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getOpSave() {
        return this.opSave;
    }

    public void setOpSave(String opSave) {
        this.opSave = opSave;
    }

    public JSONObject getOption() {
        return this.option != null ? this.option.clone() : null;
    }

    public void setOption(JSONObject option) {
        this.option = option;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Map<String, ImportLogger> getUrlLoggers() {
        return this.urlLoggers;
    }

    public void setUrlLoggers(Map<String, ImportLogger> urlLoggers) {
        this.urlLoggers = urlLoggers;
    }

    public List<IImportPlugin> getImportPlugins() {
        return this.importPlugins;
    }

    public void setImportPlugins(List<IImportPlugin> importPlugins) {
        this.importPlugins = importPlugins;
    }

    public Map<String, LinkedBlockingQueue<ImportBillData>> getDataQueues() {
        return this.dataQueues;
    }

    public void setDataQueues(Map<String, LinkedBlockingQueue<ImportBillData>> dataQueues) {
        this.dataQueues = dataQueues;
    }

    public MainEntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(MainEntityType entityType) {
        this.entityType = entityType;
    }

    public boolean isComplete(String key) {
        return this.completeUrls.contains(key);
    }

    public void setComplete(String url) {
        if (StringUtils.isNotBlank((CharSequence)url)) {
            this.completeUrls.add(url);
        }
    }

    public IFormView getView() {
        return this.view;
    }

    public void setView(IFormView view) {
        this.view = view;
    }

    public Object getLogId() {
        return this.logId;
    }

    public void setLogId(Object logId) {
        this.logId = logId;
    }

    public synchronized void feedbackProgress(int progress, ImportLogger logger, String errMsg) {
        JSONObject map;
        IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
        String cachedLogStr = cache.get(ImportCacheKey);
        JSONObject jSONObject = map = StringUtils.isNotBlank((CharSequence)cachedLogStr) ? JSON.parseObject((String)cachedLogStr) : new JSONObject();
        if (progress > map.getIntValue("progress")) {
            map.put("progress", (Object)progress);
        }
        if (logger != null) {
            int headRowCount = this.isNewFormatType ? 4 : 3;
            map.put("curRowNum", (Object)(logger.getRowIndex() + 1 - headRowCount));
            map.put("totalRowNum", (Object)(logger.getLastRowIndex() - headRowCount));
            map.put("total", (Object)logger.getTotal());
            map.put("succeed", (Object)logger.getDelRows().size());
            map.put("failed", (Object)logger.getFailed());
        }
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            map.put("err", (Object)errMsg);
        }
        cachedLogStr = JSON.toJSONString((Object)map);
        log.debug("Cached_Import_Logger---->" + cachedLogStr);
        cache.put(ImportCacheKey, cachedLogStr);
        cache.saveChanges();
    }

    public String getCheckRightAppId() {
        return this.checkRightAppId;
    }

    public void setCheckRightAppId(String checkRightAppId) {
        this.checkRightAppId = checkRightAppId;
    }

    public boolean isNewFormat() {
        return this.isNewFormatType;
    }

    public void setNewFormat(boolean newFormat) {
        this.isNewFormatType = newFormat;
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    public Boolean getFromTask() {
        return this.isFromTask;
    }
}

