/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.impt;

import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.UUID;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.io.FileUtils;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@SdkPublic
public class ExcelReader {
    private static final Log log = LogFactory.getLog(ExcelReader.class);

    public void read(InputStream in, SheetHandler sheetHandler) throws Exception {
        this.read(in, sheetHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream in, SheetHandler sheetHandler, boolean isValid) throws Exception {
        File tempFile = null;
        OPCPackage pkg = null;
        try {
            tempFile = File.createTempFile(UUID.randomUUID().toString(), "xlsx");
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
            pkg = OPCPackage.open((File)tempFile);
            XSSFReader r = new XSSFReader(pkg);
            r.setUseReadOnlySharedStringsTable(false);
            sheetHandler.setSharedStringsTable((SharedStringsTable)r.getSharedStringsTable());
            sheetHandler.setStylesTable(r.getStylesTable());
            XMLReader parser = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
            parser.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            parser.setFeature("http://xml.org/sax/features/external-general-entities", false);
            parser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            parser.setContentHandler(sheetHandler);
            XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
            HashSet<String> sheetNames = new HashSet<String>(16);
            while (sheets.hasNext()) {
                sheets.next();
                if (!StringUtils.isNotBlank((CharSequence)sheets.getSheetName())) continue;
                sheetNames.add(sheets.getSheetName());
            }
            sheetHandler.setSheetNames(sheetNames);
            sheets = (XSSFReader.SheetIterator)r.getSheetsData();
            CommonReaderWay readerWay = new CommonReaderWay(sheetHandler, parser, sheets);
            if (isValid) {
                readerWay = new SensitiveReaderWay(sheetHandler, parser, sheets);
            }
            while (sheets.hasNext()) {
                InputStream sheet = sheets.next();
                String sheetName = sheets.getSheetName();
                readerWay.handle(sheet, sheetName);
                if (!readerWay.interrupt(sheet, sheetName)) continue;
                break;
            }
        }
        finally {
            if (pkg != null) {
                pkg.revert();
            }
            FileSecurityUtil.safeDeleteFile((File)tempFile);
        }
    }

    class SensitiveReaderWay
    extends CommonReaderWay {
        private int count;

        public SensitiveReaderWay(SheetHandler sheetHandler, XMLReader parser, XSSFReader.SheetIterator sheets) {
            super(sheetHandler, parser, sheets);
            this.count = 0;
        }

        @Override
        public void handle(InputStream sheet, String sheetName) throws Exception {
            if (this.count++ == 0 || StringUtils.isNotBlank((CharSequence)sheetName) && StringUtils.equals((CharSequence)sheetName, (CharSequence)"sensitive_fields_sheet")) {
                try {
                    super.handle(sheet, sheetName);
                }
                catch (KDException e) {
                    ErrorCode errorCode = e.getErrorCode();
                    if (errorCode == null || StringUtils.equals((CharSequence)errorCode.getCode(), (CharSequence)"NEXT_SHEET")) {
                        // empty if block
                    }
                }
            }
        }

        @Override
        public boolean interrupt(InputStream sheet, String sheetName) {
            return false;
        }
    }

    class CommonReaderWay
    implements ReaderWay {
        protected SheetHandler sheetHandler;
        protected XMLReader parser;
        protected XSSFReader.SheetIterator sheets;

        public CommonReaderWay(SheetHandler sheetHandler, XMLReader parser, XSSFReader.SheetIterator sheets) {
            this.sheetHandler = sheetHandler;
            this.parser = parser;
            this.sheets = sheets;
        }

        @Override
        public void handle(InputStream sheet, String sheetName) throws Exception {
            InputSource sheetSource = new InputSource(sheet);
            if (StringUtils.isNotBlank((CharSequence)this.sheets.getSheetName())) {
                this.sheetHandler.setSheetName(this.sheets.getSheetName());
                Comments comments = this.sheets.getSheetComments();
                if (comments != null) {
                    this.sheetHandler.addSheetComments(this.sheets.getSheetName(), (CommentsTable)comments);
                }
                this.parser.parse(sheetSource);
                sheet.close();
            }
        }

        @Override
        public boolean interrupt(InputStream sheet, String sheetName) {
            if (StringUtils.isNotBlank((CharSequence)this.sheets.getSheetName())) {
                return this.sheetHandler.isInterrupt();
            }
            return true;
        }
    }

    static interface ReaderWay {
        public void handle(InputStream var1, String var2) throws Exception;

        public boolean interrupt(InputStream var1, String var2);
    }
}

