/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.background;

import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.event.ClickEventArgs;

public class MulImportTaskClick
extends AbstractTaskClick {
    private static final String IMPORT_RESULT_PK = "import_result_pk";
    private static final String BOS_MULTI_IMPORT_RESULT = "bos_multi_import_result";

    public void click(ClickEventArgs e) {
        super.click(e);
        TaskInfo taskInfo = this.queryTask();
        if (taskInfo == null) {
            return;
        }
        if (!taskInfo.isTaskEnd()) {
            this.showProgress();
        } else {
            this.showImportResult();
            e.setClearTask(true);
        }
        IFormView view = this.getParentView();
        if (view != null && !StringUtils.equals((CharSequence)this.getMainView().getPageId(), (CharSequence)view.getPageId())) {
            this.getMainView().sendFormAction(view);
        }
    }

    private void showProgress() {
        if (this.isExistProgressForm()) {
            return;
        }
        IFormView view = this.getParentView();
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (view == null || jobFormInfo == null) {
            this.getMainView().showMessage(ResManager.loadKDString((String)"\u542f\u52a8\u5bfc\u5165\u4efb\u52a1\u7684\u5217\u8868\u754c\u9762\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u518d\u6253\u5f00\u5bfc\u5165\u8fdb\u5ea6\u754c\u9762", (String)"ImportTaskClick_0", (String)"bos-import", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_multi_import_progress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Map customParams = showParameter.getCustomParams();
        customParams.putAll(jobFormInfo.getParams());
        customParams.put("import_mul_jobforminfo", SerializationUtils.toJsonString((Object)jobFormInfo));
        customParams.put("mul_import_taskid", this.getTaskId());
        view.showForm(showParameter);
        this.setProgressPageId(showParameter.getPageId());
    }

    private void showImportResult() {
        IFormView view = this.getParentView();
        if (view == null) {
            return;
        }
        String pkId = view.getPageCache().get(IMPORT_RESULT_PK);
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(BOS_MULTI_IMPORT_RESULT);
        parameter.setParentFormId(view.getFormShowParameter().getFormId());
        parameter.setParentPageId(view.getPageId());
        parameter.setPkId((Object)pkId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)parameter);
        view.sendFormAction(view);
    }
}

