/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.resolve.listerer;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelAnalysisException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import org.apache.commons.collections4.MapUtils;

public class LimitExcelReadListener
extends AnalysisEventListener<Map<Integer, String>> {
    private Integer startRow;
    private Integer startCol;
    private Integer limitRowSize;
    private Integer limitColSize;
    private boolean isIgnoreHeadEmptyRow = true;
    private List<Map<Integer, String>> headList = new ArrayList<Map<Integer, String>>();
    private List<Map<Integer, String>> dataList = new ArrayList<Map<Integer, String>>();

    public LimitExcelReadListener(Integer startRow, Integer startCol, Integer limitRowSize, Integer limitColSize) {
        this.startRow = startRow;
        this.startCol = startCol;
        this.limitRowSize = limitRowSize;
        this.limitColSize = limitColSize;
    }

    public LimitExcelReadListener(Integer startRow, Integer startCol, Integer limitRowSize, Integer limitColSize, boolean isIgnoreHeadEmptyRow) {
        this.startRow = startRow;
        this.startCol = startCol;
        this.limitRowSize = limitRowSize;
        this.limitColSize = limitColSize;
        this.isIgnoreHeadEmptyRow = isIgnoreHeadEmptyRow;
    }

    public List<Map<Integer, String>> getHeadList() {
        return this.headList;
    }

    public List<Map<Integer, String>> getDataList() {
        return this.dataList;
    }

    public void invoke(Map<Integer, String> sourceRowData, AnalysisContext context) {
        Integer curRowIndex = context.readRowHolder().getRowIndex();
        if (curRowIndex > this.startRow) {
            Map<Integer, String> newMap = this.getLimitColMap(sourceRowData);
            this.dataList.add(newMap);
        }
        if (this.dataList.size() >= this.limitRowSize) {
            throw new ExcelAnalysisException(String.format(ResManager.loadKDString((String)"%1$s\u884c%2$s\u5217\u8bfb\u53d6\u5b8c\u6210", (String)"BOS_IMPORT_15", (String)"bos-import", (Object[])new Object[0]), this.limitRowSize, this.limitColSize));
        }
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        Integer curRowIndex = context.readRowHolder().getRowIndex();
        if (!curRowIndex.equals(context.readSheetHolder().getHeadRowNumber() - 1)) {
            return;
        }
        if (this.isIgnoreHeadEmptyRow && MapUtils.isEmpty(headMap)) {
            return;
        }
        Map<Integer, String> newMap = this.getLimitColMap(headMap);
        this.headList.add(newMap);
    }

    private Map<Integer, String> getLimitColMap(Map<Integer, String> sourceRowData) {
        Integer size = sourceRowData.size();
        size = size >= this.limitColSize ? this.limitColSize : size;
        HashMap<Integer, String> rowData = new HashMap<Integer, String>(8);
        for (int i = this.startCol.intValue(); i < size; ++i) {
            rowData.put(i, sourceRowData.get(i));
        }
        return rowData;
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
    }
}

