/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.resolve.service;

import com.alibaba.excel.support.ExcelTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.background.MulImportProgress;
import kd.bos.mulimport.background.MulImportProgressImpl;
import kd.bos.mulimport.resolve.context.MulImportContext;
import kd.bos.mulimport.resolve.model.MulBuildEntryResult;
import kd.bos.mulimport.resolve.model.MulEntityImportingInfo;
import kd.bos.mulimport.resolve.model.MulImportDataMappingRule;
import kd.bos.mulimport.resolve.model.MulImportResolveTypeEnum;
import kd.bos.mulimport.resolve.model.MulImportTypeEnum;
import kd.bos.mulimport.resolve.service.MulErrorFileCreateService;
import kd.bos.mulimport.resolve.service.MulImportCollectService;
import kd.bos.mulimport.resolve.service.MulImportConvertService;
import kd.bos.mulimport.result.model.MulEntityImportResult;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.ORM;
import kd.bos.schedule.executor.AbstractTask;
import org.apache.commons.collections4.CollectionUtils;

public class MulImportService
extends AbstractTask {
    public static final String FAILREASON = "failreason_tag";
    private static final Log log = LogFactory.getLog(MulImportService.class);
    private static final String CACHE_KEY_IMPORT_RESULT_PK = "import_result_pk";
    private static final String OBJ_NAME = "objname";
    private static final String BILLSTATUS = "billstatus";
    private static final String TOTAL = "total";
    private static final String FAILED = "failed";
    private static final String IMPORTSTATUS = "importstatus";
    private static final String CREATETIME = "createtime";
    private static final String ENDTIME = "modifytime";
    private static final String USETIME = "usetime";
    private static final String CONTRACTFAILEDNUM = "contractfailednum";
    private static final String BILLNO = "billno";
    private static final String CREATOR = "creator";
    private static final String BOS_MULTI_IMPORT_RESULT = "bos_multi_import_result";
    private static final String NAME = "name";
    private static final String SEQ = "seq";
    private static final String DATASHEET_NAME = "datasheetname";
    private static final String IMPORT_TYPE = "importtype";
    private static final String DATA_REPLACE_RULE_FIELD = "datareplacerulefield";
    private static final String ENTRY_TOTAL = "entrytotal";
    private static final String FAILED_NUMBER = "failednumber";
    private static final String TREE_ENTRY_ID = "multi_import_result_tree";
    private static final String PID = "pid";
    private static final String ID = "id";
    public static final String SUB_ENTRY = "multi_import_res_subtree";
    private MulImportContext mulImportContext;
    private MulImportConvertService convertService;
    private MulImportCollectService collectService;
    private String CACHE_KEY_IMPORTSTATUS = "cache_key_importStatus";
    private String CACHE_KEY_HASIGNORESHEETNAME = "cache_key_hasIgnoreSheetName";
    private String CACHE_KEY_ErrorFile_Url = "cache_key_errorfile_url";
    private String CACHE_KEY_CHOOSE_FIRST_IMPORT = "chooseFirstImport";
    private String taskId = "";
    private MulImportProgress importProgress;
    private Boolean isFromTask = Boolean.FALSE;
    private static final String BOS_IMPORT = "bos-import";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.isFromTask = Boolean.TRUE;
        long startTime = new Date().getTime();
        String path = String.valueOf(map.get("mul_import_file_path"));
        String importStartPageId = String.valueOf(map.get("importStartPageId"));
        String billNo = String.valueOf(map.get("importResultBillNo"));
        String schemeNumber = map.get("schemeNumber") == null ? null : map.get("schemeNumber").toString();
        SessionManager sm = SessionManager.getCurrent();
        sm.setRequestThread(true);
        IFormView view = sm.getView(importStartPageId);
        try {
            List rules = (List)SerializationUtils.deSerializeFromBase64((String)((String)map.get("MulImportDataMappingRulesStr")));
            ArrayList<MulImportDataMappingRule> firstRuleList = new ArrayList<MulImportDataMappingRule>();
            ArrayList<MulImportDataMappingRule> ruleList = new ArrayList<MulImportDataMappingRule>();
            this.buildContext(schemeNumber, path, view, rules);
            if (CollectionUtils.isNotEmpty((Collection)rules) && rules.stream().filter(i -> i.getMulImportResolveTypeEnum() == MulImportResolveTypeEnum.HEAD).count() > 1L && ((MulImportDataMappingRule)rules.get(0)).getFirstImport()) {
                view.getPageCache().put(this.CACHE_KEY_CHOOSE_FIRST_IMPORT, "true");
                MulImportDataMappingRule mainRule = (MulImportDataMappingRule)rules.get(0);
                String firstRuleMainEntityNumber = mainRule.getMainEntityNumber();
                for (MulImportDataMappingRule rule : rules) {
                    if (StringUtils.equals((CharSequence)rule.getMainEntityNumber(), (CharSequence)firstRuleMainEntityNumber)) {
                        firstRuleList.add(rule);
                        continue;
                    }
                    ruleList.add(rule);
                }
                this.mulImportContext.setMulImportDataMappingRuleList(firstRuleList);
                this.collectService.collect();
                this.collectService.loadBaseData();
                this.collectService.loadUpdateDataSource();
                this.convertService.convert();
                this.mulImportContext.setMulImportDataMappingRuleList(ruleList);
            }
            this.collectService.collect();
            this.collectService.loadBaseData();
            this.collectService.loadUpdateDataSource();
            this.convertService.convert();
            this.createImportResult(startTime, billNo, rules, view);
        }
        catch (Throwable e) {
            log.error(ResManager.loadKDString((String)"\u5bfc\u5165\u5f02\u5e38\u3002", (String)"BatchImportPlugin_14", (String)BOS_IMPORT, (Object[])new Object[0]), e);
            this.mulImportContext.feedbackProgress("error");
            throw e;
        }
        finally {
            if (this.convertService != null) {
                this.convertService.deleteExcel();
            }
        }
    }

    private void createImportResult(long startTime, String billNo, List<MulImportDataMappingRule> rules, IFormView view) {
        this.mulImportContext.setMulImportDataMappingRuleList(rules);
        String pkId = this.createImportResultDetail(startTime, billNo, rules, view);
        new MulErrorFileCreateService(this.mulImportContext, this.mulImportContext.getEntityImportResult()).creatErrorFile();
        ArrayList<MulEntityImportingInfo> importStatusModels = new ArrayList<MulEntityImportingInfo>(8);
        ArrayList<String> hasIgnoreSheetName = new ArrayList<String>(8);
        int index = 0;
        for (Map.Entry<String, MulEntityImportResult> importResultEntry : this.mulImportContext.getEntityImportResult().entrySet()) {
            MulEntityImportResult importResult = importResultEntry.getValue();
            EntityType entityType = importResult.getEntityType();
            String entityName = importResult.getEntityName();
            int total = importResult.getTotalRowsIndex().size();
            int covertDataSize = importResult.getCovertRows().size();
            int ignore = total - covertDataSize;
            int failed = importResult.getFailed();
            int success = importResult.getSuccessRows().size();
            if (ignore > 0) {
                hasIgnoreSheetName.add(importResult.getDataSheetName());
            }
            if (entityType instanceof EntryType) continue;
            importStatusModels.add(new MulEntityImportingInfo(covertDataSize, entityType.getName(), entityName, total, success, failed, index++));
        }
        IPageCache pageCache = view.getPageCache();
        pageCache.put(this.CACHE_KEY_IMPORTSTATUS, SerializationUtils.toJsonString(importStatusModels));
        pageCache.put(this.CACHE_KEY_HASIGNORESHEETNAME, SerializationUtils.toJsonString(hasIgnoreSheetName));
        pageCache.put(this.CACHE_KEY_ErrorFile_Url, this.mulImportContext.getErrorFileUrl());
        pageCache.put(CACHE_KEY_IMPORT_RESULT_PK, pkId);
        this.mulImportContext.feedbackProgress("finish");
    }

    private void buildContext(String schemeNumber, String path, IFormView view, List<MulImportDataMappingRule> dataMappingRuleList) {
        this.mulImportContext = new MulImportContext(path, ExcelTypeEnum.XLSX, view, dataMappingRuleList);
        this.mulImportContext.setExcelTypeEnum(ExcelTypeEnum.XLSX);
        this.mulImportContext.setFileUrl(path);
        this.mulImportContext.setFileName(view.getPageCache().get("filename"));
        this.mulImportContext.setSchemeNumber(schemeNumber);
        this.mulImportContext.setImportProgress(this.getMulImportProgress());
        this.convertService = new MulImportConvertService(this.mulImportContext, true);
        this.collectService = new MulImportCollectService(this.mulImportContext);
    }

    private String createImportResultDetail(long startTime, String billNo, List<MulImportDataMappingRule> dataMappingRuleList, IFormView view) {
        long endTime = new Date().getTime();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)BOS_MULTI_IMPORT_RESULT);
        DynamicObject dyn = (DynamicObject)entityType.createInstance();
        dyn.set(BILLNO, (Object)billNo);
        dyn.set(CREATOR, (Object)RequestContext.get().getCurrUserId());
        dyn.set(CREATETIME, (Object)startTime);
        dyn.set(ENDTIME, (Object)new Date().getTime());
        dyn.set(USETIME, (Object)this.convertLongToSeconds(endTime - startTime));
        dyn.set(OBJ_NAME, (Object)this.genBusinessNumber(dataMappingRuleList));
        dyn.set(IMPORTSTATUS, (Object)"1");
        dyn.set(BILLSTATUS, (Object)"A");
        MulBuildEntryResult result = this.buildEntry(dyn, dataMappingRuleList);
        dyn.set(TOTAL, (Object)result.getTotal());
        dyn.set(FAILED, (Object)result.getFailed());
        dyn = (DynamicObject)BusinessDataWriter.save((IDataEntityType)entityType, (Object[])new Object[]{dyn})[0];
        return String.valueOf(dyn.getPkValue());
    }

    private String genBusinessNumber(List<MulImportDataMappingRule> dataMappingRuleList) {
        LinkedHashSet<String> billNumber = new LinkedHashSet<String>(8);
        for (MulImportDataMappingRule rule : dataMappingRuleList) {
            billNumber.add(rule.getMainEntityNumber());
        }
        return SerializationUtils.toJsonString(billNumber);
    }

    private MulBuildEntryResult buildEntry(DynamicObject dyn, List<MulImportDataMappingRule> dataMappingRuleList) {
        MulBuildEntryResult result = new MulBuildEntryResult();
        DynamicObjectCollection treeEntryEntity = (DynamicObjectCollection)dyn.get(TREE_ENTRY_ID);
        long lastId = 0L;
        long lastRootId = 0L;
        long lastEntryId = 0L;
        String lastEntityNumber = "";
        int seq = 1;
        for (MulImportDataMappingRule rule : dataMappingRuleList) {
            String entityName = rule.getEntityType().getDisplayName().getLocaleValue();
            String entityNumber = rule.getCurrentEntityNumber();
            entityName = entityName + "\uff08" + entityNumber + "\uff09";
            String dataSheetName = rule.getDataSheetName();
            MulImportTypeEnum importType = rule.getImportType();
            String dataReplaceRuleField = rule.getDataReplaceRuleField();
            dataReplaceRuleField = StringUtils.isBlank((CharSequence)dataReplaceRuleField) ? "" : rule.getEntityType().getProperty(dataReplaceRuleField).getDisplayName().getLocaleValue();
            MulEntityImportResult entityImportResult = this.mulImportContext.getEntityImportResult().get(rule.getCurrentUniqueEntityKey());
            int total = entityImportResult.getTotalRowsIndex().size();
            result.addTotal(total);
            int failed = entityImportResult.getFailed();
            result.addFailed(failed);
            DynamicObject entryRowData = new DynamicObject(treeEntryEntity.getDynamicObjectType());
            entryRowData.set(NAME, (Object)this.genEntityJson(rule.getMainEntityNumber(), rule.getCurrentEntityNumber()));
            entryRowData.set(SEQ, (Object)seq++);
            entryRowData.set(DATASHEET_NAME, (Object)dataSheetName);
            entryRowData.set(IMPORT_TYPE, (Object)importType.getType());
            entryRowData.set(DATA_REPLACE_RULE_FIELD, (Object)dataReplaceRuleField);
            entryRowData.set(ENTRY_TOTAL, (Object)total);
            entryRowData.set(FAILED_NUMBER, (Object)failed);
            entryRowData.set(CONTRACTFAILEDNUM, (Object)(total - entityImportResult.getCovertRows().size()));
            this.createResultSubEntry(entryRowData, entityImportResult.getRowErrorInfos());
            EntityType entityType = rule.getEntityType();
            long[] curArr = ORM.create().genLongIds((IDataEntityType)treeEntryEntity.getDynamicObjectType(), 1);
            long curId = curArr[0];
            entryRowData.set(ID, (Object)curId);
            lastId = curId;
            lastEntityNumber = entityName;
            if (entityType instanceof SubEntryType) {
                if (entityType.getParent().getName().equals(lastEntityNumber)) {
                    entryRowData.set(PID, (Object)lastId);
                } else {
                    entryRowData.set(PID, (Object)lastEntryId);
                }
            } else if (entityType instanceof EntryType) {
                if (entityType.getParent().getName().equals(lastEntityNumber)) {
                    entryRowData.set(PID, (Object)lastId);
                } else {
                    entryRowData.set(PID, (Object)lastRootId);
                }
                lastEntryId = curId;
            } else {
                lastRootId = curId;
            }
            treeEntryEntity.add((Object)entryRowData);
        }
        return result;
    }

    private String genEntityJson(String mainEntityNumber, String currentEntityNumber) {
        HashMap<String, String> entryMap = new HashMap<String, String>();
        entryMap.put("mainEntityNumber", mainEntityNumber);
        entryMap.put("entityNumber", currentEntityNumber);
        return SerializationUtils.toJsonString(entryMap);
    }

    private void createResultSubEntry(DynamicObject entryRowData, Map<Integer, List<String>> entityResultInfo) {
        DynamicObjectCollection subEntry = (DynamicObjectCollection)entryRowData.get(SUB_ENTRY);
        int seq = 1;
        for (Map.Entry<Integer, List<String>> resultEntry : entityResultInfo.entrySet()) {
            DynamicObject subRow = subEntry.addNew();
            Integer dataRowIndex = resultEntry.getKey();
            List<String> resultInfo = resultEntry.getValue();
            StringBuilder sb = new StringBuilder();
            for (String info : resultInfo) {
                sb.append(info).append("\r\n");
            }
            subRow.set("row", (Object)dataRowIndex);
            subRow.set(FAILREASON, (Object)sb);
            subRow.set(SEQ, (Object)seq++);
        }
    }

    private int convertLongToSeconds(long timeInMillis) {
        double seconds = (double)timeInMillis / 1000.0;
        return (int)Math.round(seconds);
    }

    public void setTaskId(String id) {
        this.taskId = id;
    }

    private MulImportProgress getMulImportProgress() {
        if (this.importProgress == null && this.isFromTask.booleanValue() && StringUtils.isNotBlank((CharSequence)this.taskId)) {
            this.importProgress = new MulImportProgressImpl(this.taskId);
        }
        return this.importProgress;
    }
}

