/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.result.plugin;

import java.util.Comparator;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class MulImportResultPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
IConfirmCallBack {
    private static final String FAILREASON = "failreason_tag";
    private static final String BAR_CONTINUEIMPORT = "continueimport";
    private static final String TREE_ENTRY_ID = "multi_import_result_tree";
    private static final String FAILEDREASONLINK = "failedreasonlink";
    private static final String BOS_MUL_IMP_RESULT_DETAIL = "bos_mul_imp_result_detail";
    private static final String ENTRY = "multi_import_result_tree";
    private static final String SUB_ENTRY = "multi_import_res_subtree";
    private static final String BOS_IMPORT = "bos-import";
    private static final String OBJ_NAME = "objname";
    private static final String NAME = "name";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("multi_import_result_tree");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (!StringUtils.equals((CharSequence)BAR_CONTINUEIMPORT, (CharSequence)itemKey)) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String importStartPageId = formShowParameter.getParentPageId();
        IFormView importStartView = this.getView().getView(importStartPageId);
        if (importStartView == null) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bos_multi_importstart");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
            return;
        }
        Tab tab = (Tab)importStartView.getControl("guidecontent");
        tab.activeTab("tabpageap");
        importStartView.activate();
        this.getView().sendFormAction(importStartView);
    }

    public void afterBindData(EventObject e) {
        String objName;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String parentFormId = formShowParameter.getParentFormId();
        if (!StringUtils.equals((CharSequence)parentFormId, (CharSequence)"bos_multi_importstart")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BAR_CONTINUEIMPORT});
        }
        if (StringUtils.isNotBlank((CharSequence)(objName = String.valueOf(this.getView().getModel().getValue(OBJ_NAME))))) {
            Set billNumbers = (Set)SerializationUtils.fromJsonString((String)objName, Set.class);
            StringBuilder showBillName = new StringBuilder();
            for (String billNumber : billNumbers) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
                String billNameLocaleValue = dataEntityType.getDisplayName().getLocaleValue();
                showBillName.append(billNameLocaleValue).append("\u3001");
            }
            showBillName.deleteCharAt(showBillName.length() - 1);
            this.getView().getModel().setValue(OBJ_NAME, (Object)showBillName.toString());
        }
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl("multi_import_result_tree");
        entryGrid.setCollapse(false);
        DynamicObjectCollection entryCollection = this.getModel().getDataEntity().getDynamicObjectCollection("multi_import_result_tree");
        for (int rowIndex = 0; rowIndex < entryCollection.size(); ++rowIndex) {
            DynamicObject dynamicObject;
            String entityNumberStr;
            int failedNumber = (Integer)this.getView().getModel().getValue("failednumber", rowIndex);
            if (failedNumber > 0) {
                this.getView().getModel().setValue(FAILEDREASONLINK, (Object)ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"MulImportResultPlugin_0", (String)BOS_IMPORT, (Object[])new Object[0]), rowIndex);
            }
            if (!StringUtils.isNotBlank((CharSequence)(entityNumberStr = (dynamicObject = (DynamicObject)entryCollection.get(rowIndex)).getString(NAME)))) continue;
            Map nameMap = (Map)SerializationUtils.fromJsonString((String)entityNumberStr, Map.class);
            String mainEntityNumber = (String)nameMap.get("mainEntityNumber");
            String entityNumber = (String)nameMap.get("entityNumber");
            EntityType entityType = (EntityType)EntityMetadataCache.getDataEntityType((String)mainEntityNumber).getAllEntities().get(entityNumber);
            this.getView().getModel().setValue(NAME, (Object)entityType.getDisplayName().getLocaleValue(), rowIndex);
        }
        this.getView().updateView("multi_import_result_tree");
        this.getModel().setDataChanged(false);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if (e.getFieldName().equals(FAILEDREASONLINK)) {
            int rowIndex = e.getRowIndex();
            DynamicObjectCollection entryCollection = (DynamicObjectCollection)this.getView().getModel().getDataEntity(true).get("multi_import_result_tree");
            DynamicObject entryDym = (DynamicObject)entryCollection.get(rowIndex);
            DynamicObjectCollection subEntryCollection = (DynamicObjectCollection)entryDym.get(SUB_ENTRY);
            LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
            Comparator<DynamicObject> rowIndexComparator = Comparator.comparing(dym -> dym.getInt("row"));
            subEntryCollection.sort(rowIndexComparator);
            for (DynamicObject rowInfo : subEntryCollection) {
                Integer row = rowInfo.getInt("row") + 1;
                String failReason = rowInfo.getString(FAILREASON);
                map.put(row, failReason);
            }
            this.showEndForm(map);
        }
    }

    private void showEndForm(Map<Integer, String> rowInfo) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(BOS_MUL_IMP_RESULT_DETAIL);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCustomParam("rowInfo", (Object)SerializationUtils.toJsonString(rowInfo));
        this.getView().showForm(showParameter);
    }
}

