/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.schemeplugin;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mulimport.schemeplugin.model.SchemeOpenTypeEnum;
import kd.bos.mulimport.stepplugin.MulImportAutoDeleteFile;

public class MulImportSchemeListPlugin
extends AbstractListPlugin {
    private static final String BOS_IMPORT = "bos-import";

    public void beforeItemClick(BeforeItemClickEvent event) {
        String key = event.getItemKey();
        if ("tblcopy".equals(key) || "tblimport".equals(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            if (rows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ImportLogDeleteFileListPlugin_5", (String)BOS_IMPORT, (Object[])new Object[0]));
                event.setCancel(true);
            } else if (rows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u65b9\u6848\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MulImportSchemePlugin_6", (String)BOS_IMPORT, (Object[])new Object[0]));
                event.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("tblnew".equals(key)) {
            this.showScheme(null, SchemeOpenTypeEnum.NEW.getType());
        } else if ("tblcopy".equals(key) || "tblimport".equals(key)) {
            int openType = "tblcopy".equals(key) ? SchemeOpenTypeEnum.COPY.getType() : SchemeOpenTypeEnum.IMPORT.getType();
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            Object id = rows.get(0).getPrimaryKeyValue();
            this.showScheme(id, openType);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        boolean isFromF7;
        if (this.getView().getFormShowParameter() instanceof ListShowParameter && (isFromF7 = ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp())) {
            return;
        }
        args.setCancel(true);
        BillList billList = (BillList)this.getControl("billlistap");
        this.showScheme(billList.getFocusRowPkId(), SchemeOpenTypeEnum.OPEN.getType());
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        qFilters.removeIf(qFilter -> qFilter.getProperty().equalsIgnoreCase("status"));
    }

    private void showScheme(Object id, int type) {
        this.getView().showForm(this.getSchemeShowParameter(id, type));
    }

    private FormShowParameter getSchemeShowParameter(Object id, int type) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_multi_importstart");
        showParameter.setCloseCallBack(new CloseCallBack(MulImportAutoDeleteFile.class.getName(), "closeMulImportTab"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (null != id) {
            params.put("id", id);
        } else {
            params.put("newScheme", "1");
            showParameter.setCaption(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5bfc\u5165\u65b9\u6848_\u65b0\u589e", (String)"MulImportSchemePlugin_1", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        showParameter.setCustomParam("schemeParam", params);
        showParameter.setCustomParam("schemeOpenType", (Object)type);
        return showParameter;
    }
}

