/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.stepplugin;

import com.alibaba.excel.support.ExcelTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AttachmentCountProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.PrintCountProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.SignatureProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.SuffixIcon;
import kd.bos.entity.tree.SuffixIconProps;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.tree.TreeNodePartialVariables;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.id.ID;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.mulimport.resolve.context.MulImportContext;
import kd.bos.mulimport.resolve.context.MulImportPreviewContext;
import kd.bos.mulimport.resolve.model.MulDynamicColElement;
import kd.bos.mulimport.resolve.model.MulDynamicColEntryElement;
import kd.bos.mulimport.resolve.model.MulDynamicColTextElement;
import kd.bos.mulimport.resolve.model.MulFieldInfo;
import kd.bos.mulimport.resolve.model.MulFieldMappingCacheVo;
import kd.bos.mulimport.resolve.model.MulFieldTypeEnum;
import kd.bos.mulimport.resolve.model.MulImportCollectTypeEnum;
import kd.bos.mulimport.resolve.model.MulImportPropConvertSeq;
import kd.bos.mulimport.resolve.model.MulImportResolveTypeEnum;
import kd.bos.mulimport.resolve.model.MulNodeDetailVo;
import kd.bos.mulimport.resolve.model.MulNodeFieldMap;
import kd.bos.mulimport.resolve.model.MulOneFieldMappingVo;
import kd.bos.mulimport.resolve.model.PreviewResolveParam;
import kd.bos.mulimport.resolve.service.MulImportPreviewResolveService;
import kd.bos.mulimport.stepplugin.MulImportStepTwoPlugin;
import kd.bos.mulimport.stepplugin.util.MulImportSearch;
import kd.bos.mulimport.stepplugin.util.MulImportStepPluginUtil;
import kd.bos.mulimport.stepplugin.util.SearchResult;
import kd.bos.mulimport.stepplugin.util.proxy.StrSimilarityProxy;
import kd.bos.mulimport.stepplugin.util.proxy.StrSimilarityResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class MulImportStepThreePlugin
extends MulImportStepTwoPlugin
implements TreeNodeClickListener,
SearchEnterListener,
TreeNodeQueryListener {
    private static final Log log = LogFactory.getLog(MulImportStepThreePlugin.class);
    private static final int NOT_NODE = 0;
    private static final int HAS_NEXT = 1;
    private static final int HAS_ALL = 2;
    private static final int HAS_PREV = 3;
    private DynamicObject currentSchemeDyn;
    private Map<String, Long> schemeNodeMap;
    MulImportPreviewContext previewContext;
    private final String ENTRY_ID = "import_result_entry";
    private final String EXCEL_FIELD = "excelfield";
    private final String IS_MAPPING = "ismapping";
    private final String COLOR_GREEN = "#1BA854";
    private final String COLOR_RED = "#999999";
    private static final String SCHEME_STARTCOLUMN = "startcol";

    @Override
    public void tabSelected(TabSelectEvent tabSelectEvent) {
        super.tabSelected(tabSelectEvent);
        String tabKey = tabSelectEvent.getTabKey();
        if ("tabpageap2".equals(tabKey)) {
            this.initSchemeNodeMap();
            this.fieldMappingPageBuildTree();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.getView().getPageCache().put("mul_import_propertyChanged_source", "tabSelected");
        MulImportStepPluginUtil.cacheBeforeTreeInfo(this.getView(), this.getModel());
        this.getModel().beginInit();
        this.getModel().deleteEntryData("fieldmapppingentry");
        this.getModel().endInit();
        String nodeId = (String)evt.getNodeId();
        this.getView().getPageCache().put("currentNodeId", nodeId);
        this.showOrHiddenRelationField(nodeId);
        this.buildOneNodeEntry(nodeId, true);
        this.getView().updateView();
        super.setLock();
        this.getView().getPageCache().remove("mul_import_propertyChanged_source");
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        String tabKey = this.getCurrentTab();
        if (StringUtils.equals((CharSequence)"tabpageap2", (CharSequence)tabKey)) {
            if ("baritenext".equals(key)) {
                this.next();
            } else if ("bariteprev".equals(key)) {
                this.previous();
            }
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        String currentTab;
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if (("baritenext".equals(key) || "bariteprev".equals(key)) && "tabpageap2".equals(currentTab = this.getCurrentTab())) {
            MulImportStepPluginUtil.cacheCurrentTreeInfo(null, this.getView(), this.getModel(), null);
            if ("baritenext".equals(key)) {
                if (this.checkData()) {
                    evt.setCancel(true);
                    this.setWizardStatus(2, "error");
                    return;
                }
                this.setWizardStatus(2, "finish");
                this.setWizardStatus(3, "");
                try {
                    this.cacheCustomEntryElement();
                }
                catch (Exception e) {
                    log.info("kd.bos.mulimport.resolve.stepplugin.MulImportStepThreePlugin.beforeItemClick", (Object)e);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6784\u5efa\u9884\u89c8\u6570\u636e\u5f02\u5e38\u3002", (String)"MulImportStepPlugin_33", (String)"bos-import", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String changedName = e.getProperty().getName();
        if ("excelfield".equals(changedName)) {
            ChangeData changeData = e.getChangeSet()[0];
            Object newValue = changeData.getNewValue();
            if (StringUtils.isNotBlank((Object)newValue)) {
                this.getModel().setValue("ismapping", (Object)1, changeData.getRowIndex());
                this.setFieldColor(changeData.getRowIndex(), "ismapping", "#1BA854");
            } else {
                this.getModel().setValue("ismapping", (Object)0, changeData.getRowIndex());
                this.setFieldColor(changeData.getRowIndex(), "ismapping", "#999999");
            }
        } else if ("withsuperrelation".equals(changedName) || "withlowerrelation".equals(changedName)) {
            boolean superEmpty;
            String currentNodeId = this.getView().getPageCache().get("currentNodeId");
            if (StringUtils.isBlank((CharSequence)currentNodeId)) {
                log.error("get current node id is empty");
                return;
            }
            int nodeLevel = this.nodeLevel(Integer.parseInt(currentNodeId));
            Object lowerField = this.getModel().getValue("withlowerrelation");
            Object superField = this.getModel().getValue("withsuperrelation");
            boolean lowerEmpty = StringUtils.isBlank((Object)lowerField) || StringUtils.equals((CharSequence)"-1", (CharSequence)lowerField.toString());
            boolean bl = superEmpty = StringUtils.isBlank((Object)superField) || StringUtils.equals((CharSequence)"-1", (CharSequence)superField.toString());
            if (nodeLevel == 1) {
                this.setIconForTree(currentNodeId, lowerEmpty);
            } else if (nodeLevel == 2) {
                this.setIconForTree(currentNodeId, lowerEmpty || superEmpty);
            } else if (nodeLevel == 3) {
                this.setIconForTree(currentNodeId, superEmpty);
            } else {
                this.setIconForTree(currentNodeId, false);
            }
        }
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u641c\u7d22\u5230\u76f8\u5173\u7ed3\u679c\u3002", (String)"MulImportStepPlugin_11", (String)"bos-import", (Object[])new Object[0]));
            return;
        }
        TreeView tree = (TreeView)this.getView().getControl("entitychoosetree");
        MulImportSearch mulImportSearch = new MulImportSearch();
        String searchUtilJson = this.getPageCache().get("searchUtil");
        if (searchUtilJson != null) {
            mulImportSearch = (MulImportSearch)SerializationUtils.fromJsonString((String)searchUtilJson, MulImportSearch.class);
        } else {
            List roots = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("mul_import_tree_cache"), TreeNode.class);
            mulImportSearch.setRoots(roots);
        }
        SearchResult searchResult = mulImportSearch.search(searchText);
        this.getPageCache().put("searchUtil", SerializationUtils.toJsonString((Object)mulImportSearch));
        if (searchResult.isSuccess()) {
            TreeNode searchedNode = searchResult.getData();
            tree.focusNode(searchedNode);
            tree.treeNodeClick(searchedNode.getParentid(), searchedNode.getId());
            return;
        }
        if (searchResult.getErrorCode() == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u641c\u7d22\u5230\u76f8\u5173\u7ed3\u679c\u3002", (String)"MulImportStepPlugin_12", (String)"bos-import", (Object[])new Object[0]));
            return;
        }
        if (searchResult.getErrorCode() == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b8c\u6210\u641c\u7d22\u3002", (String)"MulImportStepPlugin_13", (String)"bos-import", (Object[])new Object[0]));
            mulImportSearch.clear(searchText);
            this.getPageCache().put("searchUtil", SerializationUtils.toJsonString((Object)mulImportSearch));
        }
    }

    public List<String> getSearchList(SearchEnterEvent evt) {
        return super.getSearchList(evt);
    }

    public List<Object> getComPlexSearchList(SearchEnterEvent evt) {
        return super.getComPlexSearchList(evt);
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("MAPPING_FIELD_SHOW".equals(actionId)) {
            List retData = (List)closedCallBackEvent.getReturnData();
            if (retData != null) {
                int currentIndex = this.getModel().getEntryCurrentRowIndex("fieldmapppingentry");
                Object fieldNumber = this.getModel().getValue("formfield", currentIndex);
                if (!ObjectUtils.isEmpty((Object)fieldNumber)) {
                    this.setMappingFieldProps(fieldNumber.toString(), retData, currentIndex);
                }
            }
        } else if (StringUtils.equals((CharSequence)"show_scheme_save", (CharSequence)actionId) && StringUtils.isNotBlank((Object)closedCallBackEvent.getReturnData())) {
            Map retData = (Map)closedCallBackEvent.getReturnData();
            String name = retData.get("name").toString();
            String describe = retData.get("describe").toString();
            this.saveMulImportScheme(name, describe, false);
        }
    }

    private void buildOneNodeEntry(String nodeId, boolean isClick) {
        this.getView().getPageCache().put("mul_import_last_tree_node_id", nodeId);
        MulNodeDetailVo nodeInfo = this.getChooseNodeInfo(nodeId);
        String mainEntityNumber = nodeInfo.getMainTypeName();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)mainEntityNumber);
        Map entityTypeMap = mainType.getAllEntities();
        EntityType entityType = (EntityType)entityTypeMap.get(nodeInfo.getNodeNumber());
        Map allFields = entityType.getFields();
        List<MulFieldInfo> fieldInfo = this.covertFiled2FieldInfo(mainEntityNumber, allFields, isClick);
        this.getView().getPageCache().put("mul_import_allFields4CurrentNode", SerializationUtils.toJsonString((Object)new MulNodeFieldMap(nodeId, fieldInfo)));
        if (fieldInfo.size() > 0) {
            this.getModel().batchCreateNewEntryRow("fieldmapppingentry", fieldInfo.size());
        }
        this.getModel().beginInit();
        this.fillValue2Entry(nodeInfo, fieldInfo, nodeId);
        this.getModel().endInit();
        MulImportStepPluginUtil.cacheCurrentTreeInfo(nodeId, this.getView(), this.getModel(), fieldInfo);
    }

    private Set<String> getShowFields(List<EntityItem<?>> entityItems) {
        HashSet<String> itemSet = new HashSet<String>(16);
        if (CollectionUtils.isEmpty(entityItems)) {
            return itemSet;
        }
        entityItems.forEach(item -> {
            Field field;
            if (item instanceof Field && StringUtils.isNotBlank((CharSequence)(field = (Field)item).getFieldName()) && field.getFeatures().isImportable()) {
                itemSet.add(item.getKey());
            }
        });
        return itemSet;
    }

    private void fillValue2Entry(MulNodeDetailVo nodeInfo, List<MulFieldInfo> fieldInfo, String nodeId) {
        MulFieldMappingCacheVo mulFieldMappingCacheVo = MulImportStepPluginUtil.getCurrentNodeCacheInfo(this.getView(), nodeId);
        Object currentNodeExcelSheet = null;
        if (null != mulFieldMappingCacheVo && StringUtils.isNotBlank((CharSequence)mulFieldMappingCacheVo.getCurDataSheetIndex())) {
            currentNodeExcelSheet = mulFieldMappingCacheVo.getCurDataSheetIndex();
            this.getModel().setValue("withlowerrelation", (Object)mulFieldMappingCacheVo.getLowerRelationField());
            this.getModel().setValue("withsuperrelation", (Object)mulFieldMappingCacheVo.getSuperRelationField());
        } else {
            currentNodeExcelSheet = this.getModel().getValue("detailsheetchoose", nodeInfo.getRowId());
        }
        String sheetName = "";
        DynamicObject schemeObject = this.getCurrentNodeInfoFromScheme(nodeId);
        if (StringUtils.isNotBlank((Object)currentNodeExcelSheet)) {
            int currentSheet = Integer.parseInt(currentNodeExcelSheet.toString());
            this.getModel().setValue("entitysheetrelation", currentNodeExcelSheet);
            sheetName = MulImportStepPluginUtil.getSheetNameByValue(this.getView(), currentSheet);
            this.getModel().setValue("entitysheetrelationshow", (Object)sheetName);
            MulImportStepPluginUtil.createMulPageComboByExcelHead(this.getView(), "withlowerrelation", nodeId);
            MulImportStepPluginUtil.createMulPageComboByExcelHead(this.getView(), "withsuperrelation", nodeId);
            MulImportStepPluginUtil.createMulPageComboByExcelHead(this.getView(), "excelfield", nodeId);
            if (null == mulFieldMappingCacheVo) {
                if (this.schemeNotChanged(schemeObject, Integer.parseInt(nodeId))) {
                    this.getModel().setValue("withlowerrelation", (Object)schemeObject.getInt("lowerconcatefield"));
                    this.getModel().setValue("withsuperrelation", (Object)schemeObject.getInt("superconcatefield"));
                } else {
                    this.getModel().setValue("withlowerrelation", null);
                    this.getModel().setValue("withsuperrelation", null);
                }
            } else {
                this.getModel().setValue("withlowerrelation", (Object)mulFieldMappingCacheVo.getLowerRelationField());
                this.getModel().setValue("withsuperrelation", (Object)mulFieldMappingCacheVo.getSuperRelationField());
            }
        } else {
            MulImportStepPluginUtil.createSheetChooseCombo(this.getView(), "excelfield", new ArrayList<ComboItem>());
            MulImportStepPluginUtil.createSheetChooseCombo(this.getView(), "withlowerrelation", new ArrayList<ComboItem>());
            MulImportStepPluginUtil.createSheetChooseCombo(this.getView(), "withsuperrelation", new ArrayList<ComboItem>());
            this.getModel().setValue("entitysheetrelation", null);
            this.getModel().setValue("entitysheetrelationshow", (Object)"");
            this.getModel().setValue("withlowerrelation", null);
            this.getModel().setValue("withsuperrelation", null);
        }
        int notMappingCount = 0;
        String currentSpecialField = "";
        if (StringUtils.isNotBlank((CharSequence)sheetName) && this.needAutoMatch()) {
            List<String> headCells = MulImportStepPluginUtil.getHeadColumn(this.getView(), nodeId);
            HashSet hasMatched = new HashSet();
            ArrayList<MulFieldInfo> mulFieldInfos = new ArrayList<MulFieldInfo>(fieldInfo);
            notMappingCount = this.doMatchField(mulFieldInfos, headCells, hasMatched, notMappingCount);
        }
        boolean schemeNotChange = this.schemeNotChanged(schemeObject, Integer.parseInt(nodeId));
        for (MulFieldInfo mulFieldInfo : fieldInfo) {
            int i = mulFieldInfo.getRowIndex();
            String fieldNumber = mulFieldInfo.getNumber();
            String fieldName = mulFieldInfo.getShowName();
            MulFieldTypeEnum mulFieldTypeEnum = mulFieldInfo.getFieldType();
            this.getModel().setValue("formfieldshow", (Object)fieldName, i);
            this.getModel().setValue("formfield", (Object)fieldNumber, i);
            if (null != mulFieldTypeEnum) {
                currentSpecialField = this.setMappingDesc(mulFieldTypeEnum, fieldNumber, mulFieldInfo.getRealName(), currentSpecialField, i, mulFieldInfo.getRelationFieldName());
            }
            if (null != mulFieldMappingCacheVo && mulFieldMappingCacheVo.getCurDataSheetIndex().equals(currentNodeExcelSheet)) {
                MulOneFieldMappingVo mulOneFieldMappingVo = mulFieldMappingCacheVo.getOneFieldMappingVos().get(i);
                boolean mapping = StringUtils.isNotBlank((CharSequence)mulOneFieldMappingVo.getExcelField());
                this.getModel().setValue("ismapping", (Object)(mapping ? 1 : 0), i);
                if (mapping) {
                    this.setFieldColor(i, "ismapping", "#1BA854");
                } else {
                    this.setFieldColor(i, "ismapping", "#999999");
                }
                this.getModel().setValue("excelfield", (Object)mulOneFieldMappingVo.getExcelField(), i);
                continue;
            }
            if (!schemeNotChange) continue;
            DynamicObjectCollection schemeSubEntryCol = schemeObject.getDynamicObjectCollection("subentryentity");
            for (DynamicObject schemeSubEntry : schemeSubEntryCol) {
                String excelField;
                boolean isMapping;
                if (!fieldNumber.equals(schemeSubEntry.getString("entityfieldnumber"))) continue;
                this.getModel().setValue("ismapping", (Object)schemeSubEntry.getInt("ismapping"), i);
                boolean bl = isMapping = schemeSubEntry.getInt("ismapping") == 1;
                if (isMapping) {
                    this.setFieldColor(i, "ismapping", "#1BA854");
                } else {
                    this.setFieldColor(i, "ismapping", "#999999");
                }
                if ("-1".equals(excelField = schemeSubEntry.getString("excelfield"))) continue;
                this.getModel().setValue("excelfield", (Object)excelField, i);
            }
        }
        Label mappingTipLabel = (Label)this.getControl("mappingtips");
        if (notMappingCount > 0) {
            String tipLabel = String.format(ResManager.loadKDString((String)"%1$s\u5b58\u5728%2$s\u4e2a\u5b57\u6bb5\u65e0\u6cd5\u81ea\u52a8\u6620\u5c04\uff0c\u672a\u6620\u5c04\u5b57\u6bb5\u5c06\u65e0\u6cd5\u5bfc\u5165\uff0c\u82e5\u9700\u5bfc\u5165\u8be5\u5b57\u6bb5\uff0c\u8bf7\u624b\u52a8\u5efa\u7acb\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\uff08\u6682\u4e0d\u652f\u6301\u5bfc\u5165\u5f39\u6027\u57df\u5b57\u6bb5\uff09\u3002", (String)"MulImportStepPlugin_10", (String)"bos-import", (Object[])new Object[0]), nodeInfo.getNodeName(), notMappingCount);
            mappingTipLabel.setText(tipLabel);
            return;
        }
        mappingTipLabel.setText("");
    }

    private int doMatchField(List<MulFieldInfo> mulFieldInfos, List<String> headCells, Set<Integer> hasMatched, int notMappingCount) {
        if (CollectionUtils.isEmpty(mulFieldInfos)) {
            return notMappingCount;
        }
        ArrayList<StrSimilarityResult> matchFieldResults = new ArrayList<StrSimilarityResult>();
        for (int i = 0; i < mulFieldInfos.size(); ++i) {
            MulFieldInfo mulFieldInfo = mulFieldInfos.get(i);
            String fieldName = mulFieldInfo.getName();
            StrSimilarityResult matchFieldResult = StrSimilarityProxy.getSimilaritiesWord(fieldName, headCells, hasMatched);
            if (matchFieldResult == null) {
                this.setFieldColor(mulFieldInfo.getRowIndex(), "ismapping", "#999999");
                ++notMappingCount;
                mulFieldInfos.remove(i);
                --i;
                continue;
            }
            matchFieldResult.setFieldInfo(mulFieldInfo);
            matchFieldResults.add(matchFieldResult);
        }
        log.debug(" fillIndex --- " + matchFieldResults);
        Optional<StrSimilarityResult> mostSimilar = matchFieldResults.stream().max(Comparator.comparing(StrSimilarityResult::getScore));
        if (!mostSimilar.isPresent()) {
            log.debug("kd.bos.mulimport.stepplugin.MulImportStepThreePlugin.doMatchField --- \uff0creturn");
            return notMappingCount;
        }
        StrSimilarityResult matchResult = mostSimilar.get();
        log.debug(" fillIndex --- " + matchResult);
        MulFieldInfo fieldInfo = matchResult.getFieldInfo();
        int rowIndex = fieldInfo.getRowIndex();
        int fillIndex = matchResult.getFillIndex();
        hasMatched.add(fillIndex);
        mulFieldInfos.remove(fieldInfo);
        this.getModel().setValue("excelfield", (Object)fillIndex, rowIndex);
        this.getModel().setValue("ismapping", (Object)1, rowIndex);
        this.setFieldColor(rowIndex, "ismapping", "#1BA854");
        return this.doMatchField(mulFieldInfos, headCells, hasMatched, notMappingCount);
    }

    private void fieldMappingPageBuildTree() {
        TreeView tree = (TreeView)this.getView().getControl("entitychoosetree");
        tree.deleteAllNodes();
        boolean isFirstRoot = true;
        List<MulNodeDetailVo> mulTreeNodeVos = MulImportStepPluginUtil.getTreeNodeVoFromPageCache(this.getView().getPageCache());
        ArrayList<TreeNode> rootList = new ArrayList<TreeNode>(mulTreeNodeVos.size());
        Map nodeMap = mulTreeNodeVos.stream().collect(Collectors.groupingBy(MulNodeDetailVo::getMainTypeName, LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry detailVoEntry : nodeMap.entrySet()) {
            boolean isRoot = true;
            TreeNode root = new TreeNode();
            ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>();
            for (MulNodeDetailVo detailVo : (List)detailVoEntry.getValue()) {
                if (isRoot) {
                    String nodeId = String.valueOf(detailVo.getRowId());
                    boolean setIcon = this.initTreeSetIcon(nodeId);
                    root.setId(nodeId);
                    root.setText(detailVo.getNodeName());
                    root.setData((Object)detailVo.getNodeNumber());
                    root.setParentid("");
                    root.setIsOpened(true);
                    if (setIcon) {
                        root.setSuffixIconProps(this.getSuffixIconProps());
                    }
                    isRoot = false;
                } else {
                    TreeNode node = this.buildOneNode(detailVo);
                    if (String.valueOf(detailVo.getParentRowId()).equals(root.getId())) {
                        List<TreeNode> treeNodes = this.getSubTreeNodeList((List)detailVoEntry.getValue(), detailVo.getRowId());
                        if (CollectionUtils.isNotEmpty(treeNodes)) {
                            node.setIsOpened(true);
                            node.setChildren(treeNodes);
                        }
                        treeNodeList.add(node);
                    }
                }
                if (!CollectionUtils.isNotEmpty(treeNodeList)) continue;
                root.setChildren(treeNodeList);
            }
            tree.addNode(root);
            if (isFirstRoot) {
                tree.focusNode(root);
                isFirstRoot = false;
            }
            rootList.add(root);
        }
        this.getView().getPageCache().put("mul_import_tree_cache", SerializationUtils.toJsonString(rootList));
        for (int i = mulTreeNodeVos.size() - 1; i >= 0; --i) {
            TreeNodeEvent treeNodeEvent = new TreeNodeEvent((Object)"is_manual");
            treeNodeEvent.setNodeId((Object)String.valueOf(mulTreeNodeVos.get(i).getRowId()));
            this.treeNodeClick(treeNodeEvent);
        }
    }

    private List<TreeNode> getSubTreeNodeList(List<MulNodeDetailVo> detailVos, int parentId) {
        List mulNodeDetailVos = detailVos.stream().filter(item -> item.getParentRowId() == parentId).collect(Collectors.toList());
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(mulNodeDetailVos.size());
        for (MulNodeDetailVo mulNodeDetailVo : mulNodeDetailVos) {
            TreeNode node = this.buildOneNode(mulNodeDetailVo);
            treeNodeList.add(node);
        }
        return treeNodeList;
    }

    private TreeNode buildOneNode(MulNodeDetailVo mulNodeDetailVo) {
        TreeNode node = new TreeNode();
        String nodeId = String.valueOf(mulNodeDetailVo.getRowId());
        node.setId(nodeId);
        node.setText(mulNodeDetailVo.getNodeName());
        node.setData((Object)mulNodeDetailVo.getNodeNumber());
        node.setParentid(String.valueOf(mulNodeDetailVo.getParentRowId()));
        boolean setIcon = this.initTreeSetIcon(nodeId);
        if (setIcon) {
            node.setSuffixIconProps(this.getSuffixIconProps());
        }
        return node;
    }

    private MulNodeDetailVo getChooseNodeInfo(String nodeId) {
        List<MulNodeDetailVo> mulNodeDetailVos = MulImportStepPluginUtil.getTreeNodeVoFromPageCache(this.getView().getPageCache());
        for (MulNodeDetailVo detailVo : mulNodeDetailVos) {
            if (!StringUtils.equals((CharSequence)nodeId, (CharSequence)String.valueOf(detailVo.getRowId()))) continue;
            return detailVo;
        }
        return new MulNodeDetailVo();
    }

    private List<MulFieldInfo> covertFiled2FieldInfo(String mainEntityNumber, Map<String, IDataEntityProperty> allFields, boolean isClick) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityNumber, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems();
        Set<String> itemSet = this.getShowFields(entityItems);
        ArrayList<MulFieldInfo> filedShowList = new ArrayList<MulFieldInfo>(10);
        int rowIndex = 0;
        for (Map.Entry<String, IDataEntityProperty> entry : allFields.entrySet()) {
            IDataEntityProperty property = entry.getValue();
            if (property instanceof FlexProp || property instanceof AttachmentProp || property instanceof PictureProp || property instanceof RefBillProp || property instanceof SignatureProp || property instanceof PrintCountProp || property instanceof AttachmentCountProp || !itemSet.contains(property.getName())) continue;
            if (property instanceof BasedataProp || property instanceof MulBasedataProp) {
                rowIndex += this.collectBaseDataPropFields(property, filedShowList, rowIndex, isClick);
                continue;
            }
            if (property instanceof MuliLangTextProp) {
                rowIndex += this.collectMulLangTextPropFields(property, filedShowList, rowIndex, isClick);
                continue;
            }
            if (property instanceof LargeTextProp) {
                rowIndex += this.collectLargeTextPropFields(property, filedShowList, rowIndex, isClick);
                continue;
            }
            if (property instanceof GeoPointProp) {
                rowIndex += this.collectGeoPointPropFields(property, filedShowList, rowIndex, isClick);
                continue;
            }
            boolean isMustInput = isClick && property instanceof FieldProp && ((FieldProp)property).isMustInput();
            MulFieldInfo mulFieldInfo = this.buildMulFieldInfo(property, isMustInput, rowIndex++);
            filedShowList.add(mulFieldInfo);
        }
        return filedShowList;
    }

    private int collectGeoPointPropFields(IDataEntityProperty property, List<MulFieldInfo> filedShowList, int rowIndex, boolean isClick) {
        DataEntityPropertyCollection properties = property.getParent().getProperties();
        IDataEntityProperty propLo = (IDataEntityProperty)properties.get((Object)(property.getName() + "_lo"));
        IDataEntityProperty propLa = (IDataEntityProperty)properties.get((Object)(property.getName() + "_la"));
        IDataEntityProperty propAd = (IDataEntityProperty)properties.get((Object)(property.getName() + "_ad"));
        boolean isMustInput = isClick && ((GeoPointProp)property).isMustInput();
        int total = 0;
        filedShowList.add(this.buildMulFieldInfo(property, isMustInput, rowIndex + total++));
        if (propLo != null) {
            filedShowList.add(this.buildMulFieldInfo(propLo, isMustInput, rowIndex + total++));
        }
        if (propLa != null) {
            filedShowList.add(this.buildMulFieldInfo(propLa, isMustInput, rowIndex + total++));
        }
        if (propAd != null) {
            filedShowList.add(this.buildMulFieldInfo(propAd, isMustInput, rowIndex + total++));
        }
        return total;
    }

    private MulFieldInfo buildMulFieldInfo(IDataEntityProperty property, boolean isMustInput, int rowIndex) {
        String displayName;
        MulFieldInfo mulFieldInfo = new MulFieldInfo();
        String string = displayName = null == property.getDisplayName() ? property.getName() : property.getDisplayName().toString();
        if (property instanceof DateTimeProp || property instanceof TimeProp) {
            mulFieldInfo.setFieldType(MulFieldTypeEnum.DATE);
            if (property instanceof DateTimeProp && StringUtils.isNotBlank((CharSequence)((DateTimeProp)property).getRelateDateTimeRange())) {
                mulFieldInfo.setFieldType(MulFieldTypeEnum.DATE_RANGE);
                mulFieldInfo.setRealName(displayName);
                mulFieldInfo.setRelationFieldName(((DateTimeProp)property).getRelateDateTimeRange());
            }
        }
        if (property instanceof DecimalProp) {
            mulFieldInfo.setPropSeq(MulImportPropConvertSeq.DECIMAL);
        }
        mulFieldInfo.setMustInput(isMustInput);
        mulFieldInfo.setNumber(property.getName());
        mulFieldInfo.setName(displayName);
        String fieldShow = displayName + "(" + mulFieldInfo.getNumber() + ")";
        mulFieldInfo.setShowName(isMustInput ? "*" + fieldShow : fieldShow);
        mulFieldInfo.setRowIndex(rowIndex);
        return mulFieldInfo;
    }

    private int collectLargeTextPropFields(IDataEntityProperty property, List<MulFieldInfo> filedShowList, int rowIndex, boolean isClick) {
        LargeTextProp largeTextProp = (LargeTextProp)property;
        boolean isMustInput = largeTextProp.isMustInput() && isClick;
        MulFieldInfo mulFieldInfo = new MulFieldInfo();
        mulFieldInfo.setFieldType(MulFieldTypeEnum.LARGE_TEXT);
        mulFieldInfo.setMustInput(isMustInput);
        mulFieldInfo.setNumber(property.getName());
        String displayName = null == property.getDisplayName() ? property.getName() : property.getDisplayName().toString();
        mulFieldInfo.setName(displayName);
        mulFieldInfo.setRealName(displayName);
        String fieldShow = mulFieldInfo.getName() + "(" + mulFieldInfo.getNumber() + ")";
        mulFieldInfo.setShowName(isMustInput ? "*" + fieldShow : fieldShow);
        mulFieldInfo.setRowIndex(rowIndex);
        filedShowList.add(mulFieldInfo);
        MulFieldInfo tagFieldInfo = new MulFieldInfo();
        tagFieldInfo.setMustInput(isMustInput);
        tagFieldInfo.setNumber(property.getName() + "_tag");
        String tagDisplayName = ((IDataEntityProperty)property.getParent().getProperties().get((Object)tagFieldInfo.getNumber())).getDisplayName().getLocaleValue();
        tagFieldInfo.setName(tagDisplayName);
        String tagFieldShow = tagFieldInfo.getName() + "(" + tagFieldInfo.getNumber() + ")";
        tagFieldInfo.setShowName(isMustInput ? "*" + tagFieldShow : tagFieldShow);
        tagFieldInfo.setRowIndex(rowIndex + 1);
        filedShowList.add(tagFieldInfo);
        return 2;
    }

    private int collectMulLangTextPropFields(IDataEntityProperty property, List<MulFieldInfo> filedShowList, int rowIndex, boolean isClick) {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List multiLangEnabledLang = service.getMultiLangEnabledLang();
        String curLangTag = RequestContext.getOrCreate().getLang().name();
        MuliLangTextProp muliLangTextProp = (MuliLangTextProp)property;
        ArrayList<MulFieldInfo> mulLangeFields = new ArrayList<MulFieldInfo>();
        int total = 0;
        multiLangEnabledLang.sort((lang1, lang2) -> {
            String langNumber1 = lang1.getNumber();
            String langNumber2 = lang2.getNumber();
            if (langNumber1.equals(curLangTag) && !langNumber2.equals(curLangTag)) {
                return -1;
            }
            if (!langNumber1.equals(curLangTag) && langNumber2.equals(curLangTag)) {
                return 1;
            }
            return 0;
        });
        for (EnabledLang enabledLang : multiLangEnabledLang) {
            mulLangeFields.add(this.buildMulLangeFiledInfo(property, enabledLang, rowIndex + total++, muliLangTextProp.isMustInput() && isClick));
        }
        filedShowList.addAll(mulLangeFields);
        return total;
    }

    private MulFieldInfo buildMulLangeFiledInfo(IDataEntityProperty property, EnabledLang langeTag, int rowIndex, boolean isMustInput) {
        MulFieldInfo mulFieldInfo = new MulFieldInfo();
        mulFieldInfo.setFieldType(MulFieldTypeEnum.MUL_LANG_TEXT);
        mulFieldInfo.setMustInput(isMustInput);
        mulFieldInfo.setNumber(property.getName() + "." + langeTag.getNumber());
        String displayName = null == property.getDisplayName() ? property.getName() : property.getDisplayName().toString();
        mulFieldInfo.setRealName(displayName);
        mulFieldInfo.setName(displayName + "." + langeTag.getName());
        String fieldShow = mulFieldInfo.getName() + "(" + mulFieldInfo.getNumber() + ")";
        mulFieldInfo.setShowName(isMustInput ? "*" + fieldShow : fieldShow);
        mulFieldInfo.setRowIndex(rowIndex);
        return mulFieldInfo;
    }

    private int collectBaseDataPropFields(IDataEntityProperty property, List<MulFieldInfo> filedShowList, int rowIndex, boolean isClick) {
        IDataEntityProperty nameProp;
        IDataEntityProperty numberProp;
        boolean mustInput = false;
        BasedataEntityType entityType = null;
        if (property instanceof MulBasedataProp) {
            MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
            mustInput = mulBasedataProp.isMustInput();
            entityType = (BasedataEntityType)mulBasedataProp.getComplexType();
        } else {
            BasedataProp basedataProp = (BasedataProp)property;
            mustInput = basedataProp.isMustInput();
            entityType = (BasedataEntityType)basedataProp.getComplexType();
        }
        String number = entityType.getNumberProperty();
        String name = entityType.getNameProperty();
        ISimpleProperty primaryProp = entityType.getPrimaryKey();
        int total = 0;
        if (primaryProp != null) {
            filedShowList.add(this.buildBaseDataMulFieldInfo(property, (IDataEntityProperty)primaryProp, isClick && mustInput, rowIndex + total++));
        }
        if ((numberProp = entityType.findProperty(number)) != null) {
            filedShowList.add(this.buildBaseDataMulFieldInfo(property, numberProp, isClick && mustInput, rowIndex + total++));
        }
        if ((nameProp = entityType.findProperty(name)) != null) {
            filedShowList.add(this.buildBaseDataMulFieldInfo(property, nameProp, isClick && mustInput, rowIndex + total++));
        }
        return total;
    }

    private MulFieldInfo buildBaseDataMulFieldInfo(IDataEntityProperty parentProp, IDataEntityProperty property, boolean isMustInput, int rowIndex) {
        String displayName;
        MulFieldInfo mulFieldInfo = new MulFieldInfo();
        mulFieldInfo.setFieldType(MulFieldTypeEnum.BASE_DATA);
        mulFieldInfo.setMustInput(isMustInput);
        mulFieldInfo.setNumber(parentProp.getName() + "." + property.getName());
        String string = displayName = null == property.getDisplayName() ? property.getName() : property.getDisplayName().toString();
        if (StringUtils.equals((CharSequence)"id", (CharSequence)property.getName())) {
            displayName = ResManager.loadKDString((String)"\u5185\u7801", (String)"MulImportStepThreePlugin_0", (String)"bos-import", (Object[])new Object[0]);
        }
        String parentDisplayName = null == parentProp.getDisplayName() ? parentProp.getName() : parentProp.getDisplayName().toString();
        displayName = parentDisplayName + "." + displayName;
        mulFieldInfo.setName(displayName);
        mulFieldInfo.setRealName(parentDisplayName);
        String pkFieldShow = displayName + "(" + mulFieldInfo.getNumber() + ")";
        mulFieldInfo.setShowName(isMustInput ? "*" + pkFieldShow : pkFieldShow);
        mulFieldInfo.setRowIndex(rowIndex);
        this.setBaseDataType(parentProp, mulFieldInfo);
        this.setBaseDateConvertSeq(parentProp, mulFieldInfo);
        return mulFieldInfo;
    }

    private void setBaseDateConvertSeq(IDataEntityProperty property, MulFieldInfo mulFieldInfo) {
        if (property instanceof MainOrgProp) {
            mulFieldInfo.setPropSeq(MulImportPropConvertSeq.MAIN_ORG);
        } else if (property instanceof OrgProp) {
            mulFieldInfo.setPropSeq(MulImportPropConvertSeq.ORG);
        } else if (property instanceof BillTypeProp) {
            mulFieldInfo.setPropSeq(MulImportPropConvertSeq.BILL_TYPE);
        } else if (property instanceof BasedataProp || property instanceof MulBasedataProp) {
            mulFieldInfo.setPropSeq(MulImportPropConvertSeq.BASE_DATA);
        }
    }

    private void setBaseDataType(IDataEntityProperty property, MulFieldInfo mulFieldInfo) {
        if (property instanceof MainOrgProp) {
            mulFieldInfo.setType(MulImportCollectTypeEnum.MAIN_ORG.getType());
        } else if (property instanceof OrgProp) {
            mulFieldInfo.setType(MulImportCollectTypeEnum.COMMON_ORG.getType());
        } else if (property instanceof BasedataProp || property instanceof MulBasedataProp) {
            String baseDataEntityId = ((IBasedataField)property).getBaseEntityId();
            if (BaseDataServiceHelper.checkBaseDataCtrl((String)baseDataEntityId).booleanValue()) {
                mulFieldInfo.setType(MulImportCollectTypeEnum.CTRL_BASE_DATA.getType());
            } else {
                mulFieldInfo.setType(MulImportCollectTypeEnum.COMMON_BASE_DATA.getType());
            }
        }
    }

    private List<ComboItem> getMappingFieldProps(String propName) {
        String refPropStr = this.getPageCache().get("mul_import_mappingField_" + propName);
        if (refPropStr == null) {
            return null;
        }
        return SerializationUtils.fromJsonStringToList((String)refPropStr, ComboItem.class);
    }

    private List<ComboItem> cacheRefProps(IDataEntityProperty fldProperty) {
        ArrayList<ComboItem> dispComboList = new ArrayList<ComboItem>();
        ComboItem dispCombo = null;
        ArrayList<ComboItem> refItems = new ArrayList<ComboItem>();
        if (fldProperty instanceof ItemClassProp || fldProperty instanceof FlexProp) {
            refItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u540d\u79f0", (String)"ImportTemplatePlugin_14", (String)"bos-import", (Object[])new Object[0])), "name"));
            refItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7f16\u7801", (String)"ImportTemplatePlugin_15", (String)"bos-import", (Object[])new Object[0])), "number"));
            dispComboList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u540d\u79f0", (String)"ImportTemplatePlugin_14", (String)"bos-import", (Object[])new Object[0])), "name"));
        } else {
            BasedataEntityType type = (BasedataEntityType)((IBasedataField)fldProperty).getComplexType();
            for (IDataEntityProperty refProp : type.getProperties()) {
                if (refProp instanceof AttachmentProp || !(refProp instanceof IFieldHandle)) continue;
                LocaleString disp = refProp.getDisplayName();
                ComboItem temp = new ComboItem(StringUtils.isNotBlank((Object)disp) ? disp : new LocaleString(refProp.getName()), refProp.getName());
                String nameProperty = type.getNameProperty();
                String numberProperty = type.getNumberProperty();
                if (refProp.getName().equals(nameProperty)) {
                    dispCombo = temp;
                    dispComboList.add(dispCombo);
                }
                refItems.add(temp);
                if (!(fldProperty instanceof MaterielProp) || type.getMasteridType() != 2 || !StringUtils.equals((CharSequence)type.getMasteridPropName(), (CharSequence)refProp.getName())) continue;
                refItems.addAll(this.handleMaterielProp(refProp));
            }
        }
        this.getPageCache().put("mul_import_mappingField_" + fldProperty.getName(), SerializationUtils.toJsonString(refItems));
        return dispComboList;
    }

    private List<ComboItem> handleMaterielProp(IDataEntityProperty materielProp) {
        BasedataEntityType type = (BasedataEntityType)((IBasedataField)materielProp).getComplexType();
        ArrayList<ComboItem> materielItems = new ArrayList<ComboItem>();
        String materielName = materielProp.getName();
        LocaleString displayName = materielProp.getDisplayName();
        for (IDataEntityProperty refProp : type.getProperties()) {
            if (refProp instanceof AttachmentProp || !(refProp instanceof IFieldHandle) || !((IFieldHandle)refProp).isExportable()) continue;
            LocaleString name = refProp.getDisplayName();
            String appendName = materielName + "." + refProp.getName();
            if (StringUtils.isNotBlank((Object)displayName) && StringUtils.isNotBlank((Object)name)) {
                appendName = displayName + "." + name;
            }
            ComboItem temp = new ComboItem(new LocaleString(appendName), materielName + "." + refProp.getName());
            materielItems.add(temp);
        }
        return materielItems;
    }

    private void setMappingFieldProps(String propName, List<String> exportProps, int i) {
        this.getModel().setValue("mappingfield", (Object)(exportProps == null ? null : String.join((CharSequence)",", exportProps)), i);
    }

    private void showOrHiddenRelationField(String nodeId) {
        int nodeLevel = this.nodeLevel(Integer.parseInt(nodeId));
        if (nodeLevel == 1) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"withlowerrelation"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"withsuperrelation"});
        } else if (nodeLevel == 2) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"withlowerrelation"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"withsuperrelation"});
        } else if (nodeLevel == 3) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"withlowerrelation"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"withsuperrelation"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"withlowerrelation"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"withsuperrelation"});
        }
    }

    private int nodeLevel(int currentNodeId) {
        List<MulNodeDetailVo> treeNodeVos = MulImportStepPluginUtil.getTreeNodeVoFromPageCache(this.getView().getPageCache());
        for (MulNodeDetailVo detailVo : treeNodeVos) {
            if (detailVo.getRowId() != currentNodeId) continue;
            if (detailVo.getNodeType() == MulImportResolveTypeEnum.ENTRY.getType()) {
                if (this.hasNextLevelNode(currentNodeId)) {
                    return 2;
                }
                return 3;
            }
            if (detailVo.getNodeType() == MulImportResolveTypeEnum.SUB_ENTRY.getType()) {
                return 3;
            }
            if (detailVo.getNodeType() != MulImportResolveTypeEnum.HEAD.getType()) continue;
            List<Integer> lowNodes = MulImportStepPluginUtil.getLowerNodeIdByCurrentId(currentNodeId, this.getView().getPageCache(), false, false);
            if (CollectionUtils.isNotEmpty(lowNodes)) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    private boolean hasNextLevelNode(int currentNodeId) {
        List<MulNodeDetailVo> treeNodeVos = MulImportStepPluginUtil.getTreeNodeVoFromPageCache(this.getView().getPageCache());
        for (MulNodeDetailVo detailVo : treeNodeVos) {
            if (detailVo.getNodeType() != MulImportResolveTypeEnum.SUB_ENTRY.getType() || detailVo.getParentRowId() != currentNodeId) continue;
            return true;
        }
        return false;
    }

    private void setFieldColor(int row, String fieldNumber, String color) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("fieldmapppingentry");
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>();
        CellStyle cs = new CellStyle();
        cs.setForeColor(color);
        cs.setFieldKey(fieldNumber);
        cs.setRow(row);
        csList.add(cs);
        grid.setCellStyle(csList);
    }

    private boolean checkData() {
        List<MulNodeDetailVo> mulTreeNodeVos = MulImportStepPluginUtil.getTreeNodeVoFromPageCache(this.getView().getPageCache());
        StringBuilder checkRelationBuilder = new StringBuilder();
        StringBuilder checkMappingBuilder = new StringBuilder();
        boolean notPass = false;
        String notMappingTips = ResManager.loadKDString((String)"\u201c%s\u201d\u5b58\u5728\u5b57\u6bb5\u672a\u6620\u5c04\uff0c\u4f1a\u5bfc\u81f4\u672a\u6620\u5c04\u5b57\u6bb5\u65e0\u6cd5\u5bfc\u5165\uff0c\u82e5\u65e0\u9700\u5bfc\u5165\u8be5\u6620\u5c04\u5b57\u6bb5\uff0c\u53ef\u5ffd\u7565\u8be5\u63d0\u793a\u3002", (String)"MulImportStepPlugin_14", (String)"bos-import", (Object[])new Object[0]);
        for (MulNodeDetailVo detailVo : mulTreeNodeVos) {
            boolean checkMapping;
            int rowId = detailVo.getRowId();
            String entityName = detailVo.getNodeName();
            MulFieldMappingCacheVo mappingCacheVo = MulImportStepPluginUtil.getCurrentNodeCacheInfo(this.getView(), String.valueOf(rowId));
            if (null == mappingCacheVo || !CollectionUtils.isNotEmpty(mappingCacheVo.getOneFieldMappingVos())) continue;
            String emptyField = this.checkRelationField(detailVo.getNodeType(), mappingCacheVo, rowId);
            if (StringUtils.isNotBlank((CharSequence)emptyField)) {
                String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c%1$s\u201d\u7684%2$s\u3002", (String)"MulImportStepPlugin_5", (String)"bos-import", (Object[])new Object[0]);
                checkRelationBuilder.append(String.format(tips, entityName, emptyField)).append(System.getProperty("line.separator"));
            }
            if (!StringUtils.isNotBlank((CharSequence)mappingCacheVo.getCurDataSheetIndex()) || (checkMapping = this.checkAllFieldMapping(mappingCacheVo))) continue;
            checkMappingBuilder.append(entityName).append("\u3001");
        }
        if (StringUtils.isNotBlank((CharSequence)checkRelationBuilder)) {
            notPass = true;
        }
        if (StringUtils.isNotBlank((CharSequence)checkMappingBuilder)) {
            notMappingTips = String.format(notMappingTips, checkMappingBuilder.deleteCharAt(checkMappingBuilder.length() - 1));
        }
        if (notPass && StringUtils.isNotBlank((CharSequence)checkMappingBuilder)) {
            this.getView().showErrorNotification(checkRelationBuilder.append(notMappingTips).toString());
        } else if (notPass) {
            this.getView().showErrorNotification(checkRelationBuilder.toString());
        } else if (StringUtils.isNotBlank((CharSequence)checkMappingBuilder)) {
            this.getView().showTipNotification(notMappingTips);
        }
        return notPass;
    }

    private String checkRelationField(int nodeType, MulFieldMappingCacheVo mappingCacheVo, int currentIndex) {
        String lowerTips = ResManager.loadKDString((String)"\u201c\u4e0e\u4e0b\u7ea7\u5b9e\u4f53\u7684\u5173\u8054\u5b57\u6bb5\u201d", (String)"MulImportStepPlugin_15", (String)"bos-import", (Object[])new Object[0]);
        String superTips = ResManager.loadKDString((String)"\u201c\u4e0e\u4e0a\u7ea7\u5b9e\u4f53\u7684\u5173\u8054\u5b57\u6bb5\u201d", (String)"MulImportStepPlugin_16", (String)"bos-import", (Object[])new Object[0]);
        if (MulImportResolveTypeEnum.HEAD.getType() == nodeType && StringUtils.isNotBlank((CharSequence)mappingCacheVo.getCurDataSheetIndex())) {
            List<Integer> entryIds = MulImportStepPluginUtil.getLowerNodeIdByCurrentId(currentIndex, this.getView().getPageCache(), false, false);
            if (mappingCacheVo.getLowerRelationField() == -1 && CollectionUtils.isNotEmpty(entryIds) && this.lowerNodeChooseIndex(entryIds)) {
                return lowerTips;
            }
        } else if (MulImportResolveTypeEnum.ENTRY.getType() == nodeType && StringUtils.isNotBlank((CharSequence)mappingCacheVo.getCurDataSheetIndex())) {
            List<Integer> subEntryId = MulImportStepPluginUtil.getSubEntryIdByEntryId(currentIndex, this.getView().getPageCache(), false);
            if (mappingCacheVo.getLowerRelationField() == -1 && mappingCacheVo.getSuperRelationField() == -1) {
                if (CollectionUtils.isNotEmpty(subEntryId) && this.lowerNodeChooseIndex(subEntryId)) {
                    return superTips + "\uff1b" + lowerTips;
                }
                return superTips;
            }
            if (mappingCacheVo.getSuperRelationField() == -1) {
                return superTips;
            }
            if (mappingCacheVo.getLowerRelationField() == -1 && CollectionUtils.isNotEmpty(subEntryId) && this.lowerNodeChooseIndex(subEntryId)) {
                return lowerTips;
            }
        } else if (MulImportResolveTypeEnum.SUB_ENTRY.getType() == nodeType && StringUtils.isNotBlank((CharSequence)mappingCacheVo.getCurDataSheetIndex()) && mappingCacheVo.getSuperRelationField() == -1) {
            return superTips;
        }
        return "";
    }

    private boolean lowerNodeChooseIndex(List<Integer> ids) {
        for (int id : ids) {
            MulFieldMappingCacheVo subEntryCache = MulImportStepPluginUtil.getCurrentNodeCacheInfo(this.getView(), String.valueOf(id));
            if (null == subEntryCache || !StringUtils.isNotBlank((CharSequence)subEntryCache.getCurDataSheetIndex())) continue;
            return true;
        }
        return false;
    }

    private boolean checkAllFieldMapping(MulFieldMappingCacheVo mappingCacheVo) {
        List<MulOneFieldMappingVo> oneFieldMappingVos = mappingCacheVo.getOneFieldMappingVos();
        for (MulOneFieldMappingVo oneFieldMappingVo : oneFieldMappingVos) {
            if (oneFieldMappingVo.isMapping()) continue;
            return false;
        }
        return true;
    }

    private void cacheCustomEntryElement() {
        this.init();
        MulImportPreviewResolveService previewService = new MulImportPreviewResolveService(this.mulImportContext, this.previewContext);
        List<MulNodeDetailVo> mulTreeNodeVos = MulImportStepPluginUtil.getTreeNodeVoFromPageCache(this.getView().getPageCache());
        Map nodeMap = mulTreeNodeVos.stream().collect(Collectors.groupingBy(MulNodeDetailVo::getMainTypeName, LinkedHashMap::new, Collectors.toList()));
        ArrayList<PreviewResolveParam> previewResolveParams = new ArrayList<PreviewResolveParam>();
        for (Map.Entry entryNodeVoEntry : nodeMap.entrySet()) {
            int lastResolveRowId = 0;
            for (MulNodeDetailVo entryNode : (List)entryNodeVoEntry.getValue()) {
                int parentRowId;
                String curDataSheetIndex;
                int currentNodeSeq = entryNode.getRowId();
                MulFieldMappingCacheVo mulFieldMappingCacheVo = MulImportStepPluginUtil.getCurrentNodeCacheInfo(this.getView(), String.valueOf(currentNodeSeq));
                if (mulFieldMappingCacheVo == null || StringUtils.isBlank((CharSequence)(curDataSheetIndex = mulFieldMappingCacheVo.getCurDataSheetIndex())) || (parentRowId = entryNode.getParentRowId()) != lastResolveRowId) continue;
                lastResolveRowId = entryNode.getRowId();
                int currentSheetIndex = Integer.parseInt(mulFieldMappingCacheVo.getCurDataSheetIndex());
                String currentSheetName = MulImportStepPluginUtil.getSheetNameByValue(this.getView(), currentSheetIndex);
                int subContactFieldCol = mulFieldMappingCacheVo.getLowerRelationField();
                int parentContactFieldCol = mulFieldMappingCacheVo.getSuperRelationField();
                int startRow = -1;
                Object startRowObj = this.getView().getModel().getValue("startrow", currentNodeSeq);
                if (!ObjectUtils.isEmpty((Object)startRowObj)) {
                    startRow = Integer.parseInt(startRowObj.toString());
                }
                List<Integer> colIndexs = this.buildHeadFields(mulFieldMappingCacheVo);
                previewResolveParams.add(new PreviewResolveParam(colIndexs, entryNode.getNodeType(), currentSheetIndex, currentSheetName, startRow, parentContactFieldCol, subContactFieldCol));
            }
        }
        previewService.cacheShowData(previewResolveParams);
        List<MulDynamicColElement> headFields = this.previewContext.getHeadFields();
        this.cacheEntryElement(headFields, this.mulImportContext.getView());
    }

    private List<Integer> buildHeadFields(MulFieldMappingCacheVo mulFieldMappingCacheVo) {
        ArrayList<Integer> colIndexs = new ArrayList<Integer>(8);
        List<MulOneFieldMappingVo> fields = mulFieldMappingCacheVo.getOneFieldMappingVos();
        List<MulDynamicColElement> headFields = this.previewContext.getHeadFields();
        for (MulOneFieldMappingVo field : fields) {
            if (StringUtils.isBlank((CharSequence)field.getExcelField())) continue;
            MulFieldInfo fieldInfo = field.getFieldInfo();
            String fieldNumber = fieldInfo.getNumber();
            fieldNumber = fieldNumber.replace(".", "_");
            headFields.add(new MulDynamicColTextElement(fieldNumber, fieldInfo.getName()));
            colIndexs.add(Integer.parseInt(field.getExcelField()));
        }
        return colIndexs;
    }

    protected void init() {
        String path = this.getPageCache().get("mul_import_file_path");
        this.mulImportContext = new MulImportContext(path, ExcelTypeEnum.XLSX, this.getView(), null);
        this.mulImportContext.setFileName(this.getView().getPageCache().get("filename"));
        this.previewContext = new MulImportPreviewContext();
    }

    protected void cacheEntryElement(List<MulDynamicColElement> elementList, IFormView view) {
        MulDynamicColEntryElement entryElement = new MulDynamicColEntryElement("import_result_entry");
        entryElement.setItems(elementList);
        IPageCache pageCache = view.getPageCache();
        pageCache.put("entry_element", SerializationUtils.serializeToBase64((Object)entryElement));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void saveMulImportScheme(String schemeName, String schemeDesc, boolean isUpdate) {
        DynamicObject mainDynamicObject;
        List<MulNodeDetailVo> mulTreeNodeVos;
        block16: {
            block17: {
                mulTreeNodeVos = MulImportStepPluginUtil.getTreeNodeVoFromPageCache(this.getView().getPageCache());
                if (CollectionUtils.isEmpty(mulTreeNodeVos)) {
                    return;
                }
                mainDynamicObject = null;
                if (!isUpdate) break block17;
                Map schemeParam = (Map)this.getView().getFormShowParameter().getCustomParam("schemeParam");
                if (MapUtils.isNotEmpty((Map)schemeParam)) {
                    void var7_9;
                    Object v = schemeParam.get("id");
                    if (StringUtils.isBlank(v)) {
                        String string = this.getView().getPageCache().get("mul_import_scheme_new_create_id");
                    }
                    mainDynamicObject = BusinessDataServiceHelper.loadSingle((Object)var7_9, (String)"bos_multi_import_scheme");
                    break block16;
                } else if (StringUtils.isNotBlank((CharSequence)this.getView().getPageCache().get("mul_import_choose_scheme_id"))) {
                    String string = this.getView().getPageCache().get("mul_import_choose_scheme_id");
                    mainDynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(string), (String)"bos_multi_import_scheme");
                    break block16;
                } else {
                    if (!StringUtils.isNotBlank((CharSequence)this.getView().getPageCache().get("mul_import_scheme_new_create_id"))) {
                        log.error("update scheme get scheme param is empty");
                        return;
                    }
                    String string = this.getView().getPageCache().get("mul_import_scheme_new_create_id");
                    mainDynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(string), (String)"bos_multi_import_scheme");
                }
                break block16;
            }
            mainDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_multi_import_scheme", (boolean)false, (OperateOption)OperateOption.create());
            String number = this.getNumber(false, mainDynamicObject);
            mainDynamicObject.set("number", (Object)number);
            mainDynamicObject.set("name", (Object)schemeName);
            mainDynamicObject.set("schemedesc", (Object)schemeDesc);
            mainDynamicObject.set("status", (Object)"A");
            mainDynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
            mainDynamicObject.set("enable", (Object)"1");
        }
        mainDynamicObject.set("firstimportform", this.getModel().getValue("firstimportsheetcombo"));
        this.resetMulBaseData();
        mainDynamicObject.set("mulbasedatafield", this.getModel().getValue("mulbasedatafield"));
        mainDynamicObject.set("filepath", (Object)this.getView().getPageCache().get("mul_import_file_path"));
        this.getView().getPageCache().put("mul_import_scheme_save", "1");
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        if (CollectionUtils.isNotEmpty((Collection)attachmentPanel.getAttachmentData())) {
            Map map = (Map)attachmentPanel.getAttachmentData().get(0);
            mainDynamicObject.set("filename", map.get("name"));
            mainDynamicObject.set("filesize", map.get("size"));
        }
        DynamicObjectCollection dynamicObjectCollection = mainDynamicObject.getDynamicObjectCollection("setentryentity");
        if (isUpdate) {
            dynamicObjectCollection.clear();
        }
        for (MulNodeDetailVo mulNodeDetailVo : mulTreeNodeVos) {
            MulFieldMappingCacheVo cacheVo = MulImportStepPluginUtil.getCurrentNodeCacheInfo(this.getView(), String.valueOf(mulNodeDetailVo.getRowId()));
            if (null == cacheVo) continue;
            DynamicObject entryDynamicObject = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
            entryDynamicObject.set("mainnumber", (Object)mulNodeDetailVo.getMainTypeName());
            entryDynamicObject.set("entitynumber", (Object)mulNodeDetailVo.getNodeNumber());
            entryDynamicObject.set("detailsheet", StringUtils.isNotBlank((CharSequence)cacheVo.getCurDataSheetIndex()) ? cacheVo.getCurDataSheetIndex() : Integer.valueOf(-1));
            if (StringUtils.isNotBlank((CharSequence)cacheVo.getCurrentNode())) {
                int nodeId = Integer.parseInt(cacheVo.getCurrentNode());
                entryDynamicObject.set("importtype", this.getModel().getValue("importtypechoose", nodeId));
                entryDynamicObject.set("datareplacenumber", this.getModel().getValue("datareplacevalue", nodeId));
                entryDynamicObject.set("datareplacename", this.getModel().getValue("datareplacevalueshow", nodeId));
                entryDynamicObject.set("startrow", this.getModel().getValue("startrow", nodeId));
                entryDynamicObject.set(SCHEME_STARTCOLUMN, this.getModel().getValue("startcolumn", nodeId));
            } else {
                log.error("step three get node id from cache is empty");
            }
            entryDynamicObject.set("lowerconcatefield", (Object)cacheVo.getLowerRelationField());
            entryDynamicObject.set("superconcatefield", (Object)cacheVo.getSuperRelationField());
            entryDynamicObject.set("nodeid", (Object)mulNodeDetailVo.getRowId());
            entryDynamicObject.set("pnodeid", (Object)mulNodeDetailVo.getParentRowId());
            entryDynamicObject.set("nodetype", (Object)mulNodeDetailVo.getNodeType());
            entryDynamicObject.set("sheetname", (Object)cacheVo.getCurDataSheetName());
            dynamicObjectCollection.add((Object)entryDynamicObject);
            List<String> headColumn = MulImportStepPluginUtil.getHeadColumn(this.getView(), String.valueOf(mulNodeDetailVo.getRowId()));
            DynamicObjectCollection subEntryDynamicObjects = entryDynamicObject.getDynamicObjectCollection("subentryentity");
            List<MulOneFieldMappingVo> mulOneFieldMappingVos = cacheVo.getOneFieldMappingVos();
            for (MulOneFieldMappingVo oneFieldMappingVo : mulOneFieldMappingVos) {
                String excelFiled = oneFieldMappingVo.getExcelField();
                DynamicObject subEntryDynamicObject = new DynamicObject(subEntryDynamicObjects.getDynamicObjectType());
                subEntryDynamicObject.set("entityfieldnumber", (Object)oneFieldMappingVo.getFieldInfo().getNumber());
                subEntryDynamicObject.set("entityfieldname", (Object)oneFieldMappingVo.getFieldInfo().getName());
                subEntryDynamicObject.set("ismapping", (Object)(oneFieldMappingVo.isMapping() ? 1 : 0));
                subEntryDynamicObject.set("excelfield", StringUtils.isNotBlank((CharSequence)excelFiled) ? excelFiled : Integer.valueOf(-1));
                if (StringUtils.isNotBlank((CharSequence)excelFiled) && CollectionUtils.isNotEmpty(headColumn) && headColumn.size() > Integer.parseInt(excelFiled)) {
                    subEntryDynamicObject.set("excelfieldname", (Object)headColumn.get(Integer.parseInt(excelFiled)));
                }
                subEntryDynamicObject.set("basedatatype", (Object)oneFieldMappingVo.getFieldInfo().getType());
                if (null != oneFieldMappingVo.getFieldInfo().getFieldType()) {
                    subEntryDynamicObject.set("fieldtype", (Object)oneFieldMappingVo.getFieldInfo().getFieldType().getType());
                }
                subEntryDynamicObject.set("propseq", (Object)oneFieldMappingVo.getFieldInfo().getPropSeq().getSeq());
                subEntryDynamicObjects.add((Object)subEntryDynamicObject);
            }
        }
        Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainDynamicObject});
        if (!isUpdate && null != result && result[0] instanceof DynamicObject) {
            this.getView().getPageCache().put("mul_import_scheme_new_create_id", ((DynamicObject)result[0]).getPkValue().toString());
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MulImportSchemePlugin_3", (String)"bos-import", (Object[])new Object[0]));
    }

    private void resetMulBaseData() {
        Object importDynColObj = this.getModel().getValue("mulbasedatafield");
        if (importDynColObj instanceof MulBasedataDynamicObjectCollection) {
            MulBasedataDynamicObjectCollection importDynCol = (MulBasedataDynamicObjectCollection)importDynColObj;
            String[] importDynIds = new String[importDynCol.size()];
            for (int i = 0; i < importDynCol.size(); ++i) {
                DynamicObject importDyn = (DynamicObject)importDynCol.get(i);
                importDynIds[i] = importDyn.getString("fbasedataid_id");
            }
            this.getModel().setValue("mulbasedatafield", (Object)importDynIds);
        }
    }

    private String getNumber(boolean isRead, DynamicObject dynamicObject) {
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"bos_multi_import_scheme", (DynamicObject)dynamicObject, (String)String.valueOf(RequestContext.get().getOrgId()));
        if (isRead) {
            return CodeRuleServiceHelper.readNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)dynamicObject);
        }
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)dynamicObject);
    }

    protected void showSaveSchemeForm(boolean executeImport) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_multi_import_scheme", (boolean)true, (OperateOption)OperateOption.create());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("bos_mulimport_scheme_save");
        showParameter.setCustomParam("number", (Object)this.getNumber(true, dynamicObject));
        showParameter.setCustomParam("executeImport", (Object)executeImport);
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "show_scheme_save"));
        this.getView().showForm(showParameter);
    }

    private void initSchemeNodeMap() {
        String mapCache = this.getView().getPageCache().get("mul_import_scheme_node_map");
        if (StringUtils.isNotBlank((CharSequence)mapCache)) {
            this.schemeNodeMap = (Map)SerializationUtils.fromJsonString((String)mapCache, Map.class);
        }
        this.currentSchemeDyn = this.getSchemeInfo();
    }

    private DynamicObject getCurrentNodeInfoFromScheme(String nodeId) {
        if (null != this.currentSchemeDyn && null != this.schemeNodeMap) {
            DynamicObjectCollection entryCollection = this.currentSchemeDyn.getDynamicObjectCollection("setentryentity");
            for (DynamicObject dynamicObject : entryCollection) {
                if (null == this.schemeNodeMap.get(nodeId) || dynamicObject.getLong("id") != this.schemeNodeMap.get(nodeId).longValue()) continue;
                return dynamicObject;
            }
        }
        return null;
    }

    private String setMappingDesc(MulFieldTypeEnum mulFieldTypeEnum, String fieldNumber, String fieldName, String lastSpecialField, int currentNode, String relationField) {
        int fieldType = mulFieldTypeEnum.getType();
        if (fieldType == 1 || fieldType == 3 || fieldType == 4 || fieldType == 5) {
            String message;
            String currentSpecialField;
            if (fieldType == 1) {
                String[] fieldNumbers = fieldNumber.split("\\.");
                currentSpecialField = fieldNumbers[0];
                if (lastSpecialField.equals(currentSpecialField)) {
                    return lastSpecialField;
                }
                message = ResManager.loadKDString((String)"\u82e5\u9700\u5bfc\u5165%1$s\uff0c%2$s.\u5185\u7801\u3001%3$s.\u7f16\u7801\u548c%4$s.\u540d\u79f0\u9700\u81f3\u5c11\u6620\u5c04\u4e00\u4e2a\u3002", (String)"MulImportStepPlugin_19", (String)"bos-import", (Object[])new Object[0]);
                message = String.format(message, fieldName, fieldName, fieldName, fieldName);
            } else if (fieldType == 3) {
                String[] fieldNumbers = fieldNumber.split("\\.");
                currentSpecialField = fieldNumbers[0];
                if (lastSpecialField.equals(currentSpecialField)) {
                    return lastSpecialField;
                }
                message = ResManager.loadKDString((String)"\u82e5\u9700\u5bfc\u5165%1$s\uff0c%2$s\u9700\u81f3\u5c11\u6620\u5c04\u4e00\u79cd\u8bed\u8a00\u3002", (String)"MulImportStepPlugin_20", (String)"bos-import", (Object[])new Object[0]);
                message = String.format(message, fieldName, fieldName);
            } else if (fieldType == 4) {
                String[] fieldNumbers = fieldNumber.split("\\.");
                currentSpecialField = fieldNumbers[0];
                if (lastSpecialField.equals(currentSpecialField)) {
                    return lastSpecialField;
                }
                message = ResManager.loadKDString((String)"\u82e5\u9700\u5bfc\u5165%1$s\uff0c%2$s\u548c%3$s_\u8be6\u60c5\u9700\u81f3\u5c11\u6620\u5c04\u4e00\u4e2a\u3002", (String)"MulImportStepPlugin_21", (String)"bos-import", (Object[])new Object[0]);
                message = String.format(message, fieldName, fieldName, fieldName);
            } else {
                currentSpecialField = relationField;
                if (lastSpecialField.equals(fieldNumber)) {
                    return lastSpecialField;
                }
                String fieldNameDeal = fieldName.substring(0, fieldName.lastIndexOf("."));
                message = ResManager.loadKDString((String)"\u82e5\u9700\u5bfc\u5165%1$s\uff0c%2$s.\u5f00\u59cb\u548c%3$s.\u7ed3\u675f\u9700\u90fd\u8981\u6620\u5c04\u3002", (String)"MulImportStepPlugin_22", (String)"bos-import", (Object[])new Object[0]);
                message = String.format(message, fieldNameDeal, fieldNameDeal, fieldNameDeal);
            }
            this.getModel().setValue("mapdesc", (Object)message, currentNode);
            return currentSpecialField;
        }
        return "";
    }

    private boolean schemeNotChanged(DynamicObject schemeObject, int nodeId) {
        if (null == schemeObject) {
            return false;
        }
        Object startRow = this.getModel().getValue("startrow", nodeId);
        Object startCol = this.getModel().getValue("startcolumn", nodeId);
        Object sheet = this.getModel().getValue("detailsheetchoose", nodeId);
        return null != startRow && startRow.equals(schemeObject.get("startrow")) && null != startCol && startCol.equals(schemeObject.get(SCHEME_STARTCOLUMN)) && null != sheet && sheet.equals(String.valueOf(schemeObject.getInt("detailsheet")));
    }

    private void setIconForTree(String nodeId, boolean addIcon) {
        String treeNodeInfo = this.getView().getPageCache().get("mul_import_tree_cache");
        List roots = SerializationUtils.fromJsonStringToList((String)treeNodeInfo, TreeNode.class);
        TreeNode currentNode = this.findNodeById(nodeId, roots);
        if (null != currentNode) {
            TreeView treeView = (TreeView)this.getView().getControl("entitychoosetree");
            ArrayList<TreeNodePartialVariables> nodeVariables = new ArrayList<TreeNodePartialVariables>(1);
            TreeNodePartialVariables treeNodePartialVariables = new TreeNodePartialVariables();
            if (addIcon) {
                treeNodePartialVariables.setSuffixIconProps(this.getSuffixIconProps());
            } else {
                treeNodePartialVariables.setSuffixIconProps(this.getEmptySuffixIconProps());
            }
            treeNodePartialVariables.setId(currentNode.getId());
            nodeVariables.add(treeNodePartialVariables);
            treeView.updateNodeProps(nodeVariables);
        }
    }

    private TreeNode findNodeById(String nodeId, List<TreeNode> roots) {
        TreeNode findNode = roots.stream().filter(node -> node.getId().equals(nodeId)).findFirst().orElse(null);
        if (null != findNode) {
            return findNode;
        }
        for (TreeNode treeNode : roots) {
            TreeNode subNode;
            if (!CollectionUtils.isNotEmpty((Collection)treeNode.getChildren()) || null == (subNode = this.findNodeById(nodeId, treeNode.getChildren()))) continue;
            return subNode;
        }
        return null;
    }

    private SuffixIconProps getSuffixIconProps() {
        SuffixIconProps suffixIconProps = new SuffixIconProps();
        SuffixIcon suffixIcon = new SuffixIcon();
        suffixIcon.setColor("#FF991C");
        suffixIcon.setId(ID.genStringId());
        suffixIcon.setName("kdfont-jinggao");
        ArrayList<SuffixIcon> suffixIcons = new ArrayList<SuffixIcon>(1);
        suffixIcons.add(suffixIcon);
        suffixIconProps.setSuffixIcons(suffixIcons);
        suffixIconProps.setSuffixIconShowType(1);
        return suffixIconProps;
    }

    private SuffixIconProps getEmptySuffixIconProps() {
        SuffixIconProps suffixIconProps = new SuffixIconProps();
        ArrayList suffixIcons = new ArrayList();
        suffixIconProps.setSuffixIcons(suffixIcons);
        suffixIconProps.setSuffixIconShowType(1);
        return suffixIconProps;
    }

    private boolean initTreeSetIcon(String nodeId) {
        MulFieldMappingCacheVo mulFieldMappingCacheVo = MulImportStepPluginUtil.getCurrentNodeCacheInfo(this.getView(), nodeId);
        int nodeLevel = this.nodeLevel(Integer.parseInt(nodeId));
        DynamicObject schemeInfo = this.getSchemeInfo();
        if (null != mulFieldMappingCacheVo) {
            if (nodeLevel == 1) {
                return mulFieldMappingCacheVo.getLowerRelationField() == -1;
            }
            if (nodeLevel == 2) {
                return mulFieldMappingCacheVo.getLowerRelationField() == -1 || mulFieldMappingCacheVo.getSuperRelationField() == -1;
            }
            if (nodeLevel == 3) {
                return mulFieldMappingCacheVo.getSuperRelationField() == -1;
            }
            return false;
        }
        if (null != schemeInfo) {
            DynamicObjectCollection schemeEntityCol = schemeInfo.getDynamicObjectCollection("setentryentity");
            for (DynamicObject schemeEntity : schemeEntityCol) {
                if (!nodeId.equals(schemeEntity.getString("nodeid"))) continue;
                int lowerField = schemeEntity.getInt("lowerconcatefield");
                int superField = schemeEntity.getInt("superconcatefield");
                if (nodeLevel == 1) {
                    return lowerField == -1;
                }
                if (nodeLevel == 2) {
                    return lowerField == -1 || superField == -1;
                }
                if (nodeLevel == 3) {
                    return superField == -1;
                }
                return false;
            }
        } else {
            return nodeLevel != 0;
        }
        return true;
    }
}

