/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.stepplugin.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.mulimport.stepplugin.util.SearchResult;
import kd.bos.util.CollectionUtils;

public class MulImportSearch
implements Serializable {
    private static final long serialVersionUID = 2022046614691331240L;
    private List<TreeNode> roots;
    private Queue<TreeNode> searchNodesQueue = new LinkedList<TreeNode>();
    private String oldSearchText;
    private boolean searched = false;
    private boolean loadedAllApp = false;
    private boolean searchedEmpty = false;

    public MulImportSearch() {
    }

    public MulImportSearch(List<TreeNode> roots) {
        this.roots = roots;
    }

    private void collectSearchNodes(String searchText) {
        if (this.searched) {
            return;
        }
        this.searchAllNode(searchText);
        this.searched = true;
        this.searchedEmpty = this.searchNodesQueue.isEmpty();
    }

    public SearchResult search(String searchText) {
        SearchResult result = new SearchResult();
        if (!StringUtils.equals((CharSequence)searchText, (CharSequence)this.oldSearchText)) {
            this.clear(searchText);
        }
        TreeNode searchNode = null;
        searchNode = this.searchNodesQueue.poll();
        if (searchNode != null) {
            result.setSuccess(true).setData(searchNode);
            return result;
        }
        this.collectSearchNodes(searchText);
        searchNode = this.searchNodesQueue.poll();
        if (searchNode != null) {
            result.setSuccess(true).setData(searchNode);
            return result;
        }
        int errCode = this.searchedEmpty ? 1 : 0;
        result.setSuccess(false).setErrorCode(errCode);
        return result;
    }

    public void clear(String searchText) {
        this.searchNodesQueue.clear();
        this.oldSearchText = searchText;
        this.searched = false;
    }

    private void searchRoot(String searchText) {
        List<TreeNode> cloudNodes = this.roots;
        if (cloudNodes == null || cloudNodes.isEmpty()) {
            return;
        }
        ArrayList searchedRoot = new ArrayList(10);
        for (TreeNode root : this.roots) {
            root.getTreeNodeListByText(searchedRoot, searchText, 1);
        }
        this.searchNodesQueue.addAll(searchedRoot);
    }

    private void searchEntryNode(String searchText) {
        ArrayList searchedEntry = new ArrayList(10);
        for (TreeNode root : this.roots) {
            List entryNodes = root.getChildren();
            if (!CollectionUtils.isNotEmpty((Collection)entryNodes)) continue;
            for (TreeNode entryNode : entryNodes) {
                entryNode.getTreeNodeListByText(searchedEntry, searchText, 1);
            }
        }
        this.searchNodesQueue.addAll(searchedEntry);
    }

    private void searchAllNode(String searchText) {
        ArrayList searchedNode = new ArrayList(10);
        for (TreeNode root : this.roots) {
            root.getTreeNodeListByText(searchedNode, searchText, 1);
            List entryNodes = root.getChildren();
            if (!CollectionUtils.isNotEmpty((Collection)entryNodes)) continue;
            for (TreeNode entryNode : entryNodes) {
                entryNode.getTreeNodeListByText(searchedNode, searchText, 2);
                List subEntryNodes = entryNode.getChildren();
                if (!CollectionUtils.isNotEmpty((Collection)subEntryNodes)) continue;
                for (TreeNode subEntryNode : subEntryNodes) {
                    subEntryNode.getTreeNodeListByText(searchedNode, searchText, 3);
                }
            }
        }
        this.searchNodesQueue.addAll(searchedNode);
    }

    private boolean containsText(TreeNode node, String searchText) {
        return node.getText().contains(searchText);
    }

    public List<TreeNode> getRoots() {
        return this.roots;
    }

    public void setRoots(List<TreeNode> roots) {
        this.roots = roots;
    }

    public String getOldSearchText() {
        return this.oldSearchText;
    }

    public void setOldSearchText(String oldSearchText) {
        this.oldSearchText = oldSearchText;
    }

    public boolean isSearched() {
        return this.searched;
    }

    public void setSearched(boolean searched) {
        this.searched = searched;
    }

    public boolean isLoadedAllApp() {
        return this.loadedAllApp;
    }

    public void setLoadedAllApp(boolean loadedAllApp) {
        this.loadedAllApp = loadedAllApp;
    }

    public Queue<TreeNode> getSearchNodesQueue() {
        return this.searchNodesQueue;
    }

    public void setSearchNodesQueue(Queue<TreeNode> searchNodesQueue) {
        this.searchNodesQueue = searchNodesQueue;
    }

    public boolean isSearchedEmpty() {
        return this.searchedEmpty;
    }

    public void setSearchedEmpty(boolean searchedEmpty) {
        this.searchedEmpty = searchedEmpty;
    }
}

