/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.stepplugin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.resolve.model.MulFieldInfo;
import kd.bos.mulimport.resolve.model.MulFieldMappingCacheVo;
import kd.bos.mulimport.resolve.model.MulImportDataMappingRule;
import kd.bos.mulimport.resolve.model.MulImportResolveTypeEnum;
import kd.bos.mulimport.resolve.model.MulNodeDetailVo;
import kd.bos.mulimport.resolve.model.MulNodeFieldMap;
import kd.bos.mulimport.resolve.model.MulOneFieldMappingVo;
import kd.bos.mulimport.resolve.model.MulSheetVo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.api.TaskStatusConstant;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.util.CollectionUtils;

public class MulImportStepPluginUtil {
    private static final Log log = LogFactory.getLog(MulImportStepPluginUtil.class);
    private static final String BOS_IMPORT = "bos-import";
    private static final String BOS_POPCOMBO = "bos_popcombo";
    private static final String BOS_POPCOMBO_MAXSELECT = "maxselect";
    private static final String IMPORT_MULTI_PROGRESS = "bos_multi_import_progress";
    private static final String CACHE_KEY_PROGRESS = "Cache_Multi_Import_Progress";
    private static final String CACHE_KEY_IMPORT_RESULT_PK = "import_result_pk";
    private static final String CACHE_KEY_IMPORTSTATUS = "cache_key_importStatus";
    private static final String CACHE_KEY_HASIGNORESHEETNAME = "cache_key_hasIgnoreSheetName";
    private static final String CACHE_KEY_ErrorFile_Url = "cache_key_errorfile_url";
    private static final String CACHE_KEY_STATUS = "Cache_Multi_Import_Status";
    private static final String START_KEY = "CHECK_MUL_IMPORT_START_KEY";
    private static final String FINISHED_KEY = "CHECK_MUL_IMPORT_FINISHED_KEY";
    private static final String FAIL_KEY = "CHECK_MUL_IMPORT_FAIL_KEY";
    private static final String CACHE_KEY_MULTI_IMPORT_ENTITY_STATUS = "CACHE_MULTI_IMPORT_ENTITY_STATUS";
    private static final String CACHE_KEY_CHOOSE_FIRST_IMPORT = "chooseFirstImport";
    public static final String CACHEKEY_MUL_TASKID = "mul_import_taskid";

    public static void createSheetChooseCombo(IFormView formView, String comboName, List<ComboItem> comboItems) {
        ComboEdit comboEdit = (ComboEdit)formView.getControl(comboName);
        comboEdit.setComboItems(comboItems);
    }

    public static List<ComboItem> getSheetComboItem(IFormView iFormView) {
        List sheetList = SerializationUtils.fromJsonStringToList((String)iFormView.getPageCache().get("mul_import_sheet_name"), String.class);
        return MulImportStepPluginUtil.getComboItemByList(sheetList);
    }

    public static String getSheetNameByValue(IFormView iFormView, int value) {
        List sheetList = SerializationUtils.fromJsonStringToList((String)iFormView.getPageCache().get("mul_import_sheet_name"), String.class);
        return (String)sheetList.get(value);
    }

    public static void createMulPageComboByExcelHead(IFormView view, String comboControlName, String currentNode) {
        String cache = view.getPageCache().get("mul_import_sheet_head_copy");
        if (StringUtils.isBlank((CharSequence)cache)) {
            cache = view.getPageCache().get("mul_import_sheet_head");
        }
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            int nodeId = Integer.parseInt(currentNode);
            List mulSheetVos = SerializationUtils.fromJsonStringToList((String)cache, MulSheetVo.class);
            if (CollectionUtils.isNotEmpty((Collection)mulSheetVos) || mulSheetVos.size() <= nodeId) {
                MulSheetVo currentSheetVo = mulSheetVos.stream().filter(item -> item.getEntityRow() == nodeId).findFirst().orElse(null);
                if (null != currentSheetVo) {
                    List<String> sheetHeads = currentSheetVo.getHeadCells();
                    if (comboControlName.equals("excelfield")) {
                        MulImportStepPluginUtil.resetHeadName(sheetHeads);
                    }
                    ComboEdit comboEdit = (ComboEdit)view.getControl(comboControlName);
                    List<ComboItem> comboItemList = MulImportStepPluginUtil.getComboItemByList(sheetHeads);
                    comboEdit.setComboItems(comboItemList);
                }
            } else {
                log.error("get sheet info error and cache is :" + cache);
            }
        } else {
            log.error("get cache mul_import_sheet_head is empty");
        }
    }

    private static void resetHeadName(List<String> sheetHeads) {
        List repeatList = sheetHeads.stream().collect(Collectors.toMap(e -> e, e -> 1, Integer::sum)).entrySet().stream().filter(e -> (Integer)e.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(repeatList)) {
            String message = ResManager.loadKDString((String)"\uff08Excel\u7684%s\u5217\uff09", (String)"MulImportStepPlugin_25", (String)BOS_IMPORT, (Object[])new Object[0]);
            for (int i = 0; i < sheetHeads.size(); ++i) {
                String sheet = sheetHeads.get(i);
                if (!repeatList.contains(sheet) || StringUtils.isBlank((CharSequence)sheet)) continue;
                String columnReference = MulImportStepPluginUtil.getColumnReference(i + 1);
                sheetHeads.set(i, sheet + String.format(message, columnReference));
            }
        }
    }

    private static String getColumnReference(int columnNumber) {
        StringBuilder reference = new StringBuilder();
        while (columnNumber > 0) {
            int modulo = (columnNumber - 1) % 26;
            reference.insert(0, (char)(modulo + 65));
            columnNumber = (columnNumber - modulo - 1) / 26;
        }
        return reference.toString();
    }

    public static String matchSheetName(IFormView iFormView, String entityName) {
        List sheetList = SerializationUtils.fromJsonStringToList((String)iFormView.getPageCache().get("mul_import_sheet_name"), String.class);
        return sheetList.stream().filter(item -> item.equals(entityName)).findFirst().orElse("");
    }

    public static List<String> getHeadColumn(IFormView iFormView, String nodeId) {
        String cache = iFormView.getPageCache().get("mul_import_sheet_head_copy");
        if (StringUtils.isBlank((CharSequence)cache)) {
            cache = iFormView.getPageCache().get("mul_import_sheet_head");
        }
        List mulSheetVos = SerializationUtils.fromJsonStringToList((String)cache, MulSheetVo.class);
        MulSheetVo currentSheet = mulSheetVos.stream().filter(item -> String.valueOf(item.getEntityRow()).equals(nodeId)).findFirst().orElseGet(MulSheetVo::new);
        return currentSheet.getHeadCells();
    }

    private static List<ComboItem> getComboItemByList(List<String> values) {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        for (int i = 0; i < values.size(); ++i) {
            if (StringUtils.isBlank((CharSequence)values.get(i))) continue;
            comboItemList.add(new ComboItem(new LocaleString(values.get(i)), String.valueOf(i)));
        }
        return comboItemList;
    }

    public static int getSheetComboIndexByName(IFormView iFormView, String currentSheetName) {
        List sheetList = SerializationUtils.fromJsonStringToList((String)iFormView.getPageCache().get("mul_import_sheet_name"), String.class);
        return IntStream.range(0, sheetList.size()).filter(i -> currentSheetName.equals(sheetList.get(i))).findFirst().orElse(-1);
    }

    public static FormShowParameter getShowParameter() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u5c5e\u6027", (String)"ImportTemplatePlugin_5", (String)BOS_IMPORT, (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId(BOS_POPCOMBO);
        showParameter.setCustomParam(BOS_POPCOMBO_MAXSELECT, (Object)1);
        return showParameter;
    }

    public static List<MulNodeDetailVo> getTreeNodeVoFromPageCache(IPageCache pageCache) {
        String pageCacheStr = pageCache.get("mul_import_mulTreeNodeMapping_reset");
        if (StringUtils.isNotBlank((CharSequence)pageCacheStr)) {
            return SerializationUtils.fromJsonStringToList((String)pageCacheStr, MulNodeDetailVo.class);
        }
        return new ArrayList<MulNodeDetailVo>();
    }

    public static List<MulNodeDetailVo> getAllTreeNodeVoFromPageCache(IPageCache pageCache) {
        String pageCacheStr = pageCache.get("mul_import_mulTreeNodeMapping");
        if (StringUtils.isNotBlank((CharSequence)pageCacheStr)) {
            return SerializationUtils.fromJsonStringToList((String)pageCacheStr, MulNodeDetailVo.class);
        }
        return new ArrayList<MulNodeDetailVo>();
    }

    public static List<Integer> getLowerNodeIdByCurrentId(int currentIndex, IPageCache pageCache, boolean containsSubEntry, boolean containsNotMappingSheet) {
        List<MulNodeDetailVo> mulTreeNodeVos = containsNotMappingSheet ? MulImportStepPluginUtil.getAllTreeNodeVoFromPageCache(pageCache) : MulImportStepPluginUtil.getTreeNodeVoFromPageCache(pageCache);
        ArrayList<Integer> lowerNodeIds = new ArrayList<Integer>();
        MulNodeDetailVo mulNodeDetailVo = mulTreeNodeVos.stream().filter(item -> item.getRowId() == currentIndex).findFirst().orElse(null);
        if (null == mulNodeDetailVo) {
            return lowerNodeIds;
        }
        if (mulNodeDetailVo.getNodeType() == MulImportResolveTypeEnum.HEAD.getType()) {
            for (MulNodeDetailVo currentNode : mulTreeNodeVos) {
                if (!currentNode.getMainTypeName().equals(mulNodeDetailVo.getMainTypeName()) || currentNode.getRowId() == currentNode.getParentRowId()) continue;
                if (containsSubEntry) {
                    lowerNodeIds.add(currentNode.getRowId());
                    continue;
                }
                if (currentNode.getNodeType() != MulImportResolveTypeEnum.ENTRY.getType()) continue;
                lowerNodeIds.add(currentNode.getRowId());
            }
        }
        return lowerNodeIds;
    }

    public static List<Integer> getSubEntryIdByEntryId(int currentIndex, IPageCache pageCache, boolean containsNotMappingSheet) {
        List<MulNodeDetailVo> mulTreeNodeVos = containsNotMappingSheet ? MulImportStepPluginUtil.getAllTreeNodeVoFromPageCache(pageCache) : MulImportStepPluginUtil.getTreeNodeVoFromPageCache(pageCache);
        ArrayList<Integer> lowerNodeIds = new ArrayList<Integer>();
        MulNodeDetailVo mulNodeDetailVo = mulTreeNodeVos.stream().filter(item -> item.getRowId() == currentIndex).findFirst().orElse(null);
        if (null == mulNodeDetailVo) {
            return lowerNodeIds;
        }
        if (mulNodeDetailVo.getNodeType() == MulImportResolveTypeEnum.ENTRY.getType()) {
            for (MulNodeDetailVo currentNode : mulTreeNodeVos) {
                if (!currentNode.getMainTypeName().equals(mulNodeDetailVo.getMainTypeName()) || currentNode.getRowId() == currentNode.getParentRowId() || currentNode.getParentRowId() != currentIndex || currentNode.getNodeType() != MulImportResolveTypeEnum.SUB_ENTRY.getType()) continue;
                lowerNodeIds.add(currentNode.getRowId());
            }
        }
        return lowerNodeIds;
    }

    public static boolean notFirstClickNode(IFormView iFormView) {
        String lastNodeId = iFormView.getPageCache().get("mul_import_last_tree_node_id");
        return StringUtils.isNotEmpty((CharSequence)lastNodeId);
    }

    public static MulFieldMappingCacheVo getCurrentNodeCacheInfo(IFormView iFormView, String nodeId) {
        String cache = iFormView.getPageCache().get("mul_import_mul_field_mapping_" + nodeId);
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            return (MulFieldMappingCacheVo)SerializationUtils.fromJsonString((String)cache, MulFieldMappingCacheVo.class);
        }
        return null;
    }

    public static void cacheBeforeTreeInfo(IFormView iFormView, IDataModel iDataModel) {
        String cache;
        if (MulImportStepPluginUtil.notFirstClickNode(iFormView) && StringUtils.isNotEmpty((CharSequence)(cache = iFormView.getPageCache().get("mul_import_allFields4CurrentNode")))) {
            Object currentChooseSheet;
            MulNodeFieldMap mulNodeFieldMap = (MulNodeFieldMap)SerializationUtils.fromJsonString((String)cache, MulNodeFieldMap.class);
            List<MulFieldInfo> fieldInfos = mulNodeFieldMap.getMulFieldInfoList();
            String lastNodeId = iFormView.getPageCache().get("mul_import_last_tree_node_id");
            if (StringUtils.isNotEmpty((CharSequence)lastNodeId) && CollectionUtils.isNotEmpty(fieldInfos) && !ObjectUtils.isEmpty((Object)(currentChooseSheet = iDataModel.getValue("detailsheetchoose", Integer.parseInt(lastNodeId))))) {
                MulImportStepPluginUtil.cacheTreeInfo(lastNodeId, iFormView, iDataModel, fieldInfos);
            }
        }
    }

    public static void cacheCurrentTreeInfo(String currentNode, IFormView iFormView, IDataModel model, List<MulFieldInfo> fieldInfos) {
        if (StringUtils.isEmpty((CharSequence)currentNode)) {
            currentNode = iFormView.getPageCache().get("mul_import_last_tree_node_id");
        }
        if (CollectionUtils.isEmpty(fieldInfos)) {
            MulNodeFieldMap mulNodeFieldMap = (MulNodeFieldMap)SerializationUtils.fromJsonString((String)iFormView.getPageCache().get("mul_import_allFields4CurrentNode"), MulNodeFieldMap.class);
            fieldInfos = mulNodeFieldMap.getMulFieldInfoList();
        }
        if (StringUtils.isNotEmpty((CharSequence)currentNode) && CollectionUtils.isNotEmpty(fieldInfos)) {
            MulImportStepPluginUtil.cacheTreeInfo(currentNode, iFormView, model, fieldInfos);
        }
    }

    private static void cacheTreeInfo(String nodeId, IFormView iFormView, IDataModel model, List<MulFieldInfo> fieldInfos) {
        DynamicObjectCollection dynamicObjects = model.getEntryEntity("fieldmapppingentry");
        if (CollectionUtils.isNotEmpty(fieldInfos) && dynamicObjects.size() == fieldInfos.size()) {
            Object currentSheetIndex = model.getValue("entitysheetrelation");
            Object currentSheetName = model.getValue("entitysheetrelationshow");
            String currentSheetIndexStr = ObjectUtils.isEmpty((Object)currentSheetIndex) ? "" : String.valueOf(currentSheetIndex);
            String currentSheetNameStr = ObjectUtils.isEmpty((Object)currentSheetName) ? "" : String.valueOf(currentSheetName);
            Object lowerRelationField = model.getValue("withlowerrelation");
            int lowerRelationFieldCol = ObjectUtils.isEmpty((Object)lowerRelationField) ? -1 : Integer.parseInt(lowerRelationField.toString());
            Object superRelationField = model.getValue("withsuperrelation");
            int superRelationFieldCol = ObjectUtils.isEmpty((Object)superRelationField) ? -1 : Integer.parseInt(superRelationField.toString());
            MulFieldMappingCacheVo fieldMappingCacheVo = new MulFieldMappingCacheVo(currentSheetIndexStr, currentSheetNameStr, nodeId, lowerRelationFieldCol, superRelationFieldCol);
            ArrayList<MulOneFieldMappingVo> fieldMappingVos = new ArrayList<MulOneFieldMappingVo>(dynamicObjects.size());
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                MulOneFieldMappingVo oneFieldMappingVo = new MulOneFieldMappingVo();
                oneFieldMappingVo.setMapping("1".equals(dynamicObject.getString("ismapping")));
                oneFieldMappingVo.setExcelField(dynamicObject.getString("excelfield"));
                oneFieldMappingVo.setFieldInfo(fieldInfos.get(i));
                fieldMappingVos.add(oneFieldMappingVo);
            }
            fieldMappingCacheVo.setOneFieldMappingVos(fieldMappingVos);
            iFormView.getPageCache().put("mul_import_mul_field_mapping_" + nodeId, SerializationUtils.toJsonString((Object)fieldMappingCacheVo));
        }
    }

    public static Map<Integer, String> getEntityNameByTreeIdFromCache(IPageCache pageCache, DynamicObjectCollection dynamicObjectCollection) {
        LinkedHashMap<Integer, String> names = new LinkedHashMap<Integer, String>();
        int size = dynamicObjectCollection.size();
        List<MulNodeDetailVo> mulTreeNodeVos = MulImportStepPluginUtil.getAllTreeNodeVoFromPageCache(pageCache);
        if (mulTreeNodeVos.size() < size) {
            return names;
        }
        for (int i = 0; i < size; ++i) {
            MulNodeDetailVo mulNodeDetailVo = mulTreeNodeVos.get(i);
            String currentName = ((DynamicObject)dynamicObjectCollection.get(i)).getString("importentity");
            if (mulNodeDetailVo.getNodeType() == MulImportResolveTypeEnum.HEAD.getType()) {
                names.put(i, currentName);
                continue;
            }
            names.put(i, (String)names.get(mulNodeDetailVo.getParentRowId()) + "." + currentName);
        }
        return names;
    }

    public static void executeImport(List<MulImportDataMappingRule> rules, IFormView view) {
        String taskId = view.getPageCache().get(CACHEKEY_MUL_TASKID);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo == null || StringUtils.isBlank((CharSequence)taskInfo.getStatus()) || TaskStatusConstant.isEnd((String)taskInfo.getStatus())) {
            MulImportStepPluginUtil.removeCache(view);
            Set mainEntityNames = rules.stream().filter(rule -> rule.getMulImportResolveTypeEnum() == MulImportResolveTypeEnum.HEAD).map(rule -> rule.getEntityType().getDisplayName().getLocaleValue()).collect(Collectors.toCollection(LinkedHashSet::new));
            MulImportStepPluginUtil.executeImport(rules, view, mainEntityNames);
            return;
        }
        view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7b49\u5f85\u5f53\u524d\u5bfc\u5165\u5b8c\u6210\uff0c\u518d\u8fdb\u884c\u5bfc\u5165\u3002", (String)"BOS_IMPORT_31", (String)BOS_IMPORT, (Object[])new Object[0]));
    }

    public static boolean isStart(IFormView view) {
        return StringUtils.isNotBlank((CharSequence)view.getPageCache().get(START_KEY));
    }

    public static void removeCache(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        pageCache.remove(CACHE_KEY_IMPORTSTATUS);
        pageCache.remove(CACHE_KEY_HASIGNORESHEETNAME);
        pageCache.remove(CACHE_KEY_ErrorFile_Url);
        pageCache.remove(CACHE_KEY_PROGRESS);
        pageCache.remove(CACHE_KEY_STATUS);
        pageCache.remove(CACHE_KEY_MULTI_IMPORT_ENTITY_STATUS);
        pageCache.remove(FAIL_KEY);
        pageCache.remove(FINISHED_KEY);
        pageCache.remove(START_KEY);
        pageCache.remove(CACHE_KEY_CHOOSE_FIRST_IMPORT);
        log.info("removeCache success");
    }

    public static void executeImport(List<MulImportDataMappingRule> rules, IFormView view, Set<String> mainEntityNames) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(IMPORT_MULTI_PROGRESS);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("importNames", (Object)SerializationUtils.toJsonString(mainEntityNames));
        showParameter.setCustomParam("importStartPageId", (Object)view.getPageId());
        showParameter.setCustomParam("MulImportDataMappingRulesStr", (Object)SerializationUtils.serializeToBase64(rules));
        showParameter.setParentPageId(view.getPageId());
        FormShowParameter showParam = view.getFormShowParameter();
        showParameter.setCloseCallBack(showParam.getCloseCallBack());
        showParameter.setCustomParam("schemeNumber", showParam.getCustomParam("schemeNumber"));
        view.showForm(showParameter);
    }

    public static Set<String> queryHideEntity() {
        HashSet<String> hideEntitySet = new HashSet<String>();
        Map objs = BusinessDataServiceHelper.loadFromCache((String)"bos_multi_hided_entity", (String)"id,entitynumber", null);
        for (Map.Entry entry : objs.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            hideEntitySet.add(value.getString("entitynumber"));
        }
        return hideEntitySet;
    }

    public static double reCalculateRate(boolean isFirstImport, double rate) {
        if (isFirstImport) {
            if (rate > 40.0) {
                return 40.0;
            }
            return rate;
        }
        if (rate < 40.0) {
            return 40.0;
        }
        return MulImportStepPluginUtil.resetRate(rate);
    }

    public static double resetRate(double rate) {
        if (rate > 99.0) {
            rate = 99.0;
        }
        return rate;
    }
}

