/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.stepplugin.util.impl;

import java.util.HashSet;
import kd.bos.mulimport.stepplugin.util.IStringSimilarity;

public class JaccardStringSimilarity
implements IStringSimilarity {
    public static final JaccardStringSimilarity INSTANCE = new JaccardStringSimilarity();

    private JaccardStringSimilarity() {
    }

    @Override
    public double calcStrSimilarity(CharSequence left, CharSequence right) {
        if (left != null && right != null) {
            return this.innerCalculate(left, right);
        }
        throw new IllegalArgumentException("input cannot be null");
    }

    private double innerCalculate(CharSequence left, CharSequence right) {
        int leftLength = left.length();
        int rightLength = right.length();
        if (leftLength == 0 && rightLength == 0) {
            return 1.0;
        }
        if (leftLength != 0 && rightLength != 0) {
            HashSet<Character> leftSet = new HashSet<Character>(leftLength);
            for (int i = 0; i < leftLength; ++i) {
                leftSet.add(Character.valueOf(left.charAt(i)));
            }
            HashSet<Character> rightSet = new HashSet<Character>(rightLength);
            for (int i = 0; i < rightLength; ++i) {
                rightSet.add(Character.valueOf(right.charAt(i)));
            }
            HashSet<Character> unionSet = new HashSet<Character>(leftSet);
            unionSet.addAll(rightSet);
            int intersectionSize = leftSet.size() + rightSet.size() - unionSet.size();
            return (double)intersectionSize / (double)unionSet.size();
        }
        return 0.0;
    }
}

