/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.attachment.FileSource;
import kd.bos.svc.util.FileServerUtil;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.xml.sax.SAXException;

@Deprecated
public class ImportFailedSheetHandler
extends SheetHandler {
    private static final Log log = LogFactory.getLog(ImportFailedSheetHandler.class);
    private static final String BOS_FORM_MVC = "bos-form-mvc";
    private SXSSFWorkbook book;
    private SXSSFSheet sheet;
    private CellStyle redStyle;
    private CellStyle titleStyle;
    private CellStyle redTitleStyle;
    private ImportLogger importLogger;
    private final FileService service;
    private final String appid;
    private final String billFormId;
    private final String billFormName;
    private int cursorRowNum;
    private SheetHandler.ParsedRow currentRow;
    private final Map<String, Integer> logsHash = new HashMap<String, Integer>();

    public SheetHandler.ParsedRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(SheetHandler.ParsedRow currentRow) {
        this.currentRow = currentRow;
    }

    ImportFailedSheetHandler(String appid, String billFormId, String billFormName, ImportLogger importLogger, FileService service) {
        this.appid = appid;
        this.billFormId = billFormId;
        this.billFormName = billFormName;
        this.importLogger = importLogger;
        this.service = service;
        importLogger.getDelRows().sort((o1, o2) -> o1[0] - o2[0]);
    }

    @Override
    public void handleRow(SheetHandler.ParsedRow row) {
        SXSSFCell cell;
        this.currentRow = row;
        int currRowNum = this.currentRow.getRowNum();
        if (currRowNum > 2) {
            if (this.isRowSucceed(this.importLogger.getDelRows(), currRowNum)) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            List logs = (List)this.importLogger.getLogCache().get(currRowNum);
            if (logs != null && !logs.isEmpty()) {
                sb.setLength(0);
                for (ImportLogger.ImportLog log : logs) {
                    sb.append(log.toString());
                    sb.append("\n\t");
                }
                String mergeLogStr = sb.toString();
                if (this.logsHash.containsKey(mergeLogStr)) {
                    mergeLogStr = String.format(ResManager.loadKDString((String)"\u540c\u7b2c%s\u884c", (String)"ImportFailedSheetHandler_0", (String)BOS_FORM_MVC, (Object[])new Object[0]), this.logsHash.get(mergeLogStr));
                    logs.clear();
                    logs.add(new ImportLogger.ImportLog(mergeLogStr));
                } else {
                    this.logsHash.put(mergeLogStr, this.cursorRowNum);
                }
                cell = this.getRow(this.sheet, this.cursorRowNum).createCell(0);
                if (this.redStyle == null) {
                    this.redStyle = this.book.createCellStyle();
                    Font font = this.book.createFont();
                    font.setColor(IndexedColors.RED.getIndex());
                    this.redStyle.setFont(font);
                }
                cell.setCellStyle(this.redStyle);
                cell.setCellValue(mergeLogStr);
            }
        } else if (currRowNum == 2) {
            cell = this.getRow(this.sheet, this.cursorRowNum).createCell(0);
            cell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"ImportFailedSheetHandler_1", (String)BOS_FORM_MVC, (Object[])new Object[0]));
        } else if (currRowNum == 0) {
            this.book = new SXSSFWorkbook(1000);
            this.book.setCompressTempFiles(true);
            this.sheet = this.book.createSheet("sheet1");
            this.sheet.setColumnWidth(0, 10000);
        }
        for (Map.Entry<Integer, String> entry : this.getCurrentRow().getData().entrySet()) {
            cell = this.getRow(this.sheet, this.cursorRowNum).createCell(entry.getKey() + 1);
            if (currRowNum == 2) {
                if (entry.getValue().startsWith("*")) {
                    if (this.redTitleStyle == null) {
                        this.redTitleStyle = this.book.createCellStyle();
                        this.redTitleStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
                        this.redTitleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        Font font = this.book.createFont();
                        font.setColor(IndexedColors.RED.getIndex());
                        this.redTitleStyle.setFont(font);
                    }
                    cell.setCellStyle(this.redTitleStyle);
                } else {
                    if (this.titleStyle == null) {
                        this.titleStyle = this.book.createCellStyle();
                        this.titleStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
                        this.titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    }
                    cell.setCellStyle(this.titleStyle);
                }
                this.sheet.setColumnWidth(entry.getKey() + 1, entry.getValue().getBytes().length * 2 * 160);
            }
            cell.setCellValue(entry.getValue());
        }
        ++this.cursorRowNum;
    }

    private boolean isRowSucceed(List<int[]> delRows, int currRowNum) {
        for (int[] rs : delRows) {
            if (rs[1] < rs[0]) {
                return currRowNum >= rs[0];
            }
            if (currRowNum > rs[1]) continue;
            return currRowNum >= rs[0];
        }
        return false;
    }

    public SXSSFRow getRow(SXSSFSheet sheet, int r) {
        SXSSFRow row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        return row;
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.book.write((OutputStream)os);
            byte[] data = os.toByteArray();
            TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
            LocalDate now = LocalDate.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMdd");
            String formattedStr = now.format(formatter);
            String fileName = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25_%1$s_%2$s.xlsx", (String)"ImportFailedSheetHandler_3", (String)"bos-import", (Object[])new Object[0]), this.billFormName, formattedStr);
            String url = tempFile.saveAsUrl(fileName, data, data.length);
            RequestContext ctx = RequestContext.getOrCreate();
            String path = FileNameUtils.getExportFileName((String)ctx.getTenantId(), (String)ctx.getAccountId(), (String)this.appid, (String)(this.billFormId + UUID.randomUUID()), (String)fileName);
            url = this.service.upload((FileItem)FileServerUtil.createFileItem((String)fileName, (String)path, (InputStream)tempFile.getInputStream(url), (FileSource)FileSource.EXCEL_IMPORT));
            this.importLogger.setErrFile(UrlService.getAttachmentFullUrl((String)url));
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
        finally {
            try {
                if (this.book != null) {
                    this.book.close();
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
            this.sheet = null;
            this.book = null;
            this.importLogger = null;
        }
    }

    @Override
    public void handleDataValidation(Set<SheetHandler.CellValidation> cellValidations) {
        DataValidationHelper helper = this.sheet.getDataValidationHelper();
        for (SheetHandler.CellValidation validation : cellValidations) {
            String[] items = validation.getValidation().split(",", -1);
            for (String range : validation.getRange().split(" ")) {
                AreaReference ref = new AreaReference(range, SpreadsheetVersion.EXCEL2007);
                CellRangeAddressList addressList = new CellRangeAddressList(ref.getFirstCell().getRow(), ref.getLastCell().getRow(), ref.getFirstCell().getCol() + 1, ref.getLastCell().getCol() + 1);
                DataValidationConstraint constraint = helper.createExplicitListConstraint(items);
                DataValidation dataValidation = helper.createValidation(constraint, addressList);
                if (dataValidation instanceof XSSFDataValidation) {
                    dataValidation.setSuppressDropDownArrow(true);
                    dataValidation.setShowErrorBox(true);
                } else {
                    dataValidation.setSuppressDropDownArrow(false);
                }
                this.sheet.addValidationData(dataValidation);
            }
        }
    }
}

