/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fjnxs.dc.services.payment.salary;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fjnxs.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.fjnxs.dc.services.payment.salary.SalaryQuery;
import kd.ebg.aqap.banks.fjnxs.dc.utils.EBUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class B2EUploadAgentPayeeSalaryData
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQuery.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)EBUtils.buildPackerHead(this.getBizCode(), info.getBankBatchSeqID()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"PayerAcNo", (String)info.getAccNo());
        JDomUtils.addChild((Element)body, (String)"PayerCurrency", (String)info.getCurrency());
        JDomUtils.addChild((Element)body, (String)"PayerAcName", (String)info.getAccName());
        JDomUtils.addChild((Element)body, (String)"PayerAmount", (String)"");
        JDomUtils.addChild((Element)body, (String)"TotalCount", (String)(paymentInfos.size() + ""));
        JDomUtils.addChild((Element)body, (String)"Remark", (String)"");
        JDomUtils.addChild((Element)body, (String)"AgentFundNo", (String)"001");
        JDomUtils.addChild((Element)body, (String)"AgentType", (String)"002");
        Element List2 = JDomUtils.addChild((Element)body, (String)"List");
        BigDecimal totalAmt = new BigDecimal("0.00");
        boolean addKDFlagToPay = BankBusinessConfig.isAddKDFlagToPay();
        for (int i = 0; i < paymentInfos.size(); ++i) {
            info = (PaymentInfo)paymentInfos.get(0);
            Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
            JDomUtils.addChild((Element)Map2, (String)"EmployeeNo", (String)info.getBankSerialNo());
            JDomUtils.addChild((Element)Map2, (String)"PayeeAcNo", (String)info.getIncomeAccNo());
            JDomUtils.addChild((Element)Map2, (String)"PayeeAcName", (String)info.getIncomeAccName());
            JDomUtils.addChild((Element)Map2, (String)"PayeeAmount", (String)info.getAmount().toString());
            totalAmt = totalAmt.add(info.getAmount());
            String exp = info.getExplanation();
            if (addKDFlagToPay) {
                PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)info);
                exp = info.getBankDetailSeqId() + "_KD_" + exp;
            }
            JDomUtils.addChild((Element)Map2, (String)"Remark", (String)exp);
        }
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element bank_root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse headRsp = EBUtils.parserResponseInfo(bank_root);
        String bankStatus = headRsp.getResponseCode();
        if ("000000".equals(bankStatus)) {
            Element body = bank_root.getChild("Body");
            Element list = body.getChild("List");
            List lists = list.getChildren("Map");
            Element element = (Element)lists.get(0);
            String batchNo = JDomUtils.getChildText((Element)element, (String)"BatchNo");
            paymentInfos.forEach(p -> p.setBankRefID(batchNo));
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        throw EBExceiptionUtil.serviceException((String)(headRsp.getResponseMessage() + "\uff0c" + bankStatus));
    }

    public String getDeveloper() {
        return "567";
    }

    public String getBizCode() {
        return "B2EUploadAgentPayeeSalaryData";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8fde\u4ee3\u53d1\u6587\u4ef6\u4e0a\u4f20", (String)"B2EUploadAgentPayeeSalaryData_0", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

