/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fjnxs.dc.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fjnxs.dc.BankBusinessConfig;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;

public class EBUtils {
    private static Map<String, String> currencyMap;
    public static final String KD = "_KD_";
    public static final DateTimeFormatter dateTimeFormatter;

    public static String getFormatDate(Date now) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(now);
    }

    public static String getDate(Date now) {
        String date = new SimpleDateFormat("yyyyMMdd").format(now);
        return date;
    }

    public static String getFormatDate(Date now, String format) {
        String date = new SimpleDateFormat(format).format(now);
        return date;
    }

    public static LocalDateTime parseTransTime(String timeStampStr) {
        return LocalDateTime.parse(timeStampStr, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static Date parseDate(String dateStr, String fmt) {
        try {
            return DateTimeUtils.parseDate((String)dateStr, (String)fmt);
        }
        catch (ParseException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (String)"EBUtils_11", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static Element buildPackerHead(String tr_code, String req_no) {
        Element head = new Element("Head");
        JDomUtils.addChild((Element)head, (String)"TrsCode", (String)tr_code);
        JDomUtils.addChild((Element)head, (String)"ERPJnlNo", (String)req_no);
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)EBUtils.getFormatDate(new Date()));
        return head;
    }

    public static BankResponse parserResponseInfo(Element root) {
        String msg;
        String code;
        BankResponse bankResponse = new BankResponse();
        Element error = JDomUtils.getChildElement((Element)root, (String)"error");
        if (error != null) {
            code = "error";
            msg = JDomUtils.getChildText((Element)root, (String)"error");
        } else {
            Element head = JDomUtils.getChildElement((Element)root, (String)"Head");
            code = JDomUtils.getChildText((Element)head, (String)"IBSReturnCode");
            msg = JDomUtils.getChildText((Element)head, (String)"IBSReturnMsg");
        }
        bankResponse.setResponseCode(code);
        bankResponse.setResponseMessage(msg);
        return bankResponse;
    }

    public static String convertCurrencyName2Code(String name) {
        for (Map.Entry<String, String> stringStringEntry : currencyMap.entrySet()) {
            Map.Entry<String, String> entry = stringStringEntry;
            if (!entry.getValue().equals(name)) continue;
            return entry.getKey();
        }
        if (CurrencyUtils.isISOCurrency((String)name)) {
            return name;
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u7684\u5e01\u79cd\uff1a%s", (String)"EBUtils_12", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]), name));
    }

    public static String getExclusiveCifNo(String accNo) {
        String exclusiveCifNo = BankBusinessConfig.getExclusiveCifNo(accNo);
        return StringUtils.isEmpty((CharSequence)exclusiveCifNo) ? RequestContextUtils.getBankParameterValue((String)"userid") : exclusiveCifNo;
    }

    static {
        dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        currencyMap = new HashMap<String, String>();
        currencyMap.put("AUD", ResManager.loadKDString((String)"\u6fb3\u5927\u5229\u4e9a\u5143", (String)"EBUtils_0", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]));
        currencyMap.put("CAD", ResManager.loadKDString((String)"\u52a0\u62ff\u5927\u5143", (String)"EBUtils_1", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]));
        currencyMap.put("CHF", ResManager.loadKDString((String)"\u745e\u58eb\u6cd5\u90ce", (String)"EBUtils_2", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]));
        currencyMap.put("CNY", ResManager.loadKDString((String)"\u4eba\u6c11\u5e01", (String)"EBUtils_3", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]));
        currencyMap.put("EUR", ResManager.loadKDString((String)"\u6b27\u5143", (String)"EBUtils_4", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]));
        currencyMap.put("GBP", ResManager.loadKDString((String)"\u82f1\u9551", (String)"EBUtils_5", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]));
        currencyMap.put("HKD", ResManager.loadKDString((String)"\u6e2f\u5e01", (String)"EBUtils_6", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]));
        currencyMap.put("JPY", ResManager.loadKDString((String)"\u65e5\u5143", (String)"EBUtils_7", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]));
        currencyMap.put("NZD", ResManager.loadKDString((String)"\u65b0\u897f\u5170\u5143", (String)"EBUtils_8", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]));
        currencyMap.put("SGD", ResManager.loadKDString((String)"\u65b0\u52a0\u5761\u5143", (String)"EBUtils_9", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]));
        currencyMap.put("USD", ResManager.loadKDString((String)"\u7f8e\u5143", (String)"EBUtils_10", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]));
    }
}

