/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ecny.services.ecny.detail;

import kd.ebg.aqap.banks.ccb.ecny.services.CCB_DC_Parser;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class DetailPage {
    public String getFirstPageTag() throws EBServiceException {
        return "1_";
    }

    public static String preTreatXML(String responseStr) {
        StringBuilder sb = new StringBuilder();
        String xml = "";
        int totalLen = responseStr.length();
        int startIndex = 0;
        int endIndex = 0;
        int lastIndex = 0;
        int offset = 0;
        while (startIndex > -1) {
            xml = responseStr.substring(lastIndex, totalLen);
            startIndex = xml.indexOf("<DET>");
            endIndex = xml.indexOf("</DET>");
            if (startIndex > 0 && endIndex > 0) {
                sb.append(responseStr.substring(offset, startIndex += offset));
                String tempString = responseStr.substring(startIndex, endIndex += offset).substring("<DET>".length());
                tempString = tempString.replaceAll("<", "(").replaceAll(">", ")");
                sb.append("<DET>").append(tempString).append("</DET>");
                offset = lastIndex = endIndex + "</DET>".length();
                continue;
            }
            sb.append(xml);
        }
        return sb.toString();
    }

    public String getNextPageTag(String rspStr, String pageTag) throws EBServiceException {
        Element root = CCB_DC_Parser.parseString2Root(rspStr = DetailPage.preTreatXML(rspStr));
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (DetailPage.isNoDetilRspCode(response.getResponseCode())) {
            return null;
        }
        int index = pageTag.indexOf("_");
        String currentPageTag = pageTag.substring(0, index);
        int nextPage = Integer.parseInt(currentPageTag) + 1;
        String poststr = "";
        if (pageTag.equalsIgnoreCase(this.getFirstPageTag())) {
            Element txInfo = root.getChild("TX_INFO");
            poststr = txInfo.getChildTextTrim("POSTSTR");
            if (StringUtils.isEmpty((String)poststr)) {
                poststr = "";
            }
        } else {
            poststr = pageTag.substring(index + 1);
        }
        return nextPage + "_" + poststr.trim();
    }

    public boolean isLastPage(String rspStr, String pageTag) throws EBServiceException {
        Element root = CCB_DC_Parser.parseString2Root(rspStr = DetailPage.preTreatXML(rspStr));
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (DetailPage.isNoDetilRspCode(response.getResponseCode())) {
            return true;
        }
        int index = pageTag.indexOf("_");
        String currentPageTag = pageTag.substring(0, index);
        Element txInfo = root.getChild("TX_INFO");
        int totalPage = Integer.parseInt(ParserUtils.checkUnNullableElement((Element)txInfo, (String)"TOTAL_PAGE"));
        return Integer.parseInt(currentPageTag) > totalPage;
    }

    public static boolean isNoDetilRspCode(String rspCode) {
        StringBuilder noDetailCode = new StringBuilder();
        noDetailCode.append("200001").append("_");
        noDetailCode.append("990000").append("_");
        noDetailCode.append("310211").append("_");
        noDetailCode.append("1261").append("_");
        noDetailCode.append("8440ZX310211").append("_");
        noDetailCode.append("8212ZXXX1261").append("_");
        noDetailCode.append("8230ZX200000").append("_");
        noDetailCode.append("8310ZX880002");
        return -1 != noDetailCode.toString().indexOf(rspCode);
    }
}

