/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ecny.services.ecny.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ecny.services.CCB_DC_Parser;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailParser {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DetailParser.class);

    public List<DetailInfo> parseHisDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        return this.parseDetail(rqst, rspStr);
    }

    public List<DetailInfo> parseTodayDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        return this.parseDetail(rqst, rspStr);
    }

    public List<DetailInfo> parseDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>();
        String rspCode = response.getResponseCode();
        if ("000000".equals(rspCode)) {
            Element txInfo = root.getChild("TX_INFO");
            String err_level = root.getChildText("ERR_LEVEL");
            if (!StringUtils.isEmpty((String)err_level)) {
                String err_msg = "bank return error :" + root.getChildText("ERR_MSG");
                this.logger.info(err_msg);
                throw EBExceiptionUtil.serviceException((String)err_msg);
            }
            Element DETAILLIST = txInfo.getChild("DETAILLIST");
            List detail = DETAILLIST.getChildren("DETAILINFO");
            if (detail == null || detail.size() == 0) {
                this.logger.info("\u8fd4\u56deDETAIL\u8282\u70b9: null == detail || 0 == detail.size()");
                return new ArrayList<DetailInfo>();
            }
            String totalPage = txInfo.getChildTextTrim("TOTAL_PAGE");
            if ("0".equals(totalPage)) {
                return list;
            }
            for (Element detailElement : detail) {
                String oppAccNo = detailElement.getChildTextTrim("Cntrprt_Txn_AccNo");
                String oppAccName = detailElement.getChildTextTrim("CntrprtBookEntrAcNoNm");
                DetailInfo detailInfo = new DetailInfo();
                detailInfo.setOppAccNo(oppAccNo);
                detailInfo.setOppAccName(oppAccName);
                detailInfo.setCurrency("01");
                detailInfo.setAccNo(rqst.getAcnt().getAccNo());
                detailInfo.setAccName(rqst.getAcnt().getAccName());
                String Cr_HpnAm = JDomUtils.getChildText((Element)detailElement, (String)"Cr_HpnAm");
                String DHAmt = JDomUtils.getChildText((Element)detailElement, (String)"DHAmt");
                if (!StringUtils.isEmpty((String)Cr_HpnAm)) {
                    detailInfo.setCreditAmount(new BigDecimal(Cr_HpnAm));
                    detailInfo.setDebitAmount(new BigDecimal("0"));
                } else if (!StringUtils.isEmpty((String)DHAmt)) {
                    detailInfo.setDebitAmount(new BigDecimal(DHAmt));
                    detailInfo.setCreditAmount(new BigDecimal("0"));
                } else {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u672a\u77e5\u7684\u501f\u8d37\u6807\u8bc6\u3002", (String)"DetailParser_0", (String)"ebg-aqap-banks-ccb-ecny", (Object[])new Object[0]));
                }
                String balStr = detailElement.getChildTextTrim("AcBa");
                if (!StringUtils.isEmpty((String)balStr)) {
                    detailInfo.setBalance(new BigDecimal(balStr));
                }
                String tranFlow = detailElement.getChildTextTrim("Ovrlsttn_EV_Trck_No");
                String message = detailElement.getChildTextTrim("Txn_Rmrk");
                detailInfo.setExplanation(message);
                String realTransDate = detailElement.getChildTextTrim("Txn_Dt");
                String oppBankName = JDomUtils.getChildText((Element)detailElement, (String)"CDBank_Nm");
                detailInfo.setOppBankName(oppBankName);
                try {
                    detailInfo.setTransDate(LocalDate.parse(realTransDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
                }
                catch (Exception e) {
                    throw EBExceiptionUtil.serviceException((String)String.format(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8fd4\u56de\u65f6\u95f4\u5f02\u5e38(%1$s)\u3002", (String)"DetailParser_1", (String)"ebg-aqap-banks-ccb-ecny", (Object[])new Object[0]), realTransDate), new Object[0]));
                }
                try {
                    detailInfo.setTransTime(LocalDateTime.parse(realTransDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                }
                catch (Exception e) {
                    throw EBExceiptionUtil.serviceException((String)String.format(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8fd4\u56de\u65f6\u95f4\u5f02\u5e38(%1$s)\u3002", (String)"DetailParser_1", (String)"ebg-aqap-banks-ccb-ecny", (Object[])new Object[0]), realTransDate), new Object[0]));
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(detailElement);
                JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                jsonObject.put("oppAccNo", (Object)oppAccNo);
                jsonObject.put("TRANDATE", (Object)realTransDate);
                jsonObject.put("Amount", (Object)DHAmt);
                jsonObject.put("DET_NO", (Object)"1");
                jsonObject.put("TRAN_FLOW", (Object)tranFlow);
                detailInfo.setJsonMap(jsonObject.toJSONString());
                list.add(detailInfo);
            }
            return list;
        }
        throw EBExceiptionUtil.serviceException((String)(rspCode + " " + response.getResponseMessage()));
    }
}

