/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.dc.services.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.pab.dc.services.PackerHelper;
import kd.ebg.aqap.banks.pab.dc.services.PageUtil;
import kd.ebg.aqap.banks.pab.dc.services.ParserHelper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public EBBankBalanceResponse doBizWithPage(BankBalanceRequest request) {
        this.setCurrentPage("0");
        this.setLastPage(false);
        BalanceInfo balanceInfo = null;
        try {
            ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
            do {
                EBBankBalanceResponse response = this.process(request);
                List balanceInfos = response.getBalances();
                balanceInfo = this.mergeBalance(balanceInfo, balanceInfos, request);
                balances = new ArrayList(1);
                balances.add(balanceInfo);
            } while (!this.isLastPage());
            return new EBBankBalanceResponse(balances);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public BalanceInfo mergeBalance(BalanceInfo balanceInfo, List<BalanceInfo> balanceInfos, BankBalanceRequest request) {
        if (balanceInfos.size() > 0) {
            BigDecimal totalBigDecimal = new BigDecimal("0.00");
            BigDecimal totalAvailableBalance = new BigDecimal("0.00");
            boolean isFirstRecord = false;
            if (balanceInfo == null) {
                isFirstRecord = true;
                balanceInfo = balanceInfos.get(0);
            }
            for (int i = 0; i < balanceInfos.size(); ++i) {
                if (isFirstRecord) continue;
                BalanceInfo balanceInfoEntry = balanceInfos.get(i);
                BigDecimal balance = balanceInfoEntry.getCurrentBalance();
                if (balance != null) {
                    totalBigDecimal = totalBigDecimal.add(balance);
                }
                if (balanceInfoEntry.getAvailableBalance() == null) continue;
                totalAvailableBalance = totalAvailableBalance.add(balanceInfoEntry.getAvailableBalance());
            }
            balanceInfo.setCurrentBalance(balanceInfo.getCurrentBalance().add(totalBigDecimal));
            if (balanceInfo.getAvailableBalance() != null) {
                balanceInfo.setAvailableBalance(balanceInfo.getAvailableBalance().add(totalAvailableBalance));
            }
        }
        return balanceInfo;
    }

    public String pack(BankBalanceRequest request) {
        if ("fixed".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()))) {
            return this.packFixedBalanceXml(request);
        }
        this.setLastPage(true);
        Element Result = new Element("Result");
        JDomUtils.addChild((Element)Result, (String)"Account", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Result, (String)"CcyType", (String)"");
        JDomUtils.addChild((Element)Result, (String)"CcyCode", (String)request.getBankCurrency());
        String xmlStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)Result, (String)RequestContextUtils.getCharset());
        return PackerHelper.createReqMsgWithHead(EBContext.getContext().getBankRequestSeq(), "4001", xmlStr);
    }

    public String packFixedBalanceXml(BankBalanceRequest request) {
        int beginNumber = Integer.parseInt(this.getCurrentPage()) + 1;
        String PageNo = String.valueOf(beginNumber);
        Element Result = new Element("Result");
        JDomUtils.addChild((Element)Result, (String)"AcctNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Result, (String)"PageNo", (String)PageNo);
        String xmlStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)Result, (String)RequestContextUtils.getCharset());
        String reqMsgWithHead = PackerHelper.createReqMsgWithHead(EBContext.getContext().getBankRequestSeq(), "4021", xmlStr);
        log.info("\u67e5\u8be2\u5b9a\u671f\u6237\u4f59\u989d-4021\u63a5\u53e3-\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)reqMsgWithHead);
        return reqMsgWithHead;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        this.setLastPage(true);
        BankResponse bankRsp = new BankResponse();
        PageUtil pageUtil = ParserHelper.parseResponse(responseStr, bankRsp);
        if (!"000000".equalsIgnoreCase(bankRsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankRsp.getResponseCode(), (String)bankRsp.getResponseMessage()));
        }
        if ("fixed".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()))) {
            return this.parseFixedBalance(request, pageUtil);
        }
        Element root = JDomUtils.string2Root((String)pageUtil.getXmlStr(), (String)RequestContextUtils.getCharset());
        String account = root.getChildTextTrim("Account");
        String ccyCode = root.getChildTextTrim("CcyCode");
        String ccyType = root.getChildTextTrim("CcyType");
        String AccountName = root.getChildTextTrim("AccountName");
        String bal = root.getChildTextTrim("Balance");
        String lastBal = root.getChildTextTrim("LastBalance");
        String totalAmount = root.getChildTextTrim("TotalAmount");
        String accountType = root.getChildTextTrim("AccountType");
        String accountStatus = root.getChildTextTrim("AccountStatus");
        String bankName = root.getChildTextTrim("BankName");
        BalanceInfo balance = new BalanceInfo();
        this.setBankAcnt(balance, request.getBankAcntList(), account);
        balance.setBankCurrency(ccyCode);
        this.setCurrentBalance(balance, totalAmount);
        this.setAvailableBalance(balance, bal);
        this.setLastDayAvlBalance(balance, lastBal);
        balance.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }

    public EBBankBalanceResponse parseFixedBalance(BankBalanceRequest request, PageUtil pageUtil) {
        Element root = JDomUtils.string2Root((String)pageUtil.getXmlStr(), (String)RequestContextUtils.getCharset());
        String account = root.getChildTextTrim("AcctNo");
        String ccyCode = root.getChildTextTrim("CurrencyNo");
        if (!request.getAcnt().getAccNo().equalsIgnoreCase(account)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u53f7[%1$s]\u4e0e\u8fd4\u56de\u8d26\u53f7[%2$s]\u4e0d\u4e00\u81f4\u3002", (String)"TodayBalanceImpl_7", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]), request.getAcnt().getAccNo(), account));
        }
        if (this.isLastPage(root)) {
            this.setLastPage(true);
        } else {
            this.setLastPage(false);
            int beginNumber = Integer.parseInt(this.getCurrentPage()) + 1;
            String pageNo = String.valueOf(beginNumber);
            this.setCurrentPage(pageNo);
        }
        List list = root.getChildren("list");
        BigDecimal totalBalance = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); ++i) {
            Element listElement = (Element)list.get(i);
            String Amount = listElement.getChildTextTrim("Amount");
            BigDecimal balanceBig = new BigDecimal(Amount);
            totalBalance = totalBalance.add(balanceBig);
        }
        BalanceInfo balance = new BalanceInfo();
        balance.setBankAcnt(request.getAcnt());
        balance.setBankCurrency(ccyCode);
        balance.setCurrentBalance(totalBalance);
        balance.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }

    private boolean isLastPage(Element root) {
        String endFlag = root.getChildTextTrim("IsEnd");
        String pageRecCount = root.getChildTextTrim("Count");
        if ("Y".equalsIgnoreCase(endFlag)) {
            return true;
        }
        if ("N".equalsIgnoreCase(endFlag)) {
            return false;
        }
        if (0 == Integer.parseInt(pageRecCount)) {
            return true;
        }
        List list = root.getChildren("list");
        return null == list || list.size() <= 0;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"\u4f01\u4e1a\u5e10\u6237\u5355\u5e10\u6237\u4f59\u989d\u67e5\u8be2 [4001]\u3002", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"TodayBalanceImpl_5", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean isSupportPage(BankBalanceRequest request) {
        return "fixed".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()));
    }
}

