/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.opa.sign.sign.signcfca;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.api.CertUtil;
import com.cfca.util.pki.api.SignatureUtil;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.crl.X509CRL;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;

public class CertDNVerifer {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(CertDNVerifer.class);
    private Session session;
    private boolean checkCert = true;
    private Set<String> dns;
    private X509Cert[] caCerts;
    private X509CRL crl;

    public CertDNVerifer(Session session) {
        this.session = session;
    }

    public boolean verifyMsg(byte[] srcBytes, byte[] signData, X509Cert signCert, boolean detatched) throws Exception {
        X509Cert cert = null;
        SignatureUtil signUtil = new SignatureUtil();
        if (detatched) {
            if (!signUtil.p7VerifySignMessageDetached(srcBytes, signData, this.session)) {
                log.error("\u7b7e\u540d\u4e0d\u6b63\u786e");
                return false;
            }
            X509Cert[] x509Certs = signUtil.getSigerCert();
            cert = x509Certs[0];
        } else {
            if (!signUtil.p1VerifySignMessage(srcBytes, signData, "SHA1withRSAEncryption", signCert, this.session)) {
                log.error("\u7b7e\u540d\u4e0d\u6b63\u786e");
                return false;
            }
            cert = signCert;
        }
        log.info("\u7b7e\u540d\u8005=" + cert.getSubject());
        if (!this.checkCert) {
            return true;
        }
        String dn = this.getCN(cert.getSubject());
        if (!this.dns.contains(dn)) {
            log.error("\u672a\u6388\u6743\u7684\u7b7e\u540d\u8bc1\u4e66DN:[" + dn + "]");
            return false;
        }
        if (this.caCerts == null) {
            log.error("\u672a\u8bbe\u7f6e\u8bc1\u4e66\u94fe");
            return false;
        }
        try {
            if (!CertUtil.verifyCertSign((X509Cert)cert, (X509Cert[])this.caCerts, (Session)this.session)) {
                log.error("\u7b7e\u540d\u8bc1\u4e66\u4e0d\u5408\u6cd5");
                return false;
            }
        }
        catch (PKIException e) {
            log.error("\u9a8c\u7b7e\u540d\u5931\u8d25\uff1a" + e.getMessage());
            return false;
        }
        if (this.crl != null && this.crl.isRevoke(cert)) {
            log.error("\u8bc1\u4e66\u5df2\u7ecf\u540a\u9500");
            return false;
        }
        return true;
    }

    private String getCN(String dn) throws Exception {
        int start = dn.toUpperCase(Locale.ENGLISH).indexOf("CN=");
        if (start == -1) {
            log.error("\u8bc1\u4e66\u4e3b\u9898\u683c\u5f0f\u975e\u6cd5\uff1a" + dn);
            throw new Exception(String.format(ResManager.loadKDString((String)"\u8bc1\u4e66\u4e3b\u9898\u683c\u5f0f\u975e\u6cd5\uff1a%s\u3002", (String)"CertDNVerifer_1", (String)"ebg-aqap-banks-pab-opa", (Object[])new Object[0]), dn));
        }
        int end = dn.indexOf(",", start);
        if (end == -1) {
            end = dn.length();
        }
        StringBuilder sb = new StringBuilder(end - start - 3);
        for (int i = start + 3; i < end; ++i) {
            if (Character.isWhitespace(dn.charAt(i))) continue;
            sb.append(dn.charAt(i));
        }
        return sb.toString().toUpperCase(Locale.ENGLISH);
    }

    public Set<String> getDns() {
        return this.dns;
    }

    public void setDns(Set<String> dns) {
        HashSet<String> tmp = new HashSet<String>();
        for (String item : dns) {
            try {
                String dn = this.getCN(item);
                tmp.add(dn);
            }
            catch (Exception e) {
                log.error(e.toString());
            }
        }
        this.dns = tmp;
    }

    public boolean isCheckCert() {
        return this.checkCert;
    }

    public void setCheckCert(boolean checkCert) {
        this.checkCert = checkCert;
    }

    public X509Cert[] getCaCerts() {
        return this.caCerts;
    }

    public void setCaCerts(X509Cert[] caCerts) {
        this.caCerts = caCerts;
    }

    public X509CRL getCrl() {
        return this.crl;
    }

    public void setCrl(X509CRL crl) {
        this.crl = crl;
    }
}

