/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbcb.dc.service.loginout;

import java.util.Date;
import kd.ebg.aqap.banks.nbcb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.nbcb.dc.service.NBCBEBankDataHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.loginout.LoginAndOutPacker;
import kd.ebg.aqap.banks.nbcb.dc.service.loginout.LoginAndOutParser;
import kd.ebg.aqap.business.login.AbstractLoginImpl;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;

public class LoginAndOut
extends AbstractLoginImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(LoginAndOut.class);
    private static LoginAndOut loginAndOut = null;
    private String loginSessionId = null;
    private Date lastLoginTime;
    private long sessionTime = 600000L;

    public String pack() {
        String sequenceComm = Sequence.gen16Sequence();
        String loginMsg = LoginAndOutPacker.packLoginMsg(sequenceComm);
        return loginMsg;
    }

    public String parse(String s) {
        String sequenceComm = Sequence.gen16Sequence();
        return LoginAndOutParser.parserSessionId(s, sequenceComm);
    }

    public String getConnectionURI() {
        return "/directlink/httpAccess";
    }

    public int getTimeout() {
        return 1800;
    }

    public static synchronized LoginAndOut getLoginAndOut() {
        if (null == loginAndOut) {
            loginAndOut = new LoginAndOut();
        }
        return loginAndOut;
    }

    public synchronized void setNeedNewLoginSession() {
        this.loginSessionId = null;
    }

    public synchronized String loginSessionId4Pay() throws EBServiceException {
        if (BankBusinessConfig.isLoginFree()) {
            return "-1";
        }
        Date now = new Date();
        if (null == this.loginSessionId || now.getTime() - this.lastLoginTime.getTime() > this.sessionTime) {
            this.loginSessionId = this.getNewLoginSession();
            this.lastLoginTime = new Date();
        }
        return this.loginSessionId;
    }

    public synchronized String loginSessionId4Query() throws EBServiceException {
        if (BankBusinessConfig.isLoginFree()) {
            return "-1";
        }
        Date now = new Date();
        if (null == this.loginSessionId || now.getTime() - this.lastLoginTime.getTime() > this.sessionTime) {
            this.loginSessionId = this.getNewLoginSession();
            this.lastLoginTime = now;
        }
        return this.loginSessionId;
    }

    public String getNewLoginSession() throws EBServiceException {
        return super.doBiz();
    }

    public void configFactory(ConnectionFactory factory) {
        NBCBEBankDataHelper.configConnection(factory);
    }
}

