/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.crcb.dc.payment.company.otherBank;

import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.crcb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.crcb.dc.helper.JDOMHelper;
import kd.ebg.aqap.banks.crcb.dc.helper.RequestPacker;
import kd.ebg.aqap.banks.crcb.dc.helper.SvsSign;
import kd.ebg.aqap.banks.crcb.dc.payment.company.PayParser;
import kd.ebg.aqap.banks.crcb.dc.payment.company.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        String header = RequestPacker.getHeader("CL0006");
        requestMap.put("I1QYLS", paymentInfo.getBankDetailSeqId());
        requestMap.put("I1SMID", "");
        requestMap.put("I1ATID", "");
        requestMap.put("CYNO", "01");
        requestMap.put("HBJE", String.format("%.2f", paymentInfo.getAmount()));
        requestMap.put("FKKH", "020501");
        requestMap.put("FKZH", paymentInfo.getAccNo());
        requestMap.put("FKRM", paymentInfo.getAccName());
        if (paymentInfo.getIncomeCnaps() == null || paymentInfo.getIncomeCnaps().isEmpty()) {
            paymentInfo.setIncomeCnaps("020501");
        }
        requestMap.put("SKKH", paymentInfo.getIncomeCnaps());
        requestMap.put("SKHM", paymentInfo.getIncomeBankName());
        requestMap.put("SKZH", paymentInfo.getIncomeAccNo());
        requestMap.put("SKRM", paymentInfo.getIncomeAccName());
        requestMap.put("FYAN", paymentInfo.getUseCn());
        requestMap.put("FKBZ", paymentInfo.getExplanation());
        requestMap.put("JJBZ", paymentInfo.is2Urgent() ? "1" : "0");
        requestMap.put("IJYLX", BankBusinessConfig.getTransType(paymentInfo.getAccNo()));
        requestMap.put("I1SFDX", "");
        requestMap.put("I1TLSQ", "");
        requestMap.put("I1TRDT", "");
        requestMap.put("I1ZFXH", "");
        requestMap.put("I1NBBH", paymentInfo.getBankDetailSeqId());
        requestMap.put("I1JYBZ", "");
        requestMap.put("I1MXXH", "");
        requestMap.put("I1SXZF", "");
        requestMap.put("I1AC1", "");
        requestMap.put("I1NM1", "");
        requestMap.put("I1YWZL", "");
        requestMap.put("I1JLXX", "");
        String reqMessage = JDOMHelper.requestMessageFYIEncrypt(requestMap, "CL0006");
        try {
            String signData = SvsSign.getInstance().signData(reqMessage);
            if (!StringUtils.isEmpty((String)signData)) {
                String requestData = JDOMHelper.requestHttpMessage(header, signData, reqMessage);
                this.logger.info("\u4ed8\u6b3e\u7b7e\u540d\u503c:" + requestData);
                return requestData;
            }
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u62a5\u6587\u8fd4\u56de\u4e3a\u7a7a", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]));
        }
        catch (Exception e) {
            this.logger.info("\u6253\u5305\u4ed8\u6b3e\u62a5\u6587\u5931\u8d25 ", (Object)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6253\u5305\u4ed8\u6b3e\u62a5\u6587\u5931\u8d25", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        new PayParser().parsePay(bankPayRequest.getPaymentInfoAsArray(), s);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CL0006";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u8f6c\u8d26", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

